/*!
 *  Lang.js for Laravel localization in JavaScript.
 *
 *  @version 1.1.10
 *  @license MIT https://github.com/rmariuzzo/Lang.js/blob/master/LICENSE
 *  @site    https://github.com/rmariuzzo/Lang.js
 *  @author  Rubens Mariuzzo <rubens@mariuzzo.com>
 */
(function(root,factory){"use strict";if(typeof define==="function"&&define.amd){define([],factory)}else if(typeof exports==="object"){module.exports=factory()}else{root.Lang=factory()}})(this,function(){"use strict";function inferLocale(){if(typeof document!=="undefined"&&document.documentElement){return document.documentElement.lang}}function convertNumber(str){if(str==="-Inf"){return-Infinity}else if(str==="+Inf"||str==="Inf"||str==="*"){return Infinity}return parseInt(str,10)}var intervalRegexp=/^({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])$/;var anyIntervalRegexp=/({\s*(\-?\d+(\.\d+)?[\s*,\s*\-?\d+(\.\d+)?]*)\s*})|([\[\]])\s*(-Inf|\*|\-?\d+(\.\d+)?)\s*,\s*(\+?Inf|\*|\-?\d+(\.\d+)?)\s*([\[\]])/;var defaults={locale:"en"};var Lang=function(options){options=options||{};this.locale=options.locale||inferLocale()||defaults.locale;this.fallback=options.fallback;this.messages=options.messages};Lang.prototype.setMessages=function(messages){this.messages=messages};Lang.prototype.getLocale=function(){return this.locale||this.fallback};Lang.prototype.setLocale=function(locale){this.locale=locale};Lang.prototype.getFallback=function(){return this.fallback};Lang.prototype.setFallback=function(fallback){this.fallback=fallback};Lang.prototype.has=function(key,locale){if(typeof key!=="string"||!this.messages){return false}return this._getMessage(key,locale)!==null};Lang.prototype.get=function(key,replacements,locale){if(!this.has(key,locale)){return key}var message=this._getMessage(key,locale);if(message===null){return key}if(replacements){message=this._applyReplacements(message,replacements)}return message};Lang.prototype.trans=function(key,replacements){return this.get(key,replacements)};Lang.prototype.choice=function(key,number,replacements,locale){replacements=typeof replacements!=="undefined"?replacements:{};replacements.count=number;var message=this.get(key,replacements,locale);if(message===null||message===undefined){return message}var messageParts=message.split("|");var explicitRules=[];for(var i=0;i<messageParts.length;i++){messageParts[i]=messageParts[i].trim();if(anyIntervalRegexp.test(messageParts[i])){var messageSpaceSplit=messageParts[i].split(/\s/);explicitRules.push(messageSpaceSplit.shift());messageParts[i]=messageSpaceSplit.join(" ")}}if(messageParts.length===1){return message}for(var j=0;j<explicitRules.length;j++){if(this._testInterval(number,explicitRules[j])){return messageParts[j]}}var pluralForm=this._getPluralForm(number);return messageParts[pluralForm]};Lang.prototype.transChoice=function(key,count,replacements){return this.choice(key,count,replacements)};Lang.prototype._parseKey=function(key,locale){if(typeof key!=="string"||typeof locale!=="string"){return null}var segments=key.split(".");var source=segments[0].replace(/\//g,".");return{source:locale+"."+source,sourceFallback:this.getFallback()+"."+source,entries:segments.slice(1)}};Lang.prototype._getMessage=function(key,locale){locale=locale||this.getLocale();key=this._parseKey(key,locale);if(this.messages[key.source]===undefined&&this.messages[key.sourceFallback]===undefined){return null}var message=this.messages[key.source];var entries=key.entries.slice();var subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]!==undefined){message=message[subKey];subKey=""}}if(typeof message!=="string"&&this.messages[key.sourceFallback]){message=this.messages[key.sourceFallback];entries=key.entries.slice();subKey="";while(entries.length&&message!==undefined){var subKey=!subKey?entries.shift():subKey.concat(".",entries.shift());if(message[subKey]){message=message[subKey];subKey=""}}}if(typeof message!=="string"){return null}return message};Lang.prototype._findMessageInTree=function(pathSegments,tree){while(pathSegments.length&&tree!==undefined){var dottedKey=pathSegments.join(".");if(tree[dottedKey]){tree=tree[dottedKey];break}tree=tree[pathSegments.shift()]}return tree};Lang.prototype._applyReplacements=function(message,replacements){for(var replace in replacements){message=message.replace(new RegExp(":"+replace,"gi"),function(match){var value=replacements[replace];var allCaps=match===match.toUpperCase();if(allCaps){return value.toUpperCase()}var firstCap=match===match.replace(/\w/i,function(letter){return letter.toUpperCase()});if(firstCap){return value.charAt(0).toUpperCase()+value.slice(1)}return value})}return message};Lang.prototype._testInterval=function(count,interval){if(typeof interval!=="string"){throw"Invalid interval: should be a string."}interval=interval.trim();var matches=interval.match(intervalRegexp);if(!matches){throw"Invalid interval: "+interval}if(matches[2]){var items=matches[2].split(",");for(var i=0;i<items.length;i++){if(parseInt(items[i],10)===count){return true}}}else{matches=matches.filter(function(match){return!!match});var leftDelimiter=matches[1];var leftNumber=convertNumber(matches[2]);if(leftNumber===Infinity){leftNumber=-Infinity}var rightNumber=convertNumber(matches[3]);var rightDelimiter=matches[4];return(leftDelimiter==="["?count>=leftNumber:count>leftNumber)&&(rightDelimiter==="]"?count<=rightNumber:count<rightNumber)}return false};Lang.prototype._getPluralForm=function(count){switch(this.locale){case"az":case"bo":case"dz":case"id":case"ja":case"jv":case"ka":case"km":case"kn":case"ko":case"ms":case"th":case"tr":case"vi":case"zh":return 0;case"af":case"bn":case"bg":case"ca":case"da":case"de":case"el":case"en":case"eo":case"es":case"et":case"eu":case"fa":case"fi":case"fo":case"fur":case"fy":case"gl":case"gu":case"ha":case"he":case"hu":case"is":case"it":case"ku":case"lb":case"ml":case"mn":case"mr":case"nah":case"nb":case"ne":case"nl":case"nn":case"no":case"om":case"or":case"pa":case"pap":case"ps":case"pt":case"so":case"sq":case"sv":case"sw":case"ta":case"te":case"tk":case"ur":case"zu":return count==1?0:1;case"am":case"bh":case"fil":case"fr":case"gun":case"hi":case"hy":case"ln":case"mg":case"nso":case"xbr":case"ti":case"wa":return count===0||count===1?0:1;case"be":case"bs":case"hr":case"ru":case"sr":case"uk":return count%10==1&&count%100!=11?0:count%10>=2&&count%10<=4&&(count%100<10||count%100>=20)?1:2;case"cs":case"sk":return count==1?0:count>=2&&count<=4?1:2;case"ga":return count==1?0:count==2?1:2;case"lt":return count%10==1&&count%100!=11?0:count%10>=2&&(count%100<10||count%100>=20)?1:2;case"sl":return count%100==1?0:count%100==2?1:count%100==3||count%100==4?2:3;case"mk":return count%10==1?0:1;case"mt":return count==1?0:count===0||count%100>1&&count%100<11?1:count%100>10&&count%100<20?2:3;case"lv":return count===0?0:count%10==1&&count%100!=11?1:2;case"pl":return count==1?0:count%10>=2&&count%10<=4&&(count%100<12||count%100>14)?1:2;case"cy":return count==1?0:count==2?1:count==8||count==11?2:3;case"ro":return count==1?0:count===0||count%100>0&&count%100<20?1:2;case"ar":return count===0?0:count==1?1:count==2?2:count%100>=3&&count%100<=10?3:count%100>=11&&count%100<=99?4:5;default:return 0}};return Lang});

(function () {
    Lang = new Lang();
    Lang.setMessages({"GJ.auth":{"app":{"create":"Create","export":"Export","lock_account":"Lock Account","member_since":"Member since","messages":"Messages","online":"Online","print":"Print","profile":"Profile","reload":"Reload","reset":"Reset","search":"Search","settings":"Settings"},"confirm_password":"Confirm Password","email":"Email","failed":"These credentials do not match our records.","forgot_password":{"send_pwd_reset":"Send Password Reset Link","title":"Enter Email to reset password"},"full_name":"Full Name","login":{"forgot_password":"I forgot my password","register_membership":"Register a new membership","title":"Sign in to start your session"},"password":"Password","register":"Register","registration":{"have_membership":"I already have a membership","i_agree":"I agree to","terms":"the terms","title":"Register a new membership"},"remember_me":"Remember Me","reset_password":{"reset_pwd_btn":"Reset Password","title":"Reset your password"},"save":"Save","sign_in":"Sign In","sign_out":"Sign out","throttle":"Too many login attempts. Please try again in :seconds seconds."},"GJ.crud":{"action":"Action","add_new":"Add New","are_you_sure":"Are you sure?","back":"Back","cancel":"Cancel","created_at":"Created At","deleted_at":"Deleted At","detail":"Detail","edit":"Edit","id":"Id","save":"Save","updated_at":"Updated At"},"GJ.messages":{"Gallery":"Gallery","ad_space":{"ad_code":"Ad Code","ad_management":"Ad Management","ad_space":"Ad Spaces","ad_url":"Ad URL","categories":"Categories","desktop":"Desktop View","details_side":"Details Side","disable_ad":"Disable Ad","gallery":"Gallery","header":"Header","index_bottom":"Index Bottom","index_top":"Index Top","mobile":"Mobile View","popular_news":"Popular News","popular_news_index_page":"Popular News (Index Page)","post_details":"Post Details","recommended_post_index_page":"Recommended Post (Index Page)","select_ad_space":"Select Ad Space","trending_post":"Trending Post","trending_post_index_page":"Trending Post (Index Page)"},"add_post":"Add Post","admin":"Admin","ai":{"ai_filter":"AI Filter","best_of":"Best Of","call_ai":"Call AI","frequency_penalty":"Frequency penalty","generate_content":"Generate Content","maximum_length":"Maximum length","model":"Model","presence_penalty":"Presence penalty","temperature":"Temperature","top_p":"Top P"},"album":{"add_album":"Add Album","album":"Album","edit_album":"Edit Album"},"album_categories":"Album Categories","album_category":{"add_album_category":"Add Album Category","album_category":"Album Category","edit_album_category":"Edit Album Category","select_album":"Select Album"},"albums":"Albums","all":"All","allowed_file_size":"Best resolution for this profile will be","apps":"Apps","attachment":"Attachment","bulk_post":{"Optional":"Optional","boolean":"Boolean","bulk_post":"Bulk Post","bulk_post_upload":"Bulk Post Upload","categories":"Categories","category_ids_list":"Category Id list","data_type":"Data Type","documentation":"Documentation","download_csv_example":"Download CSV Example","download_csv_template":"Download CSV Template","example":"Example","field":"Field","help_documents":"Help Documents","id":"Id","integer":"Integer","languages":"Languages","longText":"longText","or":"OR","string":"String","sub_categories":"Sub Categories","test_description_about_this_post":"Test description About this post","test_title":"Test Title","the_images_must_be_a_file_of_type_article_post":"The images must be a file of type:jpg, png ,jpeg","upload_csv_File":"Upload CSV File","you_can_use_csv_file":"You can use these documents to generate your CSV file"},"cash_payment":"Cash Payment","categories":"Categories","category":{"action":"Action","add_category":"Add Category","category_language_warning":"This category is used by posts if you change the language you need to update the category for the posts","color":"Color","edit_category":"Edit Category","language":"Language","show_home":"Show In Home","show_menu":"Show In Menu","slug":"Slug","title":"Title"},"cities":"Cities","comment":{"approval_pending":"Approval Pending","approved":"Show Approved","auto-approved":"Auto Approved","comment":"Comment","comments":"Comments","email":"E-mail","enter_phone_number":"Enter Phone Number","enter_your_email":"Enter Your email","enter_your_name":"Enter Your Name","pending":"Show Pending","post_a_comment":"Post a Comment","type_your_comments":"Type Your Comments","your_name":"Your Name"},"comments":"Comments","common":{"action":"Action","active":"Active","add":"Add","all_rights":"All Rights Reserved","allow_cookies":"Allow Cookies","allowed_types":"Allowed file types: png, jpg, jpeg.","already_have_an_account":"Already have an Account?","apply":"Apply","approval_status":"Approval Status","approved":"Approved","apr":"Apr","april":"April","aug":"Aug","august":"August","back":"Back","by":"By","cancel":"Cancel","cancel_delete":"No, Cancel","cancel_image":"Cancel image","cancel_profile":"Cancel profile","change_cover_image":"Change Cover Image","change_favicon":"Change favicon","change_image":"Change image","change_logo":"Change logo","change_profile":"Change profile","city":"City","closed":"Closed","contact":"Contact","contact_us":"Contact Us","count":"Count","country":"Country","create_an_account":"Create an Account","created_at":"Created At","created_by":"Created by","custom":"Custom","dec":"Dec","december":"December","declined":"Declined","delete":"Yes, Delete","delete_message":"has been deleted","delete_warning":"Are you sure want to delete this","deleted":"Deleted!","details":"Details","discard":"Discard","edit":"Edit","feb":"Feb","february":"February","files":"Files :","get_the_best":"Get The Best Blog Stories Into Your Inbox!","image_error":"The image must be a file of type: png, jpg, jpeg, webp, svg.","image_error_excel":"The image must be a file of type: png, jpg, jpeg, pdf,excel","image_warning":"is not valid! Allowed file types: png, jpg, jpeg.","images":"Images :","jan":"Jan","january":"January","jul":"Jul","july":"July","jun":"Jun","june":"June","language":"Language","leave_a_message":"Leave a Message","login":"Login","mar":"Mar","march":"March","max":"The :attribute must not be greater than :max.","may":"May","name":"Name","new_here":"New Here","no_data_available":"No items found. Try to broaden your search.","note":"Note","nov":"Nov","november":"November","oct":"Oct","october":"October","of":"Of","off":"Off","on":"On","pending":"Pending","please_wait":"Please wait...","read":"Read","register":"Register","rejected":"Rejected","remove_image":"Remove image","required":"The :attribute field is required.","result":"Results","save":"Save","select_an_option":"Options","select_category":"Select Category","select_language":"Select Language","select_subcategory":"Select Sub Category","send":"Send","send_email":"Send Email","sep":"Sep","september":"September","service":"Service","show_contact":"Show Contact Details","showing":"Showing","sign_in_here":"Sign in here","slug":"Slug","state":"State","submit":"Submit","subscribe":"Subscribe","success_msg":"Message has been sent successfully.","tags":"Tags :","time":"Time","title":"Title","to":"To","update":"Update","video_error":"The image must be a file of type: mp4, mov, mkv, webm, avi.","view":"View","your_email":"Your Email"},"contacts":"Contacts","countries":"Countries","dashboard":"Dashboard","dashboard_show":{"drafts":"Drafts","email":"Email","latest_user":"Latest User","name":"NAME","post_views":"Post Views","posts":"Posts","profile":"Profile","recent_user":"Recent User"},"days":{"last_month":"Last Month","last_week":"Last Week","this_month":"This Month","this_week":"This Week","today":"Today"},"delete":"Delete","details":{"admin_panel":"Admin Panel","article":"Article","breaking":"Breaking","category":"Category","contact_us":"Contact Us","featured_post":"Featured Post","gallery":"Gallery","home":"Home","hot_categories":"Hot Categories","language":"Language","latest_news":"Latest News","logout":"Logout","next_post":"Next Post","popular_news":"Popular News","popular_tag":"Popular Tag","popular_tags":"Popular Tags","previous_post":"Previous Post","read_more":"Read More","recommended_post":"Recommended Post","related_post":"Related Post","sort":"Sort","top_stories":"Top Stories","trending_post":"Trending Post","view_more":"View More","view_options":"View Options","view_results":"View Results","views":"Views","vote":"Vote","voting_poll":"VOTING POLL","whats_new":"What's New"},"edit_subscription":"Edit Subscription","email_password_reset_link":"Email Password Reset Link","emails":{"Phone":"Phone","email":"Email","enquiry_details":"Here is a Enquiry Detail","message":"Message","name":"Name","required":"The Email Field is required"},"emoji":{"emoji":"Emoji","emojis":"Emojis"},"enquiry":"Enquiry","forgot_password":"Forgot Password","forgot_your_password":"Forgot your password","forgot_your_password_no_problem_just_let_us_know_your_email_address":"Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one","gallery":{"add_images":"Add Images","album":"Album","category":"Category","date":"Date","edit_images":"Edit Images","id":"Id","image":"Image","language":"Language","select_album":"Select Album","title":"Title"},"home":"Home","images":"Images","language":{"edit_language":"Edit Language","edit_translation":"Edit Translation","front_language":"Front Language","is_active":"Is Active","is_default":"Is Default","is_rtl":"Is RTL","iso_code":"ISO Code","language":"Language","native":"Native","new_language":"New Language","no_language_available":"No Language Available","no_language_found":"No Language Found","translation":"Translation"},"languages":"Languages","mail":"Mail","mails":{"action_required":"If you did not create an account, no further action is required.","contact_messages":"Contact Messages","email":"E-Mail","email_address":"Email Address","email_verification":"Email Verification","emailsend":"Send E-Mail","encryption":"Encryption","hello":"Hello","mail":"Mail","mail_content":"Mail Content","mail_host":"Mail Host","mail_library":"Mail Library","mail_password":"Mail Password","mail_port":"Mail Port","mail_protocol":"Mail Protocol","mail_subject":"Mail Subject","mail_title":"Mail Title","mail_user_name":"Mail Username","manual_payment_request":"Manual Payment Request","manual_payment_status":"Manual Payment Status","new_manual_payment_request":"New Manual Payment Request","please_click":"Please click the button below to verify your email address.","please_follow":"Please follow below step to paid manually.","regard":"Regard","reply_to":"Reply-To","select_encryption":"Select Encryption","select_mail":"Please select Email","select_mail_library":"Select Mail Library","select_mail_protocol":"Select Mail Protocol","send_contact-messages_to_email_address":"Send Contact Messages to Email Address","send_test_email":"Send Test Email","test_mail":"Test Mail","thank_you_chose":"You have selected manual payment guide","thanks_regard":"Thanks & Regards,","verify_email":"Verify Email Address","you_can_not_send_more_than_5_mails":"You can not send more than 5 Mails"},"menu":{"add_menu":"Add Menu","edit_menu":"Edit Menu","link":"Link","menu":"Menu","menu_order":"Menu Order","n_a":"N\/A","parent_menu":"Parent Menu","select_parent_menu":"Select Parent Menu","show_in_menu":"Show In Menu","title":"Title"},"menus":"Menus","months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Jul","jun":"Jun","mar":"Mar","may":"May","nov":"Nov","oct":"Oct","sep":"Sep"},"navigation":"Navigation","navigations":{"menu":"Menu"},"news_letters":"News Letters","no_album_found":"No album available","no_matching_records_found":"No matching records found","no_results_found":"No results found","notes":"Notes","ok":"ok","on_rss_feed":"Total RSS Feed Post","page":{"add_lang":"Select Language","add_page":"Add Page","add_parent_link":"Select Parent Menu Link","dont_add_menu":"Dont Add Menu","edit_page":"Edit Page","footer":"Footer","hide":"Hide","language":"Language","location":"Location","main_menu":"Main Menu","meta_description":"Meta Description","meta_title":"Meta Title","name":"Show Menu On Page","no":"No","page":"Page","parent_menu":"Parent Menu Link","show":"Show","show_breadcrumb":"Show Breadcrumb","show_name":"Name","show_right":"Show Right","show_title":"Show Title","slug":"Slug","title":"Title","top_menu":"Top Menu","user_show":"Show Only to Registered Users","visibility":"Visibility","yes":"Yes"},"pages":"Pages","patients":"Patients","payment_method":"Payment Method","phone":"Phone","placeholder":{"User_profile_updated_successfully":"User profile updated successfully","You_active_more_than_emoji":"You can't active more than 7 emoji","You_already_voted":"You already voted !!","You_can_use_any_one_of_upload_video_or_video_URL_option":"You can use any one of upload video or video URL option","You_disable_less_than_emoji":"You can't disable less than 4 emoji","adSpaces_updated_successfully":"AdSpaces Updated successfully.","album_category_created_successfully":"Album category created successfully.","album_category_deleted_successfully":"Album category deleted successfully.","album_category_retrieved_successfully":"Album category retrieved successfully","album_category_updated_successfully":"Album category updated successfully.","album_created_successfully":"Album created successfully.","album_deleted_successfully":"Album deleted successfully.","album_retrieve_successfully":"Album retrieve successfully.","album_updated_successfully":"Album updated successfully","albums_retrieved_successfully":"Albums retrieved successfully","already_image_exist":"Already Image Exist","best_resolution_for_this_favicon_will_be_32X32":"Best resolution for this favicon will be 32X32.","best_resolution_for_this_logo_will_be_90x60":"Best resolution for this logo will be 90x60.","bulk_post_created_successfully":"Bulk Post created successfully.","category_created_successfully":"Category created Successfully.","category_deleted_successfully":"Category deleted successfully","category_retrieve_successfully":"Category Retrieve Successfully.","category_retrieved_successfully":"Category retrieved successfully.","category_updated_successfully":"Category updated successfully.","chart_updated_successfully":"Chart updated Successfully.","clicking_on_submit_it_will_publish_your_post":"Note: Clicking on submit it will publish your post.","comment_create_successfully":"Comment create successfully","comment_deleted_successfully":"Comment deleted successfully.","comment_setting_updated_successfully":"Comment Setting updated successfully.","contact_deleted_successfully":"Contact deleted successfully.","contact_number_field_is_required":"Contact Number field is required","content_generated_successfully":"Content Generated successfully.","controls_diversity_via_nucleus_sampling":"Controls diversity via nucleus sampling: 0.5 means half of all likelihood-         weighted options are considered.","controls_randomness_lowering_results_in_less_random_completions":"Controls randomness: Lowering results in less random completions. As the temperature approaches zero, the model will become deterministic and repetitive.","created_request_for_payment_of":"created request for payment of","current_password_in_invalid":"Current password is invalid.","data_retried":"Data retried","default_language_deleted":"Default Language can't be deleted","default_plan":"This plan is Default","default_plan_changed_successfully":"Default plan changed successfully","default_role_do_not_deleted":"Default role do not deleted.","desktop_view_image_dimensions_must_be_800X130":"Desktop View image Dimensions must be 800X130","email_send_successfully":"Email send successfully.","email_setting_updated_successfully":"Email setting updated successfully.","emoji_created_successfully.":"Emoji created successfully.","emoji_deleted_successfully.":"Emoji deleted successfully.","emoji_status_updated_successfully":"Emoji Status Updated Successfully.","feed_updated_successfully":"Feed updated successfully.","file_not_found":"file not found","gallery_image_created_successfully":"Gallery Image Created successfully.","gallery_image_deleted_successfully.":"Gallery Image Deleted successfully.","gallery_image_updated_successfully":"Gallery Image Updated successfully","gallery_title_must_not_be_greater_than_190_characters":"Gallery Title must not be greater than 190 characters","generates_multiple_completions_server_side":"Generates multiple completions server- side, and displays only the best. Streaming only works when set to 1. Since it acts as a multiplier on the number of completions, this parameters can eat into your token quota very quickly - use caution!","given_post_is_not_yet_published":"Given post is not yet published","image_delete_successfully":"Image Delete successfully","image_upload_successfully":"Image Upload successfully","img_retrieved":"img retrieved","keyword_should_be_of_maximum_10_words_only":"Keyword should be of maximum 10 words only","language_added_to_front_successfully":"Language added to front successfully","language_be_deleted":"Language can't be deleted.","language_change_successfully":"Language change successfully","language_changed_successfully":"Language changed successfully","language_deleted_successfully":"Language Deleted Successfully.","language_not_found":"language not found","language_removed_from_front_successfully":"Language removed from front successfully","language_retrieved_successfully":"Language Retrieved Successfully","language_saved_successfully":"Language saved successfully.","language_saved_successfully.":"Language saved successfully.","language_updated_successfully":"Language updated Successfully.","login_via_facebook":"Login Via Facebook","login_via_google":"Login Via Google","mail_content_required":"Mail Content is required","mail_subject_required":"Mail Subject is required","mail_updated_successfully":"Mail Updated Successfully","menu_created_successfully":"Menu created successfully.","menu_deleted_successfully":"Menu deleted successfully","menu_update_successfully":"Menu update successfully.","mobile_view_image_dimensions_must_be_350X290":"Mobile View image Dimensions must be 350X290","name_field_is_required":"Name field is required","navigation_updated_successfully":"Navigation updated successfully.","page_created_successfully":"Page created successfully","page_deleted_successfully":"Page deleted successfully.","page_updated_successfully":"Page updated successfully","password_updated_successfully":"Password updated successfully","payment_received":"Payment Received successfully.","plan_already_used":"Plan already used","plan_created_successfully":"Plan created successfully","plan_deleted_successfully.":"Plan deleted successfully.","plan_updated_successfully":"Plan updated successfully","please_enter_CSV_files":"Please enter CSV files","please_enter_video_URL":"Please enter video URL","please_enter_video_url_or_upload_a_video":"Please enter video url or upload a video","please_enter_video_url_or_upload_video":"Please enter video url or upload video","please_select_any_one_permission":"Please select any one permission","please_select_audio_file":"Please select audio file","please_upgrade_plan":"Please Upgrade Plan","poll_created_successfully":"Poll created successfully.","poll_deleted_successfully":"Poll deleted successfully.","poll_updated_successfully":"Poll updated successfully.","poll_voted_successfully":"Poll voted successfully","post_added_on_headline_successfully":"Post added on headline successfully","post_added_to_breaking_successfully":"Post added to breaking successfully","post_added_to_featured_successfully":"Post added to featured successfully","post_added_to_recommended_successfully":"Post added to recommended successfully","post_added_to_slider_successfully":"Post added to slider successfully","post_added_to_visibility_successfully":"Post added to visibility successfully","post_created_successfully":"Post created successfully.","post_deleted_successfully":"Post deleted successfully.","post_removed_from_breaking_successfully":"Post removed from breaking successfully","post_removed_from_featured_successfully":"Post removed from featured successfully","post_removed_from_headline_successfully":"Post removed from headline successfully","post_removed_from_recommended_successfully":"Post removed from recommended successfully","post_removed_from_slider_successfully":"Post removed from slider successfully","post_removed_from_visibility_successfully":"Post removed from visibility successfully","post_updated_successfully":"Post updated successfully.","reCAPTCHA_required":"reCAPTCHA required!","registered_success":"You have registered successfully, Activate your account from mail.","role_already_exists":"Role Already Exists.","role_created_successfully":"Role Created successfully","role_deleted_successfully":"Role deleted successfully.","role_updated_successfully":"Role updated successfully.","rss_feed_create_successfully":"RSS Feed Create successfully","rss_feed_deleted_successfully":"RSS Feed deleted successfully","rss_feed_update_successfully":"RSS Feed Update successfully.","seo_tools_updated_successfully":"SEO Tools updated successfully.","session_created_successfully":"Session created successfully","settings_updated_successfully":"Settings updated successfully","show_in_home_updated_successfully":"Show in home updated successfully","show_in_menu_updated_successfully":"Show in menu updated successfully","something_wrong_occurred_please_try_again":"Something wrong occurred please try again","sort_list_title_must_not_be_greater_than_190_characters":"Sort List Title must not be greater than 190 characters","staff_created_successfully":"Staff created successfully.","staff_deleted_successfully":"Staff deleted successfully.","staff_updated_successfully":"Staff updated successfully.","status_updated_successfully":"Status updated successfully.","sub_categories_saved_successfully":"Sub Categories saved successfully.","sub_category_delete_successfully":"Sub Category Delete Successfully","sub_category_retrieved_successfully":"Sub category retrieved successfully.","sub_category_updated_successfully":"Sub Category updated successfully","subscribed_plan_wait":"You subscribed this plan successfully but wait for confirmation from Admin","subscribed_successfully":"Subscribed successfully","subscriber_delete_successfully":"Subscriber delete successfully.","subscription_date_successfully_updated":"Subscription date successfully updated.","subscription_successfully_retrieved":"Subscription successfully retrieved","successfully_verified":"You have successfully verified your mail, please login.","test_mail_send_successfully":"Test Mail Send Successfully","the_audios_must_be_a_file_of_type":"The audios must be a file of type: mp3, M4A, wav, aac, wma.","the_images_must_be_a_file_of_type":"The images must be a file of type: jpeg, png, jpg, webp,svg.","the_iso_code_field_is_required":"The ISO Code field is required","the_maximum_number_of_tokens_to_generate_requests_can_use_up":"The maximum number of tokens to generate. Requests can use up to 2,048 or 4,000 tokens shared between prompt and completion. The exact limit varies by model. (One token is roughly 4 characters for normal English text)","the_upload_csv_file_field_is_required":"The Upload CSV File field is required.","the_upload_video_must_not_be_greater_than_150_MB":"The upload video must not be greater than 150 MB.","theme_changed_successfully":"Theme Changed Successfully","these_credentials_do_not_match_our_records":"These credentials do not match our records.","this_album_category_is_in_use":"This Album Category is in use","this_album_is_in_use":"This Album is in use","this_category_is_in_use":"This category is in use","this_currency_is_not_supported":"This Currency is not supported","this_email_is_already_subscribed":"This email is already subscribed","this_sub_category_is_in_use":"This Sub category is in use","thumbnail_image_is_required":"Thumbnail image is required","unable_to_process_payment":"Unable to process the payment at the moment. Try again later.","visibility_updated_successfully":"Visibility updated successfully","you_can_use_any_one_of_upload_video_or_video_URL_option":"You can use any one of upload video or video URL option","you_delete_than_emoji":"You can't Delete than 4 emoji","your_account_is_currently_disabled_please_contact_to_administrator":"Your account is currently disabled, please contact to administrator.","your_mail_already_verified":"Your mail is already verified, please login.","your_manual_payment_request_is":"Your Manual Payment Request Is","your_plan_is_expired_Please_choose_a_plan_to_continue_the_services":"Your plan is expired. Please choose a plan to continue the services"},"plans":{"add_plan":"Add Plan","allowed_post":"Allowed Post","currency":"Currency","default_Plan":"Default Plan","edit_plan":"Edit Plan","enter_trial":"Enter Trial","frequency":"Frequency","monthly":"Monthly","new_plan":"New Plan","no_of_posts":"No Of Posts","plan":"Plan","plan_name":"Plan Name","plans":"Plans","price":"Price","select_currency":"Select Currency","trial_days":"Trial Days","unlimited":"Unlimited","yearly":"Yearly"},"poll":{"add_poll":"Add Poll","add_polls":"Add Polls","all_user":"All user","edit_poll":"Edit Poll","no_result_found":"No Result found","option1":"Option 1","option10":"Option 10","option2":"Option 2","option3":"Option 3","option4":"Option 4","option5":"Option 5","option6":"Option 6","option7":"Option 7","option8":"Option 8","option9":"Option 9","poll":"Poll","poll_result":"Poll Result","question":"Question","register_user":"Register User","show_result":"Show Result","total_vote":"Total Vote","view_option":"View Option","voting_poll":"Voting Poll"},"polls":"Polls","post":{"add_ai":"Write Post Using OpenAI","add_article":"Add Article","add_audio":"Add Audio","add_gallery":"Add Gallery","add_image":"Add Image","add_new_item":"Add New Item","add_on_headline":"Add On Headline","add_personality_quiz":"Add Personality Quiz","add_post":"Add Post","add_sort_list":"Add Sort List","add_to_breaking":"Add to Breaking","add_to_featured":"Add to Featured","add_to_recommended":"Add to Recommended","add_to_slider":"Add to Slider","add_trivia_quiz":"Add Trivia Quiz","add_video":"Add Video","additional":"Additional Images","allowed_images_jpg_png_jpeg":"(JPG,PNG,JPEG,SVG,WEBP)","article":"Article","article_with_images":"An article with images and embed videos","article_with_open_ai":"Write your content using OpenAI","audio":"Audio","category":"Category","choose_post_format":"Choose a Post Format","collection_of_images":"collection of images","d&t":"Pick Date & time","description":"Description","draft":"Save as Draft","draft_post":"Draft","edit_AI":"Edit Post","edit_Article":"Edit Article","edit_Audio":"Edit Audio","edit_Gallery":"Edit Gallery","edit_Sorted":"Edit Sort List","edit_Video":"Edit Video","edit_post":"Edit Post","featured":"Featured","file":"File","gallery":"Gallery","gallery_post_item":"Gallery List Item","get_video":"Get Video from URL","image":"Image","image_description":"Image Description","keywords":"Keywords","list_based_article":"A list based article","open_ai":"Open AI","optional_url":"Optional URL","or_add_url":"Or Add URL","personality_quiz":"Personality Quiz","pick_date":"Pick Date","post":"Post","post_details":"Post Details","post_type":"Post Type","posts":"Posts","publish":"Publish","publish_post":"Publish Post","quizzes_with_custom_results":"Quizzes with custom results","quizzes_with_right_and_wrong_answers":"Quizzes with right and wrong answers","remove_on_headline":"Remove On Headline","remove_to_breaking":"Remove to Breaking","remove_to_featured":"Remove to Featured","remove_to_recommended":"Remove to Recommended","remove_to_slider":"Remove to Slider","scheduled_post":"Scheduled Post","select_image":"Select Image","select_post":"Select Post","select_post_type":"Select Post Type","selected_file":"Selected Files","short_description":"Short Description","show_download_button":"Show Download Button","show_on_headline":"On Headline","show_registered_user":"Show Only to Registered Users","show_right":"Show Right Column","sort_list":"Sorted List","sort_list_item":"Sorted List Item","spotted_video":"(Youtube, Vimeo, Dailymotion)","sub_category":"Sub Category","submit":"Submit","tag":"Tag","thumbnail_image":"Please enter a valid URL","trivia_quiz":"Trivia Quiz","upload_audios_and_create_playlist":"Upload audios and create playlist","upload_or_embed_videos":"Upload or embed videos","upload_video":"Upload Video","video":"Video","video_embed_code":"Video Embed Code","video_thumbnail":"Video Thumbnail","video_url":"Video URL","visibility":"Visibility"},"post_reaction":"Post Reaction","reaction":{"angry":"Angry","dislike":"Dislike","funny":"Funny","like":"Like","love":"Love","pray":"Pray","sad":"Sad","super":"Super","wow":"Wow"},"recent_posts":"Recent Posts","required":"Required","role":{"add_role":"Add Role","edit_role":"Edit Role","permissions":"Permissions","role":"Role","role_permissions":"Role Permissions","select_all_permissions":"Select All Permissions"},"roles":"Roles","roles_permissions":"Roles Permissions","rss-feed":"RSS Feed","rss_feed":{"ad_code":"Ad Code","add_posts":"Add Posts as Draft","add_rss_feed":"Add RSS Feed","auto_update":"Auto Update","btn_text":"Read More Button Text","edit_rss_feed":"Edit RSS Feed","feed_name":"Feed Name","feed_url":"Feed URL","generate_keywords":"Generate Keywords from Title","images_source":"Images Source","keywords":"Keywords","my_server":"Download Images to My Server","no":"No","no_posts":"Max Import Post","original_source":"Show Images from Original Source","post_import":"Posts\/Import","scheduled_post_delete":"Scheduled Post delete","show_btn":"Show Read More Button","show_btn_text":"Show Button","yes":"Yes"},"save":"Save","search":"Search","seo-tool":{"google_analytics":"Google Analytics","home_title":"Home Title","keyword":"Keyword","language":"Language","maxkeyword":"Enter maximum 10 Keywords","site_description":"Site Description","site_title":"Site Title"},"seo-tools":"SEO Tools","service_categories":"Service Categories","services":"Services","setting":{"Manually":"Manually","Paypal":"Paypal","Stripe":"Stripe","about_text":"About Text","address":"Address","advanced_setting":"Advanced Setting","app_name":"App Name","cms":"CMS","contact_address":"Contact Address","contact_information":"Contact Information","cookie_warning":"Cookie Warnings","copy_right_text":"Copyright Text","currency":"Currency","currency_settings":"Currency Settings","download-db":"Download DB","emoji_system":"Emoji System","facebook":"Facebook","facebook_url":"Facebook URL","favicon":"Favicon","front_language":"Default Front Language","general":"General","general_details":"General Details","generate_sitemap":"Generate Sitemap","google_recaptcha":"Google Recaptcha","instagram_url":"Instagram URL","invalid_facebook_url":"Please enter a valid Facebook URL","invalid_instagram_url":"Please enter a valid Instagram URL","invalid_linkedin_url":"Please enter a valid LinkedIn URL","invalid_pinterest_url":"Please enter a valid Pinterest URL","invalid_telegram_url":"Please enter a valid Telegram URL","invalid_twitter_url":"Please enter a valid Twitter URL","invalid_vk_url":"Please enter a valid VK URL","invalid_youtube_url":"Please enter a valid Youtube URL","linkedIn":"LinkedIn","linkedin_url":"LinkedIn URL","logo":"Logo","manual_payment_guide":"Manual Payment Guide","pinterest_url":"Pinterest URL","postal_code":"Postal Code","prefix":"Prefix","privacy":"Privacy","reddit":"Reddit","registration_system":"Registration System","required_privacy":"Privacy field is required","required_support":"Support field is required","required_t&c":"Terms & conditions field is required","rss_feed_auto_update":"Auto Update RSS Feed","run_commend":"Generate Sitemap","secret_key":"Secret Key","select_time":"Select Time","setting":"Setting","show_captcha":"Show Recaptcha","show_cookie_warning":"Show Cookie Warnings","site_key":"Site Key","social_media_setting":"Social Media Settings","social_media_sharing":"Social Media Shared","support":"Support","telegram_url":"Telegram URL","terms-conditions":"Terms & conditions","twitter":"Twitter","twitter_url":"Twitter URL","vk_url":"VK URL","whatsapp":"Whatsapp","youtube_url":"Youtube URL"},"settings":"Settings","share_this_post":"Share This Post","show":"Show","staff":{"about_us":"About Us","add_staff":"Add Staff","confirm_password":"Confirm Password","contact_no":"Contact No","cover_image":"Cover Image","edit_staff":"Edit Staff","email":"Email","email_verified":"Email Verified","female":"Female","first_name":"First Name","gender":"Gender","last_name":"Last Name","male":"Male","password":"Password","profile":"Profile","role":"Role","staff":"Staff","username":"Username"},"staffs":"Staffs","states":"States","status":"Status","sub_categories":"Sub Categories","sub_category":{"action":"Action","add":"Add Sub Category","add_lan":"Language","category":"Category","edit":"Edit Sub Category","language":"Language","select_cat":"Select Category","show_menu":"Show In Menu","title":"Title"},"subscribed_user":"Subscribed User Plans","subscriber":"Subscriber","subscription":{"active_until":"Active Until","active_until_unlimited":"Active till Unlimited","amount":"Amount","cancel_subscription":"Cancel Subscription","change_payment_status":"Change payment Status","choose_plan":"Choose Plan","current_expire":"Current Expired Plan","current_plan":"Current Plan","currently_active":"Currently Active","days":"Days","duration":"Duration","end_date":"End Date","expired":"Plan is Already Expired on","expired_date":"Expired date","free":"Free","has_already_been_subscribed":"is already subscribed","has_been_subscribed":"has been subscribed","history":"Subscription History","manage_subscription":"Manage Subscription","months":"Months","no_plan_available":"No Plan Available","number_of_post":"Number Of Post","pay_or_switch_plan":"Pay \/ Switch Plan","payable_amount":"Payable Amount","payment":"Payment","plan_name":"Plan Name","plan_price":"Plan Price","proceed_to_payment":"Proceed to Payment","purchase":"Purchase","remaining":"Remaining","remaining_balance":"Remaining Balance","remaining_days":"Remaining Days","renew_free_plan":"Free Plan cannot be renewed\/chosen again","renew_plan":"Renew Plan","start_date":"Start Date","subscribed_date":"Subscribed Date","switch_plan":"Switch Plan","total_days":"Total Days","trial_plan":"Trial Plan","upgrade_plan":"Upgrade Plan","used_balance":"Used Balance","used_days":"Used Days","what_in_startup_plan":"What`s In Startup Plan","year":"Year"},"sync":"Sync","translation_manager":"Translation Manager","user":{"account":"Account","account_setting":"Account Settings","avatar":"Avatar","change_password":"Change Password","confirm_password":"Confirm Password","contact_number":"Contact Number","current_password":"Current Password","email":"Email","full_name":"Full Name","gender":"Gender","new_password":"New Password","profile":"Profile","profile_details":"Profile Details","save_changes":"Save Changes","setting":"Setting","staff_details":"Staff Details"},"users":"Users","weekdays":{"fri":"FRI","mon":"MON","sat":"SAT","sun":"SUN","thu":"THU","tue":"TUE","wed":"WED"}},"GJ.pagination":{"next":"Next &raquo;","previous":"&laquo; Previous"},"GJ.passwords":{"reset":"Your password has been reset!","sent":"We have emailed your password reset link!","throttled":"Please wait before retrying.","token":"This password reset token is invalid.","user":"We can't find a user with that email address."},"GJ.validation":{"accepted":"The :attribute must be accepted.","accepted_if":"The :attribute must be accepted when :other is :value.","active_url":"The :attribute is not a valid URL.","after":"The :attribute must be a date after :date.","after_or_equal":"The :attribute must be a date after or equal to :date.","alpha":"The :attribute must only contain letters.","alpha_dash":"The :attribute must only contain letters, numbers, dashes and underscores.","alpha_num":"The :attribute must only contain letters and numbers.","array":"The :attribute must be an array.","ascii":"The :attribute must only contain single-byte alphanumeric characters and symbols.","attributes":[],"before":"The :attribute must be a date before :date.","before_or_equal":"The :attribute must be a date before or equal to :date.","between":{"array":"The :attribute must have between :min and :max items.","file":"The :attribute must be between :min and :max kilobytes.","numeric":"The :attribute must be between :min and :max.","string":"The :attribute must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","confirmed":"The :attribute confirmation does not match.","current_password":"The password is incorrect.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"The :attribute is not a valid date.","date_equals":"The :attribute must be a date equal to :date.","date_format":"The :attribute does not match the format :format.","decimal":"The :attribute must have :decimal decimal places.","declined":"The :attribute must be declined.","declined_if":"The :attribute must be declined when :other is :value.","different":"The :attribute and :other must be different.","digits":"The :attribute must be :digits digits.","digits_between":"The :attribute must be between :min and :max digits.","dimensions":"The :attribute has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","doesnt_end_with":"The :attribute may not end with one of the following: :values.","doesnt_start_with":"The :attribute may not start with one of the following: :values.","email":"The :attribute must be a valid email address.","ends_with":"The :attribute must end with one of the following: :values.","enum":"The selected :attribute is invalid.","exists":"The selected :attribute is invalid.","file":"The :attribute must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute must have more than :value items.","file":"The :attribute must be greater than :value kilobytes.","numeric":"The :attribute must be greater than :value.","string":"The :attribute must be greater than :value characters."},"gte":{"array":"The :attribute must have :value items or more.","file":"The :attribute must be greater than or equal to :value kilobytes.","numeric":"The :attribute must be greater than or equal to :value.","string":"The :attribute must be greater than or equal to :value characters."},"image":"The :attribute must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field does not exist in :other.","integer":"The :attribute must be an integer.","ip":"The :attribute must be a valid IP address.","ipv4":"The :attribute must be a valid IPv4 address.","ipv6":"The :attribute must be a valid IPv6 address.","json":"The :attribute must be a valid JSON string.","lowercase":"The :attribute must be lowercase.","lt":{"array":"The :attribute must have less than :value items.","file":"The :attribute must be less than :value kilobytes.","numeric":"The :attribute must be less than :value.","string":"The :attribute must be less than :value characters."},"lte":{"array":"The :attribute must not have more than :value items.","file":"The :attribute must be less than or equal to :value kilobytes.","numeric":"The :attribute must be less than or equal to :value.","string":"The :attribute must be less than or equal to :value characters."},"mac_address":"The :attribute must be a valid MAC address.","max":{"array":"The :attribute must not have more than :max items.","file":"The :attribute must not be greater than :max kilobytes.","numeric":"The :attribute must not be greater than :max.","string":"The :attribute must not be greater than :max characters."},"max_digits":"The :attribute must not have more than :max digits.","mimes":"The :attribute must be a file of type: :values.","mimetypes":"The :attribute must be a file of type: :values.","min":{"array":"The :attribute must have at least :min items.","file":"The :attribute must be at least :min kilobytes.","numeric":"The :attribute must be at least :min.","string":"The :attribute must be at least :min characters."},"min_digits":"The :attribute must have at least :min digits.","multiple_of":"The :attribute must be a multiple of :value.","not_in":"The selected :attribute is invalid.","not_regex":"The :attribute format is invalid.","numeric":"The :attribute must be a number.","password":{"letters":"The :attribute must contain at least one letter.","mixed":"The :attribute must contain at least one uppercase and one lowercase letter.","numbers":"The :attribute must contain at least one number.","symbols":"The :attribute must contain at least one symbol.","uncompromised":"The given :attribute has appeared in a data leak. Please choose a different :attribute."},"present":"The :attribute field must be present.","prohibited":"The :attribute field is prohibited.","prohibited_if":"The :attribute field is prohibited when :other is :value.","prohibited_unless":"The :attribute field is prohibited unless :other is in :values.","prohibits":"The :attribute field prohibits :other from being present.","regex":"The :attribute format is invalid.","required":"The :attribute field is required.","required_array_keys":"The :attribute field must contain entries for: :values.","required_if":"The :attribute field is required when :other is :value.","required_if_accepted":"The :attribute field is required when :other is accepted.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values are present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","same":"The :attribute and :other must match.","size":{"array":"The :attribute must contain :size items.","file":"The :attribute must be :size kilobytes.","numeric":"The :attribute must be :size.","string":"The :attribute must be :size characters."},"starts_with":"The :attribute must start with one of the following: :values.","string":"The :attribute must be a string.","timezone":"The :attribute must be a valid timezone.","ulid":"The :attribute must be a valid ULID.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","uppercase":"The :attribute must be uppercase.","url":"The :attribute must be a valid URL.","uuid":"The :attribute must be a valid UUID."},"ar.auth":{"app":{"create":"\u062e\u0644\u0642","export":"\u064a\u0635\u062f\u0651\u0631","lock_account":"\u062d\u0633\u0627\u0628 \u0642\u0641\u0644","member_since":"\u0639\u0636\u0648 \u0645\u0646\u0630","messages":"\u0631\u0633\u0627\u0626\u0644","online":"\u0645\u062a\u0635\u0644","print":"\u0645\u0637\u0628\u0639\u0629","profile":"\u062d\u0633\u0627\u0628 \u062a\u0639\u0631\u064a\u0641\u064a","reload":"\u0625\u0639\u0627\u062f\u0629 \u062a\u062d\u0645\u064a\u0644","reset":"\u0625\u0639\u0627\u062f\u0629 \u0636\u0628\u0637","search":"\u0628\u062d\u062b","settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a"},"confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","failed":"\u0623\u0648\u0631\u0627\u0642 \u0627\u0644\u0627\u0639\u062a\u0645\u0627\u062f \u0647\u0630\u0647 \u0644\u0627 \u062a\u062a\u0637\u0627\u0628\u0642 \u0645\u0639 \u0633\u062c\u0644\u0627\u062a\u0646\u0627.","forgot_password":{"send_pwd_reset":"\u0625\u0631\u0633\u0627\u0644 \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631","title":"\u0623\u062f\u062e\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0644\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631"},"full_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0643\u0627\u0645\u0644","login":{"forgot_password":"\u0644\u0642\u062f \u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","register_membership":"\u062a\u0633\u062c\u064a\u0644 \u0639\u0636\u0648\u064a\u0629 \u062c\u062f\u064a\u062f\u0629","title":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0628\u062f\u0621 \u0627\u0644\u062c\u0644\u0633\u0629 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643"},"password":"\u0643\u0644\u0645\u0647 \u0627\u0644\u0633\u0631","register":"\u064a\u0633\u062c\u0644","registration":{"have_membership":"\u0644\u062f\u064a \u0639\u0636\u0648\u064a\u0629 \u0628\u0627\u0644\u0641\u0639\u0644","i_agree":"\u0623\u0648\u0627\u0641\u0642 \u0639\u0644\u0649","terms":"\u0627\u0644\u0634\u0631\u0648\u0637","title":"\u062a\u0633\u062c\u064a\u0644 \u0639\u0636\u0648\u064a\u0629 \u062c\u062f\u064a\u062f\u0629"},"remember_me":"\u062a\u0630\u0643\u0631\u0646\u0649","reset_password":{"reset_pwd_btn":"\u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","title":"\u0627\u0639\u062f \u0636\u0628\u0637 \u0643\u0644\u0645\u0647 \u0627\u0644\u0633\u0631"},"save":"\u064a\u062d\u0641\u0638","sign_in":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","sign_out":"\u062e\u0631\u0648\u062c","throttle":"\u0645\u062d\u0627\u0648\u0644\u0627\u062a \u062a\u0633\u062c\u064a\u0644 \u062f\u062e\u0648\u0644 \u0643\u062b\u064a\u0631\u0629 \u062c\u062f\u064b\u0627. \u064a\u0631\u062c\u0649 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649 \u062e\u0644\u0627\u0644: \u062b\u0648\u0627\u0646\u064a."},"ar.backup::notifications":{"application_name":"\u0627\u0633\u0645 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","backup_failed_body":"\u0645\u0647\u0645: \u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a :application_name","backup_failed_subject":"\u0623\u062e\u0641\u0642 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a \u0644\u0644 :application_name","backup_name":"\u0627\u0633\u0645 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a","backup_successful_body":"\u0623\u062e\u0628\u0627\u0631 \u0639\u0638\u064a\u0645\u0629\u060c \u0646\u0633\u062e\u0629 \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u062c\u062f\u064a\u062f\u0629 \u0644 :application_name \u062a\u0645 \u0625\u0646\u0634\u0627\u0624\u0647\u0627 \u0628\u0646\u062c\u0627\u062d \u0639\u0644\u0649 \u0627\u0644\u0642\u0631\u0635 \u0627\u0644\u0645\u0633\u0645\u0649 :disk_name.","backup_successful_subject":"\u0646\u0633\u062e \u0627\u062d\u062a\u064a\u0627\u0637\u064a \u062c\u062f\u064a\u062f \u0646\u0627\u062c\u062d \u0644 :application_name","backup_successful_subject_title":"\u0646\u062c\u0627\u062d \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a \u0627\u0644\u062c\u062f\u064a\u062f!","cleanup_failed_body":"\u062d\u062f\u062b \u062e\u0637\u0623 \u0623\u062b\u0646\u0627\u0621 \u062a\u0646\u0638\u064a\u0641 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name","cleanup_failed_subject":"\u0641\u0634\u0644 \u062a\u0646\u0638\u064a\u0641 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a \u0644\u0644\u062a\u0637\u0628\u064a\u0642 :application_name .","cleanup_successful_body":"\u062a\u0646\u0638\u064a\u0641 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name \u0639\u0644\u0649 \u0627\u0644\u0642\u0631\u0635 \u0627\u0644\u0645\u0633\u0645\u0649 :disk_name \u062a\u0645 \u0628\u0646\u062c\u0627\u062d.","cleanup_successful_subject":"\u062a\u0646\u0638\u064a\u0641 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name \u062a\u0645\u062a \u0628\u0646\u062c\u0627\u062d","cleanup_successful_subject_title":"\u062a\u0646\u0638\u064a\u0641 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u062a\u0645 \u0628\u0646\u062c\u0627\u062d!","disk":"\u0627\u0644\u0642\u0631\u0635","exception_message":"\u0631\u0633\u0627\u0644\u0629 \u0627\u0633\u062a\u062b\u0646\u0627\u0621: :message","exception_message_title":"\u0631\u0633\u0627\u0644\u0629 \u0627\u0633\u062a\u062b\u0646\u0627\u0621","exception_trace":"\u062a\u062a\u0628\u0639 \u0627\u0644\u0625\u0633\u062a\u062b\u0646\u0627\u0621: :trace","exception_trace_title":"\u062a\u062a\u0628\u0639 \u0627\u0644\u0625\u0633\u062a\u062b\u0646\u0627\u0621","healthy_backup_found_body":"\u062a\u0639\u062a\u0628\u0631 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name \u0635\u062d\u064a\u0629. \u0639\u0645\u0644 \u062c\u064a\u062f!","healthy_backup_found_subject":"\u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name \u0639\u0644\u0649 \u0627\u0644\u0642\u0631\u0635 :disk_name \u0635\u062d\u064a\u0629","healthy_backup_found_subject_title":"\u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name \u0635\u062d\u064a\u0629","newest_backup_date":"\u0623\u062d\u062f\u062b \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a","newest_backup_size":"\u0623\u062d\u062f\u062b \u062d\u062c\u0645 \u0644\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a","no_backups_info":"\u0644\u0645 \u064a\u062a\u0645 \u0639\u0645\u0644 \u0646\u0633\u062e \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u062d\u062a\u0649 \u0627\u0644\u0622\u0646","number_of_backups":"\u0639\u062f\u062f \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629","oldest_backup_date":"\u0623\u0642\u062f\u0645 \u062a\u0627\u0631\u064a\u062e \u0646\u0633\u062e \u0627\u062d\u062a\u064a\u0627\u0637\u064a","total_storage_used":"\u0625\u062c\u0645\u0627\u0644\u064a \u0645\u0633\u0627\u062d\u0629 \u0627\u0644\u062a\u062e\u0632\u064a\u0646 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0629","unhealthy_backup_found_body":"\u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name \u0639\u0644\u0649 \u0627\u0644\u0642\u0631\u0635 :disk_name \u063a\u064a\u0631 \u0635\u062d\u064a\u0629.","unhealthy_backup_found_empty":"\u0644\u0627 \u062a\u0648\u062c\u062f \u0646\u0633\u062e \u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644\u0647\u0630\u0627 \u0627\u0644\u062a\u0637\u0628\u064a\u0642 \u0639\u0644\u0649 \u0627\u0644\u0625\u0637\u0644\u0627\u0642.","unhealthy_backup_found_full":"\u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u062a\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0643\u062b\u064a\u0631 \u0645\u0646 \u0627\u0644\u062a\u062e\u0632\u064a\u0646. \u0627\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u062d\u0627\u0644\u064a \u0647\u0648 :disk_usage \u0648\u0647\u0648 \u0623\u0639\u0644\u0649 \u0645\u0646 \u0627\u0644\u062d\u062f \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647 \u0645\u0646 :disk_limit.","unhealthy_backup_found_not_reachable":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u0627\u0644\u0648\u0635\u0648\u0644 \u0625\u0644\u0649 \u0648\u062c\u0647\u0629 \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a. :error","unhealthy_backup_found_old":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0623\u062d\u062f\u062b \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0641\u064a :date \u0648\u062a\u0639\u062a\u0628\u0631 \u0642\u062f\u064a\u0645\u0629 \u062c\u062f\u0627.","unhealthy_backup_found_subject":"\u0645\u0647\u0645: \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name \u063a\u064a\u0631 \u0635\u062d\u064a\u0629","unhealthy_backup_found_subject_title":"\u0645\u0647\u0645: \u0627\u0644\u0646\u0633\u062e \u0627\u0644\u0627\u062d\u062a\u064a\u0627\u0637\u064a\u0629 \u0644 :application_name \u063a\u064a\u0631 \u0635\u062d\u064a\u0629. :problem","unhealthy_backup_found_unknown":"\u0639\u0630\u0631\u0627\u060c \u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062d\u062f\u064a\u062f \u0633\u0628\u0628 \u062f\u0642\u064a\u0642."},"ar.cookieConsent::texts":{"agree":"\u0627\u0644\u0633\u0645\u0627\u062d","message":"Your experience on this site will be improved by allowing cookies."},"ar.crud":{"action":"\u0639\u0645\u0644","add_new":"\u0627\u0636\u0641 \u062c\u062f\u064a\u062f","are_you_sure":"\u0647\u0644 \u0623\u0646\u062a \u0648\u0627\u062b\u0642\u061f","back":"\u062e\u0644\u0641","cancel":"\u064a\u0644\u063a\u064a","created_at":"\u0623\u0646\u0634\u0626\u062a \u0641\u064a","deleted_at":"\u0645\u062d\u0630\u0648\u0641 \u0641\u064a","detail":"\u0627\u0644\u062a\u0641\u0627\u0635\u064a\u0644","edit":"\u062a\u0639\u062f\u064a\u0644","id":"\u0647\u0648\u064a\u0629 \u0634\u062e\u0635\u064a\u0629","save":"\u064a\u062d\u0641\u0638","updated_at":"\u062a\u0645 \u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0641\u064a"},"ar.messages":{"Gallery":"\u0635\u0627\u0644\u0629 \u0639\u0631\u0636","ad_space":{"ad_code":"\u0643\u0648\u062f \u0627\u0644\u0625\u0639\u0644\u0627\u0646","ad_management":"\u0625\u062f\u0627\u0631\u0629 \u0627\u0644\u0625\u0639\u0644\u0627\u0646\u0627\u062a","ad_space":"\u0645\u0633\u0627\u062d\u0627\u062a \u0625\u0639\u0644\u0627\u0646\u064a\u0629","ad_url":"\u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u0625\u0639\u0644\u0627\u0646","categories":"\u0641\u0626\u0627\u062a","desktop":"\u0639\u0631\u0636 \u0633\u0637\u062d \u0627\u0644\u0645\u0643\u062a\u0628","details_side":"\u0627\u0644\u062a\u0641\u0627\u0635\u064a\u0644 \u062c\u0627\u0646\u0628","disable_ad":"\u062a\u0639\u0637\u064a\u0644 \u0627\u0644\u0625\u0639\u0644\u0627\u0646","gallery":"\u0635\u0627\u0644\u0629 \u0639\u0631\u0636","header":"\u0631\u0623\u0633","index_bottom":"\u0641\u0647\u0631\u0633 \u0633\u0641\u0644\u064a","index_top":"\u0623\u0639\u0644\u0649 \u0627\u0644\u0641\u0647\u0631\u0633","mobile":"\u0648\u0627\u062c\u0647\u0647 \u062c\u0648\u0627\u0644","popular_news":"\u0623\u062e\u0628\u0627\u0631 \u0634\u0639\u0628\u064a\u0629","popular_news_index_page":"\u0627\u0644\u0623\u062e\u0628\u0627\u0631 \u0627\u0644\u0634\u0639\u0628\u064a\u0629 (\u0635\u0641\u062d\u0629 \u0627\u0644\u0641\u0647\u0631\u0633)","post_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0646\u0634\u0648\u0631","recommended_post_index_page":"\u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647 (\u0635\u0641\u062d\u0629 \u0627\u0644\u0641\u0647\u0631\u0633)","select_ad_space":"\u062d\u062f\u062f \u0645\u0633\u0627\u062d\u0629 \u0625\u0639\u0644\u0627\u0646\u064a\u0629","trending_post":"\u0645\u0634\u0627\u0631\u0643\u0629 \u0631\u0627\u0626\u062c\u0629","trending_post_index_page":"\u0627\u0644\u0645\u0646\u0634\u0648\u0631\u0627\u062a \u0627\u0644\u0634\u0627\u0626\u0639\u0629 (\u0635\u0641\u062d\u0629 \u0627\u0644\u0641\u0647\u0631\u0633)"},"add_post":"\u0623\u0636\u0641 \u0645\u0646\u0634\u0648\u0631\u0627","admin":"\u0645\u0633\u0624\u0644","ai":{"ai_filter":"\u0645\u0631\u0634\u062d AI","best_of":"\u0623\u0641\u0636\u0644","call_ai":"\u0627\u062a\u0635\u0644 \u0628\u0640 AI","frequency_penalty":"\u0639\u0642\u0648\u0628\u0629 \u0627\u0644\u062a\u0631\u062f\u062f","generate_content":"\u062a\u0648\u0644\u064a\u062f \u0627\u0644\u0645\u062d\u062a\u0648\u0649","maximum_length":"\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u0637\u0648\u0644","model":"\u0646\u0645\u0648\u0630\u062c","presence_penalty":"\u0639\u0642\u0648\u0628\u0629 \u0627\u0644\u062d\u0636\u0648\u0631","temperature":"\u062f\u0631\u062c\u0629 \u062d\u0631\u0627\u0631\u0629","top_p":"\u0623\u0639\u0644\u0649 P"},"album":{"add_album":"\u0623\u0636\u0641 \u0627\u0644\u0628\u0648\u0645","album":"\u0627\u0644\u0628\u0648\u0645","edit_album":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0623\u0644\u0628\u0648\u0645"},"album_categories":"\u0641\u0626\u0627\u062a \u0627\u0644\u0623\u0644\u0628\u0648\u0645","album_category":{"add_album_category":"\u0625\u0636\u0627\u0641\u0629 \u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645","album_category":"\u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645","edit_album_category":"\u062a\u062d\u0631\u064a\u0631 \u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645","select_album":"\u062d\u062f\u062f \u0627\u0644\u0623\u0644\u0628\u0648\u0645"},"albums":"\u0623\u0644\u0628\u0648\u0645\u0627\u062a","all":"\u0627\u0644\u062c\u0645\u064a\u0639","allowed_file_size":"\u0623\u0641\u0636\u0644 \u0642\u0631\u0627\u0631 \u0644\u0647\u0630\u0627 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a \u0633\u064a\u0643\u0648\u0646","apps":"\u062a\u0637\u0628\u064a\u0642\u0627\u062a","attachment":"\u0645\u0631\u0641\u0642","bulk_post":{"boolean":"\u0645\u0646\u0637\u0642\u064a\u0629","bulk_post":"\u0627\u0644\u0646\u0634\u0631 \u0628\u0627\u0644\u062c\u0645\u0644\u0629","bulk_post_upload":"\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0628\u0627\u0644\u062c\u0645\u0644\u0629","categories":"\u0641\u0626\u0627\u062a","category_ids_list":"\u0642\u0627\u0626\u0645\u0629 \u0645\u0639\u0631\u0641 \u0627\u0644\u0641\u0626\u0629","data_type":"\u0646\u0648\u0639 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a","documentation":"\u062a\u0648\u062b\u064a\u0642","download_csv_example":"\u062a\u0646\u0632\u064a\u0644 \u0645\u062b\u0627\u0644 CSV","download_csv_template":"\u062a\u0646\u0632\u064a\u0644 \u0646\u0645\u0648\u0630\u062c CSV","example":"\u0645\u062b\u0627\u0644","field":"\u0645\u062c\u0627\u0644","help_documents":"\u0648\u062b\u0627\u0626\u0642 \u0627\u0644\u0645\u0633\u0627\u0639\u062f\u0629","id":"\u0628\u0637\u0627\u0642\u0629 \u062a\u0639\u0631\u064a\u0641","integer":"\u0639\u062f\u062f \u0635\u062d\u064a\u062d","languages":"\u0627\u0644\u0644\u063a\u0627\u062a","longText":"longText","or":"\u0623\u0648","string":"\u062e\u064a\u0637","sub_categories":"\u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0641\u0631\u0639\u064a\u0629","test_description_about_this_post":"\u0648\u0635\u0641 \u0627\u062e\u062a\u0628\u0627\u0631 \u062d\u0648\u0644 \u0647\u0630\u0627 \u0627\u0644\u0645\u0646\u0634\u0648\u0631","test_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0627\u062e\u062a\u0628\u0627\u0631","the_images_must_be_a_file_of_type_article_post":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631 \u0645\u0646 \u0646\u0648\u0639: jpg\u060c png\u060c jpeg","upload_csv_File":"\u062a\u062d\u0645\u064a\u0644 \u0645\u0644\u0641 CSV","you_can_use_csv_file":"\u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u0645\u0633\u062a\u0646\u062f\u0627\u062a \u0644\u0625\u0646\u0634\u0627\u0621 \u0645\u0644\u0641 CSV \u0627\u0644\u062e\u0627\u0635 \u0628\u0643"},"cash_payment":"\u062f\u0641\u0639 \u0646\u0642\u062f\u0627","categories":"\u0641\u0626\u0627\u062a","category":{"action":"\u0639\u0645\u0644","add_category":"\u0625\u0636\u0627\u0641\u0629 \u0641\u0626\u0629","category_language_warning":"\u064a\u062a\u0645 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0647\u0630\u0647 \u0627\u0644\u0641\u0626\u0629 \u0628\u0648\u0627\u0633\u0637\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631\u0627\u062a \u0625\u0630\u0627 \u0642\u0645\u062a \u0628\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u062a\u064a \u062a\u062d\u062a\u0627\u062c\u0647\u0627 \u0644\u062a\u062d\u062f\u064a\u062b \u0641\u0626\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631\u0627\u062a","color":"\u0627\u0644\u0644\u0648\u0646","edit_category":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0641\u0626\u0629","language":"\u0644\u063a\u0629","show_home":"\u0639\u0631\u0636 \u0641\u064a \u0627\u0644\u0645\u0646\u0632\u0644","show_menu":"\u0625\u0638\u0647\u0627\u0631 \u0641\u064a \u0627\u0644\u0642\u0627\u0626\u0645\u0629","slug":"\u0633\u0628\u064a\u0643\u0629","title":"\u0639\u0646\u0648\u0627\u0646"},"cities":"\u0645\u062f\u0646","comment":{"approval_pending":"\u0641\u064a \u0627\u0646\u062a\u0638\u0627\u0631 \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629","approved":"\u0625\u0638\u0647\u0627\u0631 \u062a\u0645\u062a \u0627\u0644\u0645\u0648\u0627\u0641\u0642\u0629","auto-approved":"\u0645\u0639\u062a\u0645\u062f \u062a\u0644\u0642\u0627\u0626\u064a\u064b\u0627","comment":"\u062a\u0639\u0644\u064a\u0642","comments":"\u062a\u0639\u0644\u064a\u0642\u0627\u062a","email":"\u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enter_phone_number":"\u0623\u062f\u062e\u0644 \u0631\u0642\u0645 \u0627\u0644\u0647\u0627\u062a\u0641","enter_your_email":"\u0623\u062f\u062e\u0644 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enter_your_name":"\u0623\u062f\u062e\u0644 \u0623\u0633\u0645\u0643","pending":"\u0625\u0638\u0647\u0627\u0631 \u0645\u0639\u0644\u0642","post_a_comment":"\u0627\u0646\u0634\u0631 \u062a\u0639\u0644\u064a\u0642","type_your_comments":"\u0627\u0643\u062a\u0628 \u062a\u0639\u0644\u064a\u0642\u0627\u062a\u0643","your_name":"\u0627\u0633\u0645\u0643"},"comments":"\u062a\u0639\u0644\u064a\u0642\u0627\u062a","common":{"action":"\u0639\u0645\u0644","active":"\u0646\u0634\u064a\u0637","add":"\u064a\u0636\u064a\u0641","allow_cookies":"\u0627\u0644\u0633\u0645\u0627\u062d \u0644\u0644\u0643\u0648\u0643\u064a\u0632","allowed_types":"\u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","already_have_an_account":"\u0647\u0644 \u0644\u062f\u064a\u0643 \u062d\u0633\u0627\u0628\u061f","apply":"\u064a\u062a\u0642\u062f\u0645","approval_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u0642\u0628\u0648\u0644","approved":"\u0645\u0648\u0627\u0641\u0642\u0629","apr":"\u0623\u0628\u0631\u064a\u0644","april":"\u0623\u0628\u0631\u064a\u0644","aug":"\u0623\u063a\u0633\u0637\u0633","august":"\u0634\u0647\u0631 \u0627\u063a\u0633\u0637\u0633","back":"\u062e\u0644\u0641","by":"\u0628\u0648\u0627\u0633\u0637\u0629","cancel":"\u064a\u0644\u063a\u064a","cancel_delete":"\u0644\u0627 \u060c \u0625\u0644\u063a\u0627\u0621","cancel_image":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0635\u0648\u0631\u0629","cancel_profile":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","change_cover_image":"\u062a\u063a\u064a\u064a\u0631 \u0635\u0648\u0631\u0629 \u0627\u0644\u063a\u0644\u0627\u0641","change_favicon":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0623\u064a\u0642\u0648\u0646\u0629 \u0627\u0644\u0645\u0641\u0636\u0644\u0629","change_image":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0635\u0648\u0631\u0629","change_logo":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0634\u0639\u0627\u0631","change_profile":"\u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","city":"\u0645\u062f\u064a\u0646\u0629","closed":"\u0645\u063a\u0644\u0642","contact":"\u0627\u062a\u0635\u0627\u0644","contact_us":"\u0627\u062a\u0635\u0644 \u0628\u0646\u0627","count":"\u0639\u062f\u062f","country":"\u062f\u0648\u0644\u0629","create_an_account":"\u0627\u0646\u0634\u0626 \u062d\u0633\u0627\u0628","created_at":"\u0623\u0646\u0634\u0626\u062a \u0641\u064a","created_by":"\u0627\u0646\u0634\u0623 \u0645\u0646 \u0642\u0628\u0644","custom":"\u0627\u0644\u0639\u0627\u062f\u0629","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","december":"\u062f\u064a\u0633\u0645\u0628\u0631","declined":"\u0627\u0646\u062e\u0641\u0636","delete":"\u0646\u0639\u0645 \u060c \u0627\u062d\u0630\u0641","delete_message":"\u0642\u062f \u062a\u0645 \u062d\u0630\u0641 ","delete_warning":"\u0647\u0644 \u062a\u0631\u064a\u062f \u0628\u0627\u0644\u062a\u0623\u0643\u064a\u062f \u062d\u0630\u0641 \u0647\u0630\u0627","deleted":"\u062a\u0645 \u0627\u0644\u062d\u0630\u0641!","details":"\u062a\u0641\u0627\u0635\u064a\u0644","discard":"\u062a\u062c\u0627\u0647\u0644","edit":"\u062a\u0639\u062f\u064a\u0644","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","february":"\u0634\u0647\u0631 \u0641\u0628\u0631\u0627\u064a\u0631","front_language":"\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","get_the_best":"\u0627\u062d\u0635\u0644 \u0639\u0644\u0649 \u0623\u0641\u0636\u0644 \u0642\u0635\u0635 \u0627\u0644\u0645\u062f\u0648\u0646\u0629 \u0641\u064a \u0635\u0646\u062f\u0648\u0642 \u0627\u0644\u0648\u0627\u0631\u062f \u0627\u0644\u062e\u0627\u0635 \u0628\u0643!","image_error":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0646 \u0646\u0648\u0639 \u0645\u0644\u0641: png\u060c jpg\u060c jpeg\u060c webp\u060c svg.","image_error_excel":"png, jpg, jpeg, pdf,excel :\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0646 \u0646\u0648\u0639 \u0645\u0644\u0641","image_warning":"\u063a\u064a\u0631 \u0635\u0627\u0644\u062d! \u0623\u0646\u0648\u0627\u0639 \u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627: png\u060c jpg\u060c jpeg.","jan":"\u062c\u0627\u0646","january":"\u0643\u0627\u0646\u0648\u0646 \u0627\u0644\u062b\u0627\u0646\u064a","jul":"\u062c\u0648\u0644","july":"\u062a\u0645\u0648\u0632","jun":"\u062c\u0648\u0646","june":"\u064a\u0648\u0646\u064a\u0648","language":"\u0644\u063a\u0629","leave_a_message":"\u0627\u062a\u0631\u0643 \u0631\u0633\u0627\u0644\u0629","login":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","mar":"\u0645\u0627\u0631","march":"\u0645\u0627\u0631\u0633","max":"\u0627\u0644 :attribute \u0642\u062f \u0644\u0627 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 :max.","may":"\u0645\u0627\u064a\u0648","name":"\u062a\u0639\u062f\u064a\u0644","new_here":"\u062c\u062f\u064a\u062f \u0647\u0646\u0627","no_data_available":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0639\u0646\u0627\u0635\u0631. \u062d\u0627\u0648\u0644 \u062a\u0648\u0633\u064a\u0639 \u0646\u0637\u0627\u0642 \u0627\u0644\u0628\u062d\u062b.","note":"\u0645\u0644\u062d\u0648\u0638\u0629","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","november":"\u0634\u0647\u0631 \u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","october":"\u0627\u0643\u062a\u0648\u0628\u0631","of":"\u0645\u0646","off":"\u0639\u0646","on":"\u0639\u0644\u0649","pending":"\u0642\u064a\u062f \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631","please_wait":"\u0627\u0631\u062c\u0648\u0643 \u0627\u0646\u062a\u0638\u0631...","read":"\u0627\u0642\u0631\u0623","register":"\u064a\u0633\u062c\u0644","rejected":"\u0645\u0631\u0641\u0648\u0636","remove_image":"\u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0635\u0648\u0631\u0629","required":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628.","result":"\u0646\u062a\u064a\u062c\u0629","save":"\u064a\u062d\u0641\u0638","select_an_option":"\u062d\u062f\u062f \u0627\u062e\u062a\u064a\u0627\u0631\u0627","select_category":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0641\u0626\u0629","select_language":"\u0627\u062e\u062a\u0627\u0631 \u0627\u0644\u0644\u063a\u0629","select_subcategory":"\u062d\u062f\u062f \u0641\u0626\u0629 \u0641\u0631\u0639\u064a\u0629","send_email":"\u0627\u0631\u0633\u0644 \u0628\u0631\u064a\u062f \u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","sep":"\u0633\u0628\u062a\u0645\u0628\u0631","september":"\u0634\u0647\u0631 \u0633\u0628\u062a\u0645\u0628\u0631","service":"\u062e\u062f\u0645\u0629","show_contact":"\u062a\u062d\u062f\u064a\u062b","showing":"\u0639\u0631\u0636","sign_in_here":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0647\u0646\u0627","slug":"\u0633\u0628\u064a\u0643\u0629","state":"\u062d\u0627\u0644\u0629","submit":"\u0625\u0631\u0633\u0627\u0644","subscribe":"\u0627\u0644\u0625\u0634\u062a\u0631\u0627\u0643","success_msg":"\u062a\u0645 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0631\u0633\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","time":"\u0648\u0642\u062a","title":"\u0639\u0646\u0648\u0627\u0646","to":"\u0644","update":"\u062a\u062d\u062f\u064a\u062b","view":"\u0645\u0646\u0638\u0631","your_email":"\u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a"},"contacts":"\u062c\u0647\u0627\u062a \u0627\u0644\u0627\u062a\u0635\u0627\u0644","countries":"\u0628\u0644\u062f\u0627\u0646","country":{"add_country":"\u0623\u0636\u0641 \u0627\u0644\u062f\u0648\u0644\u0629","country":"\u062f\u0648\u0644\u0629","short_code":"\u0631\u0645\u0632 \u0642\u0635\u064a\u0631"},"dashboard":"\u0644\u0648\u062d\u0629 \u0627\u0644\u0642\u064a\u0627\u062f\u0629","dashboard_show":{"drafts":"\u0627\u0644\u0645\u0633\u0648\u062f\u0627\u062a","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","latest_user":"\u0622\u062e\u0631 \u0645\u0633\u062a\u062e\u062f\u0645","name":"\u0627\u0633\u0645","post_views":"\u0645\u0634\u0627\u0647\u062f\u0627\u062a \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629","posts":"\u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0627\u062a","profile":"\u062d\u0633\u0627\u0628 \u062a\u0639\u0631\u064a\u0641\u064a","recent_user":"\u0645\u0633\u062a\u062e\u062f\u0645 \u062d\u062f\u064a\u062b"},"days":{"last_month":"\u0627\u0644\u0634\u0647\u0631 \u0627\u0644\u0645\u0627\u0636\u064a","last_week":"\u0627\u0644\u0623\u0633\u0628\u0648\u0639 \u0627\u0644\u0645\u0627\u0636\u064a","this_month":"\u0647\u0630\u0627 \u0627\u0644\u0634\u0647\u0631","this_week":"\u0647\u0630\u0627 \u0627\u0644\u0627\u0633\u0628\u0648\u0639","today":"\u0627\u0644\u064a\u0648\u0645"},"delete":"\u062d\u0630\u0641","details":{"admin_panel":"\u0644\u0648\u062d\u0629 \u0627\u0644\u0627\u062f\u0627\u0631\u0629","article":"\u0645\u0642\u0627\u0644\u0627\u062a","breaking":"\u0643\u0633\u0631","category":"\u0641\u0626\u0629","contact_us":"\u0627\u062a\u0635\u0644 \u0628\u0646\u0627","featured_post":"\u0645\u0634\u0627\u0631\u0643\u0629 \u0645\u0645\u064a\u0632\u0629","gallery":"\u0635\u0627\u0644\u0629 \u0639\u0631\u0636","home":"\u0645\u0633\u0643\u0646","hot_categories":"\u0641\u0626\u0627\u062a \u0633\u0627\u062e\u0646\u0629","language":"\u0644\u063a\u0629","latest_news":"\u0623\u062d\u062f\u062b \u0627\u0644\u0623\u062e\u0628\u0627\u0631","logout":"\u062a\u0633\u062c\u064a\u0644 \u062e\u0631\u0648\u062c","next_post":"\u0627\u0644\u0642\u0627\u062f\u0645 \u0628\u0648\u0633\u062a","popular_news":"\u0623\u062e\u0628\u0627\u0631 \u0634\u0639\u0628\u064a\u0629","popular_tag":"\u0627\u0644\u0639\u0644\u0627\u0645\u0629 \u0627\u0644\u0634\u0639\u0628\u064a\u0629","popular_tags":"\u0627\u0644\u0643\u0644\u0645\u0627\u062a \u0627\u0644\u0634\u0639\u0628\u064a\u0629","previous_post":"\u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0627\u0644\u0633\u0627\u0628\u0642","read_more":"\u0627\u0642\u0631\u0623 \u0623\u0643\u062b\u0631","recommended_post":"\u0623\u0648\u0635\u062a \u0648\u0638\u064a\u0641\u0629","related_post":"\u0645\u0646\u0634\u0648\u0631 \u0644\u0647 \u0635\u0644\u0629","sort":"\u0646\u0648\u0639","top_stories":"\u0623\u0647\u0645 \u0627\u0644\u0623\u062e\u0628\u0627\u0631","trending_post":"\u0622\u062e\u0631 \u0634\u0627\u0626\u0639","view_more":"\u0639\u0631\u0636 \u0627\u0644\u0645\u0632\u064a\u062f","view_options":"\u0639\u0631\u0636 \u0627\u0644\u062e\u064a\u0627\u0631\u0627\u062a","view_results":"\u0639\u0631\u0636 \u0627\u0644\u0646\u062a\u0627\u0626\u062c","views":"\u0631\u0623\u064a","vote":"\u062a\u0635\u0648\u064a\u062a","whats_new":"\u0645\u0627 \u0647\u0648 \u0627\u0644\u062c\u062f\u064a\u062f"},"edit_subscription":"\u062a\u063a\u064a\u064a\u0631 \u062d\u0627\u0644\u0629 \u0627\u0644\u062f\u0641\u0639","email_password_reset_link":"\u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","emails":{"Phone":"\u0647\u0627\u062a\u0641","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","enquiry_details":"\u0647\u0646\u0627 \u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u062a\u062d\u0642\u064a\u0642","message":"\u0631\u0633\u0627\u0644\u0629","name":"\u0627\u0633\u0645","required":"\u062d\u0642\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0637\u0644\u0648\u0628"},"emoji":{"emoji":"\u062a\u0639\u0628\u064a\u0631\u064a","emojis":"\u062a\u0639\u0628\u064a\u0631\u064a"},"enquiry":"\u0633\u0624\u0627\u0644","forgot_password":"\u0647\u0644 \u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631","forgot_your_password":"\u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631","forgot_your_password_no_problem_just_let_us_know_your_email_address":"\u0646\u0633\u064a\u062a \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631\u061f \u0644\u0627 \u0645\u0634\u0643\u0644\u0629. \u0641\u0642\u0637 \u0623\u062e\u0628\u0631\u0646\u0627 \u0628\u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0648\u0633\u0646\u0631\u0633\u0644 \u0644\u0643 \u0639\u0628\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u0630\u064a \u0633\u064a\u0633\u0645\u062d \u0644\u0643 \u0628\u0627\u062e\u062a\u064a\u0627\u0631 \u0639\u0646\u0648\u0627\u0646 \u062c\u062f\u064a\u062f","gallery":{"add_images":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0635\u0648\u0631","album":"\u0627\u0644\u0628\u0648\u0645","category":"\u0641\u0626\u0629","date":"\u062a\u0627\u0631\u064a\u062e","edit_images":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0635\u0648\u0631","id":"\u0647\u0648\u064a\u0629 \u0634\u062e\u0635\u064a\u0629","image":"\u0635\u0648\u0631\u0629","language":"\u0644\u063a\u0629","select_album":"\u062d\u062f\u062f \u0627\u0644\u0623\u0644\u0628\u0648\u0645","title":"\u0639\u0646\u0648\u0627\u0646"},"home":"\u0645\u0633\u0643\u0646","images":"\u0627\u0644\u0635\u0648\u0631","language":{"edit_language":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0644\u063a\u0629","edit_translation":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062a\u0631\u062c\u0645\u0629","front_language":"\u062d\u0627\u0644\u0629 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629","is_active":"\u0646\u0634\u0637","is_default":"\u0627\u0641\u062a\u0631\u0627\u0636\u064a","is_rtl":"\u0647\u0644 RTL","iso_code":"\u0643\u0648\u062f ISO","language":"\u0644\u063a\u0629","native":"\u0645\u062d\u0644\u064a","new_language":"\u0644\u063a\u0629 \u062c\u062f\u064a\u062f\u0629","no_language_available":"\u0644\u0627 \u062a\u0648\u062c\u062f \u0644\u063a\u0629 \u0645\u062a\u0627\u062d\u0629","no_language_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0644\u063a\u0629","translation":"\u062a\u0631\u062c\u0645\u0629"},"languages":"\u0627\u0644\u0644\u063a\u0627\u062a","mail":"\u0628\u0631\u064a\u062f","mails":{"action_required":"\u0625\u0630\u0627 \u0644\u0645 \u062a\u0642\u0645 \u0628\u0625\u0646\u0634\u0627\u0621 \u062d\u0633\u0627\u0628 \u060c \u0641\u0644\u0627 \u062f\u0627\u0639\u064a \u0644\u0627\u062a\u062e\u0627\u0630 \u0623\u064a \u0625\u062c\u0631\u0627\u0621 \u0622\u062e\u0631.","contact_messages":"\u0631\u0633\u0627\u0626\u0644 \u062c\u0647\u0629 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","email_address":"\u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f \u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","email_verification":"Email Verification","encryption":"\u0627\u0644\u062a\u0634\u0641\u064a\u0631","hello":"\u0645\u0631\u062d\u0628\u064b\u0627","mail":"\u0628\u0631\u064a\u062f","mail_host":"\u0645\u0636\u064a\u0641 \u0627\u0644\u0628\u0631\u064a\u062f","mail_library":"\u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0628\u0631\u064a\u062f","mail_password":"\u0643\u0644\u0645\u0629 \u0645\u0631\u0648\u0631 \u0627\u0644\u0628\u0631\u064a\u062f","mail_port":"\u0645\u0646\u0641\u0630 \u0627\u0644\u0628\u0631\u064a\u062f","mail_protocol":"\u0628\u0631\u0648\u062a\u0648\u0643\u0648\u0644 \u0627\u0644\u0628\u0631\u064a\u062f","mail_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f","mail_user_name":"\u0627\u0633\u0645 \u0645\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0628\u0631\u064a\u062f","manual_payment_request":"\u0637\u0644\u0628 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a","manual_payment_status":"\u062d\u0627\u0644\u0629 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a","please_click":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u0644\u0646\u0642\u0631 \u0641\u0648\u0642 \u0627\u0644\u0632\u0631 \u0623\u062f\u0646\u0627\u0647 \u0644\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f\u0643 \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a.","regard":"\u0627\u0639\u062a\u0628\u0627\u0631","reply_to":"\u0627\u0644\u0631\u062f \u0639\u0644\u0649","select_encryption":"\u062d\u062f\u062f \u0627\u0644\u062a\u0634\u0641\u064a\u0631","select_mail_library":"\u062d\u062f\u062f \u0645\u0643\u062a\u0628\u0629 \u0627\u0644\u0628\u0631\u064a\u062f","select_mail_protocol":"\u062d\u062f\u062f \u0628\u0631\u0648\u062a\u0648\u0643\u0648\u0644 \u0627\u0644\u0628\u0631\u064a\u062f","send_contact-messages_to_email_address":"\u0625\u0631\u0633\u0627\u0644 \u0631\u0633\u0627\u0626\u0644 \u062c\u0647\u0629 \u0627\u062a\u0635\u0627\u0644 \u0625\u0644\u0649 \u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","send_test_email":"\u0625\u0631\u0633\u0627\u0644 \u0627\u062e\u062a\u0628\u0627\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","test_mail":"\u0628\u0631\u064a\u062f \u062a\u062c\u0631\u064a\u0628\u064a","verify_email":"\u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a"},"menu":{"add_menu":"\u0625\u0636\u0627\u0641\u0629 \u0642\u0627\u0626\u0645\u0629","edit_menu":"\u0639\u062f\u0644 \u0627\u0644\u0642\u0627\u0626\u0645\u0629","link":"\u0648\u0635\u0644\u0629","menu":"\u0642\u0627\u0626\u0645\u0629","menu_order":"\u062a\u0631\u062a\u064a\u0628 \u0627\u0644\u0642\u0627\u0626\u0645\u0629","parent_menu":"\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0648\u0627\u0644\u062f\u064a\u0646","select_parent_menu":"\u062d\u062f\u062f \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0623\u0635\u0644","show_in_menu":"\u0625\u0638\u0647\u0627\u0631 \u0641\u064a \u0627\u0644\u0642\u0627\u0626\u0645\u0629","title":"\u0639\u0646\u0648\u0627\u0646"},"menus":"\u0627\u0644\u0642\u0648\u0627\u0626\u0645","months":{"apr":"\u0623\u0628\u0631\u064a\u0644","aug":"\u0623\u063a\u0633\u0637\u0633","dec":"\u062f\u064a\u0633\u0645\u0628\u0631","feb":"\u0641\u0628\u0631\u0627\u064a\u0631","jan":"\u064a\u0646\u0627\u064a\u0631","jul":"\u064a\u0648\u0644\u064a\u0648","jun":"\u064a\u0648\u0646\u064a\u0648","mar":"\u0645\u0627\u0631\u0633","may":"\u0645\u0627\u064a\u0648","nov":"\u0646\u0648\u0641\u0645\u0628\u0631","oct":"\u0623\u0643\u062a\u0648\u0628\u0631","sep":"\u0633\u0628\u062a\u0645\u0628\u0631"},"navigation":"\u0627\u0644\u062a\u0646\u0642\u0644","navigations":{"menu":"\u0642\u0627\u0626\u0645\u0629"},"news_letters":"\u0631\u0633\u0627\u0644\u0629 \u0625\u062e\u0628\u0627\u0631\u064a\u0629","no_album_found":"\u0644\u0627 \u064a\u0648\u062c\u062f \u0623\u0644\u0628\u0648\u0645 \u0645\u062a\u0627\u062d","no_matching_records_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0633\u062c\u0644\u0627\u062a \u0645\u0637\u0627\u0628\u0642\u0629","no_results_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0646\u062a\u0627\u0626\u062c","notes":"\u0645\u0644\u062d\u0648\u0638\u0627\u062a","ok":"\u0646\u0639\u0645","on_rss_feed":"\u0625\u062c\u0645\u0627\u0644\u064a \u0645\u0634\u0627\u0631\u0643\u0629 \u0645\u0648\u062c\u0632 RSS","page":{"add_lang":"\u0627\u062e\u062a\u0627\u0631 \u0627\u0644\u0644\u063a\u0629","add_page":"\u0625\u0636\u0627\u0641\u0629 \u0635\u0641\u062d\u0629","add_parent_link":"\u062d\u062f\u062f \u0627\u0631\u062a\u0628\u0627\u0637 \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0623\u0635\u0644","dont_add_menu":"\u0644\u0627 \u062a\u0636\u064a\u0641 \u0642\u0627\u0626\u0645\u0629","edit_page":"\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0635\u0641\u062d\u0629","footer":"\u062a\u0630\u064a\u064a\u0644","hide":"\u0625\u062e\u0641\u0627\u0621","language":"\u0644\u063a\u0629","location":"\u0645\u0648\u0642\u0639","main_menu":"\u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629","meta_description":"\u0645\u064a\u062a\u0627 \u0627\u0644\u0648\u0635\u0641","meta_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0641\u0648\u0642\u064a\u0629","name":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0639\u0644\u0649 \u0627\u0644\u0635\u0641\u062d\u0629","no":"\u0644\u0627","page":"\u0635\u0641\u062d\u0629","parent_menu":"\u0631\u0627\u0628\u0637 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0623\u0635\u0644","show":"\u064a\u0639\u0631\u0636","show_breadcrumb":"\u0625\u0638\u0647\u0627\u0631 \u0645\u0633\u0627\u0631 \u0627\u0644\u062a\u0646\u0642\u0644","show_name":"\u0627\u0633\u0645","show_right":"\u0639\u0631\u0636 \u0627\u0644\u062d\u0642","show_title":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","slug":"\u0633\u0628\u064a\u0643\u0629","title":"\u0639\u0646\u0648\u0627\u0646","top_menu":"\u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0639\u0644\u0648\u064a\u0629","user_show":"\u0639\u0631\u0636 \u0641\u0642\u0637 \u0644\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u0627\u0644\u0645\u0633\u062c\u0644\u064a\u0646","visibility":"\u0627\u0644\u0631\u0624\u064a\u0629","yes":"\u0646\u0639\u0645"},"pages":"\u0627\u0644\u0635\u0641\u062d\u0627\u062a","patients":"\u0645\u0631\u0636\u0649","payment_method":"\u0637\u0631\u064a\u0642\u0629 \u0627\u0644\u062f\u0641\u0639 \u0627\u0648 \u0627\u0644\u0633\u062f\u0627\u062f","phone":"\u0647\u0627\u062a\u0641","placeholder":{"User_profile_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0645\u0644\u0641 \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0646\u062c\u0627\u062d","You_active_more_than_emoji":"\u0644\u0627 \u064a\u0645\u0643\u0646\u0643 \u062a\u0646\u0634\u064a\u0637 \u0623\u0643\u062b\u0631 \u0645\u0646 7 \u0631\u0645\u0648\u0632 \u062a\u0639\u0628\u064a\u0631\u064a\u0629","You_already_voted":"\u0644\u0642\u062f \u0642\u0645\u062a \u0628\u0627\u0644\u062a\u0635\u0648\u064a\u062a \u0645\u0633\u0628\u0642\u0627 !!","You_can_use_any_one_of_upload_video_or_video_URL_option":"\u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u064a \u062e\u064a\u0627\u0631 \u0644\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0641\u064a\u062f\u064a\u0648 \u0623\u0648 \u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u0641\u064a\u062f\u064a\u0648","You_disable_less_than_emoji":"\u0644\u0627 \u064a\u0645\u0643\u0646\u0643 \u062a\u0639\u0637\u064a\u0644 \u0623\u0642\u0644 \u0645\u0646 4 \u0631\u0645\u0648\u0632 \u062a\u0639\u0628\u064a\u0631\u064a\u0629","adSpaces_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b AdSpaces \u0628\u0646\u062c\u0627\u062d","album_category_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0628\u0646\u062c\u0627\u062d","album_category_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0628\u0646\u062c\u0627\u062d","album_category_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0628\u0646\u062c\u0627\u062d","album_category_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0628\u0646\u062c\u0627\u062d","album_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0628\u0646\u062c\u0627\u062d","album_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0628\u0646\u062c\u0627\u062d","album_retrieve_successfully":"\u0627\u0633\u062a\u0631\u062c\u0627\u0639 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0628\u0646\u062c\u0627\u062d","album_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0628\u0646\u062c\u0627\u062d","albums_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0623\u0644\u0628\u0648\u0645\u0627\u062a \u0628\u0646\u062c\u0627\u062d","already_image_exist":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0645\u0648\u062c\u0648\u062f\u0629 \u0628\u0627\u0644\u0641\u0639\u0644","best_resolution_for_this_favicon_will_be_32X32":"\u0623\u0641\u0636\u0644 \u062f\u0642\u0629 \u0644\u0647\u0630\u0627 \u0627\u0644\u0631\u0645\u0632 \u0627\u0644\u0645\u0641\u0636\u0644 \u0633\u062a\u0643\u0648\u0646 32 \u00d7 32","best_resolution_for_this_logo_will_be_90x60":"\u0623\u0641\u0636\u0644 \u062f\u0642\u0629 \u0644\u0647\u0630\u0627 \u0627\u0644\u0634\u0639\u0627\u0631 \u0633\u062a\u0643\u0648\u0646 90 \u00d7 60.","bulk_post_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629 \u0627\u0644\u0645\u062c\u0645\u0639\u0629 \u0628\u0646\u062c\u0627\u062d.","category_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d","category_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d","category_retrieve_successfully":"\u0641\u0626\u0629 \u0627\u0644\u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0628\u0646\u062c\u0627\u062d","category_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d.","category_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0641\u0626\u0629 \u0628\u0646\u062c\u0627\u062d","chart_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u062e\u0637\u0637 \u0628\u0646\u062c\u0627\u062d","clicking_on_submit_it_will_publish_your_post":"\u0645\u0644\u0627\u062d\u0638\u0629: \u0627\u0644\u0646\u0642\u0631 \u0641\u0648\u0642 \u0625\u0631\u0633\u0627\u0644 \u0633\u064a\u062a\u0645 \u0646\u0634\u0631 \u0631\u0633\u0627\u0644\u062a\u0643","comment_create_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062a\u0639\u0644\u064a\u0642 \u0628\u0646\u062c\u0627\u062d","comment_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062a\u0639\u0644\u064a\u0642 \u0628\u0646\u062c\u0627\u062d","comment_setting_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0625\u0639\u062f\u0627\u062f \u0627\u0644\u062a\u0639\u0644\u064a\u0642 \u0628\u0646\u062c\u0627\u062d","contact_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u062c\u0647\u0629 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0628\u0646\u062c\u0627\u062d","contact_number_field_is_required":"\u062d\u0642\u0644 \u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0645\u0637\u0644\u0648\u0628","content_generated_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u062d\u062a\u0648\u0649 \u0628\u0646\u062c\u0627\u062d.","controls_diversity_via_nucleus_sampling":"\u064a\u062a\u062d\u0643\u0645 \u0641\u064a \u0627\u0644\u062a\u0646\u0648\u0639 \u0639\u0646 \u0637\u0631\u064a\u0642 \u0623\u062e\u0630 \u0639\u064a\u0646\u0627\u062a \u0627\u0644\u0646\u0648\u0627\u0629: 0.5 \u064a\u0639\u0646\u064a \u0646\u0635\u0641 \u062c\u0645\u064a\u0639 \u0627\u0644\u0627\u062d\u062a\u0645\u0627\u0644\u0627\u062a- weighted options are considered.","controls_randomness_lowering_results_in_less_random_completions":"\u064a\u062a\u062d\u0643\u0645 \u0641\u064a \u0627\u0644\u0639\u0634\u0648\u0627\u0626\u064a\u0629: \u064a\u0646\u062a\u062c \u0639\u0646 \u0627\u0644\u062a\u062e\u0641\u064a\u0636 \u0639\u062f\u062f \u0623\u0642\u0644 \u0645\u0646 \u0627\u0644\u0625\u0643\u0645\u0627\u0644 \u0627\u0644\u0639\u0634\u0648\u0627\u0626\u064a. \u0645\u0639 \u0627\u0642\u062a\u0631\u0627\u0628 \u062f\u0631\u062c\u0629 \u0627\u0644\u062d\u0631\u0627\u0631\u0629 \u0645\u0646 \u0627\u0644\u0635\u0641\u0631 \u060c \u0633\u064a\u0635\u0628\u062d \u0627\u0644\u0646\u0645\u0648\u0630\u062c \u0645\u062d\u062f\u062f\u064b\u0627 \u0648\u0645\u062a\u0643\u0631\u0631\u064b\u0627","created_request_for_payment_of":"\u0625\u0646\u0634\u0627\u0621 \u0637\u0644\u0628 \u0644\u0644\u062f\u0641\u0639 \u0644\u0640","current_password_in_invalid":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","data_retried":"\u062a\u0645\u062a \u0625\u0639\u0627\u062f\u0629 \u0645\u062d\u0627\u0648\u0644\u0629 \u0627\u0644\u0628\u064a\u0627\u0646\u0627\u062a","default_language_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","default_plan":"\u0647\u0630\u0647 \u0627\u0644\u062e\u0637\u0629 \u0647\u064a \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","default_plan_changed_successfully":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","default_role_do_not_deleted":"\u0644\u0627 \u064a\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062f\u0648\u0631 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a.","desktop_view_image_dimensions_must_be_800X130":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0623\u0628\u0639\u0627\u062f \u0635\u0648\u0631\u0629 \u0639\u0631\u0636 \u0633\u0637\u062d \u0627\u0644\u0645\u0643\u062a\u0628 800X130","email_send_successfully":"\u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u0646\u062c\u0627\u062d.","email_setting_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0625\u0639\u062f\u0627\u062f \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0628\u0646\u062c\u0627\u062d","emoji_created_successfully.":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0631\u0645\u0648\u0632 \u0627\u0644\u062a\u0639\u0628\u064a\u0631\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","emoji_deleted_successfully.":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0631\u0645\u0648\u0632 \u0627\u0644\u062a\u0639\u0628\u064a\u0631\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","emoji_status_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062d\u0627\u0644\u0629 \u0627\u0644\u0631\u0645\u0648\u0632 \u0627\u0644\u062a\u0639\u0628\u064a\u0631\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","feed_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062e\u0644\u0627\u0635\u0629 \u0628\u0646\u062c\u0627\u062d.","file_not_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0645\u0644\u0641","gallery_image_created_successfully":"\u0645\u0639\u0631\u0636 \u0627\u0644\u0635\u0648\u0631 \u062a\u0645 \u0625\u0646\u0634\u0627\u0624\u0647 \u0628\u0646\u062c\u0627\u062d","gallery_image_deleted_successfully.":"\u062a\u0645 \u062d\u0630\u0641 \u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0639\u0631\u0636 \u0628\u0646\u062c\u0627\u062d","gallery_image_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0639\u0631\u0636 \u0628\u0646\u062c\u0627\u062d","gallery_title_must_not_be_greater_than_190_characters":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0632\u064a\u062f \u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0639\u0631\u0636 \u0639\u0646 190 \u062d\u0631\u0641\u064b\u0627","generates_multiple_completions_server_side":"\u064a\u0648\u0644\u062f \u0627\u0644\u0639\u062f\u064a\u062f \u0645\u0646 \u0627\u0644\u0625\u0643\u0645\u0627\u0644\u0627\u062a \u0645\u0646 \u062c\u0627\u0646\u0628 \u0627\u0644\u062e\u0627\u062f\u0645 \u060c \u0648\u064a\u0639\u0631\u0636 \u0627\u0644\u0623\u0641\u0636\u0644 \u0641\u0642\u0637. \u0644\u0627 \u064a\u0639\u0645\u0644 \u0627\u0644\u0628\u062b \u0625\u0644\u0627 \u0639\u0646\u062f \u0627\u0644\u062a\u0639\u064a\u064a\u0646 \u0639\u0644\u0649 1. \u0646\u0638\u0631\u064b\u0627 \u0644\u0623\u0646\u0647 \u064a\u0639\u0645\u0644 \u0643\u0645\u0636\u0627\u0639\u0641 \u0644\u0639\u062f\u062f \u0645\u0631\u0627\u062a \u0627\u0644\u0625\u0643\u0645\u0627\u0644 \u060c \u064a\u0645\u0643\u0646 \u0644\u0647\u0630\u0647 \u0627\u0644\u0645\u0639\u0644\u0645\u0627\u062a \u0623\u0646 \u062a\u062a\u063a\u0630\u0649 \u0639\u0644\u0649 \u062d\u0635\u062a\u0643 \u0645\u0646 \u0627\u0644\u0631\u0645\u0648\u0632 \u0627\u0644\u0645\u0645\u064a\u0632\u0629 \u0628\u0633\u0631\u0639\u0629 \u0643\u0628\u064a\u0631\u0629 - \u062a\u0648\u062e \u0627\u0644\u062d\u0630\u0631!","given_post_is_not_yet_published":"\u0644\u0645 \u064a\u062a\u0645 \u0646\u0634\u0631 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0628\u0639\u062f","image_delete_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0635\u0648\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","image_upload_successfully":"\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0635\u0648\u0631\u0629 \u0628\u0646\u062c\u0627\u062d","img_retrieved":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f img","keyword_should_be_of_maximum_10_words_only":"\u0627\u0644\u0643\u0644\u0645\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629 \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0628\u062d\u062f \u0623\u0642\u0635\u0649 10 \u0643\u0644\u0645\u0627\u062a \u0641\u0642\u0637","language_added_to_front_successfully":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0644\u063a\u0629 \u0625\u0644\u0649 \u0627\u0644\u0645\u0642\u062f\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","language_be_deleted":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062d\u0630\u0641 \u0627\u0644\u0644\u063a\u0629","language_change_successfully":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","language_changed_successfully":"\u062a\u063a\u064a\u0631\u062a \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","language_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","language_not_found":"\u0627\u0644\u0644\u063a\u0629 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f\u0629","language_removed_from_front_successfully":"\u062a\u0645\u062a \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0644\u063a\u0629 \u0645\u0646 \u0627\u0644\u0623\u0645\u0627\u0645 \u0628\u0646\u062c\u0627\u062d","language_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","language_saved_successfully":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","language_saved_successfully.":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","language_setting_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0625\u0639\u062f\u0627\u062f \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d.","language_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0644\u063a\u0629 \u0628\u0646\u062c\u0627\u062d","login_via_facebook":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0639\u0628\u0631 \u0627\u0644\u0641\u064a\u0633\u0628\u0648\u0643","login_via_google":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0639\u0628\u0631 \u062c\u0648\u062c\u0644","mail_updated_successfully":"\u0643\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0646\u0627\u062c\u062d\u064b\u0627","menu_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","menu_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","menu_update_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u0628\u0646\u062c\u0627\u062d","mobile_view_image_dimensions_must_be_350X290":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0623\u0628\u0639\u0627\u062f \u0635\u0648\u0631\u0629 \u0639\u0631\u0636 \u0627\u0644\u062c\u0648\u0627\u0644 350 \u00d7 290","name_field_is_required":"\u062d\u0642\u0644 \u0627\u0644\u0627\u0633\u0645 \u0645\u0637\u0644\u0648\u0628","navigation_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0644\u0627\u062d\u0629 \u0628\u0646\u062c\u0627\u062d","page_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0635\u0641\u062d\u0629 \u0628\u0646\u062c\u0627\u062d","page_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0635\u0641\u062d\u0629 \u0628\u0646\u062c\u0627\u062d.","page_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0635\u0641\u062d\u0629 \u0628\u0646\u062c\u0627\u062d","password_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631 \u0628\u0646\u062c\u0627\u062d","payment_received":"\u062a\u0645 \u0627\u0633\u062a\u0644\u0627\u0645 \u0627\u0644\u062f\u0641\u0639\u0629 \u0628\u0646\u062c\u0627\u062d","plan_already_used":"\u0627\u0644\u062e\u0637\u0629 \u0645\u0633\u062a\u062e\u062f\u0645\u0629 \u0628\u0627\u0644\u0641\u0639\u0644","plan_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d","plan_deleted_successfully.":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d","plan_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d","please_enter_CSV_files":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0645\u0644\u0641\u0627\u062a CSV","please_enter_video_URL":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u0641\u064a\u062f\u064a\u0648","please_enter_video_url_or_upload_a_video":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 url \u0644\u0644\u0641\u064a\u062f\u064a\u0648 \u0623\u0648 \u062a\u062d\u0645\u064a\u0644 \u0645\u0642\u0637\u0639 \u0641\u064a\u062f\u064a\u0648","please_enter_video_url_or_upload_video":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0631\u0627\u0628\u0637 \u0627\u0644\u0641\u064a\u062f\u064a\u0648 \u0623\u0648 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0641\u064a\u062f\u064a\u0648","please_select_any_one_permission":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0623\u064a \u0625\u0630\u0646 \u0648\u0627\u062d\u062f","please_select_audio_file":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u062d\u062f\u064a\u062f \u0645\u0644\u0641 \u0635\u0648\u062a\u064a","please_upgrade_plan":"\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u0631\u0642\u064a\u0629 \u0627\u0644\u062e\u0637\u0629","poll_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0627\u0633\u062a\u0637\u0644\u0627\u0639 \u0628\u0646\u062c\u0627\u062d.","poll_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0627\u0633\u062a\u0637\u0644\u0627\u0639 \u0628\u0646\u062c\u0627\u062d.","poll_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0627\u0633\u062a\u0637\u0644\u0627\u0639 \u0628\u0646\u062c\u0627\u062d.","poll_voted_successfully":"\u0627\u0644\u062a\u0635\u0648\u064a\u062a \u062a\u0645 \u0627\u0644\u062a\u0635\u0648\u064a\u062a \u0628\u0646\u062c\u0627\u062d","post_added_on_headline_successfully":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0639\u0644\u0649 \u0627\u0644\u0639\u0646\u0648\u0627\u0646 \u0628\u0646\u062c\u0627\u062d","post_added_to_breaking_successfully":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0625\u0644\u0649 \u0643\u0633\u0631 \u0628\u0646\u062c\u0627\u062d","post_added_to_featured_successfully":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0625\u0644\u0649 \u0627\u0644\u0645\u0645\u064a\u0632 \u0628\u0646\u062c\u0627\u062d","post_added_to_recommended_successfully":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0625\u0644\u0649 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647 \u0628\u0646\u062c\u0627\u062d","post_added_to_slider_successfully":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629 \u0625\u0644\u0649 \u0634\u0631\u064a\u0637 \u0627\u0644\u062a\u0645\u0631\u064a\u0631 \u0628\u0646\u062c\u0627\u062d","post_added_to_visibility_successfully":"\u062a\u0645\u062a \u0625\u0636\u0627\u0641\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0625\u0644\u0649 \u0627\u0644\u0631\u0624\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","post_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629 \u0628\u0646\u062c\u0627\u062d","post_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0628\u0646\u062c\u0627\u062d.","post_removed_from_breaking_successfully":"\u062a\u0645\u062a \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0645\u0646 \u0643\u0633\u0631 \u0628\u0646\u062c\u0627\u062d","post_removed_from_featured_successfully":"\u062a\u0645\u062a \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0645\u0646 \u0627\u0644\u0645\u0645\u064a\u0632 \u0628\u0646\u062c\u0627\u062d","post_removed_from_headline_successfully":"\u062a\u0645\u062a \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0645\u0646 \u0627\u0644\u0639\u0646\u0648\u0627\u0646 \u0628\u0646\u062c\u0627\u062d","post_removed_from_recommended_successfully":"\u062a\u0645\u062a \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0629 \u0645\u0646 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627 \u0628\u0646\u062c\u0627\u062d","post_removed_from_slider_successfully":"\u062a\u0645\u062a \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0645\u0646 \u0634\u0631\u064a\u0637 \u0627\u0644\u062a\u0645\u0631\u064a\u0631 \u0628\u0646\u062c\u0627\u062d","post_removed_from_visibility_successfully":"\u062a\u0645\u062a \u0625\u0632\u0627\u0644\u0629 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0645\u0646 \u0627\u0644\u0638\u0647\u0648\u0631 \u0628\u0646\u062c\u0627\u062d","post_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0628\u0646\u062c\u0627\u062d.","reCAPTCHA_required":"\u0645\u0637\u0644\u0648\u0628 reCAPTCHA!","registered_success":"\u0644\u0642\u062f \u0642\u0645\u062a \u0628\u0627\u0644\u062a\u0633\u062c\u064a\u0644 \u0628\u0646\u062c\u0627\u062d \u060c \u0642\u0645 \u0628\u062a\u0641\u0639\u064a\u0644 \u062d\u0633\u0627\u0628\u0643 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f","role_already_exists":"\u0627\u0644\u062f\u0648\u0631 \u0645\u0648\u062c\u0648\u062f \u0628\u0627\u0644\u0641\u0639\u0644.","role_created_successfully":"\u0627\u0644\u062f\u0648\u0631 \u0627\u0644\u0630\u064a \u062a\u0645 \u0625\u0646\u0634\u0627\u0624\u0647 \u0628\u0646\u062c\u0627\u062d","role_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u062f\u0648\u0631 \u0628\u0646\u062c\u0627\u062d.","role_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062f\u0648\u0631 \u0628\u0646\u062c\u0627\u062d.","rss_feed_create_successfully":"\u0625\u0646\u0634\u0627\u0621 \u0645\u0648\u062c\u0632 RSS \u0628\u0646\u062c\u0627\u062d","rss_feed_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0645\u0648\u062c\u0632 RSS \u0628\u0646\u062c\u0627\u062d","rss_feed_update_successfully":"\u062a\u062d\u062f\u064a\u062b \u0645\u0648\u062c\u0632 RSS \u0628\u0646\u062c\u0627\u062d.","seo_tools_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0623\u062f\u0648\u0627\u062a \u062a\u062d\u0633\u064a\u0646 \u0645\u062d\u0631\u0643\u0627\u062a \u0627\u0644\u0628\u062d\u062b \u0628\u0646\u062c\u0627\u062d.","session_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0627\u0644\u062c\u0644\u0633\u0629 \u0628\u0646\u062c\u0627\u062d","settings_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0628\u0646\u062c\u0627\u062d","show_in_home_updated_successfully":"\u0625\u0638\u0647\u0627\u0631 \u0641\u064a \u0627\u0644\u0645\u0646\u0632\u0644 \u062a\u0645 \u062a\u062d\u062f\u064a\u062b\u0647 \u0628\u0646\u062c\u0627\u062d","show_in_menu_updated_successfully":"\u0625\u0638\u0647\u0627\u0631 \u0641\u064a \u0627\u0644\u0642\u0627\u0626\u0645\u0629 \u062a\u0645 \u062a\u062d\u062f\u064a\u062b\u0647 \u0628\u0646\u062c\u0627\u062d","something_wrong_occurred_please_try_again":"\u062d\u062f\u062b \u062e\u0637\u0623 \u0645\u0627 \u064a\u0631\u062c\u0649 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649","sort_list_title_must_not_be_greater_than_190_characters":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0632\u064a\u062f \u0639\u0646\u0648\u0627\u0646 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0641\u0631\u0632 \u0639\u0646 190 \u062d\u0631\u0641\u064b\u0627","staff_created_successfully":"\u062a\u0645 \u0625\u0646\u0634\u0627\u0621 \u0637\u0627\u0642\u0645 \u0627\u0644\u0639\u0645\u0644 \u0628\u0646\u062c\u0627\u062d.","staff_deleted_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0637\u0627\u0642\u0645 \u0627\u0644\u0639\u0645\u0644 \u0628\u0646\u062c\u0627\u062d.","staff_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0645\u0648\u0638\u0641\u064a\u0646 \u0628\u0646\u062c\u0627\u062d.","status_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062d\u0627\u0644\u0629 \u0628\u0646\u062c\u0627\u062d.","sub_categories_saved_successfully":"\u062a\u0645 \u062d\u0641\u0638 \u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0641\u0631\u0639\u064a\u0629 \u0628\u0646\u062c\u0627\u062d.","sub_category_delete_successfully":"\u062a\u0645 \u062d\u0630\u0641 \u0627\u0644\u0641\u0626\u0629 \u0627\u0644\u0641\u0631\u0639\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","sub_category_retrieved_successfully":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0641\u0626\u0629 \u0627\u0644\u0641\u0631\u0639\u064a\u0629 \u0628\u0646\u062c\u0627\u062d.","sub_category_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0641\u0626\u0629 \u0627\u0644\u0641\u0631\u0639\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","subscribed_plan_wait":"\u0644\u0642\u062f \u0627\u0634\u062a\u0631\u0643\u062a \u0641\u064a \u0647\u0630\u0647 \u0627\u0644\u062e\u0637\u0629 \u0628\u0646\u062c\u0627\u062d \u0648\u0644\u0643\u0646 \u0627\u0646\u062a\u0638\u0631 \u0627\u0644\u062a\u0623\u0643\u064a\u062f \u0645\u0646 \u0627\u0644\u0645\u0633\u0624\u0648\u0644","subscribed_successfully":"\u062a\u0645 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643 \u0628\u0646\u062c\u0627\u062d","subscriber_delete_successfully":"\u0627\u0644\u0645\u0634\u062a\u0631\u0643 \u062d\u0630\u0641 \u0628\u0646\u062c\u0627\u062d","subscription_date_successfully_updated":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643 \u0628\u0646\u062c\u0627\u062d.","subscription_successfully_retrieved":"\u062a\u0645 \u0627\u0633\u062a\u0631\u062f\u0627\u062f \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643 \u0628\u0646\u062c\u0627\u062d","successfully_verified":"\u0644\u0642\u062f \u0646\u062c\u062d\u062a \u0641\u064a \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0628\u0631\u064a\u062f\u0643 \u060c \u064a\u0631\u062c\u0649 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","test_mail_send_successfully":"\u0627\u062e\u062a\u0628\u0627\u0631 \u0625\u0631\u0633\u0627\u0644 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a Sussssssful","the_audios_must_be_a_file_of_type":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0635\u0648\u062a \u0645\u0646 \u0646\u0648\u0639: mp3 \u060c M4A \u060c wav \u060c aac \u060c wma.","the_images_must_be_a_file_of_type":"\u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0627\u0644\u0635\u0648\u0631 \u0645\u0646 \u0646\u0648\u0639: jpeg\u060c png\u060c jpg\u060c webp\u060c svg.","the_iso_code_field_is_required":"\u062d\u0642\u0644 \u0643\u0648\u062f ISO \u0645\u0637\u0644\u0648\u0628","the_maximum_number_of_tokens_to_generate_requests_can_use_up":"\u0627\u0644\u062d\u062f \u0627\u0644\u0623\u0642\u0635\u0649 \u0644\u0639\u062f\u062f \u0627\u0644\u0631\u0645\u0648\u0632 \u0627\u0644\u0645\u0631\u0627\u062f \u0625\u0646\u0634\u0627\u0624\u0647\u0627. \u064a\u0645\u0643\u0646 \u0623\u0646 \u062a\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0637\u0644\u0628\u0627\u062a \u0645\u0627 \u064a\u0635\u0644 \u0625\u0644\u0649 2048 \u0623\u0648 4000 \u0631\u0645\u0632 \u0645\u0634\u062a\u0631\u0643 \u0628\u064a\u0646 \u0627\u0644\u0645\u0637\u0627\u0644\u0628\u0629 \u0648\u0627\u0644\u0627\u0633\u062a\u0643\u0645\u0627\u0644. \u0627\u0644\u062d\u062f \u0627\u0644\u062f\u0642\u064a\u0642 \u064a\u062e\u062a\u0644\u0641 \u062d\u0633\u0628 \u0627\u0644\u0637\u0631\u0627\u0632. (\u0631\u0645\u0632 \u0648\u0627\u062d\u062f \u064a\u062a\u0643\u0648\u0646 \u0645\u0646 4 \u0623\u062d\u0631\u0641 \u062a\u0642\u0631\u064a\u0628\u064b\u0627 \u0644\u0644\u0646\u0635 \u0627\u0644\u0625\u0646\u062c\u0644\u064a\u0632\u064a \u0627\u0644\u0639\u0627\u062f\u064a)","the_upload_csv_file_field_is_required":"\u062d\u0642\u0644 \u062a\u062d\u0645\u064a\u0644 \u0645\u0644\u0641 CSV \u0645\u0637\u0644\u0648\u0628.","the_upload_video_must_not_be_greater_than_150_MB":"\u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u0632\u064a\u062f \u062d\u062c\u0645 \u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0641\u064a\u062f\u064a\u0648 \u0639\u0646 150 \u0645\u064a\u063a\u0627 \u0628\u0627\u064a\u062a.","theme_changed_successfully":"\u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0645\u0648\u0636\u0648\u0639 \u0628\u0646\u062c\u0627\u062d","this_album_category_is_in_use":"\u0641\u0626\u0629 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0647\u0630\u0647 \u0642\u064a\u062f \u0627\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645","this_album_is_in_use":"\u0647\u0630\u0627 \u0627\u0644\u0623\u0644\u0628\u0648\u0645 \u0642\u064a\u062f \u0627\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645","this_category_is_in_use":"\u0647\u0630\u0647 \u0627\u0644\u0641\u0626\u0629 \u0642\u064a\u062f \u0627\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645","this_currency_is_not_supported":"\u0647\u0630\u0647 \u0627\u0644\u0639\u0645\u0644\u0629 \u063a\u064a\u0631 \u0645\u062f\u0639\u0648\u0645\u0629","this_email_is_already_subscribed":"\u0647\u0630\u0627 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0645\u0634\u062a\u0631\u0643 \u0628\u0627\u0644\u0641\u0639\u0644","this_sub_category_is_in_use":"\u0647\u0630\u0647 \u0627\u0644\u0641\u0626\u0629 \u0627\u0644\u0641\u0631\u0639\u064a\u0629 \u0642\u064a\u062f \u0627\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645","thumbnail_image_is_required":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0645\u0635\u063a\u0631\u0629 \u0645\u0637\u0644\u0648\u0628\u0629","unable_to_process_payment":"\u063a\u064a\u0631 \u0642\u0627\u062f\u0631 \u0639\u0644\u0649 \u0645\u0639\u0627\u0644\u062c\u0629 \u0627\u0644\u062f\u0641\u0639 \u0641\u064a \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u062d\u0627\u0644\u064a. \u062d\u0627\u0648\u0644 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649 \u0641\u064a \u0648\u0642\u062a \u0644\u0627\u062d\u0642","visibility_updated_successfully":"\u062a\u0645 \u062a\u062d\u062f\u064a\u062b \u0627\u0644\u0631\u0624\u064a\u0629 \u0628\u0646\u062c\u0627\u062d","you_can_use_any_one_of_upload_video_or_video_URL_option":"\u064a\u0645\u0643\u0646\u0643 \u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0623\u064a \u062e\u064a\u0627\u0631 \u0644\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0641\u064a\u062f\u064a\u0648 \u0623\u0648 \u0639\u0646\u0648\u0627\u0646 URL \u0644\u0644\u0641\u064a\u062f\u064a\u0648","you_delete_than_emoji":"\u0644\u0627 \u064a\u0645\u0643\u0646\u0643 \u062d\u0630\u0641 \u0623\u0643\u062b\u0631 \u0645\u0646 4 \u0631\u0645\u0648\u0632 \u062a\u0639\u0628\u064a\u0631\u064a\u0629","your_account_is_currently_disabled_please_contact_to_administrator":"\u062d\u0633\u0627\u0628\u0643 \u0645\u0639\u0637\u0644 \u062d\u0627\u0644\u064a\u064b\u0627 \u060c \u064a\u0631\u062c\u0649 \u0627\u0644\u0627\u062a\u0635\u0627\u0644 \u0628\u0627\u0644\u0645\u0633\u0624\u0648\u0644.","your_mail_already_verified":"\u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0628\u0631\u064a\u062f\u0643 \u0628\u0627\u0644\u0641\u0639\u0644 \u060c \u064a\u0631\u062c\u0649 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644","your_manual_payment_request_is":"\u0637\u0644\u0628 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a \u0627\u0644\u062e\u0627\u0635 \u0628\u0643 \u0647\u0648","your_plan_is_expired_Please_choose_a_plan_to_continue_the_services":"\u0627\u0646\u062a\u0647\u062a \u062e\u0637\u062a\u0643. \u0627\u0644\u0631\u062c\u0627\u0621 \u0627\u062e\u062a\u064a\u0627\u0631 \u062e\u0637\u0629 \u0644\u0645\u0648\u0627\u0635\u0644\u0629 \u0627\u0644\u062e\u062f\u0645\u0627\u062a"},"plans":{"add_plan":"\u0623\u0636\u0641 \u062e\u0637\u0629","allowed_post":"\u0627\u0644\u0648\u0638\u064a\u0641\u0629 \u0627\u0644\u0645\u0633\u0645\u0648\u062d \u0628\u0647\u0627","currency":"\u0639\u0645\u0644\u0629","default_Plan":"\u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","edit_plan":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062e\u0637\u0629","enter_trial":"\u0623\u062f\u062e\u0644 \u0627\u0644\u062a\u062c\u0631\u0628\u0629","frequency":"\u062a\u0643\u0631\u0631","monthly":"\u0634\u0647\u0631\u064a\u0627","new_plan":"\u062e\u0637\u0629 \u062c\u062f\u064a\u062f\u0629","no_of_posts":"\u0639\u062f\u062f \u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0627\u062a","plan":"\u064a\u062e\u0637\u0637","plan_name":"\u0627\u0633\u0645 \u0627\u0644\u062e\u0637\u0629","plans":"\u0627\u0644\u062e\u0637\u0637","price":"\u0633\u0639\u0631","select_currency":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0639\u0645\u0644\u0629","trial_days":"\u0623\u064a\u0627\u0645 \u0627\u0644\u0645\u062d\u0627\u0643\u0645\u0629","unlimited":"\u063a\u064a\u0631 \u0645\u062d\u062f\u0648\u062f","yearly":"\u0633\u0646\u0648\u064a"},"poll":{"add_poll":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0633\u062a\u0637\u0644\u0627\u0639","add_polls":"\u0625\u0636\u0627\u0641\u0629 \u0627\u0633\u062a\u0637\u0644\u0627\u0639\u0627\u062a \u0627\u0644\u0631\u0623\u064a","all_user":"\u062c\u0645\u064a\u0639 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646","edit_poll":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0627\u0633\u062a\u0637\u0644\u0627\u0639","no_result_found":"\u0644\u0645 \u064a\u062a\u0645 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0646\u062a\u0627\u0626\u062c","option1":"\u0627\u0644\u062e\u064a\u0627\u0631 1","option10":"\u0627\u0644\u062e\u064a\u0627\u0631 10","option2":"\u0627\u0644\u062e\u064a\u0627\u0631 2","option3":"\u0627\u0644\u062e\u064a\u0627\u0631 3","option4":"\u0627\u0644\u062e\u064a\u0627\u0631 4","option5":"\u0627\u0644\u062e\u064a\u0627\u0631 5","option6":"\u0627\u0644\u062e\u064a\u0627\u0631 6","option7":"\u0627\u0644\u062e\u064a\u0627\u0631 7","option8":"\u0627\u0644\u062e\u064a\u0627\u0631 8","option9":"\u0627\u0644\u062e\u064a\u0627\u0631 9","poll":"\u062a\u0635\u0648\u064a\u062a","poll_result":"\u0646\u062a\u064a\u062c\u0629 \u0627\u0644\u0627\u0633\u062a\u0637\u0644\u0627\u0639","question":"\u0633\u0624\u0627\u0644","register_user":"\u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645","show_result":"\u0646\u062a\u064a\u062c\u0629 \u0627\u0644\u0639\u0631\u0636","total_vote":"\u0645\u062c\u0645\u0648\u0639 \u0627\u0644\u062a\u0635\u0648\u064a\u062a","view_option":"\u0639\u0631\u0636 \u0627\u0644\u062e\u064a\u0627\u0631","voting_poll":"\u062a\u0635\u0648\u064a\u062a \u062a\u0635\u0648\u064a\u062a"},"polls":"\u0627\u0633\u062a\u0637\u0644\u0627\u0639\u0627\u062a \u0627\u0644\u0631\u0623\u064a","post":{"add_ai":"\u0627\u0643\u062a\u0628 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 Openai","add_article":"\u0623\u0636\u0641 \u0627\u0644\u0645\u0627\u062f\u0629","add_audio":"\u0623\u0636\u0641 \u0627\u0644\u0635\u0648\u062a","add_gallery":"\u0623\u0636\u0641 \u0645\u0639\u0631\u0636","add_image":"\u0625\u0636\u0627\u0641\u0629 \u0635\u0648\u0631\u0629","add_new_item":"\u0623\u0636\u0641 \u0623\u062f\u0627\u0629 \u062c\u062f\u064a\u062f\u0629","add_on_headline":"\u0623\u0636\u0641 \u0639\u0644\u0649 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","add_personality_quiz":"\u0625\u0636\u0627\u0641\u0629 \u0627\u062e\u062a\u0628\u0627\u0631 \u0627\u0644\u0634\u062e\u0635\u064a\u0629,","add_post":"\u0623\u0636\u0641 \u0645\u0646\u0634\u0648\u0631\u0627","add_sort_list":"\u0625\u0636\u0627\u0641\u0629 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0641\u0631\u0632","add_to_breaking":"\u0623\u0636\u0641 \u0625\u0644\u0649 \u0643\u0633\u0631","add_to_featured":"\u0623\u0636\u0641 \u0625\u0644\u0649 \u0627\u0644\u0645\u0645\u064a\u0632","add_to_recommended":"\u0623\u0636\u0641 \u0625\u0644\u0649 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647","add_to_slider":"\u0623\u0636\u0641 \u0625\u0644\u0649 \u0627\u0644\u0645\u0646\u0632\u0644\u0642","add_trivia_quiz":"\u0623\u0636\u0641 \u0627\u062e\u062a\u0628\u0627\u0631\u064b\u0627 \u0628\u0633\u064a\u0637\u064b\u0627","add_video":"\u0623\u0636\u0641 \u0641\u064a\u062f\u064a\u0648","additional":"\u0635\u0648\u0631 \u0625\u0636\u0627\u0641\u064a\u0629","allowed_images_jpg_png_jpeg":"(JPG,PNG,JPEG,SVG,WEBP)","article":"\u0645\u0642\u0627\u0644\u0627\u062a","article_with_images":"\u0645\u0642\u0627\u0644 \u0628\u0627\u0644\u0635\u0648\u0631 \u0648\u0645\u0642\u0627\u0637\u0639 \u0627\u0644\u0641\u064a\u062f\u064a\u0648 \u0627\u0644\u0645\u0636\u0645\u0646\u0629","article_with_open_ai":"\u0627\u0643\u062a\u0628 \u0627\u0644\u0645\u062d\u062a\u0648\u0649 \u0627\u0644\u062e\u0627\u0635 \u0628\u0643 \u0628\u0627\u0633\u062a\u062e\u062f\u0627\u0645 Openai","audio":"\u0635\u0648\u062a\u064a","category":"\u0641\u0626\u0629","choose_post_format":"\u0627\u062e\u062a\u0631 \u062a\u0646\u0633\u064a\u0642 \u0627\u0644\u0645\u0646\u0634\u0648\u0631","collection_of_images":"\u0645\u062c\u0645\u0648\u0639\u0629 \u0645\u0646 \u0627\u0644\u0635\u0648\u0631","d&t":"\u0627\u062e\u062a\u0631 \u0627\u0644\u062a\u0627\u0631\u064a\u062e \u0648\u0627\u0644\u0648\u0642\u062a","description":"\u0648\u0635\u0641","draft":"\u062d\u0641\u0638 \u0643\u0645\u0633\u0648\u062f\u0629","edit_AI":"\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0646\u0634\u0648\u0631","edit_Article":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0642\u0627\u0644","edit_Audio":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0635\u0648\u062a","edit_Gallery":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0645\u0639\u0631\u0636","edit_Sorted":"\u062a\u062d\u0631\u064a\u0631 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0641\u0631\u0632","edit_Video":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u0641\u064a\u062f\u064a\u0648","edit_post":"\u062a\u0639\u062f\u064a\u0644 \u0627\u0644\u0645\u0646\u0634\u0648\u0631","featured":"\u0645\u062a\u0645\u064a\u0632","file":"\u0645\u0644\u0641","gallery":"\u0635\u0627\u0644\u0629 \u0639\u0631\u0636","gallery_post_item":"\u0639\u0646\u0635\u0631 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u0645\u0639\u0631\u0636","get_video":"\u0625\u062d\u0636\u0627\u0631 \u0641\u064a\u062f\u064a\u0648 \u0645\u0646 URL","image":"\u0635\u0648\u0631\u0629","image_description":"\u0648\u0635\u0641 \u0627\u0644\u0635\u0648\u0631\u0629","keywords":"\u0627\u0644\u0643\u0644\u0645\u0627\u062a \u0627\u0644\u062f\u0627\u0644\u0629","list_based_article":"\u0645\u0642\u0627\u0644 \u0642\u0627\u0626\u0645 \u0639\u0644\u0649 \u0627\u0644\u0642\u0627\u0626\u0645\u0629","open_ai":"\u0627\u0641\u062a\u062d \u0645\u0646\u0638\u0645\u0629 \u0627\u0644\u0639\u0641\u0648 \u0627\u0644\u062f\u0648\u0644\u064a\u0629","optional_url":"URL \u0627\u062e\u062a\u064a\u0627\u0631\u064a","or_add_url":"\u0623\u0648 \u0625\u0636\u0627\u0641\u0629 \u0639\u0646\u0648\u0627\u0646 Url \u0644\u0644\u0635\u0648\u0631\u0629","personality_quiz":"\u0645\u0633\u0627\u0628\u0642\u0629 \u0627\u0644\u0634\u062e\u0635\u064a\u0629","post":"\u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0627\u062a","post_type":"\u0646\u0648\u0639 \u0622\u062e\u0631","posts":"\u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0627\u062a","publish":"\u064a\u0646\u0634\u0631","publish_post":"\u0646\u0634\u0631 \u0627\u0644\u0645\u0646\u0634\u0648\u0631","quizzes_with_custom_results":"\u0645\u0633\u0627\u0628\u0642\u0627\u062a \u0645\u0639 \u0646\u062a\u0627\u0626\u062c \u0645\u062e\u0635\u0635\u0629","quizzes_with_right_and_wrong_answers":"\u0627\u062e\u062a\u0628\u0627\u0631\u0627\u062a \u0628\u0625\u062c\u0627\u0628\u0627\u062a \u0635\u062d\u064a\u062d\u0629 \u0648\u062e\u0627\u0637\u0626\u0629","remove_on_headline":"\u0625\u0632\u0627\u0644\u0629 \u0641\u064a \u0627\u0644\u0639\u0646\u0648\u0627\u0646","remove_to_breaking":"\u0625\u0632\u0627\u0644\u0629 \u0644\u0644\u0643\u0633\u0631","remove_to_featured":"\u0625\u0632\u0627\u0644\u0629 \u0625\u0644\u0649 \u0627\u0644\u0645\u0645\u064a\u0632\u0629","remove_to_recommended":"\u0625\u0632\u0627\u0644\u0629 \u0625\u0644\u0649 \u0627\u0644\u0645\u0648\u0635\u0649 \u0628\u0647\u0627","remove_to_slider":"\u0625\u0632\u0627\u0644\u0629 \u0625\u0644\u0649 \u0634\u0631\u064a\u0637 \u0627\u0644\u062a\u0645\u0631\u064a\u0631","scheduled_post":"\u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0627\u062a \u0627\u0644\u0645\u062c\u062f\u0648\u0644\u0629","select_image":"\u0627\u062e\u062a\u0631 \u0635\u0648\u0631\u0629","select_post_type":"\u062d\u062f\u062f \u0646\u0648\u0639 \u0627\u0644\u0645\u0646\u0634\u0648\u0631","selected_file":"\u0627\u0644\u0645\u0644\u0641\u0627\u062a \u0627\u0644\u0645\u062e\u062a\u0627\u0631\u0629","short_description":"\u0648\u0635\u0641 \u0642\u0635\u064a\u0631","show_on_headline":"\u0641\u064a \u0627\u0644\u0639\u0646\u0648\u0627\u0646","show_registered_user":"\u0639\u0631\u0636 \u0641\u0642\u0637 \u0644\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u064a\u0646 \u0627\u0644\u0645\u0633\u062c\u0644\u064a\u0646","show_right":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0639\u0645\u0648\u062f \u0627\u0644\u0623\u064a\u0645\u0646","sort_list":"\u0642\u0627\u0626\u0645\u0629 \u0645\u0631\u062a\u0628\u0629","sort_list_item":"\u0639\u0646\u0635\u0631 \u0642\u0627\u0626\u0645\u0629 \u062a\u0645 \u0641\u0631\u0632\u0647\u0627","spotted_video":"(\u064a\u0648\u062a\u064a\u0648\u0628 , \u0641\u064a\u0645\u064a\u0648 , \u062f\u064a\u0644\u064a \u0645\u0648\u0634\u0646)","sub_category":"\u062a\u0635\u0646\u064a\u0641 \u0641\u0631\u0639\u064a","submit":"\u0625\u0631\u0633\u0627\u0644","tag":"\u0627\u0644\u0639\u0644\u0627\u0645\u0627\u062a","thumbnail_image":"\u0623\u062f\u062e\u0644 \u0631\u0627\u0628\u0637 \u0635\u062d\u064a\u062d \u0645\u0646 \u0641\u0636\u0644\u0643","trivia_quiz":"\u0645\u0633\u0627\u0628\u0642\u0629 \u062a\u0631\u0627\u0641\u0627","upload_audios_and_create_playlist":"\u062a\u062d\u0645\u064a\u0644 \u0627\u0644\u0635\u0648\u062a\u064a\u0627\u062a \u0648\u0625\u0646\u0634\u0627\u0621 \u0642\u0627\u0626\u0645\u0629 \u0627\u0644\u062a\u0634\u063a\u064a\u0644","upload_or_embed_videos":"\u062a\u062d\u0645\u064a\u0644 \u0623\u0648 \u062a\u0636\u0645\u064a\u0646 \u0645\u0642\u0627\u0637\u0639 \u0627\u0644\u0641\u064a\u062f\u064a\u0648","upload_video":"\u0631\u0641\u0639 \u0641\u064a\u062f\u064a\u0648","video":"\u0641\u064a\u062f\u064a\u0648","video_embed_code":"\u0643\u0648\u062f \u062a\u0636\u0645\u064a\u0646 \u0627\u0644\u0641\u064a\u062f\u064a\u0648","video_thumbnail":"\u0635\u0648\u0631\u0629 \u0645\u0635\u063a\u0631\u0629 \u0644\u0644\u0641\u064a\u062f\u064a\u0648","video_url":"\u0631\u0627\u0628\u0637 \u0627\u0644\u0641\u064a\u062f\u064a\u0648","visibility":"\u0627\u0644\u0631\u0624\u064a\u0629"},"post_reaction":"\u0631\u062f \u0627\u0644\u0641\u0639\u0644","reaction":{"angry":"\u063a\u0627\u0636\u0628","dislike":"\u0644\u0645 \u064a\u0639\u062c\u0628\u0646\u0649","funny":"\u0645\u0636\u062d\u0643","like":"\u064a\u062d\u0628","love":"\u0627\u0644\u062d\u0628","pray":"\u064a\u0635\u0644\u064a","sad":"\u062d\u0632\u064a\u0646","super":"\u0645\u0645\u062a\u0627\u0632","wow":"\u0631\u0627\u0626\u0639"},"recent_posts":"\u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0627\u062a \u0627\u0644\u0627\u062e\u064a\u0631\u0629","required":"\u0645\u0637\u0644\u0648\u0628","role":{"add_role":"\u0623\u0636\u0641 \u062f\u0648\u0631\u064b\u0627","edit_role":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062f\u0648\u0631","permissions":"\u0623\u0630\u0648\u0646\u0627\u062a","role":"\u062f\u0648\u0631","role_permissions":"\u0623\u0630\u0648\u0646\u0627\u062a \u0627\u0644\u062f\u0648\u0631","select_all_permissions":"\u062d\u062f\u062f \u0643\u0627\u0641\u0629 \u0627\u0644\u0623\u0630\u0648\u0646\u0627\u062a"},"roles":"\u0627\u0644\u0623\u062f\u0648\u0627\u0631","roles_permissions":"\u0625\u0630\u0646 \u0627\u0644\u0623\u062f\u0648\u0627\u0631","rss-feed":"\u062a\u063a\u0630\u064a\u0629 \u0627\u0631 \u0627\u0633 \u0627\u0633","rss_feed":{"add_posts":"\u0625\u0636\u0627\u0641\u0629 \u0645\u0634\u0627\u0631\u0643\u0627\u062a \u0643\u0645\u0633\u0648\u062f\u0629","add_rss_feed":"\u0625\u0636\u0627\u0641\u0629 \u0622\u0631 \u0625\u0633 \u0625\u0633","auto_update":"\u0627\u0644\u062a\u062d\u062f\u064a\u062b \u0627\u0644\u062a\u0644\u0642\u0627\u0626\u064a","btn_text":"\u0632\u0631 \"\u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0645\u0632\u064a\u062f \u0646\u0635\"","feed_name":"\u0623\u0637\u0639\u0645\u0646\u0649","feed_url":"URL \u062a\u063a\u0630\u064a\u0629","generate_keywords":"\u062a\u0648\u0644\u064a\u062f \u0643\u0644\u0645\u0627\u062a \u0631\u0626\u064a\u0633\u064a\u0629 \u0645\u0646 \u0627\u0644\u0639\u0646\u0648\u0627\u0646","images_source":"\u0645\u0635\u062f\u0631 \u0627\u0644\u0635\u0648\u0631","keywords":"\u0627\u0644\u0643\u0644\u0645\u0627\u062a \u0627\u0644\u062f\u0627\u0644\u0629","my_server":"\u062a\u0646\u0632\u064a\u0644 \u0627\u0644\u0635\u0648\u0631 \u0625\u0644\u0649 \u062e\u0627\u062f\u0645\u064a","no":"\u0631\u0642\u0645","no_posts":"\u0645\u0627\u0643\u0633 \u0627\u0633\u062a\u064a\u0631\u0627\u062f \u0628\u0648\u0633\u062a","original_source":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0635\u0648\u0631 \u0645\u0646 \u0627\u0644\u0645\u0635\u062f\u0631 \u0627\u0644\u0623\u0635\u0644\u064a","post_import":"\u0627\u0644\u0645\u0634\u0627\u0631\u0643\u0627\u062a \/ \u0627\u0644\u0627\u0633\u062a\u064a\u0631\u0627\u062f","scheduled_post_delete":"\u062d\u0630\u0641 \u0627\u0644\u0645\u0646\u0634\u0648\u0631 \u0627\u0644\u0645\u062c\u062f\u0648\u0644","show_btn":"\u0625\u0638\u0647\u0627\u0631 \u0632\u0631 \u0642\u0631\u0627\u0621\u0629 \u0627\u0644\u0645\u0632\u064a\u062f","show_btn_text":"\u0625\u0638\u0647\u0627\u0631 \u0627\u0644\u0632\u0631","yes":"\u0646\u0639\u0645"},"save":"\u062d\u0641\u0638","search":"\u0628\u062d\u062b","seo-tool":{"google_analytics":"\u062a\u062d\u0644\u064a\u0644\u0627\u062a \u0643\u0648\u0643\u0644","home_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0646\u0632\u0644","keyword":"\u0627\u0644\u0643\u0644\u0645\u0629 \u0627\u0644\u0631\u0626\u064a\u0633\u064a\u0629","language":"\u0644\u063a\u0629","maxkeyword":"\u0623\u062f\u062e\u0644 10 \u0643\u0644\u0645\u0627\u062a \u0643\u062d\u062f \u0623\u0642\u0635\u0649","site_description":"\u0648\u0635\u0641 \u0627\u0644\u0645\u0648\u0642\u0639","site_title":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0645\u0648\u0642\u0639"},"seo-tools":"\u0623\u062f\u0648\u0627\u062a \u062a\u062d\u0633\u064a\u0646 \u0645\u062d\u0631\u0643\u0627\u062a \u0627\u0644\u0628\u062d\u062b","service_categories":"\u0641\u0626\u0627\u062a \u0627\u0644\u062e\u062f\u0645\u0629","services":"\u062e\u062f\u0645\u0627\u062a","setting":{"Manually":"\u064a\u062f\u0648\u064a\u064b\u0627","Paypal":"\u0628\u0627\u064a \u0628\u0627\u0644","Stripe":"\u0634\u0631\u064a\u0637","about_text":"\u062d\u0648\u0644 \u0627\u0644\u0646\u0635","address":"\u0639\u0646\u0648\u0627\u0646","app_name":"\u0627\u0633\u0645 \u0627\u0644\u062a\u0637\u0628\u064a\u0642","cms":"CMS","contact_address":"\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0625\u062a\u0635\u0627\u0644","contact_information":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0627\u0644\u0627\u062a\u0635\u0627\u0644","cookie_warning":"\u062a\u062d\u0630\u064a\u0631\u0627\u062a \u0645\u0644\u0641\u0627\u062a \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0627\u0631\u062a\u0628\u0627\u0637","copy_right_text":"\u0646\u0635 \u062d\u0642\u0648\u0642 \u0627\u0644\u0646\u0634\u0631","currency":"\u0639\u0645\u0644\u0629","currency_settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0639\u0645\u0644\u0629","facebook":"\u0641\u064a\u0633\u0628\u0648\u0643","facebook_url":"URL \u0627\u0644\u0641\u064a\u0633\u0628\u0648\u0643","favicon":"\u0641\u0627\u0641\u064a\u0643\u0648\u0646","front_language":"\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0623\u0645\u0627\u0645\u064a\u0629 \u0627\u0644\u0627\u0641\u062a\u0631\u0627\u0636\u064a\u0629","general":"\u0639\u0627\u0645","general_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0639\u0627\u0645\u0629","generate_sitemap":"\u062a\u0648\u0644\u064a\u062f \u062e\u0631\u064a\u0637\u0629 \u0627\u0644\u0645\u0648\u0642\u0639","google_recaptcha":"\u062c\u0648\u062c\u0644 \u0631\u064a\u0643\u0627\u0628\u062a\u0634\u0627","instagram_url":"\u0627\u0646\u0633\u062a\u063a\u0631\u0627\u0645 URL","invalid_facebook_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0639\u0644\u0649 Facebook","invalid_instagram_url":"\u064a\u0631\u062c\u0649 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Instagram","invalid_linkedin_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 LinkedIn","invalid_pinterest_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Pinterest","invalid_telegram_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d Telegram","invalid_twitter_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0639\u0644\u0649 Twitter","invalid_vk_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0644\u0640 Vk","invalid_youtube_url":"\u0627\u0644\u0631\u062c\u0627\u0621 \u0625\u062f\u062e\u0627\u0644 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d \u0639\u0644\u0649 Youtube","linkedIn":"\u064a\u0646\u0643\u062f\u064a\u0646","linkedin_url":"\u064a\u0646\u0643\u062f\u064a\u0646 URL","logo":"\u0634\u0639\u0627\u0631","manual_payment_guide":"\u062f\u0644\u064a\u0644 \u0627\u0644\u062f\u0641\u0639 \u0627\u0644\u064a\u062f\u0648\u064a","pinterest_url":"\u0628\u064a\u0646\u062a\u064a\u0631\u064a\u0633\u062a URL","postal_code":"\u0631\u0645\u0632 \u0628\u0631\u064a\u062f\u064a","prefix":"\u0627\u062e\u062a\u0635\u0627\u0631","privacy":"\u062e\u0635\u0648\u0635\u064a\u0629","reddit":"\u0631\u062f\u064a\u062a","required_privacy":"\u062d\u0642\u0644 \u0627\u0644\u062e\u0635\u0648\u0635\u064a\u0629 \u0645\u0637\u0644\u0648\u0628","required_support":"\u062d\u0642\u0644 \u0627\u0644\u062f\u0639\u0645 \u0645\u0637\u0644\u0648\u0628","required_t&c":"\u0645\u0637\u0644\u0648\u0628 \u062d\u0642\u0644 \u0627\u0644\u0634\u0631\u0648\u0637 \u0648\u0627\u0644\u0623\u062d\u0643\u0627\u0645","rss_feed_auto_update":"\u062a\u062d\u062f\u064a\u062b \u062a\u0644\u0642\u0627\u0626\u064a \u0644\u062e\u0644\u0627\u0635\u0629 RSS","run_commend":"\u0627\u0644\u0623\u0645\u0631 Run","secret_key":"\u0627\u0644\u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0633\u0631\u064a","select_time":"\u062d\u062f\u062f \u0627\u0644\u0648\u0642\u062a","setting":"\u062c\u0644\u0633\u0629","show_captcha":"\u0639\u0631\u0636 \u062c\u0648\u062c\u0644 \u0631\u064a\u0643\u0627\u0628\u0634\u0627","show_cookie_warning":"\u0625\u0638\u0647\u0627\u0631 \u062a\u062d\u0630\u064a\u0631\u0627\u062a \u0645\u0644\u0641\u0627\u062a \u062a\u0639\u0631\u064a\u0641 \u0627\u0644\u0627\u0631\u062a\u0628\u0627\u0637","site_key":"\u0645\u0641\u062a\u0627\u062d \u0627\u0644\u0645\u0648\u0642\u0639","social_media_setting":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a \u0627\u0644\u0648\u0633\u0627\u0626\u0637 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a\u0629","social_media_sharing":"\u0648\u0633\u0627\u0626\u0644 \u0627\u0644\u0627\u0639\u0644\u0627\u0645 \u0627\u0644\u0627\u062c\u062a\u0645\u0627\u0639\u064a\u0629 \u0627\u0644\u0645\u0634\u062a\u0631\u0643\u0629","support":"\u064a\u062f\u0639\u0645","telegram_url":"\u0628\u0631\u0642\u064a\u0629 URL","terms-conditions":"\u0627\u0644\u0628\u0646\u0648\u062f \u0648 \u0627\u0644\u0638\u0631\u0648\u0641","twitter":"\u062a\u0648\u064a\u062a\u0631","twitter_url":"\u062a\u0648\u064a\u062a\u0631 URL","vk_url":"VK URL","whatsapp":"\u0648\u0627\u062a\u0633 \u0627\u0628,","youtube_url":"\u064a\u0648\u062a\u064a\u0648\u0628 URL"},"settings":"\u0625\u0639\u062f\u0627\u062f\u0627\u062a","share_this_post":"\u0634\u0627\u0631\u0643 \u0647\u0630\u0627 \u0627\u0644\u0645\u0646\u0634\u0648\u0631","show":"\u064a\u0639\u0631\u0636","staff":{"about_us":"\u0645\u0639\u0644\u0648\u0645\u0627\u062a \u0639\u0646\u0627","add_staff":"\u0625\u0636\u0627\u0641\u0629 \u0637\u0627\u0642\u0645 \u0627\u0644\u0639\u0645\u0644","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_no":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","cover_image":"\u0635\u0648\u0631\u0629 \u0627\u0644\u063a\u0644\u0627\u0641","edit_staff":"\u062a\u062d\u0631\u064a\u0631 \u0641\u0631\u064a\u0642 \u0627\u0644\u0639\u0645\u0644","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","email_verified":"\u062a\u0645 \u0627\u0644\u062a\u062d\u0642\u0642 \u0645\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a","female":"\u0623\u0646\u062b\u0649","first_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0623\u0648\u0644","gender":"\u062c\u0646\u0633","last_name":"\u0627\u0644\u0643\u0646\u064a\u0629","male":"\u0630\u0643\u0631","password":"\u0643\u0644\u0645\u0647 \u0627\u0644\u0633\u0631","profile":"\u062d\u0633\u0627\u0628 \u062a\u0639\u0631\u064a\u0641\u064a","role":"\u062f\u0648\u0631","staff":"\u0627\u0644\u0639\u0627\u0645\u0644\u064a\u0646","username":"\u0627\u0633\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645"},"staffs":"\u0637\u0627\u0642\u0645 \u0627\u0644\u0639\u0645\u0644","state":{"add_state":"\u0623\u0636\u0641 \u062f\u0648\u0644\u0629","country":"\u062f\u0648\u0644\u0629","edit_state":"\u062a\u062d\u0631\u064a\u0631 \u0627\u0644\u062f\u0648\u0644\u0629","state":"\u062d\u0627\u0644\u0629","states":"\u062a\u0646\u0635 \u0639\u0644\u0649"},"states":"\u062a\u0646\u0635 \u0639\u0644\u0649","status":"\u062d\u0627\u0644\u0629","sub_categories":"\u0627\u0644\u0641\u0626\u0627\u062a \u0627\u0644\u0641\u0631\u0639\u064a\u0629","sub_category":{"action":"\u0639\u0645\u0644","add":"\u0625\u0636\u0627\u0641\u0629 \u0641\u0626\u0629 \u0641\u0631\u0639\u064a\u0629","add_lan":"\u0644\u063a\u0629","category":"\u0641\u0626\u0629","edit":"\u062a\u062d\u0631\u064a\u0631 \u0641\u0626\u0629 \u0641\u0631\u0639\u064a\u0629","language":"\u0644\u063a\u0629","select_cat":"\u0627\u062e\u062a\u0631 \u0627\u0644\u0641\u0626\u0629","show_menu":"\u0625\u0638\u0647\u0627\u0631 \u0641\u064a \u0627\u0644\u0642\u0627\u0626\u0645\u0629","title":"\u0639\u0646\u0648\u0627\u0646"},"subscribed_user":"\u062e\u0637\u0637 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645 \u0627\u0644\u0645\u0634\u062a\u0631\u0643","subscriber":"\u0645\u0634\u062a\u0631\u0643","subscription":{"active_until":"\u0646\u0634\u0637 \u062d\u062a\u0649","active_until_unlimited":"\u0646\u0634\u0637 \u062d\u062a\u0649 \u063a\u064a\u0631 \u0645\u062d\u062f\u0648\u062f","amount":"\u0645\u0642\u062f\u0627\u0631","cancel_subscription":"\u0625\u0644\u063a\u0627\u0621 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","change_payment_status":"\u062a\u063a\u064a\u064a\u0631 \u062d\u0627\u0644\u0629 \u0627\u0644\u062f\u0641\u0639","choose_plan":"\u0627\u062e\u062a\u0631 \u062e\u0637\u0629","current_expire":"\u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u0645\u0646\u062a\u0647\u064a\u0629 \u0627\u0644\u0635\u0644\u0627\u062d\u064a\u0629","current_plan":"\u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u062d\u0627\u0644\u064a\u0629","currently_active":"\u0646\u0634\u0637 \u062d\u0627\u0644\u064a\u0627","days":"\u0623\u064a\u0627\u0645","duration":"\u0645\u062f\u0629","end_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0646\u062a\u0647\u0627\u0621","expired":"\u0627\u0644\u062e\u0637\u0629 \u0627\u0646\u062a\u0647\u062a \u0628\u0627\u0644\u0641\u0639\u0644 \u0641\u064a","expired_date":"\u0645\u0646\u062a\u0647\u064a \u0627\u0644\u0635\u0644\u0627\u062d\u064a\u0629","free":"\u062d\u0631","has_already_been_subscribed":"\u0645\u0634\u062a\u0631\u0643 \u0628\u0627\u0644\u0641\u0639\u0644","has_been_subscribed":"\u062a\u0645 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","history":"\u0633\u062c\u0644 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","manage_subscription":"\u0625\u062f\u0627\u0631\u0629 \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","months":"\u0634\u0647\u0648\u0631","no_plan_available":"\u0644\u0627 \u062a\u0648\u062c\u062f \u062e\u0637\u0629 \u0645\u062a\u0627\u062d\u0629","number_of_post":"\u0631\u0642\u0645 \u0627\u0644\u0628\u0631\u064a\u062f","pay_or_switch_plan":"\u062e\u0637\u0629 \u0627\u0644\u062f\u0641\u0639 \/ \u0627\u0644\u062a\u0628\u062f\u064a\u0644","payable_amount":"\u0627\u0644\u0645\u0628\u0644\u063a \u0627\u0644\u0645\u0633\u062a\u062d\u0642","payment":"\u0642\u0633\u0637","plan_name":"\u0627\u0633\u0645 \u0627\u0644\u062e\u0637\u0629","plan_price":"\u0633\u0639\u0631 \u0627\u0644\u062e\u0637\u0629","proceed_to_payment":"\u0627\u0644\u0634\u0631\u0648\u0639 \u0641\u064a \u062f\u0641\u0639","purchase":"\u0634\u0631\u0627\u0621","remaining":"\u0645\u062a\u0628\u0642\u064a","remaining_balance":"\u0627\u0644\u0631\u0635\u064a\u062f \u0627\u0644\u0645\u062a\u0628\u0642\u064a","remaining_days":"\u0627\u0644\u0623\u064a\u0627\u0645 \u0627\u0644\u0645\u062a\u0628\u0642\u064a\u0629","renew_free_plan":"\u0644\u0627 \u064a\u0645\u0643\u0646 \u062a\u062c\u062f\u064a\u062f \/ \u0627\u062e\u062a\u064a\u0627\u0631 \u0627\u0644\u062e\u0637\u0629 \u0627\u0644\u0645\u062c\u0627\u0646\u064a\u0629 \u0645\u0631\u0629 \u0623\u062e\u0631\u0649","renew_plan":"\u062a\u062c\u062f\u064a\u062f \u0627\u0644\u062e\u0637\u0629","start_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0628\u062f\u0621","subscribed_date":"\u062a\u0627\u0631\u064a\u062e \u0627\u0644\u0627\u0634\u062a\u0631\u0627\u0643","switch_plan":"\u062a\u0628\u062f\u064a\u0644 \u0627\u0644\u062e\u0637\u0629","total_days":"\u0645\u062c\u0645\u0648\u0639 \u0627\u0644\u0623\u064a\u0627\u0645","trial_plan":"\u062e\u0637\u0629 \u062a\u062c\u0631\u064a\u0628\u064a\u0629","upgrade_plan":"\u062e\u0637\u0629 \u0627\u0644\u062a\u0631\u0642\u064a\u0629","used_balance":"\u0627\u0644\u0645\u064a\u0632\u0627\u0646 \u0627\u0644\u0645\u0633\u062a\u0639\u0645\u0644","used_days":"\u0627\u0644\u0623\u064a\u0627\u0645 \u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0629","what_in_startup_plan":"\u0645\u0627\u0630\u0627 \u064a\u0648\u062c\u062f \u0641\u064a \u062e\u0637\u0629 \u0628\u062f\u0621 \u0627\u0644\u062a\u0634\u063a\u064a\u0644","year":"\u0633\u0646\u0629"},"sync":"\u0645\u0632\u0627\u0645\u0646\u0629","translation_manager":"\u0645\u062f\u064a\u0631 \u0627\u0644\u062a\u0631\u062c\u0645\u0629","user":{"account":"\u0627\u0644\u062d\u0633\u0627\u0628","account_setting":"\u0625\u0639\u062f\u0627\u062f\u062a \u0627\u0644\u062d\u0633\u0627\u0628","avatar":"\u0627\u0644\u0635\u0648\u0631\u0629 \u0627\u0644\u0631\u0645\u0632\u064a\u0629","change_password":"\u063a\u064a\u0631 \u0643\u0644\u0645\u0629 \u0627\u0644\u0633\u0631","confirm_password":"\u062a\u0623\u0643\u064a\u062f \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631","contact_number":"\u0631\u0642\u0645 \u0627\u0644\u0627\u062a\u0635\u0627\u0644","current_password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062d\u0627\u0644\u064a\u0629","email":"\u0628\u0631\u064a\u062f \u0627\u0644\u0627\u0644\u0643\u062a\u0631\u0648\u0646\u064a","full_name":"\u0627\u0644\u0627\u0633\u0645 \u0627\u0644\u0643\u0627\u0645\u0644","gender":"\u062c\u0646\u0633","new_password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062c\u062f\u064a\u062f\u0629","profile":"\u0645\u062f\u064a\u0631 \u0627\u0644\u062a\u0631\u062c\u0645\u0629","profile_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0627\u0644\u0645\u0644\u0641 \u0627\u0644\u0634\u062e\u0635\u064a","save_changes":"\u062d\u0641\u0638 \u0627\u0644\u062a\u063a\u064a\u064a\u0631\u0627\u062a","setting":"\u062c\u0644\u0633\u0629","staff_details":"\u062a\u0641\u0627\u0635\u064a\u0644 \u0637\u0627\u0642\u0645 \u0627\u0644\u0639\u0645\u0644"},"users":"\u0627\u0644\u0645\u0633\u062a\u062e\u062f\u0645\u0648\u0646","weekdays":{"fri":"\u0627\u0644\u0627\u0628","mon":"\u0645","sat":"\u0633","sun":"\u0633","thu":"\u062a\u064a","tue":"\u062a\u064a","wed":"\u062f\u0628\u0644\u064a\u0648"}},"ar.pagination":{"next":"\u0627\u0644\u062a\u0627\u0644\u064a &raquo;","previous":"&laquo; \u0633\u0627\u0628\u0642"},"ar.passwords":{"reset":"\u062a\u0645 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643!","sent":"\u0644\u0642\u062f \u0623\u0631\u0633\u0644\u0646\u0627 \u0639\u0628\u0631 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0631\u0627\u0628\u0637 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u062e\u0627\u0635\u0629 \u0628\u0643!","throttled":"\u064a\u0631\u062c\u0649 \u0627\u0644\u0627\u0646\u062a\u0638\u0627\u0631 \u0642\u0628\u0644 \u0625\u0639\u0627\u062f\u0629 \u0627\u0644\u0645\u062d\u0627\u0648\u0644\u0629.","token":"\u0631\u0645\u0632 \u0625\u0639\u0627\u062f\u0629 \u062a\u0639\u064a\u064a\u0646 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0647\u0630\u0627 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","user":"\u0644\u0627 \u064a\u0645\u0643\u0646\u0646\u0627 \u0627\u0644\u0639\u062b\u0648\u0631 \u0639\u0644\u0649 \u0645\u0633\u062a\u062e\u062f\u0645 \u0628\u0639\u0646\u0648\u0627\u0646 \u0627\u0644\u0628\u0631\u064a\u062f \u0627\u0644\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0647\u0630\u0627."},"ar.validation":{"accepted":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0642\u0628\u0648\u0644\u0647.","active_url":"\u0627\u0644 :attribute \u0644\u064a\u0633 \u0639\u0646\u0648\u0627\u0646 URL \u0635\u0627\u0644\u062d\u064b\u0627.","after":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0628\u0639\u062f :date.","after_or_equal":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0628\u0639\u062f \u0623\u0648 \u064a\u0633\u0627\u0648\u064a :date.","alpha":"\u0627\u0644 :attribute \u0642\u062f \u062a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u0641\u0642\u0637.","alpha_dash":"\u0627\u0644 :attribute \u0642\u062f \u062a\u062d\u062a\u0648\u064a \u0641\u0642\u0637 \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u0648\u0623\u0631\u0642\u0627\u0645 \u0648\u0634\u0631\u0637\u0627\u062a \u0648\u0634\u0631\u0637\u0627\u062a \u0633\u0641\u0644\u064a\u0629.","alpha_num":"\u0627\u0644 :attribute \u0642\u062f \u062a\u062d\u062a\u0648\u064a \u0641\u0642\u0637 \u0639\u0644\u0649 \u0623\u062d\u0631\u0641 \u0648\u0623\u0631\u0642\u0627\u0645.","array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0635\u0641\u0648\u0641\u0629.","attributes":[],"before":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e \u0642\u0628\u0644 :date.","before_or_equal":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0642\u0628\u0644 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a :date.","between":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0628\u064a\u0646 :min \u0648 :max \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0627\u0646 \u064a\u0643\u0648\u0646 \u0648\u0633\u0637\u0627 :min \u0648 :max \u0643\u064a\u0644\u0648 \u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0627\u0646 \u064a\u0643\u0648\u0646 \u0648\u0633\u0637\u0627 :min \u0648 :max.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0627\u0646 \u064a\u0643\u0648\u0646 \u0648\u0633\u0637\u0627 :min \u0648 :max \u0627\u0644\u0634\u062e\u0635\u064a\u0627\u062a."},"boolean":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u062d\u0642\u0644 \u0635\u062d\u064a\u062d\u064b\u0627 \u0623\u0648 \u062e\u0637\u0623.","confirmed":"\u0627\u0644 :attribute \u0627\u0644\u062a\u0623\u0643\u064a\u062f \u063a\u064a\u0631 \u0645\u062a\u0637\u0627\u0628\u0642.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"\u0627\u0644 :attribute \u0647\u0630\u0627 \u0644\u064a\u0633 \u062a\u0627\u0631\u064a\u062e \u0635\u062d\u064a\u062d.","date_equals":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u062a\u0627\u0631\u064a\u062e\u064b\u0627 \u0645\u0633\u0627\u0648\u064a\u064b\u0627 \u0644\u0640 :date.","date_format":"\u0627\u0644 :attribute \u0644\u0627 \u064a\u062a\u0637\u0627\u0628\u0642 \u0645\u0639 \u0627\u0644\u0634\u0643\u0644 :format.","different":"\u0627\u0644 :attribute \u0648 :other \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0645\u062e\u062a\u0644\u0641.","digits":"\u0627\u0644 :attribute \u0644\u0627 \u0628\u062f \u0648\u0623\u0646 :digits \u0623\u0631\u0642\u0627\u0645.","digits_between":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0627\u0646 \u064a\u0643\u0648\u0646 \u0648\u0633\u0637\u0627 :min \u0648 :max \u0623\u0631\u0642\u0627\u0645.","dimensions":"\u0627\u0644 :attribute \u0623\u0628\u0639\u0627\u062f \u0627\u0644\u0635\u0648\u0631\u0629 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d\u0629.","distinct":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0644\u0647 \u0642\u064a\u0645\u0629 \u0645\u0643\u0631\u0631\u0629.","email":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 \u0628\u0631\u064a\u062f \u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a \u0635\u0627\u0644\u062d.","ends_with":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0646\u062a\u0647\u064a \u0628\u0648\u0627\u062d\u062f \u0645\u0645\u0627 \u064a\u0644\u064a: :values.","exists":"\u0627\u0644 \u0627\u0644\u0645\u062d\u062f\u062f :attribute \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0644\u0641\u064b\u0627.","filled":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0644\u0644\u062d\u0642\u0644 \u0642\u064a\u0645\u0629.","gt":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u062b\u0631 \u0645\u0646 :value \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0643\u064a\u0644\u0648 :value \u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 :value.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 :value \u0627\u0644\u0634\u062e\u0635\u064a\u0627\u062a."},"gte":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0627\u0646 \u064a\u0645\u0644\u0643 :value \u0645\u0646 \u0627\u0644\u0639\u0646\u0627\u0635\u0631 \u0623\u0648 \u0623\u0643\u062b\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a :value \u0643\u064a\u0644\u0648 \u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a :value.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a :value \u0627\u0644\u0634\u062e\u0635\u064a\u0627\u062a."},"image":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0635\u0648\u0631\u0629.","in":"\u0627\u0644 \u0627\u0644\u0645\u062d\u062f\u062f :attribute \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","in_array":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f \u0641\u064a :other.","integer":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0635\u062d\u064a\u062d\u0627.","ip":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 IP \u0635\u0627\u0644\u062d\u064b\u0627.","ipv4":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 IPv4 \u0635\u0627\u0644\u062d\u064b\u0627.","ipv6":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0646\u0648\u0627\u0646 IPv6 \u0635\u0627\u0644\u062d\u064b\u0627.","json":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0633\u0644\u0633\u0644\u0629 JSON \u0635\u0627\u0644\u062d\u0629.","lt":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646 :value \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646 :value \u0643\u064a\u0644\u0648 \u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646 :value.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0642\u0644 \u0645\u0646 :value \u0627\u0644\u0634\u062e\u0635\u064a\u0627\u062a."},"lte":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0644\u0627 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 \u0623\u0643\u062b\u0631 \u0645\u0646 :value \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0635\u063a\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a :value \u0643\u064a\u0644\u0648 \u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0635\u063a\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a :value.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0623\u0635\u063a\u0631 \u0645\u0646 \u0623\u0648 \u064a\u0633\u0627\u0648\u064a :value \u0627\u0644\u0634\u062e\u0635\u064a\u0627\u062a."},"max":{"array":"\u0627\u0644 :attribute \u0642\u062f \u0644\u0627 \u064a\u0643\u0648\u0646 \u0623\u0643\u062b\u0631 \u0645\u0646 :max \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u0642\u062f \u0644\u0627 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 :max \u0643\u064a\u0644\u0648 \u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u0642\u062f \u0644\u0627 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 :max.","string":"\u0627\u0644 :attribute \u0642\u062f \u0644\u0627 \u064a\u0643\u0648\u0646 \u0623\u0643\u0628\u0631 \u0645\u0646 :max \u0627\u0644\u0634\u062e\u0635\u064a\u0627\u062a."},"mimes":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: :values.","mimetypes":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0645\u0644\u0641\u064b\u0627 \u0645\u0646 \u0627\u0644\u0646\u0648\u0639: :values.","min":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 :min \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u0644\u0627 \u0628\u062f \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 :min \u0643\u064a\u0644\u0648 \u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u0644\u0627 \u0628\u062f \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 :min.","string":"\u0627\u0644 :attribute \u0644\u0627 \u0628\u062f \u0623\u0646 \u064a\u0643\u0648\u0646 \u0639\u0644\u0649 \u0627\u0644\u0623\u0642\u0644 :min \u0627\u0644\u0634\u062e\u0635\u064a\u0627\u062a."},"not_in":"\u0627\u0644 \u0627\u0644\u0645\u062d\u062f\u062f :attribute \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","not_regex":"\u0627\u0644 :attribute \u0627\u0644\u062a\u0646\u0633\u064a\u0642 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","numeric":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0631\u0642\u0645\u0627.","password":"\u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.","present":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0627\u0644\u062d\u0642\u0644 \u0645\u0648\u062c\u0648\u062f\u064b\u0627.","regex":"\u0627\u0644 :attribute \u0627\u0644\u062a\u0646\u0633\u064a\u0642 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","required":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628.","required_if":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627 :other \u064a\u0643\u0648\u0646 :value.","required_unless":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0645\u0627 \u0644\u0645 \u064a\u0643\u0646 :other \u0641\u064a \u062f\u0627\u062e\u0644 :values.","required_with":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627 :values \u062d\u0627\u0636\u0631.","required_with_all":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627 :values \u062d\u0627\u0636\u0631\u0648\u0646.","required_without":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628 \u0639\u0646\u062f\u0645\u0627 :values \u063a\u064a\u0631 \u0645\u0648\u062c\u0648\u062f.","required_without_all":"\u0627\u0644 :attribute \u0627\u0644\u062d\u0642\u0644 \u0645\u0637\u0644\u0648\u0628\u064b\u0627 \u0641\u064a \u062d\u0627\u0644\u0629 \u0639\u062f\u0645 \u0648\u062c\u0648\u062f \u0623\u064a \u0645\u0646 :values \u062d\u0627\u0636\u0631\u0648\u0646.","same":"\u0627\u0644 :attribute \u0648 :other \u064a\u062c\u0628 \u0623\u0646 \u062a\u062a\u0637\u0627\u0628\u0642.","size":{"array":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u062d\u062a\u0648\u064a \u0639\u0644\u0649 :size \u0627\u0644\u0639\u0646\u0627\u0635\u0631.","file":"\u0627\u0644 :attribute \u0644\u0627 \u0628\u062f \u0648\u0623\u0646 :size \u0643\u064a\u0644\u0648 \u0628\u0627\u064a\u062a.","numeric":"\u0627\u0644 :attribute \u0644\u0627 \u0628\u062f \u0648\u0623\u0646 :size.","string":"\u0627\u0644 :attribute \u0644\u0627 \u0628\u062f \u0648\u0623\u0646 :size \u0627\u0644\u0634\u062e\u0635\u064a\u0627\u062a."},"starts_with":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0628\u062f\u0623 \u0628\u0648\u0627\u062d\u062f \u0645\u0645\u0627 \u064a\u0644\u064a: :values.","string":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 \u0633\u0644\u0633\u0644\u0629.","timezone":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u062a\u0643\u0648\u0646 \u0645\u0646\u0637\u0642\u0629 \u0635\u0627\u0644\u062d\u0629.","unique":"\u0627\u0644 :attribute \u0644\u0642\u062f \u0627\u062a\u062e\u0630\u062a \u0628\u0627\u0644\u0641\u0639\u0644.","uploaded":"\u0627\u0644 :attribute \u0641\u0634\u0644 \u0627\u0644\u062a\u062d\u0645\u064a\u0644.","url":"\u0627\u0644 :attribute \u0627\u0644\u062a\u0646\u0633\u064a\u0642 \u063a\u064a\u0631 \u0635\u0627\u0644\u062d.","uuid":"\u0627\u0644 :attribute \u064a\u062c\u0628 \u0623\u0646 \u064a\u0643\u0648\u0646 UUID \u0635\u0627\u0644\u062d\u064b\u0627."},"bg.backup::notifications":{"application_name":"\u0418\u043c\u0435 \u043d\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u0442\u043e","backup_failed_body":"\u0412\u0430\u0436\u043d\u043e: \u0412\u044a\u0437\u043d\u0438\u043a\u043d\u0430 \u0433\u0440\u0435\u0448\u043a\u0430 \u043f\u0440\u0438 \u0430\u0440\u0445\u0438\u0432\u0438\u0440\u0430\u043d\u0435 \u043d\u0430 :application_name","backup_failed_subject":"\u041d\u0435\u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435 \u043d\u0430 :application_name","backup_name":"\u0418\u043c\u0435 \u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435","backup_successful_body":"\u0427\u0443\u0434\u0435\u0441\u043d\u0438 \u043d\u043e\u0432\u0438\u043d\u0438, \u043d\u043e\u0432\u043e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435 \u043d\u0430 :application_name \u0431\u0435\u0448\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u044a\u0437\u0434\u0430\u0434\u0435\u043d\u043e \u043d\u0430 \u0434\u0438\u0441\u043a\u0430 \u0441 \u0438\u043c\u0435 :disk_name.","backup_successful_subject":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043d\u043e\u0432\u043e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435 \u043d\u0430 :application_name","backup_successful_subject_title":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043d\u043e\u0432\u043e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435!","cleanup_failed_body":"\u0412\u044a\u0437\u043d\u0438\u043a\u043d\u0430 \u0433\u0440\u0435\u0448\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u0447\u0438\u0441\u0442\u0432\u0430\u043d\u0435\u0442\u043e \u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u043d\u0430 :application_name","cleanup_failed_subject":"\u041f\u043e\u0447\u0438\u0441\u0442\u0432\u0430\u043d\u0435\u0442\u043e \u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u043d\u0430 :application_name \u043d\u0435 \u0431\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","cleanup_successful_body":"\u041f\u043e\u0447\u0438\u0441\u0442\u0432\u0430\u043d\u0435\u0442\u043e \u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438 \u043a\u043e\u043f\u0438\u044f \u043d\u0430 :application_name \u043d\u0430 \u0434\u0438\u0441\u043a\u0430 \u0441 \u0438\u043c\u0435 :disk_name \u0431\u0435\u0448\u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","cleanup_successful_subject":"\u041f\u043e\u0447\u0438\u0441\u0442\u0432\u0430\u043d\u0435\u0442\u043e \u043d\u0430 \u0430\u0440\u0445\u0438\u0432\u0438\u0442\u0435 \u043d\u0430 :application_name \u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e","cleanup_successful_subject_title":"\u041f\u043e\u0447\u0438\u0441\u0442\u0432\u0430\u043d\u0435\u0442\u043e \u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u0435 \u0443\u0441\u043f\u0435\u0448\u043d\u043e!","disk":"\u0414\u0438\u0441\u043a","exception_message":"\u0421\u044a\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0437\u0430 \u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: :message","exception_message_title":"\u0421\u044a\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0437\u0430 \u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435","exception_trace":"\u041f\u0440\u043e\u0441\u043b\u0435\u0434\u044f\u0432\u0430\u043d\u0435 \u043d\u0430 \u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: :trace","exception_trace_title":"\u041f\u0440\u043e\u0441\u043b\u0435\u0434\u044f\u0432\u0430\u043d\u0435 \u043d\u0430 \u0438\u0437\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435","healthy_backup_found_body":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u0437\u0430 :application_name \u0441\u0435 \u0441\u0447\u0438\u0442\u0430\u0442 \u0437\u0430 \u0437\u0434\u0440\u0430\u0432\u0438. \u0414\u043e\u0431\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u0430!","healthy_backup_found_subject":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u0437\u0430 :application_name \u043d\u0430 \u0434\u0438\u0441\u043a :disk_name \u0441\u0430 \u0437\u0434\u0440\u0430\u0432\u0438","healthy_backup_found_subject_title":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u0437\u0430 :application_name \u0441\u0430 \u0437\u0434\u0440\u0430\u0432\u0438","newest_backup_date":"\u041d\u0430\u0439-\u043d\u043e\u0432\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435","newest_backup_size":"\u041d\u0430\u0439-\u043d\u043e\u0432\u0438\u044f\u0442 \u0440\u0430\u0437\u043c\u0435\u0440 \u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435","no_backups_info":"\u0412\u0441\u0435 \u043e\u0449\u0435 \u043d\u0435 \u0441\u0430 \u043f\u0440\u0430\u0432\u0435\u043d\u0438 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438 \u043a\u043e\u043f\u0438\u044f","number_of_backups":"\u0411\u0440\u043e\u0439 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438 \u043a\u043e\u043f\u0438\u044f","oldest_backup_date":"\u041d\u0430\u0439-\u0441\u0442\u0430\u0440\u0430\u0442\u0430 \u0434\u0430\u0442\u0430 \u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435","total_storage_used":"\u041e\u0431\u0449\u043e \u0438\u0437\u043f\u043e\u043b\u0437\u0432\u0430\u043d\u043e \u0434\u0438\u0441\u043a\u043e\u0432\u043e \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u043e","unhealthy_backup_found_body":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u0437\u0430 :application_name \u043d\u0430 \u0434\u0438\u0441\u043a :disk_name \u043d\u0435 \u0441\u0430 \u0437\u0434\u0440\u0430\u0432\u0438.","unhealthy_backup_found_empty":"\u0418\u0437\u043e\u0431\u0449\u043e \u043d\u044f\u043c\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438 \u043a\u043e\u043f\u0438\u044f \u043d\u0430 \u0442\u043e\u0432\u0430 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.","unhealthy_backup_found_full":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u0438\u0437\u043f\u043e\u043b\u0437\u0432\u0430\u0442 \u0442\u0432\u044a\u0440\u0434\u0435 \u043c\u043d\u043e\u0433\u043e \u043c\u044f\u0441\u0442\u043e \u0437\u0430 \u0441\u044a\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435. \u0422\u0435\u043a\u0443\u0449\u043e\u0442\u043e \u0438\u0437\u043f\u043e\u043b\u0437\u0432\u0430\u043d\u0435 \u0435 :disk_usage, \u043a\u043e\u0435\u0442\u043e \u0435 \u043f\u043e-\u0432\u0438\u0441\u043e\u043a\u043e \u043e\u0442 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043e\u0442\u043e \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 :disk_limit.","unhealthy_backup_found_not_reachable":"\u0414\u0435\u0441\u0442\u0438\u043d\u0430\u0446\u0438\u044f\u0442\u0430 \u0437\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438 \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435 \u0434\u0430 \u0431\u044a\u0434\u0435 \u0434\u043e\u0441\u0442\u0438\u0433\u043d\u0430\u0442\u0430. :\u0433\u0440\u0435\u0448\u043a\u0430","unhealthy_backup_found_old":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u043e\u0442\u043e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e \u043a\u043e\u043f\u0438\u0435, \u043d\u0430\u043f\u0440\u0430\u0432\u0435\u043d\u043e \u043d\u0430 :date, \u0441\u0435 \u0441\u0447\u0438\u0442\u0430 \u0437\u0430 \u0442\u0432\u044a\u0440\u0434\u0435 \u0441\u0442\u0430\u0440\u043e.","unhealthy_backup_found_subject":"\u0412\u0430\u0436\u043d\u043e: \u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u0437\u0430 :application_name \u043d\u0435 \u0441\u0430 \u0437\u0434\u0440\u0430\u0432\u0438","unhealthy_backup_found_subject_title":"\u0412\u0430\u0436\u043d\u043e: \u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0442\u0435 \u043a\u043e\u043f\u0438\u044f \u0437\u0430 :application_name \u043d\u0435 \u0441\u0430 \u0437\u0434\u0440\u0430\u0432\u0438. :\u043f\u0440\u043e\u0431\u043b\u0435\u043c","unhealthy_backup_found_unknown":"\u0417\u0430 \u0441\u044a\u0436\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435 \u0434\u0430 \u0441\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438 \u0442\u043e\u0447\u043d\u0430 \u043f\u0440\u0438\u0447\u0438\u043d\u0430."},"bg.cookieConsent::texts":{"agree":"\u041f\u0440\u0438\u0435\u043c\u0430\u043c","message":"\u0422\u043e\u0437\u0438 \u0441\u0430\u0439\u0442 \u0438\u0437\u043f\u043e\u043b\u0437\u0432\u0430 \u0431\u0438\u0441\u043a\u0432\u0438\u0442\u043a\u0438, \u0437\u0430 \u0434\u0430 \u043f\u043e\u0434\u043e\u0431\u0440\u0438 \u0432\u0430\u0448\u0435\u0442\u043e \u043f\u043e\u0442\u0440\u0435\u0431\u0438\u0442\u0435\u043b\u0441\u043a\u043e \u0438\u0437\u0436\u0438\u0432\u044f\u0432\u0430\u043d\u0435."},"bn.backup::notifications":{"application_name":"\u0986\u09ac\u09c7\u09a6\u09a8\u09c7\u09b0 \u09a8\u09be\u09ae","backup_failed_body":"\u0997\u09c1\u09b0\u09c1\u09a4\u09cd\u09ac\u09aa\u09c2\u09b0\u09cd\u09a3\u0983 :application_name \u09ac\u09cd\u09af\u09be\u0995 \u0986\u09aa \u0995\u09b0\u09be\u09b0 \u09b8\u09ae\u09af\u09bc \u098f\u0995\u099f\u09bf \u09a4\u09cd\u09b0\u09c1\u099f\u09bf \u0998\u099f\u09c7\u099b\u09c7\u0964","backup_failed_subject":":application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa \u09ac\u09cd\u09af\u09b0\u09cd\u09a5 \u09b9\u09df\u09c7\u099b\u09c7\u0964","backup_name":"\u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u09c7\u09b0 \u09a8\u09be\u09ae","backup_successful_body":"\u0996\u09c1\u09b6\u09bf\u09b0 \u0996\u09ac\u09b0, :application_name \u098f\u09b0 \u09a8\u09a4\u09c1\u09a8 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa :disk_name \u09a1\u09bf\u09b8\u09cd\u0995\u09c7 \u09b8\u09ab\u09b2\u09ad\u09be\u09ac\u09c7 \u09a4\u09c8\u09b0\u09bf \u09b9\u09df\u09c7\u099b\u09c7\u0964","backup_successful_subject":":application_name \u098f\u09b0 \u09a8\u09a4\u09c1\u09a8 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa \u09b8\u09ab\u09b2 \u09b9\u09df\u09c7\u099b\u09c7\u0964","backup_successful_subject_title":"\u09a8\u09a4\u09c1\u09a8 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa \u09b8\u09ab\u09b2 \u09b9\u09df\u09c7\u099b\u09c7!","cleanup_failed_body":":application_name \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u09b8\u09be\u09ab \u0995\u09b0\u09be\u09b0 \u09b8\u09ae\u09df \u098f\u0995\u099f\u09bf \u09a4\u09cd\u09b0\u09c1\u099f\u09bf \u0998\u099f\u09c7\u099b\u09c7\u0964","cleanup_failed_subject":":application_name \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u09b8\u09be\u09ab \u0995\u09b0\u09a4\u09c7 \u09ac\u09cd\u09af\u09b0\u09cd\u09a5 \u09b9\u09df\u09c7\u099b\u09c7\u0964","cleanup_successful_body":":application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf :disk_name \u09a1\u09bf\u09b8\u09cd\u0995 \u09a5\u09c7\u0995\u09c7 \u09b8\u09ab\u09b2\u09ad\u09be\u09ac\u09c7 \u09b8\u09be\u09ab \u0995\u09b0\u09be \u09b9\u09df\u09c7\u099b\u09c7\u0964","cleanup_successful_subject":":application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u09b8\u09ab\u09b2\u09ad\u09be\u09ac\u09c7 \u09b8\u09be\u09ab \u0995\u09b0\u09be \u09b9\u09df\u09c7\u099b\u09c7\u0964","cleanup_successful_subject_title":"\u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u09b8\u09ab\u09b2\u09ad\u09be\u09ac\u09c7 \u09b8\u09be\u09ab \u0995\u09b0\u09be \u09b9\u09df\u09c7\u099b\u09c7!","disk":"\u09a1\u09bf\u09b8\u09cd\u0995","exception_message":"\u098f\u0995\u09cd\u09b8\u09b8\u09c7\u09aa\u09b6\u09a8 \u09ac\u09be\u09b0\u09cd\u09a4\u09be: :message","exception_message_title":"\u098f\u0995\u09cd\u09b8\u09b8\u09c7\u09aa\u09b6\u09a8 message","exception_trace":"\u098f\u0995\u09cd\u09b8\u09b8\u09c7\u09aa\u09b6\u09a8 \u099f\u09cd\u09b0\u09c7\u09b8: :trace","exception_trace_title":"\u098f\u0995\u09cd\u09b8\u09b8\u09c7\u09aa\u09b6\u09a8 \u099f\u09cd\u09b0\u09c7\u09b8","healthy_backup_found_body":":application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf  \u09b8\u09cd\u09ac\u09be\u09b8\u09cd\u09a5\u09cd\u09af\u0995\u09b0 \u09ac\u09bf\u09ac\u09c7\u099a\u09a8\u09be \u0995\u09b0\u09be \u09b9\u099a\u09cd\u099b\u09c7\u0964 Good job!","healthy_backup_found_subject":":application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf :disk_name \u09a1\u09bf\u09b8\u09cd\u0995\u09c7 \u09b8\u09cd\u09ac\u09be\u09b8\u09cd\u09a5\u09cd\u09af\u0995\u09b0 \u0985\u09ac\u09b8\u09cd\u09a5\u09be\u09df \u0986\u099b\u09c7\u0964","healthy_backup_found_subject_title":":application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u09b8\u09cd\u09ac\u09be\u09b8\u09cd\u09a5\u09cd\u09af\u0995\u09b0 \u0985\u09ac\u09b8\u09cd\u09a5\u09be\u09df \u0986\u099b\u09c7\u0964","newest_backup_date":"\u09a8\u09a4\u09c1\u09a8 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u09c7\u09b0 \u09a4\u09be\u09b0\u09bf\u0996","newest_backup_size":"\u09a8\u09a4\u09c1\u09a8 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa \u0986\u0995\u09be\u09b0","no_backups_info":"\u0995\u09cb\u09a8\u09cb \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa \u098f\u0996\u09a8\u0993 \u09a4\u09c8\u09b0\u09bf \u09b9\u09af\u09bc\u09a8\u09bf","number_of_backups":"\u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u09c7\u09b0 \u09b8\u0982\u0996\u09cd\u09af\u09be","oldest_backup_date":"\u09aa\u09c1\u09b0\u09be\u09a8\u09cb \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u09c7\u09b0 \u09a4\u09be\u09b0\u09bf\u0996","total_storage_used":"\u09ac\u09cd\u09af\u09ac\u09b9\u09c3\u09a4 \u09ae\u09cb\u099f \u09b8\u099e\u09cd\u099a\u09af\u09bc\u09b8\u09cd\u09a5\u09be\u09a8","unhealthy_backup_found_body":":disk_name \u09a1\u09bf\u09b8\u09cd\u0995\u09c7\u09b0 :application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u0985\u09b8\u09cd\u09ac\u09be\u09b8\u09cd\u09a5\u09cd\u09af\u0995\u09b0 \u0985\u09ac\u09b8\u09cd\u09a5\u09be\u09df \u0986\u099b\u09c7\u0964","unhealthy_backup_found_empty":"\u098f\u0987 \u0985\u09cd\u09af\u09be\u09aa\u09cd\u09b2\u09bf\u0995\u09c7\u09b6\u09a8\u099f\u09bf\u09b0 \u0995\u09cb\u09a8\u0993 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa \u09a8\u09c7\u0987\u0964","unhealthy_backup_found_full":"\u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u0985\u09a4\u09bf\u09b0\u09bf\u0995\u09cd\u09a4 \u09b8\u09cd\u099f\u09cb\u09b0\u09c7\u099c \u09ac\u09cd\u09af\u09ac\u09b9\u09be\u09b0 \u0995\u09b0\u099b\u09c7\u0964 \u09ac\u09b0\u09cd\u09a4\u09ae\u09be\u09a8 \u09ac\u09cd\u09af\u09ac\u09b9\u09be\u09b0\u09c7\u09b0 \u09aa\u09b0\u09bf\u09ae\u09be\u09a8 :disk_usage \u09af\u09be \u0985\u09a8\u09c1\u09ae\u09cb\u09a6\u09bf\u09a4 \u09b8\u09c0\u09ae\u09be :disk_limit \u098f\u09b0 \u09ac\u09c7\u09b6\u09bf\u0964","unhealthy_backup_found_not_reachable":"\u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa \u0997\u09a8\u09cd\u09a4\u09ac\u09cd\u09af\u09c7 \u09aa\u09cc\u0981\u099b\u09be\u09a8\u09cb \u09af\u09be\u09df \u09a8\u09bf\u0964 :error","unhealthy_backup_found_old":"\u09b8\u09b0\u09cd\u09ac\u09b6\u09c7\u09b7 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa \u09af\u09c7\u099f\u09bf :date \u098f\u0987 \u09a4\u09be\u09b0\u09bf\u0996\u09c7 \u0995\u09b0\u09be \u09b9\u09df\u09c7\u099b\u09c7, \u09b8\u09c7\u099f\u09bf \u0996\u09c1\u09ac \u09aa\u09c1\u09b0\u09be\u09a8\u09cb\u0964","unhealthy_backup_found_subject":"\u0997\u09c1\u09b0\u09c1\u09a4\u09cd\u09ac\u09aa\u09c2\u09b0\u09cd\u09a3\u0983 :application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u0985\u09b8\u09cd\u09ac\u09be\u09b8\u09cd\u09a5\u09cd\u09af\u0995\u09b0 \u0985\u09ac\u09b8\u09cd\u09a5\u09be\u09df \u0986\u099b\u09c7\u0964","unhealthy_backup_found_subject_title":"\u0997\u09c1\u09b0\u09c1\u09a4\u09cd\u09ac\u09aa\u09c2\u09b0\u09cd\u09a3\u0983 :application_name \u098f\u09b0 \u09ac\u09cd\u09af\u09be\u0995\u0986\u09aa\u0997\u09c1\u09b2\u09bf \u0985\u09b8\u09cd\u09ac\u09be\u09b8\u09cd\u09a5\u09cd\u09af\u0995\u09b0 \u0985\u09ac\u09b8\u09cd\u09a5\u09be\u09df \u0986\u099b\u09c7\u0964 :problem","unhealthy_backup_found_unknown":"\u09a6\u09c1\u0983\u0996\u09bf\u09a4, \u09b8\u09a0\u09bf\u0995 \u0995\u09be\u09b0\u09a3 \u09a8\u09bf\u09b0\u09cd\u09a7\u09be\u09b0\u09a3 \u0995\u09b0\u09be \u09b8\u09ae\u09cd\u09ad\u09ac \u09b9\u09df\u09a8\u09bf\u0964"},"cs.backup::notifications":{"application_name":"N\u00e1zev aplikace","backup_failed_body":"D\u016fle\u017eit\u00e9: P\u0159i z\u00e1loze :application_name se vyskytla chyba","backup_failed_subject":"Z\u00e1loha :application_name neusp\u011bla","backup_name":"N\u00e1zev z\u00e1lohy","backup_successful_body":"Dobr\u00e1 zpr\u00e1va, na disku jm\u00e9nem :disk_name byla \u00fasp\u011b\u0161n\u011b vytvo\u0159ena nov\u00e1 z\u00e1loha :application_name.","backup_successful_subject":"\u00dasp\u011b\u0161n\u00e1 nov\u00e1 z\u00e1loha :application_name","backup_successful_subject_title":"\u00dasp\u011b\u0161n\u00e1 nov\u00e1 z\u00e1loha!","cleanup_failed_body":"P\u0159i \u010di\u0161t\u011bn\u00ed z\u00e1loh :application_name se vyskytla chyba","cleanup_failed_subject":"Vy\u010di\u0161t\u011bn\u00ed z\u00e1loh :application_name neusp\u011blo.","cleanup_successful_body":"Vy\u010di\u0161t\u011bn\u00ed z\u00e1loh :application_name na disku jm\u00e9nem :disk_name bylo \u00fasp\u011b\u0161n\u00e9.","cleanup_successful_subject":"Vy\u010di\u0161t\u011bn\u00ed z\u00e1loh :application_name \u00fasp\u011b\u0161n\u00e9","cleanup_successful_subject_title":"Vy\u010di\u0161t\u011bn\u00ed z\u00e1loh bylo \u00fasp\u011b\u0161n\u00e9!","disk":"Disk","exception_message":"Zpr\u00e1va v\u00fdjimky: :message","exception_message_title":"Zpr\u00e1va v\u00fdjimky","exception_trace":"Stopa v\u00fdjimky: :trace","exception_trace_title":"Stopa v\u00fdjimky","healthy_backup_found_body":"Z\u00e1lohy pro :application_name jsou pova\u017eov\u00e1ny za zdrav\u00e9. Dobr\u00e1 pr\u00e1ce!","healthy_backup_found_subject":"Z\u00e1lohy pro :application_name na disku :disk_name jsou zdrav\u00e9","healthy_backup_found_subject_title":"Z\u00e1lohy pro :application_name jsou zdrav\u00e9","newest_backup_date":"Datum nejnov\u011bj\u0161\u00ed z\u00e1lohy","newest_backup_size":"Velikost nejnov\u011bj\u0161\u00ed z\u00e1lohy","no_backups_info":"Zat\u00edm nebyly vytvo\u0159eny \u017e\u00e1dn\u00e9 z\u00e1lohy","number_of_backups":"Po\u010det z\u00e1loh","oldest_backup_date":"Datum nejstar\u0161\u00ed z\u00e1lohy","total_storage_used":"Celkov\u00e1 vyu\u017eit\u00e1 kapacita \u00falo\u017ei\u0161t\u011b","unhealthy_backup_found_body":"Z\u00e1lohy pro :application_name na disku :disk_name jsou nezdrav\u00e9.","unhealthy_backup_found_empty":"Tato aplikace nem\u00e1 v\u016fbec \u017e\u00e1dn\u00e9 z\u00e1lohy.","unhealthy_backup_found_full":"Z\u00e1lohy zab\u00edraj\u00ed p\u0159\u00edli\u0161 mnoho m\u00edsta na disku. Aktu\u00e1ln\u00ed vyu\u017eit\u00ed disku je :disk_usage, co\u017e je vy\u0161\u0161\u00ed ne\u017e povolen\u00fd limit :disk_limit.","unhealthy_backup_found_not_reachable":"Nelze se dostat k c\u00edli z\u00e1lohy. :error","unhealthy_backup_found_old":"Posledn\u00ed z\u00e1loha vytvo\u0159en\u00e1 dne :date je pova\u017eov\u00e1na za p\u0159\u00edli\u0161 starou.","unhealthy_backup_found_subject":"D\u016fle\u017eit\u00e9: Z\u00e1lohy pro :application_name jsou nezdrav\u00e9","unhealthy_backup_found_subject_title":"D\u016fle\u017eit\u00e9: Z\u00e1lohy pro :application_name jsou nezdrav\u00e9. :problem","unhealthy_backup_found_unknown":"Omlouv\u00e1me se, nem\u016f\u017eeme ur\u010dit p\u0159esn\u00fd d\u016fvod."},"cs.cookieConsent::texts":{"agree":"Souhlas\u00edm","message":"Tato str\u00e1nka pou\u017e\u00edv\u00e1 cookies na vylep\u0161en\u00ed va\u0161eho u\u017eivatelsk\u00e9ho z\u00e1\u017eitku."},"da.backup::notifications":{"application_name":"Ans\u00f8gningens navn","backup_failed_body":"Vigtigt: Der skete en fejl under backup af :application_name","backup_failed_subject":"Backup af :application_name fejlede","backup_name":"Backup navn","backup_successful_body":"Gode nyheder - der blev oprettet en ny backup af :application_name p\u00e5 disken :disk_name.","backup_successful_subject":"Ny backup af :application_name oprettet","backup_successful_subject_title":"Ny backup!","cleanup_failed_body":"Der skete en fejl under oprydning af backups for :application_name","cleanup_failed_subject":"Oprydning af backups for :application_name fejlede.","cleanup_successful_body":"Oprydningen af backups for :application_name p\u00e5 disken :disk_name er gennemf\u00f8rt.","cleanup_successful_subject":"Oprydning af backups for :application_name gennemf\u00f8rt","cleanup_successful_subject_title":"Backup oprydning gennemf\u00f8rt!","disk":"Disk","exception_message":"Fejlbesked: :message","exception_message_title":"Fejlbesked","exception_trace":"Fejl trace: :trace","exception_trace_title":"Fejl trace","healthy_backup_found_body":"Alle backups for :application_name er ok. Godt g\u00e5et!","healthy_backup_found_subject":"Alle backups for :application_name p\u00e5 disken :disk_name er OK","healthy_backup_found_subject_title":"Alle backups for :application_name er OK","newest_backup_date":"Nyeste backup-st\u00f8rrelse","newest_backup_size":"Nyeste backup-st\u00f8rrelse","no_backups_info":"Der blev ikke foretaget nogen sikkerhedskopier endnu","number_of_backups":"Antal sikkerhedskopier","oldest_backup_date":"\u00c6ldste backup-st\u00f8rrelse","total_storage_used":"Samlet lagerplads brugt","unhealthy_backup_found_body":"Backups for :application_name p\u00e5 disken :disk_name er fejlbeh\u00e6ftede.","unhealthy_backup_found_empty":"Denne applikation har ingen backups overhovedet.","unhealthy_backup_found_full":"Backups bruger for meget plads. Nuv\u00e6rende disk forbrug er :disk_usage, hvilket er mere end den tilladte gr\u00e6nse p\u00e5 :disk_limit.","unhealthy_backup_found_not_reachable":"Backup destinationen kunne ikke findes. :error","unhealthy_backup_found_old":"Den seneste backup fra :date er for gammel.","unhealthy_backup_found_subject":"Vigtigt: Backups for :application_name fejlbeh\u00e6ftede","unhealthy_backup_found_subject_title":"Vigtigt: Backups for :application_name er fejlbeh\u00e6ftede. :problem","unhealthy_backup_found_unknown":"Beklager, en pr\u00e6cis \u00e5rsag kunne ikke findes."},"da.cookieConsent::texts":{"agree":"Tillad cookies","message":"Din oplevelse p\u00e5 dette websted vil blive forbedret ved at tillade cookies."},"de.auth":{"app":{"create":"Erstellen","export":"Export","lock_account":"Account sperren","member_since":"Mitglied seit","messages":"Mitteilungen","online":"Online","print":"Drucken","profile":"Profil","reload":"Neu laden","reset":"Zur\u00fccksetzen","search":"Suche","settings":"Einstellungen"},"confirm_password":"Best\u00e4tige das Passwort","email":"Email","failed":"Diese Anmeldeinformationen stimmen nicht mit unseren Aufzeichnungen \u00fcberein.","forgot_password":{"send_pwd_reset":"Link zum Zur\u00fccksetzen des Passworts senden","title":"Geben Sie die E-Mail-Adresse ein, um das Passwort zur\u00fcckzusetzen"},"full_name":"Vollst\u00e4ndiger Name","login":{"forgot_password":"Ich habe mein Passwort vergessen","register_membership":"Registrieren Sie eine neue Mitgliedschaft","title":"Melden Sie sich an, um Ihre Sitzung zu starten"},"password":"Passwort","register":"Registrieren","registration":{"have_membership":"Ich habe bereits eine Mitgliedschaft","i_agree":"Ich stimme zu","terms":"die Bedingungen","title":"Registrieren Sie eine neue Mitgliedschaft"},"remember_me":"Mich erinnern","reset_password":{"reset_pwd_btn":"Passwort zur\u00fccksetzen","title":"Setze dein Passwort zur\u00fcck"},"save":"Speichern","sign_in":"Anmelden","sign_out":"Ausloggen","throttle":"Zu viele Anmeldeversuche. Bitte versuchen Sie es in :Sekunden Sekunden erneut."},"de.backup::notifications":{"application_name":"Applikationsname","backup_failed_body":"Wichtig: Beim Backup von :application_name ist ein Fehler aufgetreten","backup_failed_subject":"Backup von :application_name konnte nicht erstellt werden","backup_name":"Backup Name","backup_successful_body":"Gute Nachrichten, ein neues Backup von :application_name wurde erfolgreich erstellt und in :disk_name gepeichert.","backup_successful_subject":"Erfolgreiches neues Backup von :application_name","backup_successful_subject_title":"Erfolgreiches neues Backup!","cleanup_failed_body":"Beim aufr\u00e4umen der Backups von :application_name ist ein Fehler aufgetreten","cleanup_failed_subject":"Aufr\u00e4umen der Backups von :application_name schlug fehl.","cleanup_successful_body":"Aufr\u00e4umen der Backups von :application_name in :disk_name war erfolgreich.","cleanup_successful_subject":"Aufr\u00e4umen der Backups von :application_name backups erfolgreich","cleanup_successful_subject_title":"Aufr\u00e4umen der Backups erfolgreich!","disk":"Speicherort","exception_message":"Fehlermeldung: :message","exception_message_title":"Fehlermeldung","exception_trace":"Fehlerverfolgung: :trace","exception_trace_title":"Fehlerverfolgung","healthy_backup_found_body":"Die Backups von :application_name wurden als gesund eingestuft. Gute Arbeit!","healthy_backup_found_subject":"Die Backups von :application_name in :disk_name sind gesund","healthy_backup_found_subject_title":"Die Backups von :application_name sind Gesund","newest_backup_date":"Neustes Backup","newest_backup_size":"Neuste Backup-Gr\u00f6\u00dfe","no_backups_info":"Bisher keine Backups vorhanden","number_of_backups":"Anzahl Backups","oldest_backup_date":"\u00c4ltestes Backup","total_storage_used":"Gesamter genutzter Speicherplatz","unhealthy_backup_found_body":"Die Backups f\u00fcr :application_name in :disk_name sind ungesund.","unhealthy_backup_found_empty":"Es gibt f\u00fcr die Anwendung noch gar keine Backups.","unhealthy_backup_found_full":"Die Backups verbrauchen zu viel Platz. Aktuell wird :disk_usage belegt, dass ist h\u00f6her als das erlaubte Limit von :disk_limit.","unhealthy_backup_found_not_reachable":"Das Backup Ziel konnte nicht erreicht werden. :error","unhealthy_backup_found_old":"Das letzte Backup am :date ist zu lange her.","unhealthy_backup_found_subject":"Wichtig: Die Backups f\u00fcr :application_name sind nicht gesund","unhealthy_backup_found_subject_title":"Wichtig: Die Backups f\u00fcr :application_name sind ungesund. :problem","unhealthy_backup_found_unknown":"Sorry, ein genauer Grund konnte nicht gefunden werden."},"de.cookieConsent::texts":{"agree":"Akzeptieren","message":"Diese Seite verwendet Cookies um das Nutzererlebnis zu steigern."},"de.crud":{"action":"Handlung","add_new":"Neue hinzuf\u00fcgen","are_you_sure":"Bist du sicher?","back":"Zur\u00fcck","cancel":"Absagen","created_at":"Hergestellt in","deleted_at":"Gel\u00f6scht um","detail":"Detail","edit":"Bearbeiten","id":"Ausweis","save":"Speichern","updated_at":"Aktualisiert am"},"de.messages":{"Gallery":"Galerie","ad_space":{"ad_code":"Anzeigencode","ad_management":"ad-Management","ad_space":"Werbefl\u00e4chen","ad_url":"Anzeigen-URL","categories":"Kategorien","desktop":"Desktop-Ansicht","details_side":"Details Seite","disable_ad":"Anzeige deaktivieren","gallery":"Galerie","header":"Header","index_bottom":"Index unten","index_top":"Index oben","mobile":"Mobile Ansicht","popular_news":"Beliebte Nachrichten","popular_news_index_page":"Beliebte Nachrichten (Indexseite)","post_details":"Beitragsdetails","recommended_post_index_page":"Empfohlener Beitrag (Indexseite)","select_ad_space":"W\u00e4hlen Sie Werbefl\u00e4che aus","trending_post":"Trendiger Beitrag","trending_post_index_page":"Trending Post (Indexseite)"},"add_post":"Beitrag hinzuf\u00fcgen","admin":"Administrator","ai":{"ai_filter":"KI-Filter","best_of":"Das beste von","call_ai":"KI anrufen","frequency_penalty":"Frequenzstrafe","generate_content":"Inhalte generieren","maximum_length":"Maximale L\u00e4nge","model":"Modell","presence_penalty":"Anwesenheitsstrafe","temperature":"Temperatur","top_p":"Oben P"},"album":{"add_album":"Album hinzuf\u00fcgen","album":"Album","edit_album":"Album bearbeiten"},"album_categories":"Albumkategorien","album_category":{"add_album_category":"Albumkategorie hinzuf\u00fcgen","album_category":"Album-Kategorie","edit_album_category":"Albumkategorie bearbeiten","select_album":"Album ausw\u00e4hlen"},"albums":"Alben","all":"Alles","allowed_file_size":"Die beste Aufl\u00f6sung f\u00fcr dieses Profil ist","apps":"Anwendungen","attachment":"Anhang","bulk_post":{"boolean":"booleano","bulk_post":"Massenpost","bulk_post_upload":"Bulk-Post-Upload","categories":"Kategorien","category_ids_list":"Kategorie-ID-Liste","data_type":"Tipo de datos","documentation":"Dokumentation","download_csv_example":"CSV-Beispiel herunterladen","download_csv_template":"CSV-Vorlage herunterladen","example":"Ejemplo","field":"Campo","help_documents":"Hilfedokumente","id":"Ausweis","integer":"Entero","languages":"Sprachen","longText":"texto largo","or":"O","string":"Cadena","sub_categories":"Unterkategorien","test_description_about_this_post":"Descripci\u00f3n de la prueba Acerca de esta publicaci\u00f3n","test_title":"T\u00edtulo de prueba","the_images_must_be_a_file_of_type_article_post":"Las im\u00e1genes deben ser un archivo de tipo: jpg, png ,jpeg","upload_csv_File":"CSV-Datei hochladen","you_can_use_csv_file":"Sie k\u00f6nnen diese Dokumente verwenden, um Ihre CSV-Datei zu generieren"},"cash_payment":"Barzahlung","categories":"Kategorien","category":{"action":"Handlung","add_category":"Kategorie hinzuf\u00fcgen","category_language_warning":"Diese Kategorie wird von Posts verwendet, wenn Sie die Sprache \u00e4ndern, die Sie zum Aktualisieren der Kategorie f\u00fcr die Posts ben\u00f6tigen","color":"Farbe","edit_category":"Kategorie bearbeiten","language":"Sprache","show_home":"Zuhause anzeigen","show_menu":"Im Men\u00fc anzeigen","slug":"Schnecke","title":"Titel"},"cities":"St\u00e4dte","comment":{"approval_pending":"Best\u00e4tigung ausstehend","approved":"Genehmigt anzeigen","auto-approved":"Automatisch genehmigt","comment":"Kommentar","comments":"Bemerkungen","email":"Email","enter_phone_number":"Telefonnummer eingeben","enter_your_email":"Geben sie ihre E-Mail Adresse ein","enter_your_name":"Gib deinen Namen ein","pending":"Ausstehend anzeigen","post_a_comment":"Einen Kommentar posten","type_your_comments":"Geben Sie Ihre Kommentare ein","your_name":"Ihren Namen"},"comments":"Bemerkungen","common":{"action":"Handlung","active":"Aktiv","add":"Hinzuf\u00fcgen","allow_cookies":"Cookies zulassen","allowed_types":"Erlaubte Dateitypen: png, jpg, jpeg.","already_have_an_account":"Sie haben bereits ein Konto?","apply":"Sich bewerben","approval_status":"Freigabestand","approved":"Genehmigt","apr":"R","april":"April","aug":"ag","august":"August","back":"Zur\u00fcck","by":"Durch","cancel":"Absagen","cancel_delete":"Nein, stornieren","cancel_image":"Bild abbrechen","cancel_profile":"Profil k\u00fcndigen","change_cover_image":"Titelbild \u00e4ndern","change_favicon":"Favicon \u00e4ndern","change_image":"Bild \u00e4ndern","change_logo":"Logo \u00e4ndern","change_profile":"Profil \u00e4ndern","city":"Stadt","closed":"Abgeschlossen","contact":"Kontakt","contact_us":"Kontaktiere uns","count":"Z\u00e4hlen","country":"Land","create_an_account":"Ein Konto erstellen","created_at":"Hergestellt in","created_by":"Erstellt von","custom":"Brauch","dec":"Deck","december":"Dezember","declined":"Zur\u00fcckgegangen","delete":"ja, l\u00f6schen","delete_message":" Wurde gel\u00f6scht","delete_warning":"M\u00f6chten Sie dies wirklich l\u00f6schen ","deleted":"Gel\u00f6scht!","details":"Einzelheiten","discard":"Verwerfen","edit":"Bearbeiten","feb":"feb","february":"Februar","front_language":"Standard-Frontsprache","get_the_best":"Holen Sie sich die besten Blog-Geschichten in Ihren Posteingang!","image_error":"Das Bild muss folgende Dateitypen haben: png, jpg, jpeg, webp, svg.","image_error_excel":"Das Bild muss folgende Dateitypen haben:  png, jpg, jpeg, pdf,excel ","image_warning":" ist ung\u00fcltig! Erlaubte Dateitypen: png, jpg, jpeg.","jan":"John","january":"Januar","jul":"Juli","july":"Juli","jun":"Juni","june":"Juni","language":"Sprache","leave_a_message":"Hinterlasse eine Nachricht","login":"Anmeldung","mar":"Besch\u00e4digen","march":"M\u00e4rz","max":"Das :attribute darf nicht gr\u00f6\u00dfer sein als :max.","may":"kann","name":"Name","new_here":"Neu hier","no_data_available":"Keine Elemente gefunden. Versuchen Sie, Ihre Suche zu erweitern.","note":"Notiz","nov":"Nove","november":"November","oct":"Okt","october":"Oktober","of":"Von","off":"Aus","on":"An","pending":"Ausstehend","please_wait":"Warten Sie mal...","read":"Lesen","register":"Registrieren","rejected":"Abgelehnt","remove_image":"Entferne Bild","required":"Das Feld :attribute ist erforderlich.","result":"Ergebnis","save":"Speichern","select_an_option":"W\u00e4hle eine Option","select_category":"Kategorie w\u00e4hlen","select_language":"Sprache ausw\u00e4hlen","select_subcategory":"Unterkategorie ausw\u00e4hlen","send_email":"E-Mail senden","sep":"Sep","september":"September","service":"Dienstleistungen","show_contact":"Kontaktdaten anzeigen","showing":"Anzeigen","sign_in_here":"Hier anmelden","slug":"Schnecke","state":"Bundesland","submit":"Einreichen","subscribe":"Abonnieren","success_msg":"Nachricht wurde erfolgreich gesendet.","time":"Zeit","title":"Titel","to":"Zu","update":"Aktualisieren","view":"Sicht","your_email":"Deine E-Mail"},"contacts":"Kontakte","countries":"L\u00e4nder","dashboard":"Armaturenbrett","dashboard_show":{"drafts":"Entw\u00fcrfe","email":"Email","latest_user":"Letzter Benutzer","name":"NAME","post_views":"Post-Aufrufe","posts":"Beitr\u00e4ge","profile":"Profil","recent_user":"Letzter Benutzer"},"days":{"last_month":"Im vergangenen Monat","last_week":"Letzte Woche","this_month":"Diesen Monat","this_week":"In dieser Woche","today":"Heute"},"delete":"L\u00f6schen","details":{"admin_panel":"Administrationsmen\u00fc","article":"Artikel","breaking":"Brechen","category":"Kategorie","contact_us":"Kontaktiere uns","featured_post":"Ausgew\u00e4hlter Beitrag","gallery":"Galerie","home":"Heim","hot_categories":"Hei\u00dfe Kategorien","language":"Sprache","latest_news":"Neuesten Nachrichten","logout":"Ausloggen","next_post":"N\u00e4chster Beitrag","popular_news":"Beliebte Nachrichten","popular_tag":"Beliebtes Etikett","popular_tags":"beliebte Schlagw\u00f6rter","previous_post":"Vorherigen Post","read_more":"Weiterlesen","recommended_post":"Empfohlener Beitrag","related_post":"Verwandter Beitrag","sort":"Sortieren","top_stories":"Top-Geschichten","trending_post":"Trendiger Beitrag","view_more":"Mehr sehen","view_options":"Optionen anzeigen","view_results":"Ergebnisse anzeigen","views":"Sicht","vote":"Abstimmung","whats_new":"Was gibt's Neues"},"edit_subscription":"Abonnement bearbeiten","email_password_reset_link":"Link zum Zur\u00fccksetzen des Passworts per E-Mail","emails":{"Phone":"Telefon","email":"Email","enquiry_details":"Here is a Enquiry Detail","message":"Message","name":"Name","required":"Das E-Mail-Feld ist erforderlich"},"emoji":{"emoji":"Emoticons","emojis":"Emoticons"},"enquiry":"Anfrage","forgot_password":"Passwort vergessen","forgot_your_password":"Haben Sie Ihr Passwort vergessen","forgot_your_password_no_problem_just_let_us_know_your_email_address":"Haben Sie Ihr Passwort vergessen? Kein Problem. Teilen Sie uns einfach Ihre E-Mail-Adresse mit und wir senden Ihnen per E-Mail einen Link zum Zur\u00fccksetzen des Passworts, mit dem Sie ein neues ausw\u00e4hlen k\u00f6nnen","gallery":{"add_images":"F\u00fcge Bilder hinzu","album":"Alben","category":"Kategorie","date":"Datum","edit_images":"Bilder bearbeiten","id":"Ausweis","image":"Bild","language":"Sprache","select_album":"Album ausw\u00e4hlen","title":"Titel"},"home":"Heim","images":"Bilder","language":{"edit_language":"Sprache bearbeiten","edit_translation":"Edit Translation","front_language":"Frontsprachenstatus","is_active":"Ist Aktiv","is_default":"Ist Standard","is_rtl":"Ist RTL","iso_code":"ISO Code","language":"Sprache","native":"Einheimisch","new_language":"Neue Sprache","no_language_available":"Keine Sprache verf\u00fcgbar","no_language_found":"Keine Sprache gefunden","translation":"\u00dcbersetzung"},"languages":"Sprachen","mail":"Post","mails":{"action_required":"Wenn Sie kein Konto erstellt haben, sind keine weiteren Ma\u00dfnahmen erforderlich.","contact_messages":"Kontaktnachrichten","email_address":"E-Mail-Addresse","email_verification":"E-Mail-Verifizierung","encryption":"Verschl\u00fcsselung","hello":"Hallo","mail":"Post","mail_host":"Mail-Host","mail_library":"Mail-Bibliothek","mail_password":"E-Mail-Passwort","mail_port":"Mail-Port","mail_protocol":"Mail-Protokoll","mail_title":"E-Mail-Titel","mail_user_name":"E-Mail-Benutzername","manual_payment_request":"Manuelle Zahlungsanforderung","manual_payment_status":"Manueller Zahlungsstatus","please_click":"Bitte klicken Sie auf die Schaltfl\u00e4che unten, um Ihre E-Mail-Adresse zu best\u00e4tigen.","regard":"Betrachten","reply_to":"Antwort an","select_encryption":"W\u00e4hlen Sie Verschl\u00fcsselung","select_mail_library":"W\u00e4hlen Sie Mail-Bibliothek aus","select_mail_protocol":"W\u00e4hlen Sie E-Mail-Protokoll aus","send_contact-messages_to_email_address":"Kontaktnachrichten an E-Mail-Adresse senden","send_test_email":"Test-E-Mail senden","test_mail":"Test Email","verify_email":"Email Adresse best\u00e4tigen"},"menu":{"add_menu":"Men\u00fc hinzuf\u00fcgen","edit_menu":"Men\u00fc bearbeiten","link":"Verkn\u00fcpfung","menu":"Speisekarte","menu_order":"Men\u00fcbestellung","parent_menu":"Elternmen\u00fc","select_parent_menu":"W\u00e4hlen Sie Elternmen\u00fc","show_in_menu":"Im Men\u00fc anzeigen","title":"Titel"},"menus":"Men\u00fcs","months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Juli","jun":"Jun","mar":"Besch\u00e4digen","may":"Kann","nov":"Nov","oct":"Okt","sep":"Sep"},"navigation":"Navigation","navigations":{"menu":"Speisekarte"},"news_letters":"News Letter","no_album_found":"Kein Album verf\u00fcgbar","no_matching_records_found":"Keine \u00fcbereinstimmenden Aufzeichnungen gefunden,","no_results_found":"keine Ergebnisse gefunden","notes":"Anmerkungen","ok":"ok","on_rss_feed":"RSS-Feed-Beitrag insgesamt","page":{"add_lang":"Sprache ausw\u00e4hlen","add_page":"Seite hinzuf\u00fcgen","add_parent_link":"W\u00e4hlen Sie den Link zum \u00fcbergeordneten Men\u00fc","dont_add_menu":"Men\u00fc nicht hinzuf\u00fcgen","edit_page":"Seite bearbeiten","footer":"Fusszeile","hide":"Ausblenden","language":"Sprache","location":"Standort","main_menu":"Hauptmen\u00fc","meta_description":"Meta-Beschreibung","meta_title":"Meta-Titel","name":"Men\u00fc auf Seite anzeigen","no":"Nein","page":"Buchseite","parent_menu":"Link zum Elternmen\u00fc","show":"Zeigen","show_breadcrumb":"Breadcrumb anzeigen","show_name":"Name","show_right":"Recht zeigen","show_title":"Titel anzeigen","slug":"Schnecke","title":"Titel","user_show":"Nur f\u00fcr registrierte Benutzer anzeigen","visibility":"Sichtweite","yes":"Ja"},"pages":"Seiten","payment_method":"Bezahlverfahren","phone":"Telefon","placeholder":{"User_profile_updated_successfully":"Benutzerprofil erfolgreich aktualisiert","You_active_more_than_emoji":"Sie k\u00f6nnen nicht mehr als 7 Emojis aktivieren","You_already_voted":"Du hast bereits abgestimmt !!","You_can_use_any_one_of_upload_video_or_video_URL_option":"Sie k\u00f6nnen eine beliebige Option zum Hochladen von Videos oder Video-URLs verwenden","You_disable_less_than_emoji":"Sie k\u00f6nnen nicht weniger als 4 Emojis deaktivieren","adSpaces_updated_successfully":"AdSpaces erfolgreich aktualisiert","album_category_created_successfully":"Albumkategorie erfolgreich erstellt","album_category_deleted_successfully":"Albumkategorie erfolgreich gel\u00f6scht","album_category_retrieved_successfully":"Albumkategorie erfolgreich abgerufen","album_category_updated_successfully":"Albumkategorie erfolgreich aktualisiert","album_created_successfully":"Album erfolgreich erstellt","album_deleted_successfully":"Album erfolgreich gel\u00f6scht","album_retrieve_successfully":"Album erfolgreich abgerufen","album_updated_successfully":"Album erfolgreich aktualisiert","albums_retrieved_successfully":"Alben erfolgreich abgerufen","already_image_exist":"Bild bereits vorhanden","best_resolution_for_this_favicon_will_be_32X32":"Die beste Aufl\u00f6sung f\u00fcr dieses Favicon ist 32X32","best_resolution_for_this_logo_will_be_90x60":"Die beste Aufl\u00f6sung f\u00fcr dieses Logo ist 90x60.","bulk_post_created_successfully":"Bulk Post erfolgreich erstellt.","category_created_successfully":"Kategorie erfolgreich erstellt","category_deleted_successfully":"Kategorie erfolgreich gel\u00f6scht","category_retrieve_successfully":"Kategorie erfolgreich abrufen","category_retrieved_successfully":"Kategorie erfolgreich abgerufen.","category_updated_successfully":"Kategorie erfolgreich aktualisiert","chart_updated_successfully":"Diagramm erfolgreich aktualisiert","clicking_on_submit_it_will_publish_your_post":"Note: Clicking on submit it will publish your post.","comment_create_successfully":"Kommentar erfolgreich erstellt","comment_deleted_successfully":"Kommentar erfolgreich gel\u00f6scht","comment_setting_updated_successfully":"Kommentareinstellung erfolgreich aktualisiert","contact_deleted_successfully":"Kontakt erfolgreich gel\u00f6scht","contact_number_field_is_required":"Kontaktnummerfeld ist erforderlich","content_generated_successfully":"Inhalt erfolgreich generiert.","controls_diversity_via_nucleus_sampling":"Controls diversity via nucleus sampling: 0.5 means half of all likelihood-\n         weighted options are considered.","controls_randomness_lowering_results_in_less_random_completions":"Controls randomness: Lowering results in less random completions. As the temperature approaches zero, the model will become deterministic and repetitive.","created_request_for_payment_of":"erstellte Zahlungsaufforderung von","current_password_in_invalid":"Aktuelles Passwort ist ung\u00fcltig.","data_retried":"Daten erneut versucht","default_language_deleted":"Die Standardsprache kann nicht gel\u00f6scht werden","default_plan":"This plan is Default","default_plan_changed_successfully":"Standardplan erfolgreich ge\u00e4ndert","default_role_do_not_deleted":"Standardrolle nicht gel\u00f6scht.","desktop_view_image_dimensions_must_be_800X130":"Bildabmessungen f\u00fcr die Desktop-Ansicht m\u00fcssen 800 x 130 betragen","email_send_successfully":"E-Mail erfolgreich gesendet.","email_setting_updated_successfully":"E-Mail-Einstellung erfolgreich aktualisiert","emoji_created_successfully.":"Emoji erfolgreich erstellt","emoji_deleted_successfully.":"Emoji erfolgreich gel\u00f6scht","emoji_status_updated_successfully":"Emoji-Status erfolgreich aktualisiert","feed_updated_successfully":"Feed erfolgreich aktualisiert.","file_not_found":"Datei nicht gefunden","gallery_image_created_successfully":"Galeriebild erfolgreich erstellt","gallery_image_deleted_successfully.":"Galeriebild erfolgreich gel\u00f6scht","gallery_image_updated_successfully":"Galeriebild erfolgreich aktualisiert","gallery_title_must_not_be_greater_than_190_characters":"Galerietitel darf nicht l\u00e4nger als 190 Zeichen sein","generates_multiple_completions_server_side":"Generates multiple completions server- side, and displays only the best. Streaming only works when set to 1. Since it acts as a multiplier on the number of completions, this parameters can eat into your token quota very quickly - use caution!","given_post_is_not_yet_published":"Angegebener Beitrag ist noch nicht ver\u00f6ffentlicht","image_delete_successfully":"Bild erfolgreich gel\u00f6scht","image_upload_successfully":"Bild erfolgreich hochgeladen","img_retrieved":"img abgerufen","keyword_should_be_of_maximum_10_words_only":"Keyword sollte nur aus maximal 10 W\u00f6rtern bestehen","language_added_to_front_successfully":"Sprache erfolgreich zur Vorderseite hinzugef\u00fcgt","language_be_deleted":"Sprache kann nicht gel\u00f6scht werden","language_change_successfully":"Sprachumstellung erfolgreich","language_changed_successfully":"Sprache erfolgreich ge\u00e4ndert","language_deleted_successfully":"Sprache erfolgreich gel\u00f6scht","language_not_found":"Sprache nicht gefunden","language_removed_from_front_successfully":"Sprache erfolgreich von vorne entfernt","language_retrieved_successfully":"Sprache erfolgreich abgerufen","language_saved_successfully":"Sprache erfolgreich gespeichert","language_saved_successfully.":"Sprache erfolgreich gespeichert","language_updated_successfully":"Sprache erfolgreich aktualisiert","login_via_facebook":"Login Via Facebook","login_via_google":"Login Via Google","mail_updated_successfully":"Die Mail war erfolgreich","menu_created_successfully":"Men\u00fc erfolgreich erstellt","menu_deleted_successfully":"Men\u00fc erfolgreich gel\u00f6scht","menu_update_successfully":"Men\u00fc-Update erfolgreich","mobile_view_image_dimensions_must_be_350X290":"Bildabmessungen f\u00fcr mobile Ansicht m\u00fcssen 350 x 290 sein","name_field_is_required":"Namensfeld ist erforderlich","navigation_updated_successfully":"Navigation erfolgreich aktualisiert","page_created_successfully":"Seite erfolgreich erstellt","page_deleted_successfully":"Seite erfolgreich gel\u00f6scht.","page_updated_successfully":"P\u00e1gina actualizada correctamente","password_updated_successfully":"Passwort erfolgreich aktualisiert","payment_received":"Payment Received successfully.","plan_already_used":"Plan already used","plan_created_successfully":"Plan erfolgreich erstellt","plan_deleted_successfully.":"Plan erfolgreich gel\u00f6scht","plan_updated_successfully":"Plan erfolgreich aktualisiert","please_enter_CSV_files":"Bitte CSV-Dateien eingeben","please_enter_video_URL":"Bitte Video-URL eingeben","please_enter_video_url_or_upload_a_video":"Bitte geben Sie die Video-URL ein oder laden Sie ein Video hoch","please_enter_video_url_or_upload_video":"Bitte Video-URL eingeben oder Video hochladen","please_select_any_one_permission":"Bitte w\u00e4hlen Sie eine Berechtigung aus","please_select_audio_file":"Bitte Audiodatei ausw\u00e4hlen","please_upgrade_plan":"Bitte aktualisieren Sie den Plan","poll_created_successfully":"Umfrage erfolgreich erstellt.","poll_deleted_successfully":"Umfrage erfolgreich gel\u00f6scht.","poll_updated_successfully":"Umfrage erfolgreich aktualisiert.","poll_voted_successfully":"Umfrage erfolgreich abgeschlossen","post_added_on_headline_successfully":"Beitrag erfolgreich zur \u00dcberschrift hinzugef\u00fcgt","post_added_to_breaking_successfully":"Beitrag erfolgreich zur Unterbrechung hinzugef\u00fcgt","post_added_to_featured_successfully":"Beitrag erfolgreich zu Featured hinzugef\u00fcgt","post_added_to_recommended_successfully":"Beitrag erfolgreich zu empfohlen hinzugef\u00fcgt","post_added_to_slider_successfully":"Beitrag erfolgreich zum Slider hinzugef\u00fcgt","post_added_to_visibility_successfully":"Beitrag erfolgreich zur Sichtbarkeit hinzugef\u00fcgt","post_created_successfully":"Beitrag erfolgreich erstellt","post_deleted_successfully":"Beitrag erfolgreich gel\u00f6scht.","post_removed_from_breaking_successfully":"Beitrag erfolgreich aus Unterbrechung entfernt","post_removed_from_featured_successfully":"Beitrag erfolgreich aus Featured entfernt","post_removed_from_headline_successfully":"Beitrag erfolgreich aus \u00dcberschrift entfernt","post_removed_from_recommended_successfully":"Beitrag erfolgreich aus empfohlen entfernt","post_removed_from_slider_successfully":"Beitrag erfolgreich vom Slider entfernt","post_removed_from_visibility_successfully":"Beitrag erfolgreich aus der Sichtbarkeit entfernt","post_updated_successfully":"Beitrag erfolgreich aktualisiert.","reCAPTCHA_required":"reCAPTCHA erforderlich!","registered_success":"You have registered successfully, Activate your account from mail.","role_already_exists":"Rolle existiert bereits.","role_created_successfully":"Rolle erfolgreich erstellt","role_deleted_successfully":"Rolle erfolgreich gel\u00f6scht.","role_updated_successfully":"Rolle erfolgreich aktualisiert.","rss_feed_create_successfully":"RSS-Feed erfolgreich erstellt","rss_feed_deleted_successfully":"RSS-Feed erfolgreich gel\u00f6scht","rss_feed_update_successfully":"RSS-Feed-Aktualisierung erfolgreich.","seo_tools_updated_successfully":"SEO-Tools erfolgreich aktualisiert.","session_created_successfully":"Sitzung erfolgreich erstellt","settings_updated_successfully":"Einstellungen erfolgreich aktualisiert","show_in_home_updated_successfully":"Zuhause anzeigen erfolgreich aktualisiert","show_in_menu_updated_successfully":"Im Men\u00fc anzeigen erfolgreich aktualisiert","something_wrong_occurred_please_try_again":"Es ist ein Fehler aufgetreten, bitte versuchen Sie es erneut","sort_list_title_must_not_be_greater_than_190_characters":"Titel der Sortierliste darf nicht l\u00e4nger als 190 Zeichen sein","staff_created_successfully":"Personal erfolgreich erstellt.","staff_deleted_successfully":"Mitarbeiter erfolgreich gel\u00f6scht.","staff_updated_successfully":"Mitarbeiter erfolgreich aktualisiert.","status_updated_successfully":"Status erfolgreich aktualisiert.","sub_categories_saved_successfully":"Unterkategorien erfolgreich gespeichert.","sub_category_delete_successfully":"Unterkategorie erfolgreich gel\u00f6scht","sub_category_retrieved_successfully":"Unterkategorie erfolgreich abgerufen.","sub_category_updated_successfully":"Unterkategorie erfolgreich aktualisiert","subscribed_plan_wait":"You subscribed this plan successfully but wait for confirmation from Admin","subscribed_successfully":"Erfolgreich abonniert","subscriber_delete_successfully":"Abonnent erfolgreich gel\u00f6scht","subscription_date_successfully_updated":"Abonnementdatum erfolgreich aktualisiert.","subscription_successfully_retrieved":"Abonnement erfolgreich abgerufen","successfully_verified":"You have successfully verified your mail, please login.","test_mail_send_successfully":"Testmail senden Sussssssful","the_audios_must_be_a_file_of_type":"Die Audios m\u00fcssen folgende Dateitypen haben: mp3, M4A, wav, aac, wma.","the_images_must_be_a_file_of_type":"Die Bilder m\u00fcssen folgende Dateitypen haben: jpeg, png, jpg, webp,svg.","the_iso_code_field_is_required":"Das Feld ISO-Code ist erforderlich","the_maximum_number_of_tokens_to_generate_requests_can_use_up":"The maximum number of tokens to generate. Requests can use up to 2,048 or 4,000 tokens shared between prompt and completion. The exact limit varies by model. (One token is roughly 4 characters for normal English text)","the_upload_csv_file_field_is_required":"Das Feld CSV-Datei hochladen ist erforderlich.","the_upload_video_must_not_be_greater_than_150_MB":"Das hochgeladene Video darf nicht gr\u00f6\u00dfer als 150 MB sein.","theme_changed_successfully":"Design erfolgreich ge\u00e4ndert","this_album_category_is_in_use":"Diese Albumkategorie wird verwendet","this_album_is_in_use":"Dieses Album wird verwendet","this_category_is_in_use":"Diese Kategorie wird verwendet","this_currency_is_not_supported":"This Currency is not supported","this_email_is_already_subscribed":"Diese E-Mail ist bereits abonniert","this_sub_category_is_in_use":"Diese Unterkategorie wird verwendet","thumbnail_image_is_required":"Miniaturbild ist erforderlich","unable_to_process_payment":"Unable to process the payment at the moment. Try again later.","visibility_updated_successfully":"Sichtbarkeit erfolgreich aktualisiert","you_can_use_any_one_of_upload_video_or_video_URL_option":"Sie k\u00f6nnen eine beliebige Option zum Hochladen von Videos oder Video-URLs verwenden","you_delete_than_emoji":"Sie k\u00f6nnen nicht mehr als 4 Emoji l\u00f6schen","your_account_is_currently_disabled_please_contact_to_administrator":"Ihr Konto ist derzeit deaktiviert, bitte wenden Sie sich an den Administrator.","your_mail_already_verified":"Your mail is already verified, please login.","your_manual_payment_request_is":"Ihre manuelle Zahlungsanforderung ist","your_plan_is_expired_Please_choose_a_plan_to_continue_the_services":"Ihr Plan ist abgelaufen. Bitte w\u00e4hlen Sie einen Plan, um die Dienste fortzusetzen"},"plans":{"add_plan":"Tarif hinzuf\u00fcgen","allowed_post":"Erlaubtes Posten","currency":"W\u00e4hrung","default_Plan":"Standardplan","edit_plan":"Plan bearbeiten","enter_trial":"Testversion eingeben","frequency":"Frequenz","monthly":"Monatlich","new_plan":"Neuer Plan","no_of_posts":"Anzahl Beitr\u00e4ge","plan":"Planen","plan_name":"Planname","plans":"Pl\u00e4ne","price":"Preis","select_currency":"W\u00e4hrung w\u00e4hlen","trial_days":"Schnuppertage","unlimited":"Unbegrenzt","yearly":"J\u00e4hrlich"},"poll":{"add_poll":"Umfrage hinzuf\u00fcgen","add_polls":"Umfragen hinzuf\u00fcgen","all_user":"Alle Benutzer","edit_poll":"Umfrage bearbeiten","no_result_found":"Keine Eintr\u00e4ge gefunden","option1":"Option 1","option10":"M\u00f6glichkeit 10","option2":"Option 2","option3":"M\u00f6glichkeit 3","option4":"M\u00f6glichkeit 4","option5":"M\u00f6glichkeit 5","option6":"M\u00f6glichkeit 6","option7":"M\u00f6glichkeit 7","option8":"M\u00f6glichkeit 8","option9":"M\u00f6glichkeit 9","poll":"Umfrage","poll_result":"Umfrageergebnis","question":"Frage","register_user":"Benutzer registrieren","show_result":"Zeige Ergebnis","total_vote":"Gesamtabstimmung","view_option":"Ansichtsoption","voting_poll":"Wahlumfrage"},"polls":"Umfragen","post":{"add_ai":"Schreiben Sie den Beitrag mit OpenAI","add_article":"Artikel hinzuf\u00fcgen","add_audio":"Audio hinzuf\u00fcgen","add_gallery":"Galerie hinzuf\u00fcgen","add_image":"Bild hinzuf\u00fcgen","add_new_item":"Neues Element hinzuf\u00fcgen","add_on_headline":"\u00dcberschrift hinzuf\u00fcgen","add_personality_quiz":"Pers\u00f6nlichkeitsquiz hinzuf\u00fcgen","add_post":"Beitrag hinzuf\u00fcgen","add_sort_list":"Sortierliste hinzuf\u00fcgen","add_to_breaking":"Zu Brechen hinzuf\u00fcgen","add_to_featured":"Zu Vorgestellt hinzuf\u00fcgen","add_to_recommended":"Zu Empfohlen hinzuf\u00fcgen","add_to_slider":"Zum Slider hinzuf\u00fcgen","add_trivia_quiz":"Trivia-Quiz hinzuf\u00fcgen","add_video":"Video hinzuf\u00fcgen","additional":"Zus\u00e4tzliche Bilder","allowed_images_jpg_png_jpeg":"(JPG,PNG,JPEG,SVG,WEBP)","article":"Artikel","article_with_images":"Ein Artikel mit Bildern und eingebetteten Videos","article_with_open_ai":"Escriba su contenido usando OpenAI","audio":"Audio","category":"Kategorie","choose_post_format":"W\u00e4hlen Sie ein Beitragsformat","collection_of_images":"Sammlung von Bildern","d&t":"W\u00e4hlen Sie Datum und Uhrzeit aus","description":"Beschreibung","draft":"Als Entwurf speichern","edit_AI":"Beitrag bearbeiten","edit_Article":"Artikel bearbeiten","edit_Audio":"Audio bearbeiten","edit_Gallery":"Galerie bearbeiten","edit_Sorted":"Sortierliste bearbeiten","edit_Video":"Video bearbeiten","edit_post":"Beitrag bearbeiten","featured":"Hervorgehoben","file":"Datei","gallery":"Galerie","gallery_post_item":"Galerie-Listenelement","get_video":"Video von URL abrufen","image":"Bild","image_description":"Bildbeschreibung","keywords":"Schl\u00fcsselw\u00f6rter","list_based_article":"Ein listenbasierter Artikel","open_ai":"Offene AI","optional_url":"Optionale URL","or_add_url":"oder Bild-URL hinzuf\u00fcgen","personality_quiz":"Pers\u00f6nlichkeits-Quiz","post":"Beitr\u00e4ge","post_type":"Post-Typ","posts":"Beitr\u00e4ge","publish":"Ver\u00f6ffentlichen","publish_post":"Beitrag ver\u00f6ffentlichen","quizzes_with_custom_results":"Quiz mit benutzerdefinierten Ergebnissen","quizzes_with_right_and_wrong_answers":"Quiz mit richtigen und falschen Antworten","remove_on_headline":"Auf \u00dcberschrift entfernen","remove_to_breaking":"Zum Zerbrechen entfernen","remove_to_featured":"Zu \"Vorgestellt\" entfernen","remove_to_recommended":"Auf \u201eEmpfohlen\u201c entfernen","remove_to_slider":"Zum Slider entfernen","scheduled_post":"Geplanter Beitrag","select_image":"Bild ausw\u00e4hlen","select_post_type":"W\u00e4hlen Sie den Beitragstyp aus","selected_file":"Ausgew\u00e4hlte Dateien","short_description":"kurze Beschreibung","show_on_headline":"Auf \u00dcberschrift","show_registered_user":"Nur f\u00fcr registrierte Benutzer anzeigen","show_right":"Rechte Spalte anzeigen","sort_list":"Sortierte Liste","sort_list_item":"Sortiertes Listenelement","spotted_video":"(Youtube, Vimeo, Dailymotion)","sub_category":"Unterkategorie","submit":"Einreichen","tag":"Schild","thumbnail_image":"Bitte geben Sie eine g\u00fcltige URL ein","trivia_quiz":"Trivia-Quiz","upload_audios_and_create_playlist":"Laden Sie Audios hoch und erstellen Sie eine Wiedergabeliste","upload_or_embed_videos":"Videos hochladen oder einbetten","upload_video":"Video hochladen","video":"Video","video_embed_code":"Video-Einbettungscode","video_thumbnail":"Video-Miniaturansicht","video_url":"Video-URL","visibility":"Sichtweite"},"post_reaction":"Nachreaktion","reaction":{"angry":"Ver\u00e4rgert","dislike":"Nicht gefallen","funny":"Lustig","like":"M\u00f6gen","love":"Liebe","pray":"Beten","sad":"Traurig","super":"Super","wow":"Wow"},"recent_posts":"k\u00fcrzliche Posts","required":"Erforderlich","role":{"add_role":"Rolle hinzuf\u00fcgen","edit_role":"Rolle bearbeiten","permissions":"Berechtigungen","role":"Rolle","role_permissions":"Rollenberechtigungen","select_all_permissions":"W\u00e4hlen Sie Alle Berechtigungen aus"},"roles":"Rollen","roles_permissions":"Rollenberechtigung","rss-feed":"RSS-Feed","rss_feed":{"add_posts":"Beitr\u00e4ge als Entwurf hinzuf\u00fcgen","add_rss_feed":"RSS-Feed hinzuf\u00fcgen","auto_update":"Auto-Update","btn_text":"Lesen Sie mehr Schaltfl\u00e4chentext","feed_name":"Feed-Name","feed_url":"Feed URL","generate_keywords":"Keywords aus Titel generieren","images_source":"Bildquelle","keywords":"Schl\u00fcsselw\u00f6rter","my_server":"Laden Sie Bilder auf meinen Server herunter","no":"Nein","no_posts":"Max. Importbeitrag","original_source":"Bilder aus Originalquelle anzeigen","post_import":"Beitr\u00e4ge\/Import","scheduled_post_delete":"Geplante Postl\u00f6schung","show_btn":"Schaltfl\u00e4che \u201eWeiterlesen\u201c anzeigen","show_btn_text":"Schaltfl\u00e4che anzeigen","yes":"Ja"},"save":"speichern","search":"Suchen","seo-tool":{"google_analytics":"Google Analytics","home_title":"Startseite Titel","keyword":"Stichwort","language":"Sprache","maxkeyword":"Geben Sie maximal 10 Schl\u00fcsselw\u00f6rter ein","site_description":"Seitenbeschreibung","site_title":"Seitentitel"},"seo-tools":"SEO Tools","service_categories":"Servicekategorien","services":"Dienstleistungen","setting":{"Manually":"Manuell","Paypal":"PayPal","Stripe":"Streifen","about_text":"\u00dcber Texte","address":"Die Anschrift","app_name":"App Name","cms":"CMS","contact_address":"Kontakt Anschrift","contact_information":"Kontaktinformation","cookie_warning":"Cookie-Warnungen","copy_right_text":"Copyright-Text","currency":"W\u00e4hrung","currency_settings":"W\u00e4hrungseinstellungen","facebook":"Facebook","facebook_url":"Facebook URL","favicon":"Favicon","front_language":"Standard-Frontsprache","general":"Allgemein","general_details":"Allgemeine Einzelheiten","generate_sitemap":"Sitemap generieren","google_recaptcha":"Google-Recaptcha","instagram_url":"Instagram-URL","invalid_facebook_url":"Bitte geben Sie eine g\u00fcltige Facebook-URL ein","invalid_instagram_url":"Bitte geben Sie eine g\u00fcltige Instagram-URL ein","invalid_linkedin_url":"Bitte geben Sie eine g\u00fcltige LinkedIn-URL ein","invalid_pinterest_url":"Bitte geben Sie eine g\u00fcltige Pinterest-URL ein","invalid_telegram_url":"Bitte geben Sie eine g\u00fcltige Telegramm-URL ein","invalid_twitter_url":"Bitte geben Sie eine g\u00fcltige Twitter-URL ein","invalid_vk_url":"Bitte geben Sie eine g\u00fcltige Vk-URL ein","invalid_youtube_url":"Bitte geben Sie eine g\u00fcltige Youtube-URL ein","linkedIn":"LinkedIn","linkedin_url":"LinkedIn-URL","logo":"Logo","manual_payment_guide":"Anleitung zur manuellen Zahlung","pinterest_url":"Pinterest-URL","postal_code":"Postleitzahl","prefix":"Pr\u00e4fix","privacy":"Privatsph\u00e4re","reddit":"Reddit","required_privacy":"Datenschutzfeld ist erforderlich","required_support":"Support-Feld ist erforderlich","required_t&c":"Das Feld Allgemeine Gesch\u00e4ftsbedingungen ist erforderlich","rss_feed_auto_update":"RSS-Feed automatisch aktualisieren","run_commend":"F\u00fchren Sie den Befehl aus","secret_key":"Geheimer Schl\u00fcssel","select_time":"W\u00e4hlen Sie Zeit","setting":"Einstellung","show_captcha":"Recaptcha anzeigen","show_cookie_warning":"Cookie-Warnungen anzeigen","site_key":"Standortschl\u00fcssel","social_media_setting":"Social-Media-Einstellungen","social_media_sharing":"Soziale Medien geteilt","support":"Unterst\u00fctzung","telegram_url":"Telegramm-URL","terms-conditions":"Terms & amp;","twitter":"Twitter","twitter_url":"Twitter-URL","vk_url":"VK-URL","whatsapp":"WhatsApp","youtube_url":"Youtube-URL"},"settings":"Einstellungen","share_this_post":"Teile diesen Beitrag","show":"Show","staff":{"about_us":"\u00dcber uns","add_staff":"Personal hinzuf\u00fcgen","confirm_password":"Best\u00e4tige das Passwort","contact_no":"Kontakt Nr","cover_image":"Titelbild","edit_staff":"Mitarbeiter bearbeiten","email":"Email","email_verified":"Email \u00fcberpr\u00fcft","female":"Weiblich","first_name":"Vorname","gender":"Geschlecht","last_name":"Familienname, Nachname","male":"M\u00e4nnlich","password":"Passwort","profile":"Profil","role":"Rolle","staff":"Mitarbeiter"},"staffs":"Mitarbeiter","states":"Zust\u00e4nde","status":"Status","sub_categories":"Unterkategorien","sub_category":{"action":"Handlung","add":"Unterkategorie hinzuf\u00fcgen","add_lan":"Sprache","category":"Kategorie","edit":"Unterkategorie bearbeiten","language":"Sprache","select_cat":"Kategorie w\u00e4hlen","show_menu":"Im Men\u00fc anzeigen","title":"Titel"},"subscribed_user":"Abonnierte Benutzerpl\u00e4ne","subscriber":"Teilnehmer","subscription":{"active_until":"Aktiv bis","active_until_unlimited":"Aktiv bis Unbegrenzt","amount":"Menge","cancel_subscription":"Abonnement k\u00fcndigen","change_payment_status":"Zahlungsstatus \u00e4ndern","choose_plan":"W\u00e4hlen Sie einen Plan","current_expire":"Aktuell abgelaufener Plan","current_plan":"Derzeitiger Plan","currently_active":"Gerade aktiv","days":"Tage","duration":"Dauer","end_date":"Endtermin","expired":"Plan ist bereits abgelaufen am","expired_date":"Ablaufdatum","free":"Frei","has_already_been_subscribed":"ist bereits abonniert","has_been_subscribed":"wurde abonniert","history":"Abonnementverlauf","manage_subscription":"Abonnement verwalten","months":"Monate","no_plan_available":"Kein Plan verf\u00fcgbar","number_of_post":"Anzahl der Beitr\u00e4ge","pay_or_switch_plan":"Bezahlen \/ Plan wechseln","payable_amount":"Bezahlbarer Betrag","payment":"Zahlung","plan_name":"Planname","plan_price":"Planpreis","proceed_to_payment":"Weiter zur Zahlung","purchase":"Kaufen","remaining":"Verbleibend","remaining_balance":"Restbetrag","remaining_days":"Verbleibende Tage","renew_free_plan":"Der kostenlose Plan kann nicht verl\u00e4ngert\/erneut gew\u00e4hlt werden","renew_plan":"Plan erneuern","start_date":"Startdatum","subscribed_date":"Abonniertes Datum","switch_plan":"Plan wechseln","total_days":"Die Summe an Tagen","trial_plan":"Versuchsplan","upgrade_plan":"Upgrade-Plan","used_balance":"Gebrauchtes Guthaben","used_days":"Gebrauchte Tage","what_in_startup_plan":"Was ist im Startup-Plan","year":"Jahr"},"sync":"Synchronisieren","translation_manager":"\u00dcbersetzungsmanager","user":{"account":"Konto","account_setting":"Account Einstellungen","avatar":"Benutzerbild","change_password":"\u00c4ndere das Passwort","confirm_password":"Best\u00e4tige das Passwort","contact_number":"Kontakt Nummer","current_password":"Aktuelles Passwort","email":"Email","full_name":"Vollst\u00e4ndiger Name","gender":"Geschlecht","new_password":"Neues Kennwort","profile":"Profil","profile_details":"Profildetails","save_changes":"\u00c4nderungen speichern","setting":"Einstellung","staff_details":"Personaldetails","username":"Nutzername"},"users":"Benutzer","weekdays":{"fri":"FR","mon":"MO","sat":"Sa","sun":"SO","thu":"DO","tue":"DI","wed":"Mi"}},"de.pagination":{"next":"N\u00e4chster &raquo;","previous":"&laquo; Bisherige"},"de.passwords":{"reset":"Dein Passwort wurde zur\u00fcck gesetzt!","sent":"Wir haben Ihren Link zum Zur\u00fccksetzen Ihres Passworts per E-Mail gesendet!","throttled":"Bitte warten Sie, bevor Sie es erneut versuchen.","token":"Dieses Token zum Zur\u00fccksetzen des Passworts ist ung\u00fcltig.","user":"Wir k\u00f6nnen keinen Benutzer mit dieser E-Mail-Adresse finden."},"de.validation":{"accepted":"Das :attribute muss akzeptiert werden.","active_url":"Das :attribute ist keine g\u00fcltige URL.","after":"Das :attribute muss ein Datum nach :date sein.","after_or_equal":"Das :attribute muss ein Datum nach oder gleich :date sein.","alpha":"Das :attribute darf nur Buchstaben enthalten.","alpha_dash":"Das :attribute darf nur Buchstaben, Zahlen, Bindestriche und Unterstriche enthalten.","alpha_num":"Das :attribute darf nur Buchstaben und Zahlen enthalten.","array":"Das :attribute muss ein Array sein.","attributes":[],"before":"Das :attribute muss ein Datum vor :date sein.","before_or_equal":"Das :attribute muss ein Datum vor oder gleich :date sein.","between":{"array":"Das :attribute muss zwischen :min und :max liegen.","file":"Das :attribute muss zwischen :min und :max Kilobyte liegen.","numeric":"Das :attribute muss zwischen :min und :max liegen.","string":"Das :attribute muss zwischen den Zeichen :min und :max liegen."},"boolean":"Das :attribute muss wahr oder falsch sein.","confirmed":"Die Best\u00e4tigung des :attribute stimmt nicht \u00fcberein.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"Das :attribute ist kein g\u00fcltiges Datum.","date_equals":"Das :attribute muss ein Datum sein, das dem :date entspricht.","date_format":"Das :attribute stimmt nicht mit dem Format :format \u00fcberein.","different":"Das :attribute und :other muss unterschiedlich sein.","digits":"Das :attribute muss sein :digits Ziffern.","digits_between":"Das :attribute muss zwischen den Ziffern :min und :max liegen.","dimensions":"Das :attribute hat ung\u00fcltige Bildabmessungen.","distinct":"Das :attribute hat einen doppelten Wert.","email":"Das :attribute muss eine g\u00fcltige E-Mail-Adresse sein.","ends_with":"Das :attribute muss mit einem der folgenden Werte enden : :values.","exists":"Das :attribute selected ist ung\u00fcltig.","file":"Das :attribute muss eine Datei sein.","filled":"Das :attribute muss einen Wert haben.","gt":{"array":"Das :attribute muss mehr als :value Elemente enthalten.","file":"Das :attribute muss gr\u00f6\u00dfer sein als :value Kilobyte.","numeric":"Das :attribute muss gr\u00f6\u00dfer als der :value sein.","string":"Das :attribute muss gr\u00f6\u00dfer sein als :value Zeichen."},"gte":{"array":"Das :attribute muss mindestens :value Elemente enthalten.","file":"Das :attribute muss gr\u00f6\u00dfer oder gleich :value Kilobyte sein.","numeric":"Das :attribute muss gr\u00f6\u00dfer oder gleich :value sein.","string":"Das :attribute muss gr\u00f6\u00dfer oder gleich :value zeichen sein."},"image":"Das :attribute muss ein Bild sein.","in":"Das :attribute selected ist ung\u00fcltig.","in_array":"Das :attribute existiert nicht in :other.","integer":"Das :attribute muss eine Ganzzahl sein.","ip":"Das :attribute muss eine g\u00fcltige IP-Adresse sein.","ipv4":"Das :attribute muss eine g\u00fcltige IPv4-Adresse sein.","ipv6":"Das :attribute muss eine g\u00fcltige IPv6-Adresse sein.","json":"Das :attribute muss eine g\u00fcltige JSON-Zeichenfolge sein.","lt":{"array":"Das :attribute muss weniger als :value Elemente enthalten.","file":"Das :attribute muss kleiner als :value Kilobyte sein.","numeric":"Das :attribute muss kleiner als :value sein.","string":"Das :attribute muss kleiner als :value sein."},"lte":{"array":"Das :attribute darf nicht mehr als :value Elemente enthalten.","file":"Das :attribute muss kleiner oder gleich :value Kilobyte sein.","numeric":"Das :attribute muss kleiner oder gleich :value sein.","string":"Das :attribute muss kleiner oder gleich :value zeichen sein."},"max":{"array":"Das :attribute darf nicht mehr als :max Elemente enthalten.","file":"Das :attribute darf nicht gr\u00f6\u00dfer als :max Kilobyte sein.","numeric":"Das :attribute darf nicht gr\u00f6\u00dfer sein als :max.","string":"Das :attribute darf nicht gr\u00f6\u00dfer als :max Zeichen sein."},"mimes":"Das :attribute muss eine Datei vom Typ : :values sein.","mimetypes":"Das :attribute muss eine Datei vom Typ : :values sein.","min":{"array":"Das :attribute muss mindestens :min Elemente enthalten.","file":"Das :attribute muss mindestens :min Kilobyte betragen.","numeric":"Das :attribute muss mindestens :min sein.","string":"Das :attribute muss mindestens :min Zeichen enthalten."},"not_in":"Das :attribute selected ist ung\u00fcltig.","not_regex":"Das :attribute format ist ung\u00fcltig.","numeric":"Das :attribute muss eine Zahl sein.","password":"Das Passwort ist inkorrekt.","present":"Das :attribute muss vorhanden sein.","regex":"Das :attribute ist ung\u00fcltig.","required":"Das Feld :attribute ist erforderlich.","required_if":"Das Feld :attribute ist erforderlich, wenn :other ist :value .","required_unless":"Das :attribute ist erforderlich, es sei denn :other befindet sich in: values.","required_with":"Das :attribute ist erforderlich, wenn :values vorhanden ist.","required_with_all":"Das :attribute ist erforderlich, wenn :values vorhanden sind.","required_without":"Das Feld :attribute ist erforderlich, wenn :values nicht vorhanden ist.","required_without_all":"Das Feld :attribute ist erforderlich, wenn keiner der Werte vorhanden ist.","same":"Das :attribute und :other m\u00fcssen \u00fcbereinstimmen.","size":{"array":"Das :attribute muss Elemente der :Gr\u00f6\u00dfe enthalten.","file":"Das :attribute muss :Gr\u00f6\u00dfe Kilobyte sein.","numeric":"Das :attribute muss :size sein.","string":"Das :attribute muss Zeichen der :Gr\u00f6\u00dfe sein."},"starts_with":"Das :attribute muss mit einem der folgenden Werte beginnen : :values.","string":"Das :attribute muss eine Zeichenfolge sein.","timezone":"Das :attribute muss eine g\u00fcltige Zone sein.","unique":"Das :attribute wurde bereits \u00fcbernommen.","uploaded":"Das :attribute konnte nicht hochgeladen werden.","url":"Das :attribute format ist ung\u00fcltig.","uuid":"Das :attribute muss eine g\u00fcltige UUID sein."},"el.cookieConsent::texts":{"agree":"\u0391\u03c0\u03bf\u03b4\u03bf\u03c7\u03ae","message":"\u0397 \u03b9\u03c3\u03c4\u03bf\u03c3\u03b5\u03bb\u03af\u03b4\u03b1 \u03bc\u03b1\u03c2 \u03c7\u03c1\u03b7\u03c3\u03b9\u03bc\u03bf\u03c0\u03bf\u03b9\u03b5\u03af cookies \u03b3\u03b9\u03b1 \u03bd\u03b1 \u03b2\u03b5\u03bb\u03c4\u03b9\u03ce\u03c3\u03b5\u03b9 \u03c4\u03b7\u03bd \u03b5\u03bc\u03c0\u03b5\u03b9\u03c1\u03af\u03b1 \u03c0\u03b5\u03c1\u03b9\u03ae\u03b3\u03b7\u03c3\u03ae\u03c2 \u03c3\u03b1\u03c2."},"en.auth":{"app":{"create":"Create","export":"Export","lock_account":"Lock Account","member_since":"Member since","messages":"Messages","online":"Online","print":"Print","profile":"Profile","reload":"Reload","reset":"Reset","search":"Search","settings":"Settings"},"confirm_password":"Confirm Password","email":"Email","failed":"These credentials do not match our records.","forgot_password":{"send_pwd_reset":"Send Password Reset Link","title":"Enter Email to reset password"},"full_name":"Full Name","login":{"forgot_password":"I forgot my password","register_membership":"Register a new membership","title":"Sign in to start your session"},"password":"Password","register":"Register","registration":{"have_membership":"I already have a membership","i_agree":"I agree to","terms":"the terms","title":"Register a new membership"},"remember_me":"Remember Me","reset_password":{"reset_pwd_btn":"Reset Password","title":"Reset your password"},"save":"Save","sign_in":"Sign In","sign_out":"Sign out","throttle":"Too many login attempts. Please try again in :seconds seconds."},"en.backup::notifications":{"application_name":"Application name","backup_failed_body":"Important: An error occurred while backing up :application_name","backup_failed_subject":"Failed backup of :application_name","backup_name":"Backup name","backup_successful_body":"Great news, a new backup of :application_name was successfully created on the disk named :disk_name.","backup_successful_subject":"Successful new backup of :application_name","backup_successful_subject_title":"Successful new backup!","cleanup_failed_body":"An error occurred while cleaning up the backups of :application_name","cleanup_failed_subject":"Cleaning up the backups of :application_name failed.","cleanup_successful_body":"The clean up of the :application_name backups on the disk named :disk_name was successful.","cleanup_successful_subject":"Clean up of :application_name backups successful","cleanup_successful_subject_title":"Clean up of backups successful!","disk":"Disk","exception_message":"Exception message: :message","exception_message_title":"Exception message","exception_trace":"Exception trace: :trace","exception_trace_title":"Exception trace","healthy_backup_found_body":"The backups for :application_name are considered healthy. Good job!","healthy_backup_found_subject":"The backups for :application_name on disk :disk_name are healthy","healthy_backup_found_subject_title":"The backups for :application_name are healthy","newest_backup_date":"Newest backup date","newest_backup_size":"Newest backup size","no_backups_info":"No backups were made yet","number_of_backups":"Number of backups","oldest_backup_date":"Oldest backup date","total_storage_used":"Total storage used","unhealthy_backup_found_body":"The backups for :application_name on disk :disk_name are unhealthy.","unhealthy_backup_found_empty":"There are no backups of this application at all.","unhealthy_backup_found_full":"The backups are using too much storage. Current usage is :disk_usage which is higher than the allowed limit of :disk_limit.","unhealthy_backup_found_not_reachable":"The backup destination cannot be reached. :error","unhealthy_backup_found_old":"The latest backup made on :date is considered too old.","unhealthy_backup_found_subject":"Important: The backups for :application_name are unhealthy","unhealthy_backup_found_subject_title":"Important: The backups for :application_name are unhealthy. :problem","unhealthy_backup_found_unknown":"Sorry, an exact reason cannot be determined."},"en.cookieConsent::texts":{"agree":"Allow cookies","message":"Your experience on this site will be improved by allowing cookies."},"en.crud":{"action":"Action","add_new":"Add New","are_you_sure":"Are you sure?","back":"Back","cancel":"Cancel","created_at":"Created At","deleted_at":"Deleted At","detail":"Detail","edit":"Edit","id":"Id","save":"Save","updated_at":"Updated At"},"en.messages":{"Gallery":"Gallery","ad_space":{"ad_code":"Ad Code","ad_management":"Ad Management","ad_space":"Ad Spaces","ad_url":"Ad URL","categories":"Categories","desktop":"Desktop View","details_side":"Details Side","disable_ad":"Disable Ad","gallery":"Gallery","header":"Header","index_bottom":"Index Bottom","index_top":"Index Top","mobile":"Mobile View","popular_news":"Popular News","popular_news_index_page":"Popular News (Index Page)","post_details":"Post Details","recommended_post_index_page":"Recommended Post (Index Page)","select_ad_space":"Select Ad Space","trending_post":"Trending Post","trending_post_index_page":"Trending Post (Index Page)"},"add_post":"Add Post","admin":"Admin","ai":{"ai_filter":"AI Filter","best_of":"Best Of","call_ai":"Call AI","frequency_penalty":"Frequency penalty","generate_content":"Generate Content","maximum_length":"Maximum length","model":"Model","presence_penalty":"Presence penalty","temperature":"Temperature","top_p":"Top P"},"album":{"add_album":"Add Album","album":"Album","edit_album":"Edit Album"},"album_categories":"Album Categories","album_category":{"add_album_category":"Add Album Category","album_category":"Album Category","edit_album_category":"Edit Album Category","select_album":"Select Album"},"albums":"Albums","all":"All","allowed_file_size":"Best resolution for this profile will be","apps":"Apps","attachment":"Attachment","bulk_post":{"Optional":"Optional","boolean":"Boolean","bulk_post":"Bulk Post","bulk_post_upload":"Bulk Post Upload","categories":"Categories","category_ids_list":"Category Id list","data_type":"Data Type","documentation":"Documentation","download_csv_example":"Download CSV Example","download_csv_template":"Download CSV Template","example":"Example","field":"Field","help_documents":"Help Documents","id":"Id","integer":"Integer","languages":"Languages","longText":"longText","or":"OR","string":"String","sub_categories":"Sub Categories","test_description_about_this_post":"Test description About this post","test_title":"Test Title","the_images_must_be_a_file_of_type_article_post":"The images must be a file of type:jpg, png ,jpeg","upload_csv_File":"Upload CSV File","you_can_use_csv_file":"You can use these documents to generate your CSV file"},"cash_payment":"Cash Payment","categories":"Categories","category":{"action":"Action","add_category":"Add Category","category_language_warning":"This category is used by posts if you change the language you need to update the category for the posts","color":"Color","edit_category":"Edit Category","language":"Language","show_home":"Show In Home","show_menu":"Show In Menu","slug":"Slug","title":"Title"},"cities":"Cities","comment":{"approval_pending":"Approval Pending","approved":"Show Approved","auto-approved":"Auto Approved","comment":"Comment","comments":"Comments","email":"E-mail","enter_phone_number":"Enter Phone Number","enter_your_email":"Enter Your email","enter_your_name":"Enter Your Name","pending":"Show Pending","post_a_comment":"Post a Comment","type_your_comments":"Type Your Comments","your_name":"Your Name"},"comments":"Comments","common":{"action":"Action","active":"Active","add":"Add","all_rights":"All Rights Reserved","allow_cookies":"Allow Cookies","allowed_types":"Allowed file types: png, jpg, jpeg.","already_have_an_account":"Already have an Account?","apply":"Apply","approval_status":"Approval Status","approved":"Approved","apr":"Apr","april":"April","aug":"Aug","august":"August","back":"Back","by":"By","cancel":"Cancel","cancel_delete":"No, Cancel","cancel_image":"Cancel image","cancel_profile":"Cancel profile","change_cover_image":"Change Cover Image","change_favicon":"Change favicon","change_image":"Change image","change_logo":"Change logo","change_profile":"Change profile","city":"City","closed":"Closed","contact":"Contact","contact_us":"Contact Us","count":"Count","country":"Country","create_an_account":"Create an Account","created_at":"Created At","created_by":"Created by","custom":"Custom","dec":"Dec","december":"December","declined":"Declined","delete":"Yes, Delete","delete_message":" has been deleted","delete_warning":"Are you sure want to delete this ","deleted":"Deleted!","details":"Details","discard":"Discard","edit":"Edit","feb":"Feb","february":"February","files":"Files :","get_the_best":"Get The Best Blog Stories Into Your Inbox!","image_error":"The image must be a file of type: png, jpg, jpeg, webp, svg.","image_error_excel":"The image must be a file of type: png, jpg, jpeg, pdf,excel","image_warning":" is not valid! Allowed file types: png, jpg, jpeg.","images":"Images :","jan":"Jan","january":"January","jul":"Jul","july":"July","jun":"Jun","june":"June","language":"Language","leave_a_message":"Leave a Message","login":"Login","mar":"Mar","march":"March","max":"The :attribute must not be greater than :max.","may":"May","name":"Name","new_here":"New Here","no_data_available":"No items found. Try to broaden your search.","note":"Note","nov":"Nov","november":"November","oct":"Oct","october":"October","of":"Of","off":"Off","on":"On","pending":"Pending","please_wait":"Please wait...","read":"Read","register":"Register","rejected":"Rejected","remove_image":"Remove image","required":"The :attribute field is required.","result":"Results","save":"Save","select_an_option":"Options","select_category":"Select Category","select_language":"Select Language","select_subcategory":"Select Sub Category","send_email":"Send Email","sep":"Sep","september":"September","service":"Service","show_contact":"Show Contact Details","showing":"Showing","sign_in_here":"Sign in here","slug":"Slug","state":"State","submit":"Submit","subscribe":"Subscribe","success_msg":"Message has been sent successfully.","tags":"Tags :","time":"Time","title":"Title","to":"To","update":"Update","video_error":"The image must be a file of type: mp4, mov, mkv, webm, avi.","view":"View","your_email":"Your Email"},"contacts":"Contacts","countries":"Countries","dashboard":"Dashboard","dashboard_show":{"drafts":"Drafts","email":"Email","latest_user":"Latest User","name":"NAME","post_views":"Post Views","posts":"Posts","profile":"Profile","recent_user":"Recent User"},"days":{"last_month":"Last Month","last_week":"Last Week","this_month":"This Month","this_week":"This Week","today":"Today"},"delete":"Delete","details":{"admin_panel":"Admin Panel","article":"Article","breaking":"Breaking","category":"Category","contact_us":"Contact Us","featured_post":"Featured Post","gallery":"Gallery","home":"Home","hot_categories":"Hot Categories","language":"Language","latest_news":"Latest News","logout":"Logout","next_post":"Next Post","popular_news":"Popular News","popular_tag":"Popular Tag","popular_tags":"Popular Tags","previous_post":"Previous Post","read_more":"Read More","recommended_post":"Recommended Post","related_post":"Related Post","sort":"Sort","top_stories":"Top Stories","trending_post":"Trending Post","view_more":"View More","view_options":"View Options","view_results":"View Results","views":"Views","vote":"Vote","voting_poll":"VOTING POLL","whats_new":"What's New"},"edit_subscription":"Edit Subscription","email_password_reset_link":"Email Password Reset Link","emails":{"Phone":"Phone","email":"Email","enquiry_details":"Here is a Enquiry Detail","message":"Message","name":"Name","required":"The Email Field is required"},"emoji":{"emoji":"Emoji","emojis":"Emojis"},"enquiry":"Enquiry","forgot_password":"Forgot Password","forgot_your_password":"Forgot your password","forgot_your_password_no_problem_just_let_us_know_your_email_address":"Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one","gallery":{"add_images":"Add Images","album":"Album","category":"Category","date":"Date","edit_images":"Edit Images","id":"Id","image":"Image","language":"Language","select_album":"Select Album","title":"Title"},"home":"Home","images":"Images","language":{"edit_language":"Edit Language","edit_translation":"Edit Translation","front_language":"Front Language","is_active":"Is Active","is_default":"Is Default","is_rtl":"Is RTL","iso_code":"ISO Code","language":"Language","native":"Native","new_language":"New Language","no_language_available":"No Language Available","no_language_found":"No Language Found","translation":"Translation"},"languages":"Languages","mail":"Mail","mails":{"action_required":"If you did not create an account, no further action is required.","contact_messages":"Contact Messages","email_address":"Email Address","email_verification":"Email Verification","encryption":"Encryption","hello":"Hello","mail":"Mail","mail_host":"Mail Host","mail_library":"Mail Library","mail_password":"Mail Password","mail_port":"Mail Port","mail_protocol":"Mail Protocol","mail_title":"Mail Title","mail_user_name":"Mail Username","manual_payment_request":"Manual Payment Request","manual_payment_status":"Manual Payment Status","new_manual_payment_request":"New Manual Payment Request","please_click":"Please click the button below to verify your email address.","please_follow":"Please follow below step to paid manually.","regard":"Regard","reply_to":"Reply-To","select_encryption":"Select Encryption","select_mail_library":"Select Mail Library","select_mail_protocol":"Select Mail Protocol","send_contact-messages_to_email_address":"Send Contact Messages to Email Address","send_test_email":"Send Test Email","test_mail":"Test Mail","thank_you_chose":"You have selected manual payment guide","thanks_regard":"Thanks & Regards,","verify_email":"Verify Email Address"},"menu":{"add_menu":"Add Menu","edit_menu":"Edit Menu","link":"Link","menu":"Menu","menu_order":"Menu Order","n_a":"N\/A","parent_menu":"Parent Menu","select_parent_menu":"Select Parent Menu","show_in_menu":"Show In Menu","title":"Title"},"menus":"Menus","months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Jul","jun":"Jun","mar":"Mar","may":"May","nov":"Nov","oct":"Oct","sep":"Sep"},"navigation":"Navigation","navigations":{"menu":"Menu"},"news_letters":"News Letters","no_album_found":"No album available","no_matching_records_found":"No matching records found","no_results_found":"No results found","notes":"Notes","ok":"ok","on_rss_feed":"Total RSS Feed Post","page":{"add_lang":"Select Language","add_page":"Add Page","add_parent_link":"Select Parent Menu Link","dont_add_menu":"Dont Add Menu","edit_page":"Edit Page","footer":"Footer","hide":"Hide","language":"Language","location":"Location","main_menu":"Main Menu","meta_description":"Meta Description","meta_title":"Meta Title","name":"Show Menu On Page","no":"No","page":"Page","parent_menu":"Parent Menu Link","show":"Show","show_breadcrumb":"Show Breadcrumb","show_name":"Name","show_right":"Show Right","show_title":"Show Title","slug":"Slug","title":"Title","top_menu":"Top Menu","user_show":"Show Only to Registered Users","visibility":"Visibility","yes":"Yes"},"pages":"Pages","patients":"Patients","payment_method":"Payment Method","phone":"Phone","placeholder":{"User_profile_updated_successfully":"User profile updated successfully","You_active_more_than_emoji":"You can't active more than 7 emoji","You_already_voted":"You already voted !!","You_can_use_any_one_of_upload_video_or_video_URL_option":"You can use any one of upload video or video URL option","You_disable_less_than_emoji":"You can't disable less than 4 emoji","adSpaces_updated_successfully":"AdSpaces Updated successfully.","album_category_created_successfully":"Album category created successfully.","album_category_deleted_successfully":"Album category deleted successfully.","album_category_retrieved_successfully":"Album category retrieved successfully","album_category_updated_successfully":"Album category updated successfully.","album_created_successfully":"Album created successfully.","album_deleted_successfully":"Album deleted successfully.","album_retrieve_successfully":"Album retrieve successfully.","album_updated_successfully":"Album updated successfully","albums_retrieved_successfully":"Albums retrieved successfully","already_image_exist":"Already Image Exist","best_resolution_for_this_favicon_will_be_32X32":"Best resolution for this favicon will be 32X32.","best_resolution_for_this_logo_will_be_90x60":"Best resolution for this logo will be 90x60.","bulk_post_created_successfully":"Bulk Post created successfully.","category_created_successfully":"Category created Successfully.","category_deleted_successfully":"Category deleted successfully","category_retrieve_successfully":"Category Retrieve Successfully.","category_retrieved_successfully":"Category retrieved successfully.","category_updated_successfully":"Category updated successfully.","chart_updated_successfully":"Chart updated Successfully.","clicking_on_submit_it_will_publish_your_post":"Note: Clicking on submit it will publish your post.","comment_create_successfully":"Comment create successfully","comment_deleted_successfully":"Comment deleted successfully.","comment_setting_updated_successfully":"Comment Setting updated successfully.","contact_deleted_successfully":"Contact deleted successfully.","contact_number_field_is_required":"Contact Number field is required","content_generated_successfully":"Content Generated successfully.","controls_diversity_via_nucleus_sampling":"Controls diversity via nucleus sampling: 0.5 means half of all likelihood-\n         weighted options are considered.","controls_randomness_lowering_results_in_less_random_completions":"Controls randomness: Lowering results in less random completions. As the temperature approaches zero, the model will become deterministic and repetitive.","created_request_for_payment_of":"created request for payment of","current_password_in_invalid":"Current password is invalid.","data_retried":"Data retried","default_language_deleted":"Default Language can't be deleted","default_plan":"This plan is Default","default_plan_changed_successfully":"Default plan changed successfully","default_role_do_not_deleted":"Default role do not deleted.","desktop_view_image_dimensions_must_be_800X130":"Desktop View image Dimensions must be 800X130","email_send_successfully":"Email send successfully.","email_setting_updated_successfully":"Email setting updated successfully.","emoji_created_successfully.":"Emoji created successfully.","emoji_deleted_successfully.":"Emoji deleted successfully.","emoji_status_updated_successfully":"Emoji Status Updated Successfully.","feed_updated_successfully":"Feed updated successfully.","file_not_found":"file not found","gallery_image_created_successfully":"Gallery Image Created successfully.","gallery_image_deleted_successfully.":"Gallery Image Deleted successfully.","gallery_image_updated_successfully":"Gallery Image Updated successfully","gallery_title_must_not_be_greater_than_190_characters":"Gallery Title must not be greater than 190 characters","generates_multiple_completions_server_side":"Generates multiple completions server- side, and displays only the best. Streaming only works when set to 1. Since it acts as a multiplier on the number of completions, this parameters can eat into your token quota very quickly - use caution!","given_post_is_not_yet_published":"Given post is not yet published","image_delete_successfully":"Image Delete successfully","image_upload_successfully":"Image Upload successfully","img_retrieved":"img retrieved","keyword_should_be_of_maximum_10_words_only":"Keyword should be of maximum 10 words only","language_added_to_front_successfully":"Language added to front successfully","language_be_deleted":"Language can't be deleted.","language_change_successfully":"Language change successfully","language_changed_successfully":"Language changed successfully","language_deleted_successfully":"Language Deleted Successfully.","language_not_found":"language not found","language_removed_from_front_successfully":"Language removed from front successfully","language_retrieved_successfully":"Language Retrieved Successfully","language_saved_successfully":"Language Saved successfully.","language_saved_successfully.":"Language Saved successfully.","language_updated_successfully":"Language Updated Successfully.","login_via_facebook":"Login Via Facebook","login_via_google":"Login Via Google","menu_created_successfully":"Menu created successfully.","menu_deleted_successfully":"Menu deleted successfully","menu_update_successfully":"Menu update successfully.","mobile_view_image_dimensions_must_be_350X290":"Mobile View image Dimensions must be 350X290","name_field_is_required":"Name field is required","navigation_updated_successfully":"Navigation updated successfully.","page_created_successfully":"Page created successfully","page_deleted_successfully":"Page deleted successfully.","page_updated_successfully":"Page updated successfully","password_updated_successfully":"Password updated successfully","payment_received":"Payment Received successfully.","plan_already_used":"Plan already used","plan_created_successfully":"Plan created successfully","plan_deleted_successfully.":"Plan deleted successfully.","plan_updated_successfully":"Plan updated successfully","please_enter_CSV_files":"Please enter CSV files","please_enter_video_URL":"Please enter video URL","please_enter_video_url_or_upload_a_video":"Please enter video url or upload a video","please_enter_video_url_or_upload_video":"Please enter video url or upload video","please_select_any_one_permission":"Please select any one permission","please_select_audio_file":"Please select audio file","please_upgrade_plan":"Please Upgrade Plan","poll_created_successfully":"Poll created successfully.","poll_deleted_successfully":"Poll deleted successfully.","poll_updated_successfully":"Poll updated successfully.","poll_voted_successfully":"Poll voted successfully","post_added_on_headline_successfully":"Post added on headline successfully","post_added_to_breaking_successfully":"Post added to breaking successfully","post_added_to_featured_successfully":"Post added to featured successfully","post_added_to_recommended_successfully":"Post added to recommended successfully","post_added_to_slider_successfully":"Post added to slider successfully","post_added_to_visibility_successfully":"Post added to visibility successfully","post_created_successfully":"Post created successfully.","post_deleted_successfully":"Post deleted successfully.","post_removed_from_breaking_successfully":"Post removed from breaking successfully","post_removed_from_featured_successfully":"Post removed from featured successfully","post_removed_from_headline_successfully":"Post removed from headline successfully","post_removed_from_recommended_successfully":"Post removed from recommended successfully","post_removed_from_slider_successfully":"Post removed from slider successfully","post_removed_from_visibility_successfully":"Post removed from visibility successfully","post_updated_successfully":"Post updated successfully.","reCAPTCHA_required!":"reCAPTCHA required!","registered_success":"You have registered successfully, Activate your account from mail.","role_already_exists":"Role Already Exists.","role_created_successfully":"Role Created successfully","role_deleted_successfully":"Role deleted successfully.","role_updated_successfully":"Role updated successfully.","rss_feed_create_successfully":"RSS Feed Create successfully","rss_feed_deleted_successfully":"RSS Feed deleted successfully","rss_feed_update_successfully":"RSS Feed Update successfully.","seo_tools_updated_successfully":"SEO Tools updated successfully.","session_created_successfully":"Session created successfully","settings_updated_successfully":"Settings updated successfully","show_in_home_updated_successfully":"Show in home updated successfully","show_in_menu_updated_successfully":"Show in menu updated successfully","something_wrong_occurred_please_try_again":"Something wrong occurred please try again","sort_list_title_must_not_be_greater_than_190_characters":"Sort List Title must not be greater than 190 characters","staff_created_successfully":"Staff created successfully.","staff_deleted_successfully":"Staff deleted successfully.","staff_updated_successfully":"Staff updated successfully.","status_updated_successfully":"Status updated successfully.","sub_categories_saved_successfully":"Sub Categories saved successfully.","sub_category_delete_successfully":"Sub Category Delete Successfully","sub_category_retrieved_successfully":"Sub category retrieved successfully.","sub_category_updated_successfully":"Sub Category updated successfully","subscribed_plan_wait":"You subscribed this plan successfully but wait for confirmation from Admin","subscribed_successfully":"Subscribed successfully","subscriber_delete_successfully":"Subscriber delete successfully.","subscription_date_successfully_updated":"Subscription date successfully updated.","subscription_successfully_retrieved":"Subscription successfully retrieved","successfully_verified":"You have successfully verified your mail, please login.","the_audios_must_be_a_file_of_type":"The audios must be a file of type: mp3, M4A, wav, aac, wma.","the_images_must_be_a_file_of_type":"The images must be a file of type: jpeg, png, jpg, webp,svg.","the_iso_code_field_is_required":"The ISO Code field is required","the_maximum_number_of_tokens_to_generate_requests_can_use_up":"The maximum number of tokens to generate. Requests can use up to 2,048 or 4,000 tokens shared between prompt and completion. The exact limit varies by model. (One token is roughly 4 characters for normal English text)","the_upload_csv_file_field_is_required":"The Upload CSV File field is required.","the_upload_video_must_not_be_greater_than_150_MB":"The upload video must not be greater than 150 MB.","theme_changed_successfully":"Theme Changed Successfully","this_album_category_is_in_use":"This Album Category is in use","this_album_is_in_use":"This Album is in use","this_category_is_in_use":"This category is in use","this_currency_is_not_supported":"This Currency is not supported","this_email_is_already_subscribed":"This email is already subscribed","this_sub_category_is_in_use":"This Sub category is in use","thumbnail_image_is_required":"Thumbnail image is required","unable_to_process_payment":"Unable to process the payment at the moment. Try again later.","visibility_updated_successfully":"visibility Updated Successfully","you_can_use_any_one_of_upload_video_or_video_URL_option":"You can use any one of upload video or video URL option","you_delete_than_emoji":"You can't Delete than 4 emoji","your_account_is_currently_disabled_please_contact_to_administrator":"Your account is currently disabled, please contact to administrator.","your_mail_already_verified":"Your mail is already verified, please login.","your_manual_payment_request_is":"Your Manual Payment Request Is","your_plan_is_expired_Please_choose_a_plan_to_continue_the_services":"Your plan is expired. Please choose a plan to continue the services"},"plans":{"add_plan":"Add Plan","allowed_post":"Allowed Post","currency":"Currency","default_Plan":"Default Plan","edit_plan":"Edit Plan","enter_trial":"Enter Trial","frequency":"Frequency","monthly":"Monthly","new_plan":"New Plan","no_of_posts":"No Of Posts","plan":"Plan","plan_name":"Plan Name","plans":"Plans","price":"Price","select_currency":"Select Currency","trial_days":"Trial Days","unlimited":"Unlimited","yearly":"Yearly"},"poll":{"add_poll":"Add Poll","add_polls":"Add Polls","all_user":"All user","edit_poll":"Edit Poll","no_result_found":"No Result found","option1":"Option 1","option10":"Option 10","option2":"Option 2","option3":"Option 3","option4":"Option 4","option5":"Option 5","option6":"Option 6","option7":"Option 7","option8":"Option 8","option9":"Option 9","poll":"Poll","poll_result":"Poll Result","question":"Question","register_user":"Register User","show_result":"Show Result","total_vote":"Total Vote","view_option":"View Option","voting_poll":"Voting Poll"},"polls":"Polls","post":{"add_ai":"Write Post Using OpenAI","add_article":"Add Article","add_audio":"Add Audio","add_gallery":"Add Gallery","add_image":"Add Image","add_new_item":"Add New Item","add_on_headline":"Add On Headline","add_personality_quiz":"Add Personality Quiz","add_post":"Add Post","add_sort_list":"Add Sort List","add_to_breaking":"Add to Breaking","add_to_featured":"Add to Featured","add_to_recommended":"Add to Recommended","add_to_slider":"Add to Slider","add_trivia_quiz":"Add Trivia Quiz","add_video":"Add Video","additional":"Additional Images","allowed_images_jpg_png_jpeg":"(JPG,PNG,JPEG,SVG,WEBP)","article":"Article","article_with_images":"An article with images and embed videos","article_with_open_ai":"Write your content using OpenAI","audio":"Audio","category":"Category","choose_post_format":"Choose a Post Format","collection_of_images":"collection of images","d&t":"Pick Date & time","description":"Description","draft":"Save as Draft","draft_post":"Draft","edit_AI":"Edit Post","edit_Article":"Edit Article","edit_Audio":"Edit Audio","edit_Gallery":"Edit Gallery","edit_Sorted":"Edit Sort List","edit_Video":"Edit Video","edit_post":"Edit Post","featured":"Featured","file":"File","gallery":"Gallery","gallery_post_item":"Gallery List Item","get_video":"Get Video from URL","image":"Image","image_description":"Image Description","keywords":"Keywords","list_based_article":"A list based article","open_ai":"Open AI","optional_url":"Optional URL","or_add_url":"Or Add Url","personality_quiz":"Personality Quiz","post":"Post","post_details":"Post Details","post_type":"Post Type","posts":"Posts","publish":"Publish","publish_post":"Publish Post","quizzes_with_custom_results":"Quizzes with custom results","quizzes_with_right_and_wrong_answers":"Quizzes with right and wrong answers","remove_on_headline":"Remove On Headline","remove_to_breaking":"Remove to Breaking","remove_to_featured":"Remove to Featured","remove_to_recommended":"Remove to Recommended","remove_to_slider":"Remove to Slider","scheduled_post":"Scheduled Post","select_image":"Select Image","select_post":"Select Post","select_post_type":"Select Post Type","selected_file":"Selected Files","short_description":"Short Description","show_download_button":"Show Download Button","show_on_headline":"On Headline","show_registered_user":"Show Only to Registered Users","show_right":"Show Right Column","sort_list":"Sorted List","sort_list_item":"Sorted List Item","spotted_video":"(Youtube, Vimeo, Dailymotion)","sub_category":"Sub Category","submit":"Submit","tag":"Tag","thumbnail_image":"Please enter a valid URL","trivia_quiz":"Trivia Quiz","upload_audios_and_create_playlist":"Upload audios and create playlist","upload_or_embed_videos":"Upload or embed videos","upload_video":"Upload Video","video":"Video","video_embed_code":"Video Embed Code","video_thumbnail":"Video Thumbnail","video_url":"Video URL","visibility":"Visibility"},"post_reaction":"Post Reaction","reaction":{"angry":"Angry","dislike":"Dislike","funny":"Funny","like":"Like","love":"Love","pray":"Pray","sad":"Sad","super":"Super","wow":"Wow"},"recent_posts":"Recent Posts","required":"Required","role":{"add_role":"Add Role","edit_role":"Edit Role","permissions":"Permissions","role":"Role","role_permissions":"Role Permissions","select_all_permissions":"Select All Permissions"},"roles":"Roles","roles_permissions":"Roles Permissions","rss-feed":"RSS Feed","rss_feed":{"ad_code":"Ad Code","add_posts":"Add Posts as Draft","add_rss_feed":"Add RSS Feed","auto_update":"Auto Update","btn_text":"Read More Button Text","feed_name":"Feed Name","feed_url":"Feed URL","generate_keywords":"Generate Keywords from Title","images_source":"Images Source","keywords":"Keywords","my_server":"Download Images to My Server","no":"No","no_posts":"Max Import Post","original_source":"Show Images from Original Source","post_import":"Posts\/Import","show_btn":"Show Read More Button","show_btn_text":"Show Button","yes":"Yes"},"save":"Save","search":"Search","seo-tool":{"google_analytics":"Google Analytics","home_title":"Home Title","keyword":"Keyword","language":"Language","maxkeyword":"Enter maximum 10 Keywords","site_description":"Site Description","site_title":"Site Title"},"seo-tools":"SEO Tools","service_categories":"Service Categories","services":"Services","setting":{"Manually":"Manually","Paypal":"Paypal","Stripe":"Stripe","about_text":"About Text","address":"Address","app_name":"App Name","cms":"CMS","contact_address":"Contact Address","contact_information":"Contact Information","cookie_warning":"Cookie Warnings","copy_right_text":"Copyright Text","currency":"Currency","currency_settings":"Currency Settings","download-db":"Download DB","facebook":"Facebook","facebook_url":"Facebook URL","favicon":"Favicon","front_language":"Default Front Language","general":"General","general_details":"General Details","generate_sitemap":"Generate Sitemap","google_recaptcha":"Google Recaptcha","instagram_url":"Instagram URL","invalid_facebook_url":"Please enter a valid Facebook URL","invalid_instagram_url":"Please enter a valid Instagram URL","invalid_linkedin_url":"Please enter a valid LinkedIn URL","invalid_pinterest_url":"Please enter a valid Pinterest URL","invalid_telegram_url":"Please enter a valid Telegram URL","invalid_twitter_url":"Please enter a valid Twitter URL","invalid_vk_url":"Please enter a valid VK URL","invalid_youtube_url":"Please enter a valid Youtube URL","linkedIn":"LinkedIn","linkedin_url":"LinkedIn URL","logo":"Logo","manual_payment_guide":"Manual Payment Guide","pinterest_url":"Pinterest URL","postal_code":"Postal Code","prefix":"Prefix","privacy":"Privacy","reddit":"Reddit","required_privacy":"Privacy field is required","required_support":"Support field is required","required_t&c":"Terms & conditions field is required","rss_feed_auto_update":"Auto Update RSS Feed","run_commend":"Run Commend","secret_key":"Secret Key","select_time":"Select Time","setting":"Setting","show_captcha":"Show Recaptcha","show_cookie_warning":"Show Cookie Warnings","site_key":"Site Key","social_media_setting":"Social Media Settings","social_media_sharing":"Social Media Shared","support":"Support","telegram_url":"Telegram URL","terms-conditions":"Terms & conditions","twitter":"Twitter","twitter_url":"Twitter URL","vk_url":"VK URL","whatsapp":"Whatsapp","youtube_url":"Youtube URL"},"settings":"Settings","share_this_post":"Share This Post","show":"Show","staff":{"about_us":"About Us","add_staff":"Add Staff","confirm_password":"Confirm Password","contact_no":"Contact No","cover_image":"Cover Image","edit_staff":"Edit Staff","email":"Email","email_verified":"Email Verified","female":"Female","first_name":"First Name","gender":"Gender","last_name":"Last Name","male":"Male","password":"Password","profile":"Profile","role":"Role","staff":"Staff","username":"Username"},"staffs":"Staffs","states":"States","status":"Status","sub_categories":"Sub Categories","sub_category":{"action":"Action","add":"Add Sub Category","add_lan":"Language","category":"Category","edit":"Edit Sub Category","language":"Language","select_cat":"Select Category","show_menu":"Show In Menu","title":"Title"},"subscribed_user":"Subscribed User Plans","subscriber":"Subscriber","subscription":{"active_until":"Active Until","active_until_unlimited":"Active till Unlimited","amount":"Amount","cancel_subscription":"Cancel Subscription","change_payment_status":"Change payment Status","choose_plan":"Choose Plan","current_expire":"Current Expired Plan","current_plan":"Current Plan","currently_active":"Currently Active","days":"Days","duration":"Duration","end_date":"End Date","expired":"Plan is Already Expired on","expired_date":"Expired date","free":"Free","has_already_been_subscribed":"is already subscribed","has_been_subscribed":"has been subscribed","history":"Subscription History","manage_subscription":"Manage Subscription","months":"Months","no_plan_available":"No Plan Available","number_of_post":"Number Of Post","pay_or_switch_plan":"Pay \/ Switch Plan","payable_amount":"Payable Amount","payment":"Payment","plan_name":"Plan Name","plan_price":"Plan Price","proceed_to_payment":"Proceed to Payment","purchase":"Purchase","remaining":"Remaining","remaining_balance":"Remaining Balance","remaining_days":"Remaining Days","renew_free_plan":"Free Plan cannot be renewed\/chosen again","renew_plan":"Renew Plan","start_date":"Start Date","subscribed_date":"Subscribed Date","switch_plan":"Switch Plan","total_days":"Total Days","trial_plan":"Trial Plan","upgrade_plan":"Upgrade Plan","used_balance":"Used Balance","used_days":"Used Days","what_in_startup_plan":"What`s In Startup Plan","year":"Year"},"sync":"Sync","translation_manager":"Translation Manager","user":{"account":"Account","account_setting":"Account Settings","avatar":"Avatar","change_password":"Change Password","confirm_password":"Confirm Password","contact_number":"Contact Number","current_password":"Current Password","email":"Email","full_name":"Full Name","gender":"Gender","new_password":"New Password","profile":"Profile","profile_details":"Profile Details","save_changes":"Save Changes","setting":"Setting","staff_details":"Staff Details"},"users":"Users","weekdays":{"fri":"FRI","mon":"MON","sat":"SAT","sun":"SUN","thu":"THU","tue":"TUE","wed":"WED"}},"en.pagination":{"next":"Next &raquo;","previous":"&laquo; Previous"},"en.passwords":{"reset":"Your password has been reset!","sent":"We have emailed your password reset link!","throttled":"Please wait before retrying.","token":"This password reset token is invalid.","user":"We can't find a user with that email address."},"en.validation":{"accepted":"The :attribute must be accepted.","accepted_if":"The :attribute must be accepted when :other is :value.","active_url":"The :attribute is not a valid URL.","after":"The :attribute must be a date after :date.","after_or_equal":"The :attribute must be a date after or equal to :date.","alpha":"The :attribute must only contain letters.","alpha_dash":"The :attribute must only contain letters, numbers, dashes and underscores.","alpha_num":"The :attribute must only contain letters and numbers.","array":"The :attribute must be an array.","ascii":"The :attribute must only contain single-byte alphanumeric characters and symbols.","attributes":[],"before":"The :attribute must be a date before :date.","before_or_equal":"The :attribute must be a date before or equal to :date.","between":{"array":"The :attribute must have between :min and :max items.","file":"The :attribute must be between :min and :max kilobytes.","numeric":"The :attribute must be between :min and :max.","string":"The :attribute must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","confirmed":"The :attribute confirmation does not match.","current_password":"The password is incorrect.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"The :attribute is not a valid date.","date_equals":"The :attribute must be a date equal to :date.","date_format":"The :attribute does not match the format :format.","decimal":"The :attribute must have :decimal decimal places.","declined":"The :attribute must be declined.","declined_if":"The :attribute must be declined when :other is :value.","different":"The :attribute and :other must be different.","digits":"The :attribute must be :digits digits.","digits_between":"The :attribute must be between :min and :max digits.","dimensions":"The :attribute has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","doesnt_end_with":"The :attribute may not end with one of the following: :values.","doesnt_start_with":"The :attribute may not start with one of the following: :values.","email":"The :attribute must be a valid email address.","ends_with":"The :attribute must end with one of the following: :values.","enum":"The selected :attribute is invalid.","exists":"The selected :attribute is invalid.","file":"The :attribute must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute must have more than :value items.","file":"The :attribute must be greater than :value kilobytes.","numeric":"The :attribute must be greater than :value.","string":"The :attribute must be greater than :value characters."},"gte":{"array":"The :attribute must have :value items or more.","file":"The :attribute must be greater than or equal to :value kilobytes.","numeric":"The :attribute must be greater than or equal to :value.","string":"The :attribute must be greater than or equal to :value characters."},"image":"The :attribute must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field does not exist in :other.","integer":"The :attribute must be an integer.","ip":"The :attribute must be a valid IP address.","ipv4":"The :attribute must be a valid IPv4 address.","ipv6":"The :attribute must be a valid IPv6 address.","json":"The :attribute must be a valid JSON string.","lowercase":"The :attribute must be lowercase.","lt":{"array":"The :attribute must have less than :value items.","file":"The :attribute must be less than :value kilobytes.","numeric":"The :attribute must be less than :value.","string":"The :attribute must be less than :value characters."},"lte":{"array":"The :attribute must not have more than :value items.","file":"The :attribute must be less than or equal to :value kilobytes.","numeric":"The :attribute must be less than or equal to :value.","string":"The :attribute must be less than or equal to :value characters."},"mac_address":"The :attribute must be a valid MAC address.","max":{"array":"The :attribute must not have more than :max items.","file":"The :attribute must not be greater than :max kilobytes.","numeric":"The :attribute must not be greater than :max.","string":"The :attribute must not be greater than :max characters."},"max_digits":"The :attribute must not have more than :max digits.","mimes":"The :attribute must be a file of type: :values.","mimetypes":"The :attribute must be a file of type: :values.","min":{"array":"The :attribute must have at least :min items.","file":"The :attribute must be at least :min kilobytes.","numeric":"The :attribute must be at least :min.","string":"The :attribute must be at least :min characters."},"min_digits":"The :attribute must have at least :min digits.","multiple_of":"The :attribute must be a multiple of :value.","not_in":"The selected :attribute is invalid.","not_regex":"The :attribute format is invalid.","numeric":"The :attribute must be a number.","password":{"letters":"The :attribute must contain at least one letter.","mixed":"The :attribute must contain at least one uppercase and one lowercase letter.","numbers":"The :attribute must contain at least one number.","symbols":"The :attribute must contain at least one symbol.","uncompromised":"The given :attribute has appeared in a data leak. Please choose a different :attribute."},"present":"The :attribute field must be present.","prohibited":"The :attribute field is prohibited.","prohibited_if":"The :attribute field is prohibited when :other is :value.","prohibited_unless":"The :attribute field is prohibited unless :other is in :values.","prohibits":"The :attribute field prohibits :other from being present.","regex":"The :attribute format is invalid.","required":"The :attribute field is required.","required_array_keys":"The :attribute field must contain entries for: :values.","required_if":"The :attribute field is required when :other is :value.","required_if_accepted":"The :attribute field is required when :other is accepted.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values are present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","same":"The :attribute and :other must match.","size":{"array":"The :attribute must contain :size items.","file":"The :attribute must be :size kilobytes.","numeric":"The :attribute must be :size.","string":"The :attribute must be :size characters."},"starts_with":"The :attribute must start with one of the following: :values.","string":"The :attribute must be a string.","timezone":"The :attribute must be a valid timezone.","ulid":"The :attribute must be a valid ULID.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","uppercase":"The :attribute must be uppercase.","url":"The :attribute must be a valid URL.","uuid":"The :attribute must be a valid UUID."},"eo.cookieConsent::texts":{"agree":"Akcepti kuketojn","message":"Tiu \u0109i retejo uzas kuketojn por plibonigi vian sperton."},"er.auth":{"app":{"create":"Create","export":"Export","lock_account":"Lock Account","member_since":"Member since","messages":"Messages","online":"Online","print":"Print","profile":"Profile","reload":"Reload","reset":"Reset","search":"Search","settings":"Settings"},"confirm_password":"Confirm Password","email":"Email","failed":"These credentials do not match our records.","forgot_password":{"send_pwd_reset":"Send Password Reset Link","title":"Enter Email to reset password"},"full_name":"Full Name","login":{"forgot_password":"I forgot my password","register_membership":"Register a new membership","title":"Sign in to start your session"},"password":"Password","register":"Register","registration":{"have_membership":"I already have a membership","i_agree":"I agree to","terms":"the terms","title":"Register a new membership"},"remember_me":"Remember Me","reset_password":{"reset_pwd_btn":"Reset Password","title":"Reset your password"},"save":"Save","sign_in":"Sign In","sign_out":"Sign out","throttle":"Too many login attempts. Please try again in :seconds seconds."},"er.crud":{"action":"Action","add_new":"Add New","are_you_sure":"Are you sure?","back":"Back","cancel":"Cancel","created_at":"Created At","deleted_at":"Deleted At","detail":"Detail","edit":"Edit","id":"Id","save":"Save","updated_at":"Updated At"},"er.messages":{"Gallery":"Gallery","ad_space":{"ad_management":"Ad Management","ad_space":"Ad Spaces","ad_url":"Ad URL","categories":"Categories","desktop":"Desktop View","details_side":"Details Side","gallery":"Gallery","header":"Header","index_bottom":"Index Bottom","index_top":"Index Top","mobile":"Mobile View","popular_news":"Popular News","popular_news_index_page":"Popular News (Index Page)","post_details":"Post Details","recommended_post_index_page":"Recommended Post (Index Page)","select_ad_space":"Select Ad Space","trending_post":"Trending Post","trending_post_index_page":"Trending Post (Index Page)"},"add_post":"Add Post","admin":"Admin","ai":{"ai_filter":"AI Filter","best_of":"Best Of","call_ai":"Call AI","frequency_penalty":"Frequency penalty","generate_content":"Generate Content","maximum_length":"Maximum length","model":"Model","presence_penalty":"Presence penalty","temperature":"Temperature","top_p":"Top P"},"album":{"add_album":"Add Album","album":"Album","edit_album":"Edit Album"},"album_categories":"Album Categories","album_category":{"add_album_category":"Add Album Category","album_category":"Album Category","edit_album_category":"Edit Album Category","select_album":"Select Album"},"albums":"Albums","all":"All","allowed_file_size":"Best resolution for this profile will be","apps":"Apps","bulk_post":{"bulk_post":"Bulk Post","bulk_post_upload":"Bulk Post Upload","categories":"Categories","category_ids_list":"Category Ids list","documentation":"Documentation","download_csv_example":"Download CSV Example","download_csv_template":"Download CSV Template","help_documents":"Help Documents","id":"Id","languages":"Languages","sub_categories":"Sub Categories","upload_csv_File":"Upload CSV File","you_can_use_csv_file":"You can use these documents to generate your CSV file"},"categories":"Categories","category":{"action":"Action","add_category":"Add Category","category_language_warning":"This category is used by posts if you change the language you need to update the category for the posts","color":"Color","edit_category":"Edit Category","language":"Language","show_home":"Show In Home","show_menu":"Show In Menu","slug":"Slug","title":"Title"},"cities":"Cities","comment":{"approval_pending":"Approval Pending","approved":"Show Approved","auto-approved":"Auto Approved","comment":"Comment","comments":"Comments","email":"E-mail","enter_phone_number":"Enter Phone Number","enter_your_email":"Enter Your email","enter_your_name":"Enter Your Name","pending":"Show Pending","post_a_comment":"Post a Comment","type_your_comments":"Type Your Comments","your_name":"Your Name"},"comments":"Comments","common":{"action":"Action","add":"Add","all_rights":"All Rights Reserved","allowed_types":"Allowed file types: png, jpg, jpeg.","apply":"Apply","apr":"Apr","april":"April","aug":"Aug","august":"August","back":"Back","by":"By","cancel":"Cancel","cancel_delete":"No, Cancel","cancel_image":"Cancel image","cancel_profile":"Cancel profile","change_favicon":"Change favicon","change_image":"Change image","change_logo":"Change logo","change_profile":"Change profile","city":"City","contact":"Contact","contact_us":"Contact Us","count":"Count","country":"Country","created_at":"Created At","created_by":"Created by","custom":"Custom","dec":"Dec","december":"December","delete":"Yes, Delete","delete_message":" has been deleted","delete_warning":"Are you sure want to delete this ","deleted":"Deleted!","details":"Details","discard":"Discard","edit":"Edit","feb":"Feb","february":"February","files":"Files :","get_the_best":"Get The Best Blog Stories Into Your Inbox!","image_error":"The image must be a file of type: png, jpg, jpeg, webp, svg.","image_warning":" is not valid! Allowed file types: png, jpg, jpeg.","images":"Images :","jan":"Jan","january":"January","jul":"Jul","july":"July","jun":"Jun","june":"June","language":"Language","leave_a_message":"Leave a Message","login":"Login","mar":"Mar","march":"March","max":"The :attribute must not be greater than :max.","may":"May","name":"Name","no_data_available":"No items found. Try to broaden your search.","note":"Note","nov":"Nov","november":"November","oct":"Oct","october":"October","of":"Of","please_wait":"Please wait...","read":"Read","remove_image":"Remove image","required":"The :attribute field is required.","result":"Results","save":"Save","select_an_option":"Options","select_category":"Select Category","select_language":"Select Language","select_subcategory":"Select Sub Category","sep":"Sep","september":"September","service":"Service","show_contact":"Show Contact Details","showing":"Showing","slug":"Slug","state":"State","submit":"Submit","subscribe":"Subscribe","success_msg":"Message has been sent successfully.","tags":"Tags :","time":"Time","title":"Title","to":"To","update":"Update","video_error":"The image must be a file of type: mp4, mov, mkv, webm, avi.","your_email":"Your Email"},"contacts":"Contacts","countries":"Countries","dashboard":"Dashboard","dashboard_show":{"drafts":"Drafts","email":"Email","latest_user":"Latest User","name":"NAME","post_views":"Post Views","posts":"Posts","profile":"Profile","recent_user":"Recent User"},"days":{"last_month":"Last Month","last_week":"Last Week","this_month":"This Month","this_week":"This Week","today":"Today"},"delete":"Delete","details":{"admin_panel":"Admin Panel","article":"Article","breaking":"Breaking","category":"Category","contact_us":"Contact Us","featured_post":"Featured Post","gallery":"Gallery","home":"Home","hot_categories":"Hot Categories","language":"Language","latest_news":"Latest News","logout":"Logout","next_post":"Next Post","popular_news":"Popular News","popular_tag":"Popular Tag","popular_tags":"Popular Tags","previous_post":"Previous Post","read_more":"Read More","recommended_post":"Recommended Post","related_post":"Related Post","sort":"Sort","top_stories":"Top Stories","trending_post":"Trending Post","view_more":"View More","view_options":"View Options","view_results":"View Results","views":"Views","vote":"Vote","voting_poll":"VOTING POLL","whats_new":"What's New"},"emails":{"email":"Email","enquiry_details":"Here is a Enquiry Detail","message":"Message","name":"Name","phone":"Phone","required":"The Email Field is required"},"gallery":{"add_images":"Add Images","album":"Album","category":"Category","date":"Date","edit_images":"Edit Images","id":"Id","image":"Image","language":"Language","select_album":"Select Album","title":"Title"},"home":"Home","images":"Images","language":{"edit_language":"Edit Language","edit_translation":"Edit Translation","is_active":"Is Active","is_default":"Is Default","is_rtl":"Is RTL","iso_code":"ISO Code","language":"Language","native":"Native","new_language":"New Language","no_language_available":"No Language Available","no_language_found":"No Language Found","translation":"Translation"},"languages":"Languages","mail":"Mail","mails":{"contact_messages":"Contact Messages","email_address":"Email Address","email_verification":"Email Verification","encryption":"Encryption","mail":"Mail","mail_host":"Mail Host","mail_library":"Mail Library","mail_password":"Mail Password","mail_port":"Mail Port","mail_protocol":"Mail Protocol","mail_title":"Mail Title","mail_user_name":"Mail Username","reply_to":"Reply-To","select_encryption":"Select Encryption","select_mail_library":"Select Mail Library","select_mail_protocol":"Select Mail Protocol","send_contact-messages_to_email_address":"Send Contact Messages to Email Address","send_test_email":"Send Test Email"},"menu":{"add_menu":"Add Menu","edit_menu":"Edit Menu","link":"Link","menu":"Menu","menu_order":"Menu Order","n_a":"N\/A","parent_menu":"Parent Menu","select_parent_menu":"Select Parent Menu","show_in_menu":"Show In Menu","title":"Title"},"menus":"Menus","months":{"apr":"Apr","aug":"Aug","dec":"Dec","feb":"Feb","jan":"Jan","jul":"Jul","jun":"Jun","mar":"Mar","may":"May","nov":"Nov","oct":"Oct","sep":"Sep"},"navigation":"Navigation","navigations":{"menu":"Menu"},"news_letters":"News Letters","no_album_found":"No album available","no_matching_records_found":"No matching records found","on_rss_feed":"Total RSS Feed Post","page":{"add_lang":"Select Language","add_page":"Add Page","add_parent_link":"Select Parent Menu Link","dont_add_menu":"Dont Add Menu","edit_page":"Edit Page","footer":"Footer","hide":"Hide","language":"Language","location":"Location","main_menu":"Main Menu","meta_description":"Meta Description","meta_title":"Meta Title","name":"Show Menu On Page","no":"No","page":"Page","parent_menu":"Parent Menu Link","show":"Show","show_breadcrumb":"Show Breadcrumb","show_name":"Name","show_right":"Show Right","show_title":"Show Title","slug":"Slug","title":"Title","top_menu":"Top Menu","user_show":"Show Only to Registered Users","visibility":"Visibility","yes":"Yes"},"pages":"Pages","patients":"Patients","placeholder":{"successfully_verified":"You have successfully verified your mail, please login.","your_mail_already_verified":"Your mail is already verified, please login."},"poll":{"add_poll":"Add Poll","add_polls":"Add Polls","all_user":"All user","edit_poll":"Edit Poll","no_result_found":"No Result found","option1":"Option 1","option10":"Option 10","option2":"Option 2","option3":"Option 3","option4":"Option 4","option5":"Option 5","option6":"Option 6","option7":"Option 7","option8":"Option 8","option9":"Option 9","poll":"Poll","poll_result":"Poll Result","question":"Question","register_user":"Register User","show_result":"Show Result","total_vote":"Total Vote","view_option":"View Option","voting_poll":"Voting Poll"},"polls":"Polls","post":{"add_article":"Add Article","add_audio":"Add Audio","add_gallery":"Add Gallery","add_image":"Add Image","add_new_item":"Add New Item","add_on_headline":"Add On Headline","add_personality_quiz":"Add Personality Quiz","add_post":"Add Post","add_sort_list":"Add Sort List","add_to_breaking":"Add to Breaking","add_to_featured":"Add to Featured","add_to_recommended":"Add to Recommended","add_to_slider":"Add to Slider","add_trivia_quiz":"Add Trivia Quiz","add_video":"Add Video","additional":"Additional Images","allowed_images_jpg_png_jpeg":"(JPG,PNG,JPEG,SVG,WEBP)","article":"Article","article_with_images":"An article with images and embed videos","article_with_open_ai":"Write your content using OpenAI","audio":"Audio","category":"Category","choose_post_format":"Choose a Post Format","collection_of_images":"collection of images","d&t":"Pick Date & time","description":"Description","draft":"Save as Draft","edit_Article":"Edit Article","edit_Audio":"Edit Audio","edit_Gallery":"Edit Gallery","edit_Sorted":"Edit Sort List","edit_Video":"Edit Video","edit_post":"Edit Post","featured":"Featured","file":"File","gallery":"Gallery","gallery_post_item":"Gallery List Item","get_video":"Get Video from URL","image":"Image","image_description":"Image Description","keywords":"Keywords","list_based_article":"A list based article","optional_url":"Optional URL","or_add_url":"Or Add URL","personality_quiz":"Personality Quiz","post":"Post","post_type":"Post Type","posts":"Posts","publish":"Publish","quizzes_with_custom_results":"Quizzes with custom results","quizzes_with_right_and_wrong_answers":"Quizzes with right and wrong answers","remove_on_headline":"Remove On Headline","remove_to_breaking":"Remove to Breaking","remove_to_featured":"Remove to Featured","remove_to_recommended":"Remove to Recommended","remove_to_slider":"Remove to Slider","scheduled_post":"Scheduled Post","select_image":"Select Image","select_post_type":"Select Post Type","selected_file":"Selected Files","show_download_button":"Show Download Button","show_on_headline":"On Headline","show_registered_user":"Show Only to Registered Users","show_right":"Show Right Column","sort_list":"Sorted List","sort_list_item":"Sorted List Item","spotted_video":"(Youtube, Vimeo, Dailymotion)","sub_category":"Sub Category","submit":"Submit","tag":"Tag","thumbnail_image":"Please enter a valid URL","trivia_quiz":"Trivia Quiz","upload_audios_and_create_playlist":"Upload audios and create playlist","upload_or_embed_videos":"Upload or embed videos","upload_video":"Upload Video","video":"Video","video_embed_code":"Video Embed Code","video_thumbnail":"Video Thumbnail","video_url":"Video URL","visibility":"Visibility"},"role":{"add_role":"Add Role","edit_role":"Edit Role","permissions":"Permissions","role":"Role","role_permissions":"Role Permissions","select_all_permissions":"Select All Permissions"},"roles":"Roles","roles_permissions":"Roles Permissions","rss-feed":"RSS Feed","rss_feed":{"ad_code":"Ad Code","add_posts":"Add Posts as Draft","add_rss_feed":"Add RSS Feed","auto_update":"Auto Update","btn_text":"Read More Button Text","feed_name":"Feed Name","feed_url":"Feed URL","generate_keywords":"Generate Keywords from Title","images_source":"Images Source","keywords":"Keywords","my_server":"Download Images to My Server","no":"No","no_posts":"Max Import Post","original_source":"Show Images from Original Source","post_import":"Posts\/Import","show_btn":"Show Read More Button","show_btn_text":"Show Button","yes":"Yes"},"save":"Save","search":"Search","seo-tool":{"google_analytics":"Google Analytics","home_title":"Home Title","keyword":"Keyword","language":"Language","maxkeyword":"Enter maximum 10 Keywords","site_description":"Site Description","site_title":"Site Title"},"seo-tools":"SEO Tools","service_categories":"Service Categories","services":"Services","setting":{"about_text":"About Text","address":"Address","app_name":"App Name","cms":"CMS","contact_address":"Contact Address","contact_information":"Contact Information","cookie_warning":"Cookie Warnings","copy_right_text":"Copyright Text","currency":"Currency","currency_settings":"Currency Settings","facebook_url":"Facebook URL","favicon":"Favicon","front_language":"Default Front Language","general":"General","general_details":"General Details","google_recaptcha":"Google Recaptcha","instagram_url":"Instagram URL","invalid_facebook_url":"Please enter a valid Facebook URL","invalid_instagram_url":"Please enter a valid Instagram URL","invalid_linkedin_url":"Please enter a valid LinkedIn URL","invalid_pinterest_url":"Please enter a valid Pinterest URL","invalid_telegram_url":"Please enter a valid Telegram URL","invalid_twitter_url":"Please enter a valid Twitter URL","invalid_vk_url":"Please enter a valid VK URL","invalid_youtube_url":"Please enter a valid Youtube URL","linkedin_url":"LinkedIn URL","logo":"Logo","pinterest_url":"Pinterest URL","postal_code":"Postal Code","prefix":"Prefix","privacy":"Privacy","required_privacy":"Privacy field is required","required_support":"Support field is required","required_t&c":"Terms & conditions field is required","rss_feed_auto_update":"Auto Update RSS Feed","secret_key":"Secret Key","select_time":"Select Time","setting":"Setting","show_captcha":"Show Recaptcha","show_cookie_warning":"Show Cookie Warnings","site_key":"Site Key","social_media_setting":"Social Media Settings","support":"Support","telegram_url":"Telegram URL","terms-conditions":"Terms & conditions","twitter_url":"Twitter URL","vk_url":"VK URL","youtube_url":"Youtube URL"},"settings":"Settings","share_this_post":"Share This Post","show":"Show","staff":{"add_staff":"Add Staff","confirm_password":"Confirm Password","contact_no":"Contact No","edit_staff":"Edit Staff","email":"Email","email_verified":"Email Verified","female":"Female","first_name":"First Name","gender":"Gender","last_name":"Last Name","male":"Male","password":"Password","profile":"Profile","role":"Role","staff":"Staff"},"staffs":"Staffs","states":"States","status":"Status","sub_categories":"Sub Categories","sub_category":{"action":"Action","add":"Add Sub Category","add_lan":"Language","category":"Category","edit":"Edit Sub Category","language":"Language","select_cat":"Select Category","show_menu":"Show In Menu","title":"Title"},"subscriber":"Subscriber","translation_manager":"Translation Manager","user":{"account":"Account","account_setting":"Account Settings","avatar":"Avatar","change_password":"Change Password","confirm_password":"Confirm Password","contact_number":"Contact Number","current_password":"Current Password","email":"Email","full_name":"Full Name","gender":"Gender","new_password":"New Password","profile":"Profile","profile_details":"Profile Details","save_changes":"Save Changes","setting":"Setting","staff_details":"Staff Details"},"users":"Users","weekdays":{"fri":"FRI","mon":"MON","sat":"SAT","sun":"SUN","thu":"THU","tue":"TUE","wed":"WED"}},"er.pagination":{"next":"Next &raquo;","previous":"&laquo; Previous"},"er.passwords":{"reset":"Your password has been reset!","sent":"We have emailed your password reset link!","throttled":"Please wait before retrying.","token":"This password reset token is invalid.","user":"We can't find a user with that email address."},"er.validation":{"accepted":"The :attribute must be accepted.","accepted_if":"The :attribute must be accepted when :other is :value.","active_url":"The :attribute is not a valid URL.","after":"The :attribute must be a date after :date.","after_or_equal":"The :attribute must be a date after or equal to :date.","alpha":"The :attribute must only contain letters.","alpha_dash":"The :attribute must only contain letters, numbers, dashes and underscores.","alpha_num":"The :attribute must only contain letters and numbers.","array":"The :attribute must be an array.","ascii":"The :attribute must only contain single-byte alphanumeric characters and symbols.","attributes":[],"before":"The :attribute must be a date before :date.","before_or_equal":"The :attribute must be a date before or equal to :date.","between":{"array":"The :attribute must have between :min and :max items.","file":"The :attribute must be between :min and :max kilobytes.","numeric":"The :attribute must be between :min and :max.","string":"The :attribute must be between :min and :max characters."},"boolean":"The :attribute field must be true or false.","confirmed":"The :attribute confirmation does not match.","current_password":"The password is incorrect.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"The :attribute is not a valid date.","date_equals":"The :attribute must be a date equal to :date.","date_format":"The :attribute does not match the format :format.","decimal":"The :attribute must have :decimal decimal places.","declined":"The :attribute must be declined.","declined_if":"The :attribute must be declined when :other is :value.","different":"The :attribute and :other must be different.","digits":"The :attribute must be :digits digits.","digits_between":"The :attribute must be between :min and :max digits.","dimensions":"The :attribute has invalid image dimensions.","distinct":"The :attribute field has a duplicate value.","doesnt_end_with":"The :attribute may not end with one of the following: :values.","doesnt_start_with":"The :attribute may not start with one of the following: :values.","email":"The :attribute must be a valid email address.","ends_with":"The :attribute must end with one of the following: :values.","enum":"The selected :attribute is invalid.","exists":"The selected :attribute is invalid.","file":"The :attribute must be a file.","filled":"The :attribute field must have a value.","gt":{"array":"The :attribute must have more than :value items.","file":"The :attribute must be greater than :value kilobytes.","numeric":"The :attribute must be greater than :value.","string":"The :attribute must be greater than :value characters."},"gte":{"array":"The :attribute must have :value items or more.","file":"The :attribute must be greater than or equal to :value kilobytes.","numeric":"The :attribute must be greater than or equal to :value.","string":"The :attribute must be greater than or equal to :value characters."},"image":"The :attribute must be an image.","in":"The selected :attribute is invalid.","in_array":"The :attribute field does not exist in :other.","integer":"The :attribute must be an integer.","ip":"The :attribute must be a valid IP address.","ipv4":"The :attribute must be a valid IPv4 address.","ipv6":"The :attribute must be a valid IPv6 address.","json":"The :attribute must be a valid JSON string.","lowercase":"The :attribute must be lowercase.","lt":{"array":"The :attribute must have less than :value items.","file":"The :attribute must be less than :value kilobytes.","numeric":"The :attribute must be less than :value.","string":"The :attribute must be less than :value characters."},"lte":{"array":"The :attribute must not have more than :value items.","file":"The :attribute must be less than or equal to :value kilobytes.","numeric":"The :attribute must be less than or equal to :value.","string":"The :attribute must be less than or equal to :value characters."},"mac_address":"The :attribute must be a valid MAC address.","max":{"array":"The :attribute must not have more than :max items.","file":"The :attribute must not be greater than :max kilobytes.","numeric":"The :attribute must not be greater than :max.","string":"The :attribute must not be greater than :max characters."},"max_digits":"The :attribute must not have more than :max digits.","mimes":"The :attribute must be a file of type: :values.","mimetypes":"The :attribute must be a file of type: :values.","min":{"array":"The :attribute must have at least :min items.","file":"The :attribute must be at least :min kilobytes.","numeric":"The :attribute must be at least :min.","string":"The :attribute must be at least :min characters."},"min_digits":"The :attribute must have at least :min digits.","multiple_of":"The :attribute must be a multiple of :value.","not_in":"The selected :attribute is invalid.","not_regex":"The :attribute format is invalid.","numeric":"The :attribute must be a number.","password":{"letters":"The :attribute must contain at least one letter.","mixed":"The :attribute must contain at least one uppercase and one lowercase letter.","numbers":"The :attribute must contain at least one number.","symbols":"The :attribute must contain at least one symbol.","uncompromised":"The given :attribute has appeared in a data leak. Please choose a different :attribute."},"present":"The :attribute field must be present.","prohibited":"The :attribute field is prohibited.","prohibited_if":"The :attribute field is prohibited when :other is :value.","prohibited_unless":"The :attribute field is prohibited unless :other is in :values.","prohibits":"The :attribute field prohibits :other from being present.","regex":"The :attribute format is invalid.","required":"The :attribute field is required.","required_array_keys":"The :attribute field must contain entries for: :values.","required_if":"The :attribute field is required when :other is :value.","required_if_accepted":"The :attribute field is required when :other is accepted.","required_unless":"The :attribute field is required unless :other is in :values.","required_with":"The :attribute field is required when :values is present.","required_with_all":"The :attribute field is required when :values are present.","required_without":"The :attribute field is required when :values is not present.","required_without_all":"The :attribute field is required when none of :values are present.","same":"The :attribute and :other must match.","size":{"array":"The :attribute must contain :size items.","file":"The :attribute must be :size kilobytes.","numeric":"The :attribute must be :size.","string":"The :attribute must be :size characters."},"starts_with":"The :attribute must start with one of the following: :values.","string":"The :attribute must be a string.","timezone":"The :attribute must be a valid timezone.","ulid":"The :attribute must be a valid ULID.","unique":"The :attribute has already been taken.","uploaded":"The :attribute failed to upload.","uppercase":"The :attribute must be uppercase.","url":"The :attribute must be a valid URL.","uuid":"The :attribute must be a valid UUID."},"es.auth":{"app":{"create":"Crear","export":"Exportar","lock_account":"Bloquear cuenta","member_since":"Miembro desde","messages":"Mensajes","online":"En l\u00ednea","print":"Imprimir","profile":"Perfil","reload":"Recargar","reset":"Reiniciar","search":"B\u00fasqueda","settings":"Ajustes"},"confirm_password":"confirmar Contrase\u00f1a","email":"Correo electr\u00f3nico","failed":"Estas credenciales no coinciden con nuestros registros.","forgot_password":{"send_pwd_reset":"Enviar enlace de restablecimiento de contrase\u00f1a","title":"Ingrese el correo electr\u00f3nico para restablecer la contrase\u00f1a"},"full_name":"Nombre completo","login":{"forgot_password":"Olvid\u00e9 mi contrase\u00f1a","register_membership":"Registrar una nueva membres\u00eda","title":"Inicia sesi\u00f3n para iniciar tu sesi\u00f3n"},"password":"Clave","register":"Registro","registration":{"have_membership":"ya tengo una membresia","i_agree":"estoy de acuerdo con","terms":"los t\u00e9rminos","title":"Registrar una nueva membres\u00eda"},"remember_me":"Recu\u00e9rdame","reset_password":{"reset_pwd_btn":"Restablecer la contrase\u00f1a","title":"Restablecer su contrase\u00f1a"},"save":"Guardar","sign_in":"Iniciar sesi\u00f3n","sign_out":"desconectar","throttle":"Demasiados intentos de inicio de sesi\u00f3n. Vuelva a intentarlo en :seconds segundos."},"es.backup::notifications":{"application_name":"Nombre de la aplicaci\u00f3n","backup_failed_body":"Importante: Ocurri\u00f3 un error al realizar la copia de seguridad de :application_name","backup_failed_subject":"Copia de seguridad de :application_name fallida","backup_name":"Nombre de la copia de seguridad","backup_successful_body":"Buenas noticias, una nueva copia de seguridad de :application_name fue creada con \u00e9xito en el disco llamado :disk_name.","backup_successful_subject":"Se complet\u00f3 con \u00e9xito la copia de seguridad de :application_name","backup_successful_subject_title":"\u00a1Nueva copia de seguridad creada con \u00e9xito!","cleanup_failed_body":"Ocurri\u00f3 un error mientras se realizaba la limpieza de copias de seguridad de :application_name","cleanup_failed_subject":"La limpieza de copias de seguridad de :application_name fall\u00f3.","cleanup_successful_body":"La limpieza de copias de seguridad de :application_name en el disco llamado :disk_name se completo con \u00e9xito.","cleanup_successful_subject":"La limpieza de copias de seguridad de :application_name se complet\u00f3 con \u00e9xito","cleanup_successful_subject_title":"!Limpieza de copias de seguridad completada con \u00e9xito!","disk":"Disco","exception_message":"Mensaje de la excepci\u00f3n: :message","exception_message_title":"Mensaje de la excepci\u00f3n","exception_trace":"Traza de la excepci\u00f3n: :trace","exception_trace_title":"Traza de la excepci\u00f3n","healthy_backup_found_body":"Las copias de seguridad de :application_name se consideran en buen estado. \u00a1Buen trabajo!","healthy_backup_found_subject":"Las copias de seguridad de :application_name en el disco :disk_name est\u00e1n en buen estado","healthy_backup_found_subject_title":"Las copias de seguridad de :application_name est\u00e1n en buen estado","newest_backup_date":"Fecha de la copia de seguridad m\u00e1s reciente","newest_backup_size":"Tama\u00f1o de copia de seguridad m\u00e1s reciente","no_backups_info":"A\u00fan no se hicieron copias de seguridad","number_of_backups":"N\u00famero de copias de seguridad","oldest_backup_date":"Fecha de la copia de seguridad m\u00e1s antigua","total_storage_used":"Almacenamiento total utilizado","unhealthy_backup_found_body":"Las copias de seguridad de :application_name en el disco :disk_name est\u00e1n en mal estado.","unhealthy_backup_found_empty":"No existe ninguna copia de seguridad de esta aplicaci\u00f3n.","unhealthy_backup_found_full":"Las copias de seguridad  est\u00e1n ocupando demasiado espacio. El espacio utilizado actualmente es :disk_usage el cual es mayor que el l\u00edmite permitido de :disk_limit.","unhealthy_backup_found_not_reachable":"No se puede acceder al destino de la copia de seguridad. :error","unhealthy_backup_found_old":"La \u00faltima copia de seguriad hecha en :date es demasiado antigua.","unhealthy_backup_found_subject":"Importante: Las copias de seguridad de :application_name est\u00e1n en mal estado","unhealthy_backup_found_subject_title":"Importante: Las copias de seguridad de :application_name est\u00e1n en mal estado. :problem","unhealthy_backup_found_unknown":"Lo siento, no es posible determinar la raz\u00f3n exacta."},"es.cookieConsent::texts":{"agree":"Aceptar","message":"Su experiencia en este sitio ser\u00e1 mejorada con el uso de cookies."},"es.crud":{"action":"Acci\u00f3n","add_new":"Agregar nuevo","are_you_sure":"Estas seguro","back":"Atr\u00e1s","cancel":"Cancelar","created_at":"Creado en","deleted_at":"Eliminado en","detail":"Detalle","edit":"Editar","id":"Identificaci\u00f3n","save":"Guardar","updated_at":"Actualizado en"},"es.messages":{"Gallery":"Galer\u00eda","ad_space":{"ad_code":"c\u00f3digo de anuncio","ad_management":"Gesti\u00f3n de anuncios","ad_space":"espacios publicitarios","ad_url":"URL del anuncio","categories":"Categor\u00edas","desktop":"Vista de escritorio","details_side":"Lado de detalles","disable_ad":"Deshabilitar anuncio","gallery":"Galer\u00eda","header":"Encabezamiento","index_bottom":"Parte inferior del \u00edndice","index_top":"\u00cdndice superior","mobile":"Vista m\u00f3vil","popular_news":"Noticias populares","popular_news_index_page":"Noticias populares (p\u00e1gina de \u00edndice)","post_details":"Detalles de la publicaci\u00f3n","recommended_post_index_page":"Publicaci\u00f3n recomendada (p\u00e1gina de \u00edndice)","select_ad_space":"Seleccionar espacio publicitario","trending_post":"Publicaci\u00f3n de tendencia","trending_post_index_page":"Publicaci\u00f3n de tendencias (p\u00e1gina de \u00edndice)"},"add_post":"A\u00f1adir publicaci\u00f3n","admin":"Administrador","ai":{"ai_filter":"Filtro de IA","best_of":"Mejor de","call_ai":"llamar a la IA","frequency_penalty":"penalizaci\u00f3n de frecuencia","generate_content":"Generate Content","maximum_length":"Longitud m\u00e1xima","model":"Modelo","presence_penalty":"Penalizaci\u00f3n por presencia","temperature":"Temperatura","top_p":"P superior"},"album":{"add_album":"Agregar \u00e1lbum","album":"\u00c1lbum","edit_album":"Editar \u00e1lbum"},"album_categories":"Categor\u00edas de \u00e1lbumes","album_category":{"add_album_category":"Agregar categor\u00eda de \u00e1lbum","album_category":"Categor\u00eda de \u00e1lbum","edit_album_category":"Editar categor\u00eda de \u00e1lbum","select_album":"Seleccionar \u00e1lbum"},"albums":"\u00c1lbumes","all":"Todos","allowed_file_size":"La mejor resoluci\u00f3n para este perfil ser\u00e1","apps":"aplicaciones","attachment":"adjunto","bulk_post":{"boolean":"booleano","bulk_post":"Publicaci\u00f3n masiva","bulk_post_upload":"Carga masiva de publicaciones","categories":"Categor\u00edas","category_ids_list":"Lista de ID de categor\u00eda","data_type":"Tipo de datos","documentation":"Documentaci\u00f3n","download_csv_example":"Descargar ejemplo CSV","download_csv_template":"Descargar plantilla CSV","example":"Ejemplo","field":"Campo","help_documents":"Documentos de ayuda","id":"Identificaci\u00f3n","integer":"Entero","languages":"Idiomas","longText":"texto largo","or":"O","string":"Cadena","sub_categories":"Subcategor\u00edas","test_description_about_this_post":"Descripci\u00f3n de la prueba Acerca de esta publicaci\u00f3n","test_title":"T\u00edtulo de prueba","the_images_must_be_a_file_of_type_article_post":"Las im\u00e1genes deben ser un archivo de tipo: jpg, png ,jpeg","upload_csv_File":"Subir archivo CSV","you_can_use_csv_file":"Puede utilizar estos documentos para generar su archivo CSV"},"cash_payment":"Pago en efectivo","categories":"Categor\u00edas","category":{"action":"Acci\u00f3n","add_category":"a\u00f1adir categor\u00eda","category_language_warning":"Esta categor\u00eda es utilizada por publicaciones si cambia el idioma que necesita para actualizar la categor\u00eda para las publicaciones","color":"Color","edit_category":"Editar categoria","language":"Idioma","show_home":"Mostrar en casa","show_menu":"Mostrar en el men\u00fa","slug":"Babosa","title":"T\u00edtulo"},"cities":"Ciudades","comment":{"approval_pending":"Aprobaci\u00f3n pendiente","approved":"Mostrar aprobado","auto-approved":"Aprobado autom\u00e1ticamente","comment":"Comentario","comments":"Comentarios","email":"Correo electr\u00f3nico","enter_phone_number":"Ingresa n\u00famero telef\u00f3nico","enter_your_email":"Introduce tu correo electr\u00f3nico","enter_your_name":"Introduzca su nombre","pending":"Mostrar pendiente","post_a_comment":"Publicar un comentario","type_your_comments":"Escriba sus comentarios","your_name":"Su nombre"},"comments":"Comentarios","common":{"action":"Acci\u00f3n","active":"Activo","add":"Agregar","allow_cookies":"Permitir cookies","allowed_types":"Tipos de archivos permitidos: png, jpg, jpeg.","already_have_an_account":"\u00bfYa tienes una cuenta?","apply":"Aplicar","approval_status":"Estado de aprobaci\u00f3n","approved":"Aprobado","apr":"R","april":"abril","aug":"ag","august":"agosto","back":"Atr\u00e1s","by":"Por","cancel":"Cancelar","cancel_delete":"no, cancelar","cancel_image":"Cancelar imagen","cancel_profile":"Cancelar perfil","change_cover_image":"Cambiar imagen de portada","change_favicon":"Cambiar icono de favorito","change_image":"Cambiar imagen","change_logo":"Cambiar logotipo","change_profile":"Cambiar el perfil","city":"Ciudad","closed":"Cerrada","contact":"Contacto","contact_us":"Contacta con nosotros","count":"Contar","country":"Pa\u00eds","create_an_account":"Crea una cuenta","created_at":"Creado en","created_by":"Creado por","custom":"Disfraz","dec":"plataforma","december":"diciembre","declined":"Rechazado","delete":"S\u00ed, Eliminar","delete_message":"Ha sido eliminado","delete_warning":"Est\u00e1s seguro de que quieres eliminar esto","deleted":"\u00a1Borrado!","details":"Detalles","discard":"Desechar","edit":"Editar","feb":"feb","february":"febrero","front_language":"Idioma frontal predeterminado","get_the_best":"\u00a1Obtenga las mejores historias de blogs en su bandeja de entrada!","image_error":"La imagen debe ser un archivo de tipo: png, jpg, jpeg, webp, svg.","image_error_excel":"La imagen debe ser un archivo de tipo: png, jpg, jpeg, pdf,excel","image_warning":"no es v\u00e1lido! Tipos de archivos permitidos: png, jpg, jpeg.","jan":"John","january":"enero","jul":"Jul","july":"mes de julio","jun":"Junio","june":"junio","language":"Idioma","leave_a_message":"Deja un mensaje","mar":"Mar","march":"marcha","max":"El :attribute no puede ser mayor que :max.","may":"mayo","name":"Nombre","new_here":"Nuevo aqu\u00ed","no_data_available":"No se encontraron art\u00edculos. Intenta ampliar tu b\u00fasqueda.","note":"Nota","nov":"novedad","november":"noviembre","oct":"Oct","october":"octubre","of":"De","off":"Apagado","on":"En","pending":"Pendiente","please_wait":"Espere por favor...","read":"Leer","register":"Registro","rejected":"Rechazado","remove_image":"Quita la imagen","required":"El campo de :attribute es obligatorio.","result":"Resultado","save":"Guardar","select_an_option":"Seleccione una opci\u00f3n","select_category":"selecciona una categor\u00eda","select_language":"Seleccione el idioma","select_subcategory":"Seleccionar subcategor\u00eda","send_email":"Enviar correo electr\u00f3nico","sep":"Sep","september":"septiembre","service":"Servicio","show_contact":"Mostrar detalles de contacto","showing":"Demostraci\u00f3n","sign_in_here":"Firme aqu\u00ed","slug":"Babosa","state":"Expresar","submit":"Entregar","subscribe":"Suscribir","success_msg":"El mensaje ha sido enviado con \u00e9xito.","time":"Tiempo","title":"T\u00edtulo","to":"Para","update":"Actualizar","view":"Vista","your_email":"Tu correo electr\u00f3nico"},"contacts":"Contactos","countries":"Los paises","dashboard":"Panel","dashboard_show":{"drafts":"Borradores","email":"Correo electr\u00f3nico","latest_user":"\u00daltimo usuario","name":"NOMBRE","post_views":"Vistas de publicaciones","posts":"Publicaciones","profile":"Perfil","recent_user":"Usuario reciente"},"days":{"last_month":"El mes pasado","last_week":"La semana pasada","this_month":"Este mes","this_week":"Esta semana","today":"Este Dia"},"delete":"Borrar","details":{"admin_panel":"Panel de administrador","article":"Art\u00edculo","breaking":"Rotura","category":"Categor\u00eda","contact_us":"Contacta con nosotras","featured_post":"Publicaci\u00f3n destacada","gallery":"Galer\u00eda","home":"Casa","hot_categories":"Categor\u00edas calientes","language":"Idioma","latest_news":"\u00daltimas noticias","logout":"Cerrar sesi\u00f3n","next_post":"Publicaci\u00f3n siguiente","popular_news":"Noticias populares","popular_tag":"Etiqueta popular","popular_tags":"Etiquetas Populares","previous_post":"Publicaci\u00f3n anterior","read_more":"Lee mas","recommended_post":"Publicaci\u00f3n recomendada","related_post":"Publicaci\u00f3n relacionada","sort":"Clasificar","top_stories":"Historias destacadas","trending_post":"Publicaci\u00f3n de tendencia","view_more":"Ver m\u00e1s","view_options":"ver opciones","view_results":"Ver resultados","views":"Vista","vote":"votar","whats_new":"Qu\u00e9 hay de nuevo"},"edit_subscription":"Abonnement bearbeiten","email_password_reset_link":"Enlace de restablecimiento de contrase\u00f1a de correo electr\u00f3nico","emails":{"Phone":"Tel\u00e9fono","email":"Correo electr\u00f3nico","enquiry_details":"Here is a Enquiry Detail","message":"Mensaje","name":"Nombre","required":"El campo de correo electr\u00f3nico es obligatorio"},"emoji":{"emoji":"emoticonos","emojis":"emoticonos"},"enquiry":"Consulta","forgot_password":"Has olvidado tu contrase\u00f1a","forgot_your_password":"Olvidaste tu contrase\u00f1a","forgot_your_password_no_problem_just_let_us_know_your_email_address":"\u00bfOlvidaste tu contrase\u00f1a? Ning\u00fan problema. Simplemente h\u00e1ganos saber su direcci\u00f3n de correo electr\u00f3nico y le enviaremos un enlace de restablecimiento de contrase\u00f1a que le permitir\u00e1 elegir una nueva.","gallery":{"add_images":"A\u00f1adir im\u00e1genes","album":"\u00c1lbum","category":"Categor\u00eda","date":"Fecha","edit_images":"Editar im\u00e1genes","id":"Identificaci\u00f3n","image":"Imagen","language":"Idioma","select_album":"Seleccionar \u00e1lbum","title":"T\u00edtulo"},"home":"Casa","images":"Im\u00e1genes","language":{"edit_language":"Editar idioma","edit_translation":"Editar traducci\u00f3n","front_language":"Front Language status","is_active":"Est\u00e1 activo","is_default":"es predeterminado","is_rtl":"es RTL","iso_code":"C\u00f3digo ISO","language":"Idioma","native":"Nativo","new_language":"Nuevo idioma","no_language_available":"Ning\u00fan idioma disponible","no_language_found":"No se encontr\u00f3 ning\u00fan idioma","translation":"Traducci\u00f3n"},"languages":"Idiomas","login":"Acceso","mail":"Correo","mails":{"action_required":"Si no cre\u00f3 una cuenta, no se requiere ninguna otra acci\u00f3n.","contact_messages":"Mensajes de contacto","email_address":"Direcci\u00f3n de correo electr\u00f3nico","email_verification":"verificacion de email","encryption":"Cifrado","hello":"Hola","mail":"Correo","mail_host":"Anfitri\u00f3n de correo","mail_library":"Biblioteca de correo","mail_password":"Contrase\u00f1a de correo","mail_port":"Puerto de correo","mail_protocol":"Protocolo de correo","mail_title":"T\u00edtulo del correo","mail_user_name":"Nombre de usuario de correo","manual_payment_request":"Solicitud de pago manual","manual_payment_status":"Estado de pago manual","please_click":"Haga clic en el bot\u00f3n de abajo para verificar su direcci\u00f3n de correo electr\u00f3nico.","regard":"Respecto","reply_to":"Responder a","select_encryption":"Seleccione Cifrado","select_mail_library":"Seleccionar biblioteca de correo","select_mail_protocol":"Seleccione Protocolo de correo","send_contact-messages_to_email_address":"Enviar mensajes de contacto a la direcci\u00f3n de correo electr\u00f3nico","send_test_email":"Enviar correo electr\u00f3nico de prueba","test_mail":"Correo de prueba","verify_email":"Confirme su direcci\u00f3n de correo electr\u00f3nico"},"menu":{"add_menu":"A\u00f1adir men\u00fa","edit_menu":"Men\u00fa de edici\u00f3n","link":"Enlace","menu":"Men\u00fa","menu_order":"Orden del men\u00fa","parent_menu":"Men\u00fa principal","select_parent_menu":"Seleccionar men\u00fa principal","show_in_menu":"Mostrar en el men\u00fa","title":"T\u00edtulo"},"menus":"Men\u00fas","months":{"apr":"Abr","aug":"Ago","dec":"Dic","feb":"Feb","jan":"Ene","jul":"Jul","jun":"Jun","mar":"Mar","may":"Mayo","nov":"Nov","oct":"Oct","sep":"Sep"},"navigation":"Navegaci\u00f3n","navigations":{"menu":"Men\u00fa"},"news_letters":"Boletin informativo","no_album_found":"Ning\u00fan \u00e1lbum disponible","no_matching_records_found":"No se encontraron registros coincidentes,","no_results_found":"No se han encontrado resultados","notes":"notas","ok":"ok","on_rss_feed":"Publicaci\u00f3n total de fuentes RSS","page":{"add_lang":"Seleccione el idioma","add_page":"A\u00f1adir p\u00e1gina","add_parent_link":"Seleccione el enlace del men\u00fa principal","dont_add_menu":"No agregar men\u00fa","edit_page":"Editar p\u00e1gina","footer":"Pie de p\u00e1gina","hide":"Esconder","language":"Idioma","location":"Localizaci\u00f3n","main_menu":"Men\u00fa principal","meta_description":"Metadescripci\u00f3n","meta_title":"Metat\u00edtulo","name":"Mostrar men\u00fa en la p\u00e1gina","no":"No","page":"P\u00e1gina","parent_menu":"Enlace del men\u00fa principal","show":"Show","show_breadcrumb":"Mostrar ruta de navegaci\u00f3n","show_name":"Nombre","show_right":"Mostrar a la derecha","show_title":"Mostrar t\u00edtulo","slug":"Babosa","title":"T\u00edtulo","top_menu":"Menu principal","user_show":"Mostrar solo a usuarios registrados","visibility":"Visibilidad","yes":"S\u00ed"},"pages":"Paginas","patients":"Pacientes","payment_method":"M\u00e9todo de pago","phone":"Tel\u00e9fono","placeholder":{"User_profile_updated_successfully":"Perfil de usuario actualizado con \u00e9xito","You_active_more_than_emoji":"No puedes activar m\u00e1s de 7 emoji","You_already_voted":"Ya votaste !!","You_can_use_any_one_of_upload_video_or_video_URL_option":"Puedes usar cualquiera de las opciones de subir video o URL de video","You_disable_less_than_emoji":"No puedes deshabilitar menos de 4 emoji","adSpaces_updated_successfully":"AdSpaces actualizado con \u00e9xito","album_category_created_successfully":"Categor\u00eda de \u00e1lbum creada con \u00e9xito","album_category_deleted_successfully":"Categor\u00eda de \u00e1lbum eliminada con \u00e9xito","album_category_retrieved_successfully":"Categor\u00eda de \u00e1lbum recuperada con \u00e9xito","album_category_updated_successfully":"Categor\u00eda de \u00e1lbum actualizada con \u00e9xito","album_created_successfully":"\u00c1lbum creado con \u00e9xito","album_deleted_successfully":"\u00c1lbum eliminado con \u00e9xito","album_retrieve_successfully":"\u00c1lbum recuperado con \u00e9xito","album_updated_successfully":"\u00c1lbum actualizado con \u00e9xito","albums_retrieved_successfully":"\u00c1lbumes recuperados con \u00e9xito","already_image_exist":"La imagen ya existe","best_resolution_for_this_favicon_will_be_32X32":"La mejor resoluci\u00f3n para este favicon ser\u00e1 32X32","best_resolution_for_this_logo_will_be_90x60":"La mejor resoluci\u00f3n para este logo ser\u00e1 90x60.","bulk_post_created_successfully":"Publicaci\u00f3n masiva creada con \u00e9xito.","category_created_successfully":"Categor\u00eda creada con \u00e9xito","category_deleted_successfully":"Categor\u00eda eliminada con \u00e9xito","category_retrieve_successfully":"Categor\u00eda recuperada con \u00e9xito","category_retrieved_successfully":"Categor\u00eda recuperada con \u00e9xito.","category_updated_successfully":"Categor\u00eda actualizada con \u00e9xito","chart_updated_successfully":"Gr\u00e1fico actualizado con \u00e9xito","clicking_on_submit_it_will_publish_your_post":"Note: Clicking on submit it will publish your post.","comment_create_successfully":"Comentario creado con \u00e9xito","comment_deleted_successfully":"Comentario eliminado con \u00e9xito","comment_setting_updated_successfully":"Configuraci\u00f3n de comentarios actualizada con \u00e9xito","contact_deleted_successfully":"Contacto eliminado con \u00e9xito","contact_number_field_is_required":"El campo N\u00famero de contacto es obligatorio","content_generated_successfully":"Contenido generado con \u00e9xito.","controls_diversity_via_nucleus_sampling":"Controls diversity via nucleus sampling: 0.5 means half of all likelihood-         weighted options are considered.","controls_randomness_lowering_results_in_less_random_completions":"Controls randomness: Lowering results in less random completions. As the temperature approaches zero, the model will become deterministic and repetitive.","created_request_for_payment_of":"solicitud creada para el pago de","current_password_in_invalid":"La contrase\u00f1a actual no es v\u00e1lida.","data_retried":"Datos reintentados","default_language_deleted":"El idioma predeterminado no se puede eliminar","default_plan":"This plan is Default","default_plan_changed_successfully":"El plan predeterminado se cambi\u00f3 con \u00e9xito","default_role_do_not_deleted":"La funci\u00f3n predeterminada no se elimina.","desktop_view_image_dimensions_must_be_800X130":"Desktop View image Las dimensiones deben ser 800X130","email_send_successfully":"Correo electr\u00f3nico enviado con \u00e9xito.","email_setting_updated_successfully":"Configuraci\u00f3n de correo electr\u00f3nico actualizada con \u00e9xito","emoji_created_successfully.":"Emoji creado con \u00e9xito","emoji_deleted_successfully.":"Emoji eliminado con \u00e9xito","emoji_status_updated_successfully":"Estado de emoji actualizado con \u00e9xito","feed_updated_successfully":"Feed actualizado con \u00e9xito.","file_not_found":"archivo no encontrado","gallery_image_created_successfully":"Imagen de la galer\u00eda creada con \u00e9xito","gallery_image_deleted_successfully.":"Imagen de la galer\u00eda eliminada con \u00e9xito","gallery_image_updated_successfully":"Imagen de la galer\u00eda actualizada con \u00e9xito","gallery_title_must_not_be_greater_than_190_characters":"El t\u00edtulo de la galer\u00eda no debe tener m\u00e1s de 190 caracteres","generates_multiple_completions_server_side":"Generates multiple completions server- side, and displays only the best. Streaming only works when set to 1. Since it acts as a multiplier on the number of completions, this parameters can eat into your token quota very quickly - use caution!","given_post_is_not_yet_published":"La publicaci\u00f3n dada a\u00fan no est\u00e1 publicada","image_delete_successfully":"Eliminaci\u00f3n de imagen con \u00e9xito","image_upload_successfully":"Imagen cargada con \u00e9xito","img_retrieved":"imagen recuperada","keyword_should_be_of_maximum_10_words_only":"La palabra clave debe tener un m\u00e1ximo de 10 palabras \u00fanicamente","language_added_to_front_successfully":"Idioma agregado al frente con \u00e9xito","language_be_deleted":"El idioma no se puede eliminar","language_change_successfully":"Cambio de idioma con \u00e9xito","language_changed_successfully":"Idioma cambiado correctamente","language_deleted_successfully":"Idioma eliminado con \u00e9xito","language_not_found":"idioma no encontrado","language_removed_from_front_successfully":"Idioma eliminado del frente con \u00e9xito","language_retrieved_successfully":"Idioma recuperado con \u00e9xito","language_saved_successfully":"Idioma Guardado con \u00e9xito","language_saved_successfully.":"Idioma Guardado con \u00e9xito","language_setting_updated_successfully":"La configuraci\u00f3n de idioma se actualiz\u00f3 correctamente.","language_updated_successfully":"Idioma actualizado con \u00e9xito","login_via_facebook":"Login Via Facebook","login_via_google":"Login Via Google","mail_updated_successfully":"El correo fue exitoso","menu_created_successfully":"Men\u00fa creado con \u00e9xito","menu_deleted_successfully":"Men\u00fa eliminado con \u00e9xito","menu_update_successfully":"Actualizaci\u00f3n del men\u00fa con \u00e9xito","mobile_view_image_dimensions_must_be_350X290":"Las dimensiones de la imagen de vista m\u00f3vil deben ser 350X290","name_field_is_required":"El campo de nombre es obligatorio","navigation_updated_successfully":"Navegaci\u00f3n actualizada con \u00e9xito","page_created_successfully":"P\u00e1gina creada con \u00e9xito","page_deleted_successfully":"P\u00e1gina eliminada con \u00e9xito.","page_updated_successfully":"P\u00e1gina actualizada correctamente","password_updated_successfully":"Contrase\u00f1a actualizada exitosamente","payment_received":"Payment Received successfully.","plan_already_used":"Plan already used","plan_created_successfully":"Plan creado con \u00e9xito","plan_deleted_successfully.":"Plan eliminado con \u00e9xito","plan_updated_successfully":"Plan actualizado correctamente","please_enter_CSV_files":"Por favor ingrese archivos CSV","please_enter_video_URL":"Ingrese la URL del video","please_enter_video_url_or_upload_a_video":"Ingrese la URL del video o cargue un video","please_enter_video_url_or_upload_video":"Ingrese la URL del video o cargue el video","please_select_any_one_permission":"Seleccione cualquier permiso","please_select_audio_file":"Seleccione el archivo de audio","please_upgrade_plan":"Por favor actualice el plan","poll_created_successfully":"Encuesta creada con \u00e9xito.","poll_deleted_successfully":"Encuesta eliminada con \u00e9xito.","poll_updated_successfully":"Encuesta actualizada con \u00e9xito.","poll_voted_successfully":"Encuesta votada con \u00e9xito","post_added_on_headline_successfully":"Publicaci\u00f3n agregada en el t\u00edtulo con \u00e9xito","post_added_to_breaking_successfully":"Publicaci\u00f3n agregada para romper con \u00e9xito","post_added_to_featured_successfully":"Publicaci\u00f3n a\u00f1adida a destacada con \u00e9xito","post_added_to_recommended_successfully":"Publicaci\u00f3n a\u00f1adida a recomendada con \u00e9xito","post_added_to_slider_successfully":"Publicaci\u00f3n agregada al control deslizante con \u00e9xito","post_added_to_visibility_successfully":"Publicaci\u00f3n agregada a la visibilidad con \u00e9xito","post_created_successfully":"Publicaci\u00f3n creada con \u00e9xito.","post_deleted_successfully":"Publicaci\u00f3n eliminada con \u00e9xito.","post_removed_from_breaking_successfully":"Publicaci\u00f3n eliminada de ruptura exitosa","post_removed_from_featured_successfully":"Publicaci\u00f3n eliminada de destacados con \u00e9xito","post_removed_from_headline_successfully":"Publicaci\u00f3n eliminada del t\u00edtulo con \u00e9xito","post_removed_from_recommended_successfully":"Publicaci\u00f3n eliminada de recomendada con \u00e9xito","post_removed_from_slider_successfully":"Publicaci\u00f3n eliminada del control deslizante con \u00e9xito","post_removed_from_visibility_successfully":"Publicaci\u00f3n eliminada de la visibilidad con \u00e9xito","post_updated_successfully":"Publicaci\u00f3n actualizada con \u00e9xito.","reCAPTCHA_required":"\u00a1Se requiere reCAPTCHA!","registered_success":"You have registered successfully, Activate your account from mail.","role_already_exists":"El rol ya existe.","role_created_successfully":"Rol creado con \u00e9xito","role_deleted_successfully":"Rol eliminado con \u00e9xito.","role_updated_successfully":"Rol actualizado con \u00e9xito.","rss_feed_create_successfully":"Fuente RSS creada con \u00e9xito","rss_feed_deleted_successfully":"Fuente RSS eliminada con \u00e9xito","rss_feed_update_successfully":"Actualizaci\u00f3n de la fuente RSS con \u00e9xito.","seo_tools_updated_successfully":"Herramientas de SEO actualizadas con \u00e9xito.","session_created_successfully":"Sesi\u00f3n creada con \u00e9xito","settings_updated_successfully":"Configuraci\u00f3n actualizada con \u00e9xito","show_in_home_updated_successfully":"Mostrar en casa actualizado con \u00e9xito","show_in_menu_updated_successfully":"Mostrar en el men\u00fa actualizado con \u00e9xito","something_wrong_occurred_please_try_again":"Ocurri\u00f3 algo mal, int\u00e9ntalo de nuevo","sort_list_title_must_not_be_greater_than_190_characters":"El t\u00edtulo de la lista de clasificaci\u00f3n no debe tener m\u00e1s de 190 caracteres","staff_created_successfully":"Personal creado con \u00e9xito.","staff_deleted_successfully":"Personal eliminado con \u00e9xito.","staff_updated_successfully":"Personal actualizado con \u00e9xito.","status_updated_successfully":"Estado actualizado con \u00e9xito.","sub_categories_saved_successfully":"Subcategor\u00edas guardadas con \u00e9xito.","sub_category_delete_successfully":"Subcategor\u00eda eliminada con \u00e9xito","sub_category_retrieved_successfully":"Subcategor\u00eda recuperada con \u00e9xito.","sub_category_updated_successfully":"Subcategor\u00eda actualizada con \u00e9xito","subscribed_plan_wait":"You subscribed this plan successfully but wait for confirmation from Admin","subscribed_successfully":"Suscrito con \u00e9xito","subscriber_delete_successfully":"Eliminaci\u00f3n de suscriptor con \u00e9xito","subscription_date_successfully_updated":"Fecha de suscripci\u00f3n actualizada con \u00e9xito.","subscription_successfully_retrieved":"Suscripci\u00f3n recuperada con \u00e9xito","successfully_verified":"You have successfully verified your mail, please login.","test_mail_send_successfully":"Enviar correo de prueba Sussssssful","the_audios_must_be_a_file_of_type":"Los audios deben ser un archivo de tipo: mp3, M4A, wav, aac, wma.","the_images_must_be_a_file_of_type":"Las im\u00e1genes deben ser un archivo de tipo: jpeg, png, jpg, webp,svg.","the_iso_code_field_is_required":"El campo C\u00f3digo ISO es obligatorio","the_maximum_number_of_tokens_to_generate_requests_can_use_up":"The maximum number of tokens to generate. Requests can use up to 2,048 or 4,000 tokens shared between prompt and completion. The exact limit varies by model. (One token is roughly 4 characters for normal English text)","the_upload_csv_file_field_is_required":"El campo Cargar archivo CSV es obligatorio.","the_upload_video_must_not_be_greater_than_150_MB":"El video subido no debe tener m\u00e1s de 150 MB.","theme_changed_successfully":"Tema cambiado con \u00e9xito","this_action_not_allowed_for_default_records":"Esta acci\u00f3n no est\u00e1 permitida para los registros predeterminados","this_album_category_is_in_use":"Esta categor\u00eda de \u00e1lbum est\u00e1 en uso","this_album_is_in_use":"Este \u00e1lbum est\u00e1 en uso","this_category_is_in_use":"Esta categor\u00eda est\u00e1 en uso","this_currency_is_not_supported":"This Currency is not supported","this_email_is_already_subscribed":"Este correo ya est\u00e1 suscrito","this_sub_category_is_in_use":"Esta subcategor\u00eda est\u00e1 en uso","thumbnail_image_is_required":"Se requiere imagen en miniatura","unable_to_process_payment":"Unable to process the payment at the moment. Try again later.","visibility_updated_successfully":"Visibilidad actualizada con \u00e9xito","you_can_use_any_one_of_upload_video_or_video_URL_option":"Puedes usar cualquiera de las opciones de subir video o URL de video","you_delete_than_emoji":"No puedes eliminar m\u00e1s de 4 emoji","your_account_is_currently_disabled_please_contact_to_administrator":"Su cuenta est\u00e1 deshabilitada actualmente, comun\u00edquese con el administrador.","your_mail_already_verified":"Your mail is already verified, please login.","your_manual_payment_request_is":"Su solicitud de pago manual es","your_plan_is_expired_Please_choose_a_plan_to_continue_the_services":"Tu plan ha caducado. Elija un plan para continuar con los servicios"},"plans":{"add_plan":"Agregar plan","allowed_post":"Publicaci\u00f3n permitida","currency":"Divisa","default_Plan":"Plan predeterminado","edit_plan":"Editar plan","enter_trial":"Entrar en prueba","frequency":"Frecuencia","monthly":"Mensual","new_plan":"Nuevo plan","no_of_posts":"N\u00famero de publicaciones","plan":"Plan","plan_name":"Nombre del plan","plans":"planes","price":"Precio","select_currency":"Seleccione el tipo de moneda","trial_days":"D\u00edas de prueba","unlimited":"Ilimitado","yearly":"Anual"},"poll":{"add_poll":"A\u00f1adir un sondeo","add_polls":"Agregar encuestas","all_user":"Todo usuario","edit_poll":"Editar encuesta","no_result_found":"No se han encontrado resultados","option1":"Opci\u00f3n 1","option10":"Opci\u00f3n 10","option2":"Opci\u00f3n 2","option3":"Opci\u00f3n 3","option4":"Opci\u00f3n 4","option5":"Opci\u00f3n 5","option6":"Opci\u00f3n 6","option7":"Opci\u00f3n 7","option8":"Opci\u00f3n 8","option9":"Opci\u00f3n 9","poll":"Encuesta","poll_result":"Resultado de la encuesta","question":"Pregunta","register_user":"Registrar usuario","show_result":"Mostrar resultado","total_vote":"Voto Total","view_option":"Ver opci\u00f3n","voting_poll":"Encuesta de votaci\u00f3n"},"polls":"Centro","post":{"add_ai":"Escribir publicaci\u00f3n usando OpenAi","add_article":"A\u00f1adir art\u00edculo","add_audio":"A\u00f1adir audio","add_gallery":"A\u00f1adir galer\u00eda","add_image":"A\u00f1adir imagen","add_new_item":"Agregar \u00edtem nuevo","add_on_headline":"A\u00f1adir en el t\u00edtulo","add_personality_quiz":"Agregar prueba de personalidad","add_post":"A\u00f1adir publicaci\u00f3n","add_sort_list":"Agregar lista de clasificaci\u00f3n","add_to_breaking":"Agregar a romper","add_to_featured":"Agregar a Destacados","add_to_recommended":"A\u00f1adir a Recomendado","add_to_slider":"Agregar al control deslizante","add_trivia_quiz":"Agregar prueba de trivia","add_video":"A\u00f1adir video","additional":"Im\u00e1genes Adicionales","allowed_images_jpg_png_jpeg":"(JPG,PNG,JPEG,SVG,WEBP)","article":"Art\u00edculo","article_with_images":"Un art\u00edculo con im\u00e1genes y videos incrustados.","article_with_open_ai":"Escriba su contenido usando OpenAI","audio":"Audio","category":"Categor\u00eda","choose_post_format":"Elija un formato de publicaci\u00f3n","collection_of_images":"colecci\u00f3n de im\u00e1genes","d&t":"Elegir fecha y hora","description":"Descripci\u00f3n","draft":"Guardar como borrador","edit_AI":"Editar post","edit_Article":"Editar art\u00edculo","edit_Audio":"Editar audio","edit_Gallery":"Editar galer\u00eda","edit_Sorted":"Editar lista de clasificaci\u00f3n","edit_Video":"Editar video","edit_post":"Editar post","featured":"Presentado","file":"Archivo","gallery":"Galer\u00eda","gallery_post_item":"Elemento de la lista de la galer\u00eda","get_video":"Obtener video de URL","image":"Imagen","image_description":"Descripci\u00f3n de la imagen","keywords":"Palabras clave","list_based_article":"Un art\u00edculo basado en una lista","open_ai":"Abierta ai","optional_url":"URL opcional","or_add_url":"o Agregar URL de imagen","personality_quiz":"Prueba de personalidad","post":"Publicaciones","post_type":"tipo de publicaci\u00f3n","posts":"Publicaciones","publish":"Publicar","publish_post":"Publicar publicaci\u00f3n","quizzes_with_custom_results":"Cuestionarios con resultados personalizados","quizzes_with_right_and_wrong_answers":"Cuestionarios con respuestas correctas e incorrectas","remove_on_headline":"Eliminar en el t\u00edtulo","remove_to_breaking":"Eliminar para romper","remove_to_featured":"Quitar a destacados","remove_to_recommended":"Quitar a Recomendado","remove_to_slider":"Quitar al control deslizante","scheduled_post":"Publicaci\u00f3n programada","select_image":"Seleccionar imagen","select_post_type":"Seleccionar tipo de publicaci\u00f3n","selected_file":"Archivos seleccionados","short_description":"Breve descripci\u00f3n","show_on_headline":"En Titular","show_registered_user":"Mostrar solo a usuarios registrados","show_right":"Mostrar columna derecha","sort_list":"Lista ordenada","sort_list_item":"Elemento de lista ordenado","spotted_video":"(Youtube, Vimeo, Dailymotion)","sub_category":"Subcategor\u00eda","submit":"Entregar","tag":"Etiqueta","thumbnail_image":"Por favor introduzca un URL v\u00e1lido","trivia_quiz":"Prueba de trivia","upload_audios_and_create_playlist":"Subir audios y crear listas de reproducci\u00f3n","upload_or_embed_videos":"Subir o insertar videos","upload_video":"Subir v\u00eddeo","video":"Video","video_embed_code":"C\u00f3digo de inserci\u00f3n de v\u00eddeo","video_thumbnail":"Miniatura de v\u00eddeo","video_url":"URL del v\u00eddeo","visibility":"Visibilidad"},"post_reaction":"Reacci\u00f3n posterior","reaction":{"angry":"Enojado","dislike":"Disgusto","funny":"Divertido","like":"Como","love":"Amar","pray":"Orar","sad":"Triste","super":"S\u00faper","wow":"Guau"},"recent_posts":"Mensajes recientes","required":"Requerida","role":{"add_role":"Agregar rol","edit_role":"Editar rol","permissions":"permisos","role":"Role","role_permissions":"Permisos de rol","select_all_permissions":"Seleccionar todos los permisos"},"roles":"roles","roles_permissions":"Permiso de funciones","rss-feed":"RSS Feed","rss_feed":{"add_posts":"Agregar publicaciones como borrador","add_rss_feed":"Agregar fuente Rss","auto_update":"Auto actualizaci\u00f3n","btn_text":"Leer m\u00e1s texto del bot\u00f3n","feed_name":"nombre de la alimentaci\u00f3n","feed_url":"URL para el canal","generate_keywords":"Generar palabras clave a partir del t\u00edtulo","images_source":"Fuente de im\u00e1genes","keywords":"Palabras clave","my_server":"Descargar im\u00e1genes a mi servidor","no":"No","no_posts":"Publicaci\u00f3n m\u00e1xima de importaci\u00f3n","original_source":"Mostrar im\u00e1genes de la fuente original","post_import":"Publicaciones\/Importar","scheduled_post_delete":"Eliminaci\u00f3n de publicaci\u00f3n programada","show_btn":"Mostrar bot\u00f3n Leer m\u00e1s","show_btn_text":"Mostrar bot\u00f3n","yes":"S\u00ed"},"save":"Save","search":"b\u00fasqueda","seo-tool":{"google_analytics":"Google analitico","home_title":"T\u00edtulo de la casa","keyword":"Palabra clave","language":"Idioma","maxkeyword":"Introduzca un m\u00e1ximo de 10 palabras clave","site_description":"descripci\u00f3n del lugar","site_title":"T\u00edtulo del sitio"},"seo-tools":"Herramientas SEO","service_categories":"Categor\u00edas de servicio","services":"Servicios","setting":{"Manually":"A mano","Paypal":"Paypal","Stripe":"Raya","about_text":"Acerca del texto","address":"Direcci\u00f3n","app_name":"Nombre de la aplicaci\u00f3n","cms":"CMS","contact_address":"direcci\u00f3n de contacto","contact_information":"Informaci\u00f3n del contacto","cookie_warning":"Advertencias de cookies","copy_right_text":"Texto de derechos de autor","currency":"Divisa","currency_settings":"Configuraci\u00f3n de moneda","facebook":"Facebook","facebook_url":"URL de facebook","favicon":"icono de favoritos","front_language":"Idioma frontal predeterminado","general":"General","general_details":"Detalles generales","generate_sitemap":"Generar mapa del sitio","google_recaptcha":"Recaptcha de Google","instagram_url":"URL de Instagram","invalid_facebook_url":"Introduce una URL de Facebook v\u00e1lida","invalid_instagram_url":"Introduce una URL de Instagram v\u00e1lida","invalid_linkedin_url":"Introduce una URL de LinkedIn v\u00e1lida","invalid_pinterest_url":"Introduce una URL de Pinterest v\u00e1lida","invalid_telegram_url":"Ingrese una URL de Telegram v\u00e1lida","invalid_twitter_url":"Ingrese una URL de Twitter v\u00e1lida","invalid_vk_url":"Ingrese una URL Vk v\u00e1lida","invalid_youtube_url":"Introduce una URL de Youtube v\u00e1lida","linkedIn":"LinkedIn","linkedin_url":"URL de LinkedIn","logo":"Logo","manual_payment_guide":"Gu\u00eda de pago manual","pinterest_url":"URL de Pinterest","postal_code":"C\u00f3digo postal","prefix":"Prefijo","privacy":"Privacidad","reddit":"Reddit","required_privacy":"El campo de privacidad es obligatorio","required_support":"El campo de soporte es requerido","required_t&c":"El campo de t\u00e9rminos y condiciones es obligatorio","rss_feed_auto_update":"Fuente RSS de actualizaci\u00f3n autom\u00e1tica","run_commend":"Ejecutar comando","secret_key":"Llave secreta","select_time":"Seleccionar hora","setting":"Entorno","show_captcha":"Mostrar recaptcha","show_cookie_warning":"Mostrar advertencias de cookies","site_key":"Clave del sitio","social_media_setting":"Configuraci\u00f3n de redes sociales","social_media_sharing":"Redes Sociales Compartidas","support":"Apoyo","telegram_url":"URL de telegrama","terms-conditions":"T\u00e9rminos y condiciones","twitter":"Gorjeo","twitter_url":"URL de Twitter","vk_url":"URL de VK","whatsapp":"Whatsapp","youtube_url":"URL de Youtube"},"settings":"Ajustes","share_this_post":"Compartir esta publicacion","show":"Show","staff":{"about_us":"Sobre nosotros","add_staff":"Agregar personal","confirm_password":"confirmar Contrase\u00f1a","contact_no":"N\u00famero de contacto","cover_image":"Imagen de portada","edit_staff":"Editar personal","email":"Correo electr\u00f3nico","email_verified":"Correo verificado","female":"Femenina","first_name":"Primer nombre","gender":"G\u00e9nero","last_name":"Apellido","male":"masculino","password":"Contrase\u00f1a","profile":"perfil","role":"Role","staff":"personal","username":"Nombre de usuario"},"staffs":"bastones","states":"estados","status":"Estado","sub_categories":"Subcategor\u00edas","sub_category":{"action":"Acci\u00f3n","add":"Agregar subcategor\u00eda","add_lan":"Idioma","category":"Categor\u00eda","edit":"Editar subcategor\u00eda","language":"Idioma","select_cat":"selecciona una categor\u00eda","show_menu":"Mostrar en el men\u00fa","title":"T\u00edtulo"},"subscribed_user":"Planes de usuario suscrito","subscriber":"Abonado","subscription":{"active_until":"Activo hasta","active_until_unlimited":"Activo hasta Ilimitado","amount":"Monto","cancel_subscription":"Cancelar suscripci\u00f3n","change_payment_status":"Cambiar el estado de pago","choose_plan":"Elija Plan","current_expire":"Plan actual vencido","current_plan":"Plan de prueba","currently_active":"Actualmente activo","days":"Dias","duration":"Duraci\u00f3n","end_date":"Fecha final","expired":"El plan ya venci\u00f3 el","expired_date":"Fecha de vencimiento","free":"Gratis","has_already_been_subscribed":"ya est\u00e1 suscrito","has_been_subscribed":"ha sido suscrito","history":"Historial de suscripciones","manage_subscription":"Administrar suscripci\u00f3n","months":"Meses","no_plan_available":"Ning\u00fan plan disponible","number_of_post":"N\u00famero de publicaci\u00f3n","pay_or_switch_plan":"Plan de pago\/cambio","payable_amount":"Cantidad a pagar","payment":"Pago","plan_name":"Nombre del plan","plan_price":"Precio del plan","proceed_to_payment":"Proceder al pago","purchase":"Compra","remaining":"Restante","remaining_balance":"Balance restante","remaining_days":"D\u00edas restantes","renew_free_plan":"El plan gratuito no se puede renovar\/elegir de nuevo","renew_plan":"Plan Renovar","start_date":"Fecha de inicio","subscribed_date":"Fecha de suscripci\u00f3n","switch_plan":"cambiar de plan","total_days":"D\u00edas totales","trial_plan":"Plan de prueba","upgrade_plan":"Plan de actualizaci\u00f3n","used_balance":"Saldo usado","used_days":"D\u00edas utilizados","what_in_startup_plan":"Qu\u00e9 hay en el plan de inicio","year":"A\u00f1o"},"sync":"sincronizar","translation_manager":"Gerente de traducci\u00f3n","user":{"account":"Cuenta","account_setting":"Configuraciones de la cuenta","avatar":"Avatar","change_password":"Cambia la contrase\u00f1a","confirm_password":"confirmar Contrase\u00f1a","contact_number":"N\u00famero de contacto","current_password":"contrase\u00f1a actual","email":"Correo electr\u00f3nico","full_name":"Nombre completo","gender":"G\u00e9nero","new_password":"Nueva contrase\u00f1a","profile":"Perfil","profile_details":"detalles del perfil","save_changes":"Guardar cambios","setting":"Entorno","staff_details":"Detalles del personal"},"users":"Usuarios","weekdays":{"fri":"VIE","mon":"LUN","sat":"S\u00e1b","sun":"SOL","thu":"JUE","tue":"MAR","wed":"Mi\u00e9"}},"es.pagination":{"next":"Pr\u00f3xima &raquo;","previous":"&laquo; Previa"},"es.passwords":{"reset":"\u00a1Tu contrase\u00f1a ha sido restablecida!","sent":"\u00a1Hemos enviado su enlace de restablecimiento de contrase\u00f1a por correo electr\u00f3nico!","throttled":"Espere antes de volver a intentarlo.","token":"Este token de restablecimiento de contrase\u00f1a no es v\u00e1lido.","user":"No podemos encontrar un usuario con esa direcci\u00f3n de correo electr\u00f3nico."},"es.validation":{"accepted":"El :attribute debe ser aceptado.","active_url":"El :attribute no es una URL v\u00e1lida.","after":"El :attribute debe ser una fecha despu\u00e9s de :date.","after_or_equal":"El :attribute debe ser una fecha posterior o igual a :date.","alpha":"El :attribute solo puede contener letras.","alpha_dash":"El :attribute solo puede contener letras, n\u00fameros, guiones y guiones bajos.","alpha_num":"El :attribute solo puede contener letras y n\u00fameros.","array":"El :attribute debe ser una matriz.","attributes":[],"before":"El :attribute debe ser una fecha anterior a :date.","before_or_equal":"El :attribute debe ser una fecha anterior o igual a :date.","between":{"array":"El :attribute debe tener entre :min y :art\u00edculos max.","file":"El :attribute debe estar entre :min y :max kilobytes.","numeric":"El :attribute debe estar entre :min y :max.","string":"El :attribute debe estar entre :min y :max caracteres."},"boolean":"El campo :attribute debe ser verdadero o falso.","confirmed":"La confirmaci\u00f3n de :attribute no coincide.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"El :attribute no es una fecha v\u00e1lida.","date_equals":"El :attribute debe ser una fecha igual a :date.","date_format":"El :attribute no coincide con el formato :format.","different":"El :attribute y :other deben ser diferentes.","digits":"El :attribute debe ser :digits d\u00edgitos.","digits_between":"El :attribute debe estar entre :min y :max d\u00edgitos.","dimensions":"El :attribute tiene dimensiones de imagen no v\u00e1lidas.","distinct":"El :attribute atributo tiene un valor duplicado.","email":"El :attribute debe ser una direcci\u00f3n de correo electr\u00f3nico v\u00e1lida.","ends_with":"El :attribute debe terminar con uno de los siguientes :values.","exists":"El :attribute seleccionado no es v\u00e1lido.","file":"El :attribute debe ser un archivo.","filled":"El campo :attribute debe tener un valor.","gt":{"array":"El :attribute debe tener m\u00e1s de elementos de :value.","file":"El :attribute debe ser mayor que :value kilobytes.","numeric":"El :attribute debe ser mayor que :value.","string":"El :attribute debe ser mayor que caracteres de :value."},"gte":{"array":"El :attribute debe tener elementos de :value o m\u00e1s.","file":"El :attribute debe ser mayor o igual :value kilobytes.","numeric":"El :attribute debe ser mayor o igual que :value.","string":"El :attribute debe ser mayor o igual que caracteres de :value."},"image":"El :attribute debe ser una imagen.","in":"El :attribute seleccionado no es v\u00e1lido.","in_array":"El campo :attribute no existe en :other.","integer":"El :attribute debe ser un entero.","ip":"El :attribute debe ser una direcci\u00f3n IP v\u00e1lida.","ipv4":"El :attribute debe ser una direcci\u00f3n IPv4 v\u00e1lida.","ipv6":"El :attribute debe ser una direcci\u00f3n IPv6 v\u00e1lida.","json":"El :attribute debe ser una cadena JSON v\u00e1lida.","lt":{"array":"El :attribute debe tener menos de elementos de :value.","file":"El :attribute debe ser menor que :value kilobytes.","numeric":"El :attribute debe ser menor que :value.","string":"El :attribute debe ser menor que caracteres de :value."},"lte":{"array":"El :attribute no debe tener m\u00e1s de elementos de :value.","file":"El :attribute debe ser menor o igual :value kilobytes.","numeric":"El :attribute debe ser menor o igual que :value.","string":"El :attribute debe ser menor o igual que caracteres de :value."},"max":{"array":"El :attribute no puede tener m\u00e1s de elementos :max.","file":"El :attribute no puede ser mayor que kilobytes :max.","numeric":"El :attribute no puede ser mayor que :max.","string":"El :attribute no puede ser mayor que caracteres :max."},"mimes":"El :attribute debe ser un archivo de tipo: :values.","mimetypes":"El :attribute debe ser un archivo de tipo: :values.","min":{"array":"El :attribute debe tener al menos elementos :min.","file":"El :attribute debe ser al menos :min kilobytes.","numeric":"El :attribute debe ser al menos :min.","string":"El :attribute debe tener al menos caracteres :min."},"not_in":"El :attribute seleccionado no es v\u00e1lido.","not_regex":"El formato del :attribute no es v\u00e1lido.","numeric":"El :attribute debe ser un n\u00famero.","password":"La contrase\u00f1a es incorrecta.","present":"El campo de :attribute debe estar presente.","regex":"El formato del :attribute no es v\u00e1lido.","required":"El campo de :attribute es obligatorio.","required_if":"El campo :attribute es obligatorio cuando :other es :value.","required_unless":"El campo :attribute es obligatorio a menos que :other est\u00e9 en :values.","required_with":"El campo :attribute es obligatorio cuando :values est\u00e1n presentes.","required_with_all":"El campo :attribute es obligatorio cuando los :values est\u00e1n presentes.","required_without":"El campo :attribute es obligatorio cuando los :values no est\u00e1n presentes.","required_without_all":"El campo :attribute es obligatorio cuando ninguno de los :values est\u00e1 presente.","same":"El :attribute y :other deben coincidir.","size":{"array":"El :attribute debe contener elementos de :size.","file":"El :attribute debe ser :size kilobytes.","numeric":"El :attribute debe ser :size.","string":"El :attribute debe ser caracteres de :size."},"starts_with":"El :attribute debe comenzar con uno de los siguientes :values.","string":"El :attribute debe ser una cadena.","timezone":"El :attribute debe ser una zona v\u00e1lida.","unique":"El :attribute ya se ha tomado.","uploaded":"El :attribute no se pudo cargar.","url":"El formato del :attribute no es v\u00e1lido.","uuid":"El :attribute debe ser un UUID v\u00e1lido."},"et.cookieConsent::texts":{"agree":"Sain aru","message":"Sellel veebilehel on kasutusel cookies-failid teie kasutajaliidese parandamiseks."},"fa.backup::notifications":{"application_name":"\u0646\u0627\u0645 \u0646\u0631\u0645 \u0627\u0641\u0632\u0627\u0631","backup_failed_body":"\u067e\u06cc\u063a\u0627\u0645 \u0645\u0647\u0645: \u0647\u0646\u06af\u0627\u0645 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u200c\u06af\u06cc\u0631\u06cc \u0627\u0632 :application_name \u062e\u0637\u0627\u06cc\u06cc \u0631\u062e \u062f\u0627\u062f\u0647 \u0627\u0633\u062a. ","backup_failed_subject":"\u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u200c\u06af\u06cc\u0631\u06cc :application_name \u0628\u0627 \u062e\u0637\u0627 \u0645\u0648\u0627\u062c\u0647 \u0634\u062f.","backup_name":"\u0646\u0627\u0645 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646","backup_successful_body":"\u062e\u0628\u0631 \u062e\u0648\u0628, \u0628\u0647 \u062a\u0627\u0632\u06af\u06cc \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0628\u0631 \u0631\u0648\u06cc \u062f\u06cc\u0633\u06a9 :disk_name \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0633\u0627\u062e\u062a\u0647 \u0634\u062f. ","backup_successful_subject":"\u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u062c\u062f\u06cc\u062f :application_name \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0633\u0627\u062e\u062a\u0647 \u0634\u062f.","backup_successful_subject_title":"\u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u200c\u06af\u06cc\u0631\u06cc \u0645\u0648\u0641\u0642!","cleanup_failed_body":"\u0647\u0646\u06af\u0627\u0645 \u067e\u0627\u06a9\u200c\u0633\u0627\u0632\u06cc \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u062e\u0637\u0627\u06cc\u06cc \u0631\u062e \u062f\u0627\u062f\u0647 \u0627\u0633\u062a.","cleanup_failed_subject":"\u067e\u0627\u06a9\u200c\u200c\u0633\u0627\u0632\u06cc \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f.","cleanup_successful_body":"\u067e\u0627\u06a9\u200c\u0633\u0627\u0632\u06cc \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0628\u0631 \u0631\u0648\u06cc \u062f\u06cc\u0633\u06a9 :disk_name \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0627\u0646\u062c\u0627\u0645 \u0634\u062f.","cleanup_successful_subject":"\u067e\u0627\u06a9\u200c\u0633\u0627\u0632\u06cc \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0628\u0627 \u0645\u0648\u0641\u0642\u06cc\u062a \u0627\u0646\u062c\u0627\u0645 \u0634\u062f.","cleanup_successful_subject_title":"\u067e\u0627\u06a9\u200c\u0633\u0627\u0632\u06cc \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646!","disk":"\u062f\u06cc\u0633\u06a9","exception_message":"\u067e\u06cc\u063a\u0627\u0645 \u062e\u0637\u0627: :message","exception_message_title":"\u067e\u06cc\u063a\u0627\u0645 \u062e\u0637\u0627","exception_trace":"\u062c\u0632\u06cc\u06cc\u0627\u062a \u062e\u0637\u0627: :trace","exception_trace_title":"\u062c\u0632\u06cc\u06cc\u0627\u062a \u062e\u0637\u0627","healthy_backup_found_body":"\u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0628\u0647 \u0646\u0638\u0631 \u0633\u0627\u0644\u0645 \u0645\u06cc\u0627\u062f. \u062f\u0645\u062a \u06af\u0631\u0645!","healthy_backup_found_subject":"\u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0628\u0631 \u0631\u0648\u06cc \u062f\u06cc\u0633\u06a9 :disk_name \u0633\u0627\u0644\u0645 \u0628\u0648\u062f.","healthy_backup_found_subject_title":"\u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0633\u0627\u0644\u0645 \u0628\u0648\u062f.","newest_backup_date":"\u062c\u062f\u06cc\u062f\u062a\u0631\u06cc\u0646 \u0627\u0646\u062f\u0627\u0632\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646","newest_backup_size":"\u062c\u062f\u06cc\u062f\u062a\u0631\u06cc\u0646 \u0627\u0646\u062f\u0627\u0632\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646","no_backups_info":"\u0647\u0646\u0648\u0632 \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u062a\u0647\u06cc\u0647 \u0646\u0634\u062f\u0647 \u0627\u0633\u062a","number_of_backups":"\u062a\u0639\u062f\u0627\u062f \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u06af\u06cc\u0631\u06cc","oldest_backup_date":"\u0642\u062f\u06cc\u0645\u06cc \u062a\u0631\u06cc\u0646 \u0627\u0646\u062f\u0627\u0632\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646","total_storage_used":"\u06a9\u0644 \u0641\u0636\u0627\u06cc \u0630\u062e\u06cc\u0631\u0647 \u0633\u0627\u0632\u06cc \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u062f\u0647","unhealthy_backup_found_body":"\u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0628\u0631 \u0631\u0648\u06cc \u062f\u06cc\u0633\u06a9 :disk_name \u0633\u0627\u0644\u0645 \u0646\u0628\u0648\u062f.","unhealthy_backup_found_empty":"\u0628\u0631\u0627\u06cc \u0627\u06cc\u0646 \u0628\u0631\u0646\u0627\u0645\u0647 \u0647\u06cc\u0686 \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u0648\u062c\u0648\u062f \u0646\u062f\u0627\u0631\u062f.","unhealthy_backup_found_full":"\u0646\u0633\u062e\u0647\u200c\u0647\u0627\u06cc \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u06cc \u06a9\u0647 \u062a\u0647\u06cc\u0647 \u06a9\u0631\u062f\u0647 \u0627\u06cc\u062f \u062d\u062c\u0645 \u0632\u06cc\u0627\u062f\u06cc \u0627\u0634\u063a\u0627\u0644 \u06a9\u0631\u062f\u0647 \u0627\u0646\u062f. \u0645\u06cc\u0632\u0627\u0646 \u062f\u06cc\u0633\u06a9 \u0627\u0633\u062a\u0641\u0627\u062f\u0647 \u0634\u062f\u0647 :disk_usage \u0627\u0633\u062a \u06a9\u0647 \u0627\u0632 \u0645\u06cc\u0632\u0627\u0646 \u0645\u062c\u0627\u0632 :disk_limit \u0641\u0631\u0627\u062a\u0631 \u0631\u0641\u062a\u0647 \u0627\u0633\u062a. ","unhealthy_backup_found_not_reachable":"\u0645\u0642\u0635\u062f \u067e\u0634\u062a\u06cc\u0628\u0627\u0646\u200c\u06af\u06cc\u0631\u06cc \u062f\u0631 \u062f\u0633\u062a\u0631\u0633 \u0646\u0628\u0648\u062f. :error","unhealthy_backup_found_old":"\u0622\u062e\u0631\u06cc\u0646 \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 \u0628\u0631\u0627\u06cc \u062a\u0627\u0631\u06cc\u062e :date \u0627\u0633\u062a. \u06a9\u0647 \u0628\u0647 \u0646\u0638\u0631 \u062e\u06cc\u0644\u06cc \u0642\u062f\u06cc\u0645\u06cc \u0645\u06cc\u0627\u062f. ","unhealthy_backup_found_subject":"\u062e\u0628\u0631 \u0645\u0647\u0645: \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0633\u0627\u0644\u0645 \u0646\u0628\u0648\u062f.","unhealthy_backup_found_subject_title":"\u062e\u0628\u0631 \u0645\u0647\u0645: \u0646\u0633\u062e\u0647 \u067e\u0634\u062a\u06cc\u0628\u0627\u0646 :application_name \u0633\u0627\u0644\u0645 \u0646\u0628\u0648\u062f. :problem","unhealthy_backup_found_unknown":"\u0645\u062a\u0627\u0633\u0641\u0627\u0646\u0647 \u062f\u0644\u06cc\u0644 \u062f\u0642\u06cc\u0642 \u0645\u0634\u062e\u0635 \u0646\u0634\u062f\u0647 \u0627\u0633\u062a."},"fi.backup::notifications":{"application_name":"Sovelluksen nimi","backup_failed_body":"HUOM!: :application_name varmuuskoipionnissa tapahtui virhe","backup_failed_subject":":application_name varmuuskopiointi ep\u00e4onnistui","backup_name":"Varmuuskopion nimi","backup_successful_body":"Hyvi\u00e4 uutisia! :application_name on varmuuskopioitu levylle :disk_name.","backup_successful_subject":":application_name varmuuskopioitu onnistuneesti","backup_successful_subject_title":"Uusi varmuuskopio!","cleanup_failed_body":":application_name varmuuskopioiden poistamisessa tapahtui virhe.","cleanup_failed_subject":":application_name varmuuskopioiden poistaminen ep\u00e4onnistui.","cleanup_successful_body":":application_name varmuuskopiot poistettu onnistuneesti levylt\u00e4 :disk_name.","cleanup_successful_subject":":application_name varmuuskopiot poistettu onnistuneesti","cleanup_successful_subject_title":"Varmuuskopiot poistettu onnistuneesti!","disk":"Levy","exception_message":"Virheilmoitus: :message","exception_message_title":"Virheilmoitus","exception_trace":"Virhe, j\u00e4ljitys: :trace","exception_trace_title":"Virheen j\u00e4ljitys","healthy_backup_found_body":":application_name varmuuskopiot ovat kunnossa. Hieno homma!","healthy_backup_found_subject":":application_name varmuuskopiot levyll\u00e4 :disk_name ovat kunnossa","healthy_backup_found_subject_title":":application_name varmuuskopiot ovat kunnossa","newest_backup_date":"Uusin varmuuskopion koko","newest_backup_size":"Uusin varmuuskopion koko","no_backups_info":"Varmuuskopioita ei viel\u00e4 tehty","number_of_backups":"Varmuuskopioiden m\u00e4\u00e4r\u00e4","oldest_backup_date":"Vanhin varmuuskopion koko","total_storage_used":"K\u00e4ytetty tallennustila yhteens\u00e4","unhealthy_backup_found_body":":application_name varmuuskopiot levyll\u00e4 :disk_name ovat vialliset.","unhealthy_backup_found_empty":"T\u00e4st\u00e4 sovelluksesta ei ole varmuuskopioita.","unhealthy_backup_found_full":"Varmuuskopiot viev\u00e4t liikaa levytilaa. T\u00e4ll\u00e4 hetkell\u00e4 k\u00e4yt\u00f6ss\u00e4 :disk_usage, mik\u00e4 on suurempi kuin sallittu tilavuus (:disk_limit).","unhealthy_backup_found_not_reachable":"Varmuuskopioiden kohdekansio ei ole saatavilla. :error","unhealthy_backup_found_old":"Viimeisin varmuuskopio, luotu :date, on liian vanha.","unhealthy_backup_found_subject":"HUOM!: :application_name varmuuskopiot ovat vialliset","unhealthy_backup_found_subject_title":"HUOM!: :application_name varmuuskopiot ovat vialliset. :problem","unhealthy_backup_found_unknown":"Virhe, tarkempaa tietoa syyst\u00e4 ei valitettavasti ole saatavilla."},"fr.backup::notifications":{"application_name":"Nom de l'application","backup_failed_body":"Important : Une erreur est survenue lors de la sauvegarde de :application_name","backup_failed_subject":"\u00c9chec de la sauvegarde de :application_name","backup_name":"Nom de la sauvegarde","backup_successful_body":"Bonne nouvelle, une nouvelle sauvegarde de :application_name a \u00e9t\u00e9 cr\u00e9\u00e9e avec succ\u00e8s sur le disque nomm\u00e9 :disk_name.","backup_successful_subject":"Succ\u00e8s de la sauvegarde de :application_name","backup_successful_subject_title":"Sauvegarde cr\u00e9\u00e9e avec succ\u00e8s !","cleanup_failed_body":"Une erreur est survenue lors du nettoyage des sauvegardes de :application_name","cleanup_failed_subject":"Le nettoyage des sauvegardes de :application_name a echou\u00e9.","cleanup_successful_body":"Le nettoyage des sauvegardes de :application_name sur le disque nomm\u00e9 :disk_name a \u00e9t\u00e9 effectu\u00e9 avec succ\u00e8s.","cleanup_successful_subject":"Succ\u00e8s du nettoyage des sauvegardes de :application_name","cleanup_successful_subject_title":"Sauvegardes nettoy\u00e9es avec succ\u00e8s !","disk":"Disque","exception_message":"Message de l'exception : :message","exception_message_title":"Message de l'exception","exception_trace":"Trace de l'exception : :trace","exception_trace_title":"Trace de l'exception","healthy_backup_found_body":"Les sauvegardes pour :application_name sont consid\u00e9r\u00e9es saines. Bon travail !","healthy_backup_found_subject":"Les sauvegardes pour :application_name sur le disque :disk_name sont saines","healthy_backup_found_subject_title":"Les sauvegardes pour :application_name sont saines","newest_backup_date":"Date de la sauvegarde la plus r\u00e9cente","newest_backup_size":"Taille de la sauvegarde la plus r\u00e9cente","no_backups_info":"Aucune sauvegarde n'a encore \u00e9t\u00e9 effectu\u00e9e","number_of_backups":"Nombre de sauvegardes","oldest_backup_date":"Date de la sauvegarde la plus ancienne","total_storage_used":"Stockage total utilis\u00e9","unhealthy_backup_found_body":"Les sauvegardes pour :application_name sur le disque :disk_name sont corrompues.","unhealthy_backup_found_empty":"Il n'y a aucune sauvegarde pour cette application.","unhealthy_backup_found_full":"Les sauvegardes utilisent trop d'espace disque. L'utilisation actuelle est de :disk_usage alors que la limite autoris\u00e9e est de :disk_limit.","unhealthy_backup_found_not_reachable":"La destination de la sauvegarde n'est pas accessible. :error","unhealthy_backup_found_old":"La derni\u00e8re sauvegarde du :date est consid\u00e9r\u00e9e trop vieille.","unhealthy_backup_found_subject":"Important : Les sauvegardes pour :application_name sont corrompues","unhealthy_backup_found_subject_title":"Important : Les sauvegardes pour :application_name sont corrompues. :problem","unhealthy_backup_found_unknown":"D\u00e9sol\u00e9, une raison exacte ne peut \u00eatre d\u00e9termin\u00e9e."},"fr.cookieConsent::texts":{"agree":"Accepter","message":"Ce site n\u00e9cessite l'autorisation de cookies pour fonctionner correctement."},"hi.backup::notifications":{"application_name":"\u0906\u0935\u0947\u0926\u0928 \u0915\u093e \u0928\u093e\u092e","backup_failed_body":"\u091c\u0930\u0942\u0930\u0940 \u0938\u0941\u091a\u0928\u093e: :application_name \u0915\u093e \u092c\u0948\u0915\u0905\u092a \u0932\u0947\u0924\u0947 \u0938\u092e\u092f \u0905\u0938\u092b\u0932 \u0930\u0939\u0947","backup_failed_subject":":application_name \u0915\u093e \u092c\u0948\u0915\u0905\u092a \u0905\u0938\u092b\u0932 \u0930\u0939\u093e","backup_name":"\u092c\u0948\u0915\u0905\u092a \u0928\u093e\u092e","backup_successful_body":"\u0916\u0941\u0936\u0916\u092c\u0930, :application_name \u0915\u093e \u092c\u0948\u0915\u0905\u092a :disk_name \u092a\u0930 \u0938\u0902\u0917\u094d\u0930\u0939\u093f\u0924 \u0915\u0930\u0928\u0947 \u092e\u0947 \u0938\u092b\u0932 \u0930\u0939\u0947.","backup_successful_subject":":application_name \u0915\u093e \u092c\u0948\u0915\u0905\u092a \u0938\u092b\u0932 \u0930\u0939\u093e","backup_successful_subject_title":"\u092c\u0948\u0915\u0905\u092a \u0938\u092b\u0932 \u0930\u0939\u093e!","cleanup_failed_body":":application_name \u0915\u0947 \u092c\u0948\u0915\u0905\u092a \u0915\u0940 \u0938\u092b\u093e\u0908 \u0915\u0930\u0924\u0947 \u0938\u092e\u092f \u0915\u0941\u091b \u092c\u093e\u0927\u093e \u0906\u092f\u0940 \u0939\u0948.","cleanup_failed_subject":":application_name \u0915\u0947 \u092c\u0948\u0915\u0905\u092a \u0915\u0940 \u0938\u092b\u093e\u0908 \u0905\u0938\u092b\u0932 \u0930\u0939\u0940.","cleanup_successful_body":":application_name \u0915\u093e \u092c\u0948\u0915\u0905\u092a \u091c\u094b :disk_name \u0928\u093e\u092e \u0915\u0940 \u0921\u093f\u0938\u094d\u0915 \u092a\u0930 \u0938\u0902\u0917\u094d\u0930\u0939\u093f\u0924 \u0939\u0948, \u0909\u0938\u0915\u0940 \u0938\u092b\u093e\u0908 \u0938\u092b\u0932 \u0930\u0939\u0940.","cleanup_successful_subject":":application_name \u0915\u0947 \u092c\u0948\u0915\u0905\u092a \u0915\u0940 \u0938\u092b\u093e\u0908 \u0938\u092b\u0932 \u0930\u0939\u0940","cleanup_successful_subject_title":"\u092c\u0948\u0915\u0905\u092a \u0915\u0940 \u0938\u092b\u093e\u0908 \u0938\u092b\u0932 \u0930\u0939\u0940!","disk":"\u0921\u093f\u0938\u094d\u0915","exception_message":"\u0905\u092a\u0935\u093e\u0926 \u0938\u0902\u0926\u0947\u0936: :message","exception_message_title":"\u0905\u092a\u0935\u093e\u0926\u0940 \u0938\u0902\u0926\u0947\u0936","exception_trace":"\u0905\u092a\u0935\u093e\u0926 \u0928\u093f\u0936\u093e\u0928: :trace","exception_trace_title":"\u0905\u092a\u0935\u093e\u0926 \u0928\u093f\u0936\u093e\u0928","healthy_backup_found_body":"\u092c\u0939\u0941\u0924 \u092c\u0922\u093c\u093f\u092f\u093e! :application_name \u0915\u0947 \u0938\u092d\u0940 \u092c\u0948\u0915\u0905\u092a \u0938\u094d\u0935\u0938\u094d\u0925 \u0939\u0948.","healthy_backup_found_subject":":disk_name \u0928\u093e\u092e \u0915\u0940 \u0921\u093f\u0938\u094d\u0915 \u092a\u0930 \u0938\u0902\u0917\u094d\u0930\u0939\u093f\u0924 :application_name \u0915\u0947 \u092c\u0948\u0915\u0905\u092a \u0938\u094d\u0935\u0938\u094d\u0925 \u0939\u0948","healthy_backup_found_subject_title":":application_name \u0915\u0947 \u0938\u092d\u0940 \u092c\u0948\u0915\u0905\u092a \u0938\u094d\u0935\u0938\u094d\u0925 \u0939\u0948","newest_backup_date":"\u0928\u0935\u0940\u0928\u0924\u092e \u092c\u0948\u0915\u0905\u092a \u0906\u0915\u093e\u0930","newest_backup_size":"\u0928\u0935\u0940\u0928\u0924\u092e \u092c\u0948\u0915\u0905\u092a \u0906\u0915\u093e\u0930","no_backups_info":"\u0905\u092d\u0940 \u0924\u0915 \u0915\u094b\u0908 \u092c\u0948\u0915\u0905\u092a \u0928\u0939\u0940\u0902 \u092c\u0928\u093e\u092f\u093e \u0917\u092f\u093e \u0925\u093e","number_of_backups":"\u092c\u0948\u0915\u0905\u092a \u0915\u0940 \u0938\u0902\u0916\u094d\u092f\u093e","oldest_backup_date":"\u0938\u092c\u0938\u0947 \u092a\u0941\u0930\u093e\u0928\u093e \u092c\u0948\u0915\u0905\u092a \u0906\u0915\u093e\u0930","total_storage_used":"\u0909\u092a\u092f\u094b\u0917 \u0915\u093f\u092f\u093e \u0917\u092f\u093e \u0915\u0941\u0932 \u0938\u0902\u0917\u094d\u0930\u0939\u0923","unhealthy_backup_found_body":":disk_name \u0928\u093e\u092e \u0915\u0940 \u0921\u093f\u0938\u094d\u0915 \u092a\u0930 \u0938\u0902\u0917\u094d\u0930\u0939\u093f\u0924 :application_name \u0915\u0947 \u092c\u0948\u0915\u0905\u092a \u0905\u0938\u094d\u0935\u0938\u094d\u0925 \u0939\u0948","unhealthy_backup_found_empty":"\u0907\u0938 \u090f\u092a\u094d\u0932\u0940\u0915\u0947\u0936\u0928 \u0915\u093e \u0915\u094b\u0908 \u092d\u0940 \u092c\u0948\u0915\u0905\u092a \u0928\u0939\u0940\u0902 \u0939\u0948.","unhealthy_backup_found_full":"\u0938\u092d\u0940 \u092c\u0948\u0915\u0905\u092a \u092c\u0939\u0941\u0924 \u091c\u094d\u092f\u093e\u0926\u093e \u091c\u0917\u0939 \u0915\u093e \u0909\u092a\u092f\u094b\u0917 \u0915\u0930 \u0930\u0939\u0947 \u0939\u0948. \u095e\u093f\u0932\u0939\u093e\u0932 \u0938\u092d\u0940 \u092c\u0948\u0915\u0905\u092a :disk_usage \u091c\u0917\u0939 \u0915\u093e \u0909\u092a\u092f\u094b\u0917 \u0915\u0930 \u0930\u0939\u0947 \u0939\u0948, \u091c\u094b \u0915\u0940 :disk_limit \u0905\u0928\u0941\u092e\u0924\u093f \u0938\u0940\u092e\u093e \u0938\u0947 \u0905\u0927\u093f\u0915 \u0915\u093e \u0939\u0948.","unhealthy_backup_found_not_reachable":":error \u0915\u0947 \u092c\u091c\u0947\u0938\u0947 \u092c\u0948\u0915\u0905\u092a \u0915\u0940 \u092e\u0902\u091c\u093f\u0932 \u0924\u0915 \u092a\u094b\u0939\u094b\u091a \u0928\u0939\u0940\u0902 \u0938\u0915\u0924\u0947.","unhealthy_backup_found_old":"\u0939\u093e\u0932\u0939\u0940\u092e\u0947\u0902 :date \u0915\u094b \u0932\u093f\u092f\u093e \u0939\u0941\u0906 \u092c\u0948\u0915\u0905\u092a \u092c\u0939\u0941\u0924 \u092a\u0941\u0930\u093e\u0928\u093e \u0939\u0948.","unhealthy_backup_found_subject":"\u091c\u0930\u0942\u0930\u0940 \u0938\u0941\u091a\u0928\u093e :  :application_name \u0915\u0947 \u092c\u0948\u0915\u0905\u092a \u0905\u0938\u094d\u0935\u0938\u094d\u0925 \u0939\u0948","unhealthy_backup_found_subject_title":"\u091c\u0930\u0942\u0930\u0940 \u0938\u0941\u091a\u0928\u093e : :application_name \u0915\u0947 \u092c\u0948\u0915\u0905\u092a :problem \u0915\u0947 \u092c\u091c\u0947\u0938\u0947 \u0905\u0938\u094d\u0935\u0938\u094d\u0925 \u0939\u0948","unhealthy_backup_found_unknown":"\u092e\u093e\u092b\u093c \u0915\u0940\u091c\u093f\u092f\u0947, \u0938\u0939\u0940 \u0915\u093e\u0930\u0923 \u0928\u093f\u0930\u094d\u0927\u093e\u0930\u093f\u0924 \u0928\u0939\u0940\u0902 \u0915\u0930 \u0938\u0915\u0924\u0947."},"hu.cookieConsent::texts":{"agree":"S\u00fctik enged\u00e9lyez\u00e9se","message":"A megfelel\u0151 \u00e9lm\u00e9ny biztos\u00edt\u00e1s\u00e1hoz s\u00fctikre van sz\u00fcks\u00e9g."},"id.backup::notifications":{"application_name":"Nama aplikasi","backup_failed_body":"Penting: Sebuah error terjadi ketika membackup :application_name","backup_failed_subject":"Gagal backup :application_name","backup_name":"Nama cadangan","backup_successful_body":"Kabar baik, sebuah backup baru dari :application_name sukses dibuat pada disk bernama :disk_name.","backup_successful_subject":"Backup baru sukses dari :application_name","backup_successful_subject_title":"Backup baru sukses!","cleanup_failed_body":"Sebuah error teradi ketika membersihkan backup dari :application_name","cleanup_failed_subject":"Membersihkan backup dari :application_name yang gagal.","cleanup_successful_body":"Pembersihan backup :application_name pada disk bernama :disk_name telah sukses.","cleanup_successful_subject":"Sukses membersihkan backup :application_name","cleanup_successful_subject_title":"Sukses membersihkan backup!","disk":"Disk","exception_message":"Pesan pengecualian: :message","exception_message_title":"Pesan pengecualian","exception_trace":"Jejak pengecualian: :trace","exception_trace_title":"Jejak pengecualian","healthy_backup_found_body":"Backup untuk :application_name dipertimbangkan sehat. Kerja bagus!","healthy_backup_found_subject":"Backup untuk :application_name pada disk :disk_name sehat","healthy_backup_found_subject_title":"Backup untuk :application_name sehat","newest_backup_date":"Ukuran cadangan terbaru","newest_backup_size":"Ukuran cadangan terbaru","no_backups_info":"Belum ada backup yang dibuat","number_of_backups":"Jumlah cadangan","oldest_backup_date":"Ukuran cadangan tertua","total_storage_used":"Total penyimpanan yang digunakan","unhealthy_backup_found_body":"Backup untuk :application_name pada disk :disk_name tidak sehat.","unhealthy_backup_found_empty":"Tidak ada backup pada aplikasi ini sama sekali.","unhealthy_backup_found_full":"Backup menggunakan terlalu banyak kapasitas penyimpanan. Penggunaan terkini adalah :disk_usage dimana lebih besar dari batas yang diperbolehkan yaitu :disk_limit.","unhealthy_backup_found_not_reachable":"Tujuan backup tidak dapat terjangkau. :error","unhealthy_backup_found_old":"Backup terakhir dibuat pada :date dimana dipertimbahkan sudah sangat lama.","unhealthy_backup_found_subject":"Penting: Backup untuk :application_name tidak sehat","unhealthy_backup_found_subject_title":"Penting: Backup untuk :application_name tidak sehat. :problem","unhealthy_backup_found_unknown":"Maaf, sebuah alasan persisnya tidak dapat ditentukan."},"id.cookieConsent::texts":{"agree":"Izikan Cookies","message":"Pengalaman anda pada situs ini akan meningkat dengan cara mengizinkan cookies."},"it.backup::notifications":{"application_name":"Nome dell'applicazione","backup_failed_body":"Importante: Si \u00e8 verificato un errore durante il backup di :application_name","backup_failed_subject":"Fallito il backup di :application_name","backup_name":"Nome di backup","backup_successful_body":"Grande notizia, un nuovo backup di :application_name \u00e8 stato creato con successo sul disco :disk_name.","backup_successful_subject":"Creato nuovo backup di :application_name","backup_successful_subject_title":"Nuovo backup creato!","cleanup_failed_body":"Si \u00e8 verificato un errore durante la pulizia dei backup di :application_name","cleanup_failed_subject":"Pulizia dei backup di :application_name fallita.","cleanup_successful_body":"La pulizia dei backup di :application_name sul disco :disk_name \u00e8 avvenuta con successo.","cleanup_successful_subject":"Pulizia dei backup di :application_name avvenuta con successo","cleanup_successful_subject_title":"Pulizia dei backup avvenuta con successo!","disk":"Disco","exception_message":"Messaggio dell'eccezione: :message","exception_message_title":"Messaggio dell'eccezione","exception_trace":"Traccia dell'eccezione: :trace","exception_trace_title":"Traccia dell'eccezione","healthy_backup_found_body":"I backup per :application_name sono considerati sani. Bel Lavoro!","healthy_backup_found_subject":"I backup per :application_name sul disco :disk_name sono sani","healthy_backup_found_subject_title":"I backup per :application_name sono sani","newest_backup_date":"Data del backup pi\u00f9 recente","newest_backup_size":"Dimensione backup pi\u00f9 recente","no_backups_info":"Non sono stati ancora effettuati backup","number_of_backups":"Numero di backup","oldest_backup_date":"Data del backup pi\u00f9 vecchio","total_storage_used":"Spazio di archiviazione totale utilizzato","unhealthy_backup_found_body":"I backup per :application_name sul disco :disk_name sono corrotti.","unhealthy_backup_found_empty":"Non esiste alcun backup di questa applicazione.","unhealthy_backup_found_full":"I backup utilizzano troppa memoria. L'utilizzo corrente \u00e8 :disk_usage che \u00e8 superiore al limite consentito di :disk_limit.","unhealthy_backup_found_not_reachable":"Impossibile raggiungere la destinazione di backup. :error","unhealthy_backup_found_old":"L'ultimo backup fatto il :date \u00e8 considerato troppo vecchio.","unhealthy_backup_found_subject":"Importante: i backup per :application_name sono corrotti","unhealthy_backup_found_subject_title":"Importante: i backup per :application_name sono corrotti. :problem","unhealthy_backup_found_unknown":"Spiacenti, non \u00e8 possibile determinare una ragione esatta."},"it.cookieConsent::texts":{"agree":"Consenti i cookies","message":"Questo sito utilizza i cookies per offrire un'esperienza migliore all'utente."},"ja.backup::notifications":{"application_name":"\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u540d","backup_failed_body":"\u91cd\u8981: :application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002","backup_failed_subject":":application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002","backup_name":"\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u540d","backup_successful_body":"\u6717\u5831\u3067\u3059\u3002\u30c7\u30a3\u30b9\u30af :disk_name \u3078 :application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304c\u6210\u529f\u3057\u307e\u3057\u305f\u3002","backup_successful_subject":":application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002","backup_successful_subject_title":"\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u6210\u529f\u3057\u307e\u3057\u305f\uff01","cleanup_failed_body":":application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u524a\u9664\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002","cleanup_failed_subject":":application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002","cleanup_successful_body":"\u30c7\u30a3\u30b9\u30af :disk_name \u306b\u4fdd\u5b58\u3055\u308c\u305f :application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u524a\u9664\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002","cleanup_successful_subject":":application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u524a\u9664\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002","cleanup_successful_subject_title":"\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u524a\u9664\u306b\u6210\u529f\u3057\u307e\u3057\u305f\uff01","disk":"\u30c7\u30a3\u30b9\u30af","exception_message":"\u4f8b\u5916\u306e\u30e1\u30c3\u30bb\u30fc\u30b8: :message","exception_message_title":"\u4f8b\u5916\u306e\u30e1\u30c3\u30bb\u30fc\u30b8","exception_trace":"\u4f8b\u5916\u306e\u8ffd\u8de1: :trace","exception_trace_title":"\u4f8b\u5916\u306e\u8ffd\u8de1","healthy_backup_found_body":":application_name \u3078\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306f\u6b63\u5e38\u3067\u3059\u3002\u3044\u3044\u4ed5\u4e8b\u3057\u3066\u307e\u3059\u306d\uff01","healthy_backup_found_subject":"\u30c7\u30a3\u30b9\u30af :disk_name \u3078\u306e :application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306f\u6b63\u5e38\u3067\u3059\u3002","healthy_backup_found_subject_title":":application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306f\u6b63\u5e38\u3067\u3059\u3002","newest_backup_date":"\u6700\u65b0\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u65e5\u6642","newest_backup_size":"\u6700\u65b0\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u30b5\u30a4\u30ba","no_backups_info":"\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306f\u307e\u3060\u4f5c\u6210\u3055\u308c\u3066\u3044\u307e\u305b\u3093","number_of_backups":"\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u6570","oldest_backup_date":"\u6700\u3082\u53e4\u3044\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u65e5\u6642","total_storage_used":"\u4f7f\u7528\u3055\u308c\u305f\u5408\u8a08\u30b9\u30c8\u30ec\u30fc\u30b8","unhealthy_backup_found_body":":disk_name \u3078\u306e :application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u7570\u5e38\u304c\u3042\u308a\u307e\u3059\u3002","unhealthy_backup_found_empty":"\u3053\u306e\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002","unhealthy_backup_found_full":"\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304c\u30c7\u30a3\u30b9\u30af\u5bb9\u91cf\u3092\u5727\u8feb\u3057\u3066\u3044\u307e\u3059\u3002\u73fe\u5728\u306e\u4f7f\u7528\u91cf :disk_usage\u3000\u306f\u3001\u8a31\u53ef\u3055\u308c\u305f\u9650\u754c\u5024 :disk_limit \u3092\u8d85\u3048\u3066\u3044\u307e\u3059\u3002","unhealthy_backup_found_not_reachable":"\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u5148\u306b\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 :error","unhealthy_backup_found_old":":date \u306b\u4fdd\u5b58\u3055\u308c\u305f\u76f4\u8fd1\u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u304c\u53e4\u3059\u304e\u307e\u3059\u3002","unhealthy_backup_found_subject":"\u91cd\u8981: :application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u7570\u5e38\u304c\u3042\u308a\u307e\u3059\u3002","unhealthy_backup_found_subject_title":"\u91cd\u8981: :application_name \u306e\u30d0\u30c3\u30af\u30a2\u30c3\u30d7\u306b\u7570\u5e38\u304c\u3042\u308a\u307e\u3059\u3002 :problem","unhealthy_backup_found_unknown":"\u7533\u3057\u8a33\u3054\u3056\u3044\u307e\u305b\u3093\u3002\u4e88\u671f\u305b\u306c\u30a8\u30e9\u30fc\u3067\u3059\u3002"},"kr.cookieConsent::texts":{"agree":"\ucfe0\ud0a4 \ud5c8\uc6a9","message":"\ubcf4\ub2e4 \ub098\uc740 \uc0ac\uc6a9\uc790 \uacbd\ud5d8\uc744 \uc704\ud574 \ucfe0\ud0a4\ub97c \ud5c8\uc6a9\ud574 \uc8fc\uc2ed\uc2dc\uc694."},"mk.cookieConsent::texts":{"agree":"\u0414\u043e\u0437\u0432\u043e\u043b\u0438","message":"\u0412\u0430\u0448\u0435\u0442\u043e \u0438\u0441\u043a\u0443\u0441\u0442\u0432\u043e \u043d\u0430 \u043e\u0432\u0430\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u045c\u0435 \u0441\u0435 \u043f\u043e\u0434\u043e\u0431\u0440\u0438 \u0441\u043e \u0434\u043e\u0437\u0432\u043e\u043b\u0443\u0432\u0430\u045a\u0435 \u043a\u043e\u043b\u0430\u0447\u0438\u045a\u0430"},"nb.cookieConsent::texts":{"agree":"Jeg forst\u00e5r","message":"Vi bruker informasjonskapsler (cookies) som lagres i nettleseren din n\u00e5r du bes\u00f8ker nettsiden v\u00e5r. Ved \u00e5 fortsette \u00e5 bes\u00f8ke nettsiden v\u00e5r eller bruke tjenestene v\u00e5re, godtar du at vi bruker informasjonskapsler."},"nl.backup::notifications":{"application_name":"Naam van de toepassing","backup_failed_body":"Belangrijk: Er ging iets fout tijdens het maken van een back-up van :application_name","backup_failed_subject":"Back-up van :application_name mislukt","backup_name":"Back-upnaam","backup_successful_body":"Goed nieuws, een nieuwe back-up van :application_name was succesvol aangemaakt op de schijf genaamd :disk_name.","backup_successful_subject":"Succesvolle nieuwe back-up van :application_name","backup_successful_subject_title":"Succesvolle nieuwe back-up!","cleanup_failed_body":"Er ging iets fout tijdens het opschonen van de back-ups van :application_name","cleanup_failed_subject":"Het opschonen van de back-ups van :application_name is mislukt.","cleanup_successful_body":"Het opschonen van de :application_name back-ups op de schijf genaamd :disk_name was succesvol.","cleanup_successful_subject":"Opschonen van :application_name back-ups was succesvol.","cleanup_successful_subject_title":"Opschonen van back-ups was succesvol!","disk":"Schijf","exception_message":"Fout bericht: :message","exception_message_title":"Fout bericht","exception_trace":"Fout trace: :trace","exception_trace_title":"Fout trace","healthy_backup_found_body":"De back-ups voor :application_name worden als gezond beschouwd. Goed gedaan!","healthy_backup_found_subject":"De back-ups voor :application_name op schijf :disk_name zijn gezond","healthy_backup_found_subject_title":"De back-ups voor :application_name zijn gezond","newest_backup_date":"Datum nieuwste back-up","newest_backup_size":"Nieuwste back-upgrootte","no_backups_info":"Er zijn nog geen back-ups gemaakt","number_of_backups":"Aantal back-ups","oldest_backup_date":"Datum oudste back-up","total_storage_used":"Totale gebruikte opslagruimte","unhealthy_backup_found_body":"De back-ups voor :application_name op schijf :disk_name zijn niet gezond.","unhealthy_backup_found_empty":"Er zijn geen back-ups van deze applicatie beschikbaar.","unhealthy_backup_found_full":"De back-ups gebruiken te veel opslagruimte. Momenteel wordt er :disk_usage gebruikt wat hoger is dan de toegestane limiet van :disk_limit.","unhealthy_backup_found_not_reachable":"De back-upbestemming kon niet worden bereikt. :error","unhealthy_backup_found_old":"De laatste back-up gemaakt op :date is te oud.","unhealthy_backup_found_subject":"Belangrijk: De back-ups voor :application_name zijn niet meer gezond","unhealthy_backup_found_subject_title":"Belangrijk: De back-ups voor :application_name zijn niet gezond. :problem","unhealthy_backup_found_unknown":"Sorry, een exacte reden kon niet worden bepaald."},"nl.cookieConsent::texts":{"agree":"Sta cookies toe","message":"Uw ervaring op deze site wordt verbeterd door het gebruik van cookies."},"no.backup::notifications":{"application_name":"Programnavn","backup_failed_body":"Viktg: En feil oppstod under backing av :application_name","backup_failed_subject":"Backup feilet for :application_name","backup_name":"Navn p\u00e5 sikkerhetskopi","backup_successful_body":"Gode nyheter, en ny backup av :application_name ble opprettet p\u00e5 disken :disk_name.","backup_successful_subject":"Gjennomf\u00f8rt backup av :application_name","backup_successful_subject_title":"Gjennomf\u00f8rt backup!","cleanup_failed_body":"En feil oppstod under opprydding av backups for :application_name","cleanup_failed_subject":"Opprydding av backup for :application_name feilet.","cleanup_successful_body":"Oppryddingen av backup for :application_name p\u00e5 disken :disk_name har blitt gjennomf\u00f8rt.","cleanup_successful_subject":"Opprydding av backup for :application_name gjennomf\u00f8rt","cleanup_successful_subject_title":"Opprydding av backup gjennomf\u00f8rt!","disk":"Disk","exception_message":"Exception: :message","exception_message_title":"Exception","exception_trace":"Exception trace: :trace","exception_trace_title":"Exception trace","healthy_backup_found_body":"Alle backups for :application_name er ok. Godt jobba!","healthy_backup_found_subject":"Alle backups for :application_name p\u00e5 disken :disk_name er OK","healthy_backup_found_subject_title":"Alle backups for :application_name er OK","newest_backup_date":"Nyeste backup-st\u00f8rrelse","newest_backup_size":"Nyeste backup-st\u00f8rrelse","no_backups_info":"Ingen sikkerhetskopier ble gjort enn\u00e5","number_of_backups":"Antall sikkerhetskopier","oldest_backup_date":"Eldste sikkerhetskopist\u00f8rrelse","total_storage_used":"Total lagring brukt","unhealthy_backup_found_body":"Backups for :application_name p\u00e5 disken :disk_name er ikke OK.","unhealthy_backup_found_empty":"Denne applikasjonen mangler backups.","unhealthy_backup_found_full":"Backups bruker for mye lagringsplass. N\u00e5v\u00e6rende diskbruk er :disk_usage, som er mer enn den tillatte grensen p\u00e5 :disk_limit.","unhealthy_backup_found_not_reachable":"Kunne ikke finne backup-destinasjonen. :error","unhealthy_backup_found_old":"Den siste backupem fra :date er for gammel.","unhealthy_backup_found_subject":"Viktig: Backups for :application_name ikke OK","unhealthy_backup_found_subject_title":"Viktig: Backups for :application_name er ikke OK. :problem","unhealthy_backup_found_unknown":"Beklager, kunne ikke finne n\u00f8yaktig \u00e5rsak."},"pl.backup::notifications":{"application_name":"Nazwa aplikacji","backup_failed_body":"Wa\u017cne: Wyst\u0105pi\u0142 b\u0142\u0105d podczas tworzenia kopii zapasowej aplikacji :application_name","backup_failed_subject":"Tworzenie kopii zapasowej aplikacji :application_name nie powiod\u0142o si\u0119","backup_name":"Nazwa kopii zapasowej","backup_successful_body":"Wspania\u0142a wiadomo\u015b\u0107, nowa kopia zapasowa aplikacji :application_name zosta\u0142a pomy\u015blnie utworzona na dysku o nazwie :disk_name.","backup_successful_subject":"Pomy\u015blnie utworzono kopi\u0119 zapasow\u0105 aplikacji :application_name","backup_successful_subject_title":"Nowa kopia zapasowa!","cleanup_failed_body":"Wyst\u0105pi\u0142 b\u0142\u0105d podczas czyszczenia kopii zapasowej aplikacji :application_name","cleanup_failed_subject":"Czyszczenie kopii zapasowych aplikacji :application_name nie powiod\u0142o si\u0119.","cleanup_successful_body":"Czyszczenie kopii zapasowych aplikacji :application_name na dysku :disk_name zako\u0144czone sukcesem.","cleanup_successful_subject":"Kopie zapasowe aplikacji :application_name zosta\u0142y pomy\u015blnie wyczyszczone","cleanup_successful_subject_title":"Kopie zapasowe zosta\u0142y pomy\u015blnie wyczyszczone!","disk":"Dysk","exception_message":"B\u0142\u0105d: :message","exception_message_title":"B\u0142\u0105d","exception_trace":"Zrzut b\u0142\u0119du: :trace","exception_trace_title":"Zrzut b\u0142\u0119du","healthy_backup_found_body":"Kopie zapasowe aplikacji :application_name s\u0105 poprawne. Dobra robota!","healthy_backup_found_subject":"Kopie zapasowe aplikacji :application_name na dysku :disk_name s\u0105 poprawne","healthy_backup_found_subject_title":"Kopie zapasowe aplikacji :application_name s\u0105 poprawne","newest_backup_date":"Najnowszy rozmiar kopii zapasowej","newest_backup_size":"Najnowszy rozmiar kopii zapasowej","no_backups_info":"Nie utworzono jeszcze kopii zapasowych","number_of_backups":"Liczba kopii zapasowych","oldest_backup_date":"Najstarszy rozmiar kopii zapasowej","total_storage_used":"Ca\u0142kowite wykorzystane miejsce","unhealthy_backup_found_body":"Kopie zapasowe aplikacji :application_name na dysku :disk_name s\u0105 niepoprawne.","unhealthy_backup_found_empty":"W aplikacji nie ma \u017cadnej kopii zapasowych tej aplikacji.","unhealthy_backup_found_full":"Kopie zapasowe zajmuj\u0105 zbyt du\u017co miejsca. Obecne u\u017cycie dysku :disk_usage jest wi\u0119ksze od ustalonego limitu :disk_limit.","unhealthy_backup_found_not_reachable":"Miejsce docelowe kopii zapasowej nie jest osi\u0105galne. :error","unhealthy_backup_found_old":"Ostatnia kopia zapasowa wykonania dnia :date jest zbyt stara.","unhealthy_backup_found_subject":"Wa\u017cne: Kopie zapasowe aplikacji :application_name s\u0105 niepoprawne","unhealthy_backup_found_subject_title":"Wa\u017cne: Kopie zapasowe aplikacji :application_name s\u0105 niepoprawne. :problem","unhealthy_backup_found_unknown":"Niestety, nie mo\u017cna ustali\u0107 dok\u0142adnego b\u0142\u0119du."},"pl.cookieConsent::texts":{"agree":"Zezwalaj na cookie","message":"Twoje do\u015bwiadczenia na tej witrynie b\u0119d\u0105 lepsze dzi\u0119ki cookies."},"pt-BR.backup::notifications":{"application_name":"Nome da Aplica\u00e7\u00e3o","backup_failed_body":"Importante: Ocorreu um erro ao fazer o backup da aplica\u00e7\u00e3o :application_name","backup_failed_subject":"Falha no backup da aplica\u00e7\u00e3o :application_name","backup_name":"Nome de backup","backup_successful_body":"Boas not\u00edcias, um novo backup da aplica\u00e7\u00e3o :application_name foi criado no disco :disk_name.","backup_successful_subject":"Backup realizado com sucesso: :application_name","backup_successful_subject_title":"Backup Realizado com sucesso!","cleanup_failed_body":"Um erro ocorreu ao fazer a limpeza dos backups da aplica\u00e7\u00e3o :application_name","cleanup_failed_subject":"Falha na limpeza dos backups da aplica\u00e7\u00e3o :application_name.","cleanup_successful_body":"A limpeza dos backups da aplica\u00e7\u00e3o :application_name no disco :disk_name foi conclu\u00edda.","cleanup_successful_subject":"Limpeza dos backups da aplica\u00e7\u00e3o :application_name conclu\u00edda!","cleanup_successful_subject_title":"Limpeza dos backups conclu\u00edda!","disk":"Disco","exception_message":"Exception message: :message","exception_message_title":"Exception message","exception_trace":"Exception trace: :trace","exception_trace_title":"Exception trace","healthy_backup_found_body":"Os backups da aplica\u00e7\u00e3o :application_name est\u00e3o em dia. Bom trabalho!","healthy_backup_found_subject":"Os backups da aplica\u00e7\u00e3o :application_name no disco :disk_name est\u00e3o em dia","healthy_backup_found_subject_title":"Os backups da aplica\u00e7\u00e3o :application_name est\u00e3o em dia","newest_backup_date":"Data do backup mais recente","newest_backup_size":"Tamanho do backup mais recente","no_backups_info":"Nenhum backup foi feito ainda","number_of_backups":"N\u00famero de backups","oldest_backup_date":"Data do backup mais antigo","total_storage_used":"Armazenamento total usado","unhealthy_backup_found_body":"Os backups da aplica\u00e7\u00e3o :application_name no disco :disk_name n\u00e3o est\u00e3o em dia.","unhealthy_backup_found_empty":"N\u00e3o existem backups para essa aplica\u00e7\u00e3o.","unhealthy_backup_found_full":"Os backups est\u00e3o usando muito espa\u00e7o de armazenamento. A utiliza\u00e7\u00e3o atual \u00e9 de :disk_usage, o que \u00e9 maior que o limite permitido de :disk_limit.","unhealthy_backup_found_not_reachable":"O destino dos backups n\u00e3o pode ser alcan\u00e7ado. :error","unhealthy_backup_found_old":"O \u00faltimo backup realizado em :date \u00e9 considerado muito antigo.","unhealthy_backup_found_subject":"Importante: Os backups da aplica\u00e7\u00e3o :application_name n\u00e3o est\u00e3o em dia","unhealthy_backup_found_subject_title":"Importante: Os backups da aplica\u00e7\u00e3o :application_name n\u00e3o est\u00e3o em dia. :problem","unhealthy_backup_found_unknown":"Desculpe, a exata raz\u00e3o n\u00e3o pode ser encontrada."},"pt.backup::notifications":{"application_name":"Nome da Aplica\u00e7\u00e3o","backup_failed_body":"Importante: Ocorreu um erro ao executar o backup da aplica\u00e7\u00e3o :application_name","backup_failed_subject":"Falha no backup da aplica\u00e7\u00e3o :application_name","backup_name":"Nome de backup","backup_successful_body":"Boas not\u00edcias, foi criado um novo backup no disco :disk_name referente \u00e0 aplica\u00e7\u00e3o :application_name.","backup_successful_subject":"Backup realizado com sucesso: :application_name","backup_successful_subject_title":"Backup Realizado com Sucesso!","cleanup_failed_body":"Ocorreu um erro ao executar a limpeza dos backups da aplica\u00e7\u00e3o :application_name","cleanup_failed_subject":"Falha na limpeza dos backups da aplica\u00e7\u00e3o :application_name.","cleanup_successful_body":"Conclu\u00edda a limpeza dos backups da aplica\u00e7\u00e3o :application_name no disco :disk_name.","cleanup_successful_subject":"Limpeza dos backups da aplica\u00e7\u00e3o :application_name conclu\u00edda!","cleanup_successful_subject_title":"Limpeza dos backups conclu\u00edda!","disk":"Disco","exception_message":"Exception message: :message","exception_message_title":"Exception message","exception_trace":"Exception trace: :trace","exception_trace_title":"Exception trace","healthy_backup_found_body":"Os backups da aplica\u00e7\u00e3o :application_name est\u00e3o em dia. Bom trabalho!","healthy_backup_found_subject":"Os backups da aplica\u00e7\u00e3o :application_name no disco :disk_name est\u00e3o em dia","healthy_backup_found_subject_title":"Os backups da aplica\u00e7\u00e3o :application_name est\u00e3o em dia","newest_backup_date":"Tamanho de backup mais recente","newest_backup_size":"Tamanho de backup mais recente","no_backups_info":"Nenhum backup foi feito ainda","number_of_backups":"N\u00famero de backups","oldest_backup_date":"Tamanho de backup mais antigo","total_storage_used":"Armazenamento total usado","unhealthy_backup_found_body":"Os backups da aplica\u00e7\u00e3o :application_name no disco :disk_name n\u00e3o est\u00e3o em dia.","unhealthy_backup_found_empty":"N\u00e3o existem backups para essa aplica\u00e7\u00e3o.","unhealthy_backup_found_full":"Os backups est\u00e3o a utilizar demasiado espa\u00e7o de armazenamento. A utiliza\u00e7\u00e3o atual \u00e9 de :disk_usage, o que \u00e9 maior que o limite permitido de :disk_limit.","unhealthy_backup_found_not_reachable":"O destino dos backups n\u00e3o pode ser alcan\u00e7ado. :error","unhealthy_backup_found_old":"O \u00faltimo backup realizado em :date \u00e9 demasiado antigo.","unhealthy_backup_found_subject":"Importante: Os backups da aplica\u00e7\u00e3o :application_name n\u00e3o est\u00e3o em dia","unhealthy_backup_found_subject_title":"Importante: Os backups da aplica\u00e7\u00e3o :application_name n\u00e3o est\u00e3o em dia. :problem","unhealthy_backup_found_unknown":"Desculpe, imposs\u00edvel determinar a raz\u00e3o exata."},"pt.cookieConsent::texts":{"agree":"Aceitar","message":"Este site utiliza cookies. Ao navegar no site estar\u00e1 a consentir a sua utiliza\u00e7\u00e3o."},"ro.backup::notifications":{"application_name":"Numele aplicatiei","backup_failed_body":"Important: A ap\u0103rut o eroare \u00een timpul gener\u0103rii copiei de rezerv\u0103 pentru :application_name","backup_failed_subject":"Nu s-a putut face copie de rezerv\u0103 pentru :application_name","backup_name":"Numele de rezerv\u0103","backup_successful_body":"Ve\u0219ti bune, o nou\u0103 copie de rezerv\u0103 pentru :application_name a fost creat\u0103 cu succes pe discul cu numele :disk_name.","backup_successful_subject":"Copie de rezerv\u0103 efectuat\u0103 cu succes pentru :application_name","backup_successful_subject_title":"O nou\u0103 copie de rezerv\u0103 a fost efectuat\u0103 cu succes!","cleanup_failed_body":"A ap\u0103rut o eroare \u00een timpul cur\u0103\u021birii copiilor de rezerv\u0103 pentru :application_name","cleanup_failed_subject":"Cur\u0103\u021barea copiilor de rezerv\u0103 pentru :application_name nu a reu\u0219it.","cleanup_successful_body":"Cur\u0103\u021barea copiilor de rezerv\u0103 pentru :application_name de pe discul cu numele :disk_name a fost f\u0103cut\u0103 cu succes.","cleanup_successful_subject":"Cur\u0103\u021barea copiilor de rezerv\u0103 pentru :application_name a fost f\u0103cut\u0103 cu succes","cleanup_successful_subject_title":"Cur\u0103\u021barea copiilor de rezerv\u0103 a fost f\u0103cut\u0103 cu succes!","disk":"Disc","exception_message":"Cu excep\u021bia mesajului: :message","exception_message_title":"Mesaj de excep\u021bie","exception_trace":"Urm\u0103 excep\u0163ie: :trace","exception_trace_title":"Urm\u0103 excep\u0163ie","healthy_backup_found_body":"Copiile de rezerv\u0103 pentru :application_name sunt considerate \u00een regul\u0103. Bun\u0103 treab\u0103!","healthy_backup_found_subject":"Copiile de rezerv\u0103 pentru :application_name de pe discul :disk_name sunt \u00een regul\u0103","healthy_backup_found_subject_title":"Copiile de rezerv\u0103 pentru :application_name sunt \u00een regul\u0103","newest_backup_date":"Cea mai nou\u0103 dimensiune de rezerv\u0103","newest_backup_size":"Cea mai nou\u0103 dimensiune de rezerv\u0103","no_backups_info":"Nu s-au f\u0103cut \u00eenc\u0103 copii de rezerv\u0103","number_of_backups":"Num\u0103r de copii de rezerv\u0103","oldest_backup_date":"Cea mai veche dimensiune de rezerv\u0103","total_storage_used":"Spa\u021biu total de stocare utilizat","unhealthy_backup_found_body":"Copiile de rezerv\u0103 pentru :application_name de pe discul :disk_name nu sunt \u00een regul\u0103.","unhealthy_backup_found_empty":"Nu exist\u0103 copii de rezerv\u0103 ale acestei aplica\u021bii.","unhealthy_backup_found_full":"Copiile de rezerv\u0103 folosesc prea mult spa\u021biu de stocare. Utilizarea curent\u0103 este de :disk_usage care este mai mare dec\u00e2t limita permis\u0103 de :disk_limit.","unhealthy_backup_found_not_reachable":"Nu se poate ajunge la destina\u021bia copiilor de rezerv\u0103. :error","unhealthy_backup_found_old":"Cea mai recent\u0103 copie de rezerv\u0103 f\u0103cut\u0103 la :date este considerat\u0103 prea veche.","unhealthy_backup_found_subject":"Important: Copiile de rezerv\u0103 pentru :application_name nu sunt \u00een regul\u0103","unhealthy_backup_found_subject_title":"Important: Copiile de rezerv\u0103 pentru :application_name nu sunt \u00een regul\u0103. :problem","unhealthy_backup_found_unknown":"Ne pare r\u0103u, un motiv exact nu poate fi determinat."},"ro.cookieConsent::texts":{"agree":"Accept\u0103 cookie","message":"Experien\u021ba ta pe acest site va fi \u00eembun\u0103t\u0103\u021bit\u0103 dac\u0103 accepta\u021bi folosirea de cookie-uri."},"ru.backup::notifications":{"application_name":"\u0418\u043c\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f","backup_failed_body":"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0433\u043e \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f :application_name","backup_failed_subject":"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e :application_name","backup_name":"\u0418\u043c\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438","backup_successful_body":"\u041e\u0442\u043b\u0438\u0447\u043d\u0430\u044f \u043d\u043e\u0432\u043e\u0441\u0442\u044c, \u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f :application_name \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430 \u043d\u0430 \u0434\u0438\u0441\u043a :disk_name.","backup_successful_subject":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f :application_name","backup_successful_subject_title":"\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f!","cleanup_failed_body":"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0447\u0438\u0441\u0442\u043a\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 :application_name","cleanup_failed_subject":"\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 :application_name","cleanup_successful_body":"\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043e\u0442 \u0441\u0442\u0430\u0440\u044b\u0445 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 :application_name \u043d\u0430 \u0434\u0438\u0441\u043a\u0435 :disk_name \u043f\u0440\u043e\u0448\u043b\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e.","cleanup_successful_subject":"\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043e\u0442 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 :application_name \u043f\u0440\u043e\u0448\u043b\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e","cleanup_successful_subject_title":"\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u043f\u0440\u043e\u0448\u043b\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e!","disk":"\u0414\u0438\u0441\u043a","exception_message":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435: :message","exception_message_title":"\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435","exception_trace":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435: :trace","exception_trace_title":"\u0421\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435","healthy_backup_found_body":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 :application_name \u0441\u0447\u0438\u0442\u0430\u044e\u0442\u0441\u044f \u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b\u043c\u0438. \u0425\u043e\u0440\u043e\u0448\u0430\u044f \u0440\u0430\u0431\u043e\u0442\u0430!","healthy_backup_found_subject":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 :application_name \u0441 \u0434\u0438\u0441\u043a\u0430 :disk_name \u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b","healthy_backup_found_subject_title":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 :application_name \u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b","newest_backup_date":"\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438","newest_backup_size":"\u0420\u0430\u0437\u043c\u0435\u0440 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438","no_backups_info":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u0435\u0449\u0435 \u043d\u0435 \u0431\u044b\u043b\u043e","number_of_backups":"\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439","oldest_backup_date":"\u0414\u0430\u0442\u0430 \u0441\u0430\u043c\u043e\u0439 \u0441\u0442\u0430\u0440\u043e\u0439 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438","total_storage_used":"\u041e\u0431\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u043e\u0433\u043e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430","unhealthy_backup_found_body":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 \u0434\u043b\u044f :application_name \u043d\u0430 \u0434\u0438\u0441\u043a\u0435 :disk_name \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b.","unhealthy_backup_found_empty":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442.","unhealthy_backup_found_full":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u043f\u0430\u043c\u044f\u0442\u0438. \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f :disk_usage \u0447\u0442\u043e \u0432\u044b\u0448\u0435 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u0435\u043b\u0430: :disk_limit.","unhealthy_backup_found_not_reachable":"\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0438\u0447\u044c \u043c\u0435\u0441\u0442\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438. :error","unhealthy_backup_found_old":"\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0435 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u043e\u0435 :date \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0443\u0441\u0442\u0430\u0440\u0435\u0432\u0448\u0438\u043c.","unhealthy_backup_found_subject":"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 :application_name \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b","unhealthy_backup_found_subject_title":"\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 \u0434\u043b\u044f :application_name \u043d\u0435\u0438\u0441\u043f\u0440\u0430\u0432\u043d\u044b. :problem","unhealthy_backup_found_unknown":"\u0418\u0437\u0432\u0438\u043d\u0438\u0442\u0435, \u0442\u043e\u0447\u043d\u0430\u044f \u043f\u0440\u0438\u0447\u0438\u043d\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0430."},"ru.cookieConsent::texts":{"agree":"\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c","message":"\u041d\u0430 \u044d\u0442\u043e\u043c \u0441\u0430\u0439\u0442\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u044b cookies \u0434\u043b\u044f \u0443\u043b\u0443\u0447\u0448\u0435\u043d\u0438\u044f \u0432\u0430\u0448\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430."},"sk.cookieConsent::texts":{"agree":"S\u00fahlas\u00edm","message":"T\u00e1to str\u00e1nka pou\u017e\u00edva cookies na vylep\u0161enie v\u00e1\u0161ho u\u017e\u00edvate\u013esk\u00e9ho z\u00e1\u017eitku."},"sv.cookieConsent::texts":{"agree":"Jag f\u00f6rst\u00e5r","message":"Vi anv\u00e4nder kakor (cookies) f\u00f6r att webbplatsen ska fungera p\u00e5 ett bra s\u00e4tt f\u00f6r dig. Genom att surfa vidare godk\u00e4nner du att vi anv\u00e4nder kakor."},"tr.backup::notifications":{"application_name":"Uygulama Ad\u0131","backup_failed_body":"\u00d6nemli: Yedeklenirken bir hata olu\u015ftu :application_name","backup_failed_subject":"Yedeklenemedi :application_name","backup_name":"Yedek ad\u0131","backup_successful_body":"Harika bir haber, :application_name \u00e2it yeni bir yedekleme :disk_name adl\u0131 diskte ba\u015far\u0131yla olu\u015fturuldu.","backup_successful_subject":"Ba\u015far\u0131l\u0131 :application_name yeni yedeklemesi","backup_successful_subject_title":"Ba\u015far\u0131l\u0131 bir yeni yedekleme!","cleanup_failed_body":":application_name yedeklerini temizlerken bir hata olu\u015ftu ","cleanup_failed_subject":":application_name yedeklemeleri temizlenmesi ba\u015far\u0131s\u0131z.","cleanup_successful_body":":application_name yedeklemeleri temizlenmesi ,:disk_name diskinden silindi","cleanup_successful_subject":":application_name yedeklemeleri temizlenmesi ba\u015far\u0131l\u0131.","cleanup_successful_subject_title":"Yedeklerin temizlenmesi ba\u015far\u0131l\u0131!","disk":"Disk","exception_message":"Hata mesaj\u0131: :message","exception_message_title":"Hata mesaj\u0131","exception_trace":"Hata izleri: :trace","exception_trace_title":"Hata izleri","healthy_backup_found_body":":application_name i\u00e7in yap\u0131lan yedeklemeler sa\u011fl\u0131kl\u0131 say\u0131l\u0131r. Aferin!","healthy_backup_found_subject":":application_name yedeklenmesi ,:disk_name adl\u0131 diskte sa\u011fl\u0131kl\u0131","healthy_backup_found_subject_title":":application_name yedeklenmesi sa\u011fl\u0131kl\u0131","newest_backup_date":"En yeni yedekleme boyutu","newest_backup_size":"En yeni yedekleme boyutu","no_backups_info":"Hen\u00fcz yedekleme yap\u0131lmad\u0131","number_of_backups":"Yedekleme say\u0131s\u0131","oldest_backup_date":"En eski yedekleme boyutu","total_storage_used":"Kullan\u0131lan toplam depolama alan\u0131","unhealthy_backup_found_body":"Yedeklemeler: :application_name disk: :disk_name sa\u011fl\u0131ks\u0131z.","unhealthy_backup_found_empty":"Bu uygulaman\u0131n yedekleri yok.","unhealthy_backup_found_full":"Yedeklemeler \u00e7ok fazla depolama alan\u0131 kullan\u0131yor. \u015eu anki kullan\u0131m: :disk_usage, izin verilen s\u0131n\u0131rdan y\u00fcksek: :disk_limit.","unhealthy_backup_found_not_reachable":"Yedekleme hedefine ula\u015f\u0131lam\u0131yor. :error","unhealthy_backup_found_old":":date tarihinde yap\u0131lan en son yedekleme \u00e7ok eski kabul ediliyor.","unhealthy_backup_found_subject":"\u00d6nemli: :application_name i\u00e7in yedeklemeler sa\u011fl\u0131ks\u0131z","unhealthy_backup_found_subject_title":"\u00d6nemli: :application_name i\u00e7in yedeklemeler sa\u011fl\u0131ks\u0131z. :problem","unhealthy_backup_found_unknown":"\u00dczg\u00fcn\u00fcm, kesin bir sebep belirlenemiyor."},"tr.cookieConsent::texts":{"agree":"\u00c7erezlere izin ver","message":"Bu sitedeki deneyiminizi \u00e7erezlere izin vererek geli\u015ftirebilirsiniz."},"uk.backup::notifications":{"application_name":"\u041d\u0430\u0437\u0432\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u0438","backup_failed_body":"\u0423\u0432\u0430\u0433\u0430: \u0422\u0440\u0430\u043f\u0438\u043b\u0430\u0441\u044c \u043f\u043e\u043c\u0438\u043b\u043a\u0430 \u043f\u0456\u0434 \u0447\u0430\u0441 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0433\u043e \u043a\u043e\u043f\u0456\u044e\u0432\u0430\u043d\u043d\u044f :application_name","backup_failed_subject":"\u041d\u0435 \u0432\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0440\u043e\u0431\u0438\u0442\u0438 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443 \u043a\u043e\u043f\u0456\u044e :application_name","backup_name":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0435 \u0456\u043c\u2019\u044f","backup_successful_body":"\u0427\u0443\u0434\u043e\u0432\u0430 \u043d\u043e\u0432\u0438\u043d\u0430, \u043d\u043e\u0432\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f :application_name \u0443\u0441\u043f\u0456\u0448\u043d\u043e \u0441\u0442\u0432\u043e\u0440\u0435\u043d\u0430 \u0456 \u0437\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u0430 \u043d\u0430 \u0434\u0438\u0441\u043a :disk_name.","backup_successful_subject":"\u0423\u0441\u043f\u0456\u0448\u043d\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0435 \u043a\u043e\u043f\u0456\u044e\u0432\u0430\u043d\u043d\u044f :application_name","backup_successful_subject_title":"\u0423\u0441\u043f\u0456\u0448\u043d\u043e \u0441\u0442\u0432\u043e\u0440\u0435\u043d\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f!","cleanup_failed_body":"\u0421\u0442\u0430\u043b\u0430\u0441\u044f \u043f\u043e\u043c\u0438\u043b\u043a\u0430 \u043f\u0456\u0434 \u0447\u0430\u0441 \u043e\u0447\u0438\u0449\u0435\u043d\u043d\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0445 \u043a\u043e\u043f\u0456\u0439 :application_name","cleanup_failed_subject":"\u041d\u0435 \u0432\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0447\u0438\u0441\u0442\u0438\u0442\u0438 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0456 \u043a\u043e\u043f\u0456\u0457 :application_name","cleanup_successful_body":"\u041e\u0447\u0438\u0449\u0435\u043d\u043d\u043e \u0432\u0456\u0434 \u0441\u0442\u0430\u0440\u0438\u0445 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0445 \u043a\u043e\u043f\u0456\u0439 :application_name \u043d\u0430 \u0434\u0438\u0441\u043a\u0443 :disk_name \u043f\u043e\u0439\u0448\u043b\u043e \u0443\u0441\u043f\u0456\u0448\u043d\u043e.","cleanup_successful_subject":"\u0423\u0441\u043f\u0456\u0448\u043d\u0435 \u043e\u0447\u0438\u0449\u0435\u043d\u043d\u044f \u0432\u0456\u0434 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0445 \u043a\u043e\u043f\u0456\u0439 :application_name","cleanup_successful_subject_title":"\u041e\u0447\u0438\u0449\u0435\u043d\u043d\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0445 \u043a\u043e\u043f\u0456\u0439 \u043f\u0440\u043e\u0439\u0448\u043b\u043e \u0432\u0434\u0430\u043b\u043e!","disk":"\u0414\u0438\u0441\u043a","exception_message":"\u041f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f \u043f\u0440\u043e \u043f\u043e\u043c\u0438\u043b\u043a\u0443: :message","exception_message_title":"\u041f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f \u043f\u043e\u043c\u0438\u043b\u043a\u0438","exception_trace":"\u0414\u0435\u0442\u0430\u043b\u0456 \u043f\u043e\u043c\u0438\u043b\u043a\u0438: :trace","exception_trace_title":"\u0414\u0435\u0442\u0430\u043b\u0456 \u043f\u043e\u043c\u0438\u043b\u043a\u0438","healthy_backup_found_body":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f :application_name \u0443\u0441\u043f\u0456\u0448\u043d\u043e \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430. \u0425\u043e\u0440\u043e\u0448\u0430 \u0440\u043e\u0431\u043e\u0442\u0430!","healthy_backup_found_subject":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f :application_name \u0437 \u0434\u0438\u0441\u043a\u0443 :disk_name \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430","healthy_backup_found_subject_title":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f :application_name \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430","newest_backup_date":"\u041d\u0430\u0439\u043d\u043e\u0432\u0456\u0448\u0438\u0439 \u0440\u043e\u0437\u043c\u0456\u0440 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0457 \u043a\u043e\u043f\u0456\u0457","newest_backup_size":"\u041d\u0430\u0439\u043d\u043e\u0432\u0456\u0448\u0438\u0439 \u0440\u043e\u0437\u043c\u0456\u0440 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0457 \u043a\u043e\u043f\u0456\u0457","no_backups_info":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0445 \u043a\u043e\u043f\u0456\u0439 \u0449\u0435 \u043d\u0435 \u0431\u0443\u043b\u043e \u0437\u0440\u043e\u0431\u043b\u0435\u043d\u043e","number_of_backups":"\u041a\u0456\u043b\u044c\u043a\u0456\u0441\u0442\u044c \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0438\u0445 \u043a\u043e\u043f\u0456\u0439","oldest_backup_date":"\u041d\u0430\u0439\u0441\u0442\u0430\u0440\u0456\u0448\u0438\u0439 \u0440\u043e\u0437\u043c\u0456\u0440 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0457 \u043a\u043e\u043f\u0456\u0457","total_storage_used":"\u0417\u0430\u0433\u0430\u043b\u044c\u043d\u0438\u0439 \u043e\u0431\u0441\u044f\u0433 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043e\u0433\u043e \u0441\u0445\u043e\u0432\u0438\u0449\u0430","unhealthy_backup_found_body":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f \u0434\u043b\u044f :application_name \u043d\u0430 \u0434\u0438\u0441\u043a\u0443 :disk_name \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b\u0430\u0441\u044c.","unhealthy_backup_found_empty":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0456 \u043a\u043e\u043f\u0456\u0457 \u0434\u043b\u044f \u0446\u044c\u043e\u0433\u043e \u0434\u043e\u0434\u0430\u0442\u043a\u0443 \u0432\u0456\u0434\u0441\u0443\u0442\u043d\u0456.","unhealthy_backup_found_full":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0456 \u043a\u043e\u043f\u0456\u0457 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u044e\u0442\u044c \u0437\u0430\u043d\u0430\u0434\u0442\u043e \u0431\u0430\u0433\u0430\u0442\u043e \u043f\u0430\u043c`\u044f\u0442\u0456. \u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0454\u0442\u044c\u0441\u044f :disk_usage \u0449\u043e \u0432\u0438\u0449\u0435 \u0437\u0430 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0443 \u043c\u0435\u0436\u0443 :disk_limit.","unhealthy_backup_found_not_reachable":"\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f \u043d\u0435 \u0437\u043c\u043e\u0433\u043b\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0438\u0441\u044c. :error","unhealthy_backup_found_old":"\u041e\u0441\u0442\u0430\u043d\u043d\u0454 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0435 \u043a\u043e\u043f\u0456\u044e\u0432\u0430\u043d\u043d\u044f \u0441\u0442\u0432\u043e\u0440\u0435\u043d\u043e :date \u0454 \u0437\u0430\u0441\u0442\u0430\u0440\u0456\u043b\u0438\u043c.","unhealthy_backup_found_subject":"\u0423\u0432\u0430\u0433\u0430: \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f :application_name \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b\u0430\u0441\u044c","unhealthy_backup_found_subject_title":"\u0423\u0432\u0430\u0433\u0430: \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430 \u043a\u043e\u043f\u0456\u044f \u0434\u043b\u044f :application_name \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u043b\u0430\u0441\u044c. :problem","unhealthy_backup_found_unknown":"\u0412\u0438\u0431\u0430\u0447\u0442\u0435, \u0430\u043b\u0435 \u043c\u0438 \u043d\u0435 \u0437\u043c\u043e\u0433\u043b\u0438 \u0432\u0438\u0437\u043d\u0430\u0447\u0438\u0442\u0438 \u0442\u043e\u0447\u043d\u0443 \u043f\u0440\u0438\u0447\u0438\u043d\u0443."},"vi.cookieConsent::texts":{"agree":"Cho ph\u00e9p Cookie","message":"Tr\u1ea3i nghi\u1ec7m c\u1ee7a b\u1ea1n tr\u00ean trang web n\u00e0y s\u1ebd \u0111\u01b0\u1ee3c c\u1ea3i thi\u1ec7n b\u1eb1ng c\u00e1ch cho ph\u00e9p Cookie."},"zh-CN.backup::notifications":{"application_name":"\u5e94\u7528\u540d\u79f0","backup_failed_body":"\u91cd\u8981\u8bf4\u660e\uff1a\u5907\u4efd :application_name \u65f6\u53d1\u751f\u9519\u8bef","backup_failed_subject":":application_name \u5907\u4efd\u5931\u8d25","backup_name":"\u5907\u4efd\u540d\u79f0","backup_successful_body":"\u597d\u6d88\u606f, :application_name \u5907\u4efd\u6210\u529f\uff0c\u4f4d\u4e8e\u78c1\u76d8 :disk_name \u4e2d\u3002","backup_successful_subject":":application_name \u5907\u4efd\u6210\u529f","backup_successful_subject_title":"\u5907\u4efd\u6210\u529f\uff01","cleanup_failed_body":"\u6e05\u9664\u5907\u4efd :application_name \u65f6\u53d1\u751f\u9519\u8bef","cleanup_failed_subject":"\u6e05\u9664 :application_name \u7684\u5907\u4efd\u5931\u8d25\u3002","cleanup_successful_body":"\u6210\u529f\u6e05\u9664 :disk_name \u78c1\u76d8\u4e0a :application_name \u7684\u5907\u4efd\u3002","cleanup_successful_subject":"\u6210\u529f\u6e05\u9664 :application_name \u7684\u5907\u4efd","cleanup_successful_subject_title":"\u6210\u529f\u6e05\u9664\u5907\u4efd\uff01","disk":"\u78c1\u76d8","exception_message":"\u5f02\u5e38\u4fe1\u606f: :message","exception_message_title":"\u5f02\u5e38\u4fe1\u606f","exception_trace":"\u5f02\u5e38\u8ddf\u8e2a: :trace","exception_trace_title":"\u5f02\u5e38\u8ddf\u8e2a","healthy_backup_found_body":":application_name \u7684\u5907\u4efd\u662f\u5065\u5eb7\u7684\u3002\u5e72\u7684\u597d\uff01","healthy_backup_found_subject":":disk_name \u78c1\u76d8\u4e0a :application_name \u7684\u5907\u4efd\u662f\u5065\u5eb7\u7684","healthy_backup_found_subject_title":":application_name \u7684\u5907\u4efd\u662f\u5065\u5eb7\u7684","newest_backup_date":"\u6700\u65b0\u5907\u4efd\u5927\u5c0f","newest_backup_size":"\u6700\u65b0\u5907\u4efd\u5927\u5c0f","no_backups_info":"\u5c1a\u672a\u8fdb\u884c\u4efb\u4f55\u5907\u4efd","number_of_backups":"\u5907\u4efd\u6570\u91cf","oldest_backup_date":"\u6700\u65e7\u7684\u5907\u4efd\u5927\u5c0f","total_storage_used":"\u4f7f\u7528\u7684\u603b\u5b58\u50a8\u91cf","unhealthy_backup_found_body":":disk_name \u78c1\u76d8\u4e0a :application_name \u7684\u5907\u4efd\u4e0d\u5065\u5eb7\u3002","unhealthy_backup_found_empty":"\u6839\u672c\u6ca1\u6709\u6b64\u5e94\u7528\u7a0b\u5e8f\u7684\u5907\u4efd\u3002","unhealthy_backup_found_full":"\u5907\u4efd\u5360\u7528\u4e86\u592a\u591a\u5b58\u50a8\u7a7a\u95f4\u3002\u5f53\u524d\u5360\u7528\u4e86 :disk_usage \uff0c\u9ad8\u4e8e\u5141\u8bb8\u7684\u9650\u5236 :disk_limit\u3002","unhealthy_backup_found_not_reachable":"\u65e0\u6cd5\u8bbf\u95ee\u5907\u4efd\u76ee\u6807\u3002 :error","unhealthy_backup_found_old":"\u6700\u8fd1\u7684\u5907\u4efd\u521b\u5efa\u4e8e :date \uff0c\u592a\u65e7\u4e86\u3002","unhealthy_backup_found_subject":"\u91cd\u8981\u8bf4\u660e\uff1a:application_name \u7684\u5907\u4efd\u4e0d\u5065\u5eb7","unhealthy_backup_found_subject_title":"\u91cd\u8981\u8bf4\u660e\uff1a:application_name \u5907\u4efd\u4e0d\u5065\u5eb7\u3002 :problem","unhealthy_backup_found_unknown":"\u5bf9\u4e0d\u8d77\uff0c\u786e\u5207\u539f\u56e0\u65e0\u6cd5\u786e\u5b9a\u3002"},"zh-TW.backup::notifications":{"application_name":"\u61c9\u7528\u540d\u7a31","backup_failed_body":"\u91cd\u8981\u8aaa\u660e\uff1a\u5099\u4efd :application_name \u6642\u767c\u751f\u932f\u8aa4","backup_failed_subject":":application_name \u5099\u4efd\u5931\u6557","backup_name":"\u5099\u4efd\u540d\u7a31","backup_successful_body":"\u597d\u6d88\u606f, :application_name \u5099\u4efd\u6210\u529f\uff0c\u4f4d\u65bc\u78c1\u789f :disk_name \u4e2d\u3002","backup_successful_subject":":application_name \u5099\u4efd\u6210\u529f","backup_successful_subject_title":"\u5099\u4efd\u6210\u529f\uff01","cleanup_failed_body":"\u6e05\u9664\u5099\u4efd :application_name \u6642\u767c\u751f\u932f\u8aa4","cleanup_failed_subject":"\u6e05\u9664 :application_name \u7684\u5099\u4efd\u5931\u6557\u3002","cleanup_successful_body":"\u6210\u529f\u6e05\u9664 :disk_name \u78c1\u789f\u4e0a :application_name \u7684\u5099\u4efd\u3002","cleanup_successful_subject":"\u6210\u529f\u6e05\u9664 :application_name \u7684\u5099\u4efd","cleanup_successful_subject_title":"\u6210\u529f\u6e05\u9664\u5099\u4efd\uff01","disk":"\u78c1\u789f","exception_message":"\u7570\u5e38\u8a0a\u606f: :message","exception_message_title":"\u7570\u5e38\u8a0a\u606f","exception_trace":"\u7570\u5e38\u8ffd\u8e64: :trace","exception_trace_title":"\u7570\u5e38\u8ffd\u8e64","healthy_backup_found_body":":application_name \u7684\u5099\u4efd\u662f\u5065\u5eb7\u7684\u3002\u5e79\u7684\u597d\uff01","healthy_backup_found_subject":":disk_name \u78c1\u789f\u4e0a :application_name \u7684\u5099\u4efd\u662f\u5065\u5eb7\u7684","healthy_backup_found_subject_title":":application_name \u7684\u5099\u4efd\u662f\u5065\u5eb7\u7684","newest_backup_date":"\u6700\u65b0\u5099\u4efd\u5927\u5c0f","newest_backup_size":"\u6700\u65b0\u5099\u4efd\u5927\u5c0f","no_backups_info":"\u5c1a\u672a\u9032\u884c\u4efb\u4f55\u5099\u4efd","number_of_backups":"\u5099\u4efd\u6578\u91cf","oldest_backup_date":"\u6700\u65e9\u7684\u5099\u4efd\u5927\u5c0f","total_storage_used":"\u4f7f\u7528\u7684\u7e3d\u5b58\u5132\u91cf","unhealthy_backup_found_body":":disk_name \u78c1\u789f\u4e0a :application_name \u7684\u5099\u4efd\u4e0d\u5065\u5eb7\u3002","unhealthy_backup_found_empty":"\u6839\u672c\u6c92\u6709\u6b64\u61c9\u7528\u7a0b\u5e8f\u7684\u5099\u4efd\u3002","unhealthy_backup_found_full":"\u5099\u4efd\u4f54\u7528\u4e86\u592a\u591a\u5b58\u5132\u7a7a\u9593\u3002\u7576\u524d\u4f54\u7528\u4e86 :disk_usage \uff0c\u9ad8\u65bc\u5141\u8a31\u7684\u9650\u5236 :disk_limit\u3002","unhealthy_backup_found_not_reachable":"\u7121\u6cd5\u8a2a\u554f\u5099\u4efd\u76ee\u6a19\u3002 :error","unhealthy_backup_found_old":"\u6700\u8fd1\u7684\u5099\u4efd\u5275\u5efa\u65bc :date \uff0c\u592a\u820a\u4e86\u3002","unhealthy_backup_found_subject":"\u91cd\u8981\u8aaa\u660e\uff1a:application_name \u7684\u5099\u4efd\u4e0d\u5065\u5eb7","unhealthy_backup_found_subject_title":"\u91cd\u8981\u8aaa\u660e\uff1a:application_name \u5099\u4efd\u4e0d\u5065\u5eb7\u3002 :problem","unhealthy_backup_found_unknown":"\u5c0d\u4e0d\u8d77\uff0c\u78ba\u5207\u539f\u56e0\u7121\u6cd5\u78ba\u5b9a\u3002"},"zh.auth":{"app":{"create":"\u521b\u9020","export":"\u51fa\u53e3","lock_account":"\u9501\u5b9a\u5e10\u6237","member_since":"\u6210\u5458\u81ea","messages":"\u7559\u8a00","online":"\u5728\u7ebf\u7684","print":"\u6253\u5370","profile":"\u8f6e\u5ed3","reload":"\u91cd\u65b0\u52a0\u8f7d","reset":"\u91cd\u542f","search":"\u641c\u7d22","settings":"\u8bbe\u7f6e"},"confirm_password":"\u786e\u8ba4\u5bc6\u7801","email":"\u7535\u5b50\u90ae\u4ef6","failed":"\u8fd9\u4e9b\u51ed\u636e\u4e0e\u6211\u4eec\u7684\u8bb0\u5f55\u4e0d\u7b26\u3002","forgot_password":{"send_pwd_reset":"\u53d1\u9001\u5bc6\u7801\u91cd\u7f6e\u94fe\u63a5","title":"\u8f93\u5165\u90ae\u7bb1\u91cd\u7f6e\u5bc6\u7801"},"full_name":"\u5168\u540d","login":{"forgot_password":"\u6211\u5fd8\u8bb0\u4e86\u6211\u7684\u5bc6\u7801","register_membership":"\u6ce8\u518c\u65b0\u4f1a\u5458","title":"\u767b\u5f55\u4ee5\u5f00\u59cb\u60a8\u7684\u4f1a\u8bdd"},"password":"\u5bc6\u7801","register":"\u767b\u8bb0","registration":{"have_membership":"\u6211\u5df2\u7ecf\u6709\u4f1a\u5458\u4e86","i_agree":"\u6211\u540c\u610f","terms":"\u6761\u6b3e","title":"\u6ce8\u518c\u65b0\u4f1a\u5458"},"remember_me":"\u8bb0\u4f4f\u8d26\u53f7","reset_password":{"reset_pwd_btn":"\u91cd\u8bbe\u5bc6\u7801","title":"\u91cd\u7f6e\u60a8\u7684\u5bc6\u7801"},"save":"\u8282\u7701","sign_in":"\u767b\u5165","sign_out":"\u767b\u51fa","throttle":"\u767b\u5f55\u5c1d\u8bd5\u6b21\u6570\u8fc7\u591a\u3002\u8bf7\u5728 :seconds \u79d2\u540e\u91cd\u8bd5\u3002"},"zh.crud":{"action":"\u884c\u52a8","add_new":"\u6dfb\u65b0","are_you_sure":"\u4f60\u786e\u5b9a\u5417\uff1f","back":"\u540e\u9000","cancel":"\u53d6\u6d88","created_at":"\u521b\u5efa\u4e8e","deleted_at":"\u5220\u9664\u4e8e","detail":"\u7ec6\u8282","edit":"\u7f16\u8f91","id":"Id","save":"\u8282\u7701","updated_at":"\u66f4\u65b0\u4e8e"},"zh.messages":{"Gallery":"\u753b\u5eca","ad_space":{"ad_code":"\u5e7f\u544a\u4ee3\u7801","ad_management":"\u5e7f\u544a\u7ba1\u7406","ad_space":"\u5e7f\u544a\u4f4d","ad_url":"\u5e7f\u544a\u7f51\u5740","categories":"\u7c7b\u522b","desktop":"\u684c\u9762\u89c6\u56fe","details_side":"\u7ec6\u8282\u9762","disable_ad":"\u7981\u7528\u5e7f\u544a","gallery":"\u753b\u5eca","header":"\u6807\u5934","index_bottom":"\u7d22\u5f15\u5e95\u90e8","index_top":"\u7d22\u5f15\u9876\u90e8","mobile":"\u79fb\u52a8\u89c6\u56fe","popular_news":"\u70ed\u95e8\u65b0\u95fb","popular_news_index_page":"\u70ed\u95e8\u65b0\u95fb\uff08\u7d22\u5f15\u9875\uff09","post_details":"\u5e16\u5b50\u8be6\u60c5","recommended_post_index_page":"\u63a8\u8350\u5e16\u5b50\uff08\u7d22\u5f15\u9875\uff09","select_ad_space":"\u9009\u62e9\u5e7f\u544a\u4f4d","trending_post":"\u70ed\u95e8\u5e16\u5b50","trending_post_index_page":"\u70ed\u95e8\u5e16\u5b50\uff08\u7d22\u5f15\u9875\uff09"},"add_post":"\u6dfb\u52a0\u5e16\u5b50","admin":"\u884c\u653f","ai":{"ai_filter":"\u4eba\u5de5\u667a\u80fd\u6ee4\u955c","best_of":"\u6700\u597d\u7684","call_ai":"\u547c\u53eb\u4eba\u5de5\u667a\u80fd","frequency_penalty":"\u9891\u7387\u60e9\u7f5a","generate_content":"\u751f\u6210\u5185\u5bb9","maximum_length":"\u6700\u5927\u957f\u5ea6","model":"\u6a21\u578b","presence_penalty":"\u5b58\u5728\u60e9\u7f5a","temperature":"\u6e29\u5ea6","top_p":"\u9876P"},"album":{"add_album":"\u6dfb\u52a0\u76f8\u518c","album":"\u4e13\u8f91","edit_album":"\u7f16\u8f91\u76f8\u518c"},"album_categories":"\u4e13\u8f91\u5206\u7c7b","album_category":{"add_album_category":"\u6dfb\u52a0\u4e13\u8f91\u7c7b\u522b","album_category":"\u4e13\u8f91\u7c7b\u522b","edit_album_category":"\u7f16\u8f91\u4e13\u8f91\u7c7b\u522b","select_album":"\u9009\u62e9\u4e13\u8f91"},"albums":"\u76f8\u518c","all":"\u5168\u90e8","allowed_file_size":"\u6b64\u914d\u7f6e\u6587\u4ef6\u7684\u6700\u4f73\u5206\u8fa8\u7387\u4e3a","apps":"\u5e94\u7528","attachment":"\u4f9d\u604b","bulk_post":{"boolean":"\u5e03\u5c14\u503c","bulk_post":"\u6279\u91cf\u90ae\u5bc4","bulk_post_upload":"\u6279\u91cf\u53d1\u5e03\u4e0a\u4f20","categories":"\u7c7b\u522b","category_ids_list":"\u7c7b\u522b ID \u5217\u8868","data_type":"\u6570\u636e\u7c7b\u578b","documentation":"\u6587\u6863","download_csv_example":"\u4e0b\u8f7d CSV \u793a\u4f8b","download_csv_template":"\u4e0b\u8f7d CSV \u6a21\u677f","example":"\u4f8b\u5b50","field":"\u573a\u5730","help_documents":"\u5e2e\u52a9\u6587\u6863","id":"ID","integer":"\u6574\u6570","languages":"\u8bed\u8a00","longText":"\u957f\u6587\u672c","or":"\u6216\u8005","string":"\u7ec6\u7ef3","sub_categories":"\u5b50\u7c7b\u522b","test_description_about_this_post":"\u6d4b\u8bd5\u63cf\u8ff0\u5173\u4e8e\u8fd9\u7bc7\u6587\u7ae0","test_title":"\u6d4b\u8bd5\u6807\u9898","the_images_must_be_a_file_of_type_article_post":"\u56fe\u50cf\u5fc5\u987b\u662f\u4e00\u4e2a\u7c7b\u578b\u7684\u6587\u4ef6\uff1ajpg, png ,jpeg","upload_csv_File":"\u4e0a\u4f20 CSV \u6587\u4ef6","you_can_use_csv_file":"\u60a8\u53ef\u4ee5\u4f7f\u7528\u8fd9\u4e9b\u6587\u4ef6\u751f\u6210\u60a8\u7684 CSV \u6587\u4ef6"},"cash_payment":"\u73b0\u91d1\u652f\u4ed8","categories":"\u7c7b\u522b","category":{"action":"\u884c\u52a8","add_category":"\u6dfb\u52a0\u7c7b\u522b","category_language_warning":"\u5982\u679c\u60a8\u66f4\u6539\u9700\u8981\u66f4\u65b0\u5e16\u5b50\u7c7b\u522b\u7684\u8bed\u8a00\uff0c\u5e16\u5b50\u5c06\u4f7f\u7528\u6b64\u7c7b\u522b","color":"\u989c\u8272","edit_category":"\u7f16\u8f91\u7c7b\u522b","language":"\u8bed\u8a00","show_home":"\u5728\u5bb6\u4e2d\u5c55\u793a","show_menu":"\u663e\u793a\u5728\u83dc\u5355\u4e2d","slug":"\u86de\u8753","title":"\u6807\u9898"},"cities":"\u57ce\u5e02","comment":{"approval_pending":"\u7b49\u5f85\u6279\u51c6","approved":"\u663e\u793a\u5df2\u6279\u51c6","auto-approved":"\u81ea\u52a8\u6279\u51c6","comment":"\u8bc4\u8bba","comments":"\u8bc4\u8bba","email":"\u7535\u5b50\u90ae\u4ef6","enter_phone_number":"\u8f93\u5165\u7535\u8bdd\u53f7\u7801","enter_your_email":"\u8f93\u5165\u4f60\u7684\u7535\u5b50\u90ae\u7bb1","enter_your_name":"\u8f93\u5165\u4f60\u7684\u540d\u5b57","pending":"\u663e\u793a\u5f85\u5904\u7406","post_a_comment":"\u53d1\u8868\u8bc4\u8bba","type_your_comments":"\u8f93\u5165\u60a8\u7684\u8bc4\u8bba","your_name":"\u4f60\u7684\u540d\u5b57"},"comments":"\u8bc4\u8bba","common":{"action":"\u884c\u52a8","active":"\u7a4d\u6975\u7684","add":"\u6dfb\u52a0","allow_cookies":"\u5141\u8bb8 Cookie","allowed_types":"\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","already_have_an_account":"\u5df2\u6709\u5e10\u6237\uff1f","apply":"\u7533\u8bf7","approval_status":"\u5ba1\u6279\u72b6\u6001","approved":"\u5f97\u5230\u6b63\u5f0f\u8ba4\u53ef\u7684","apr":"R","april":"\u56db\u6708","aug":"ag","august":"\u516b\u6708","back":"\u540e\u9000","by":"\u7ecf\u8fc7","cancel":"\u53d6\u6d88","cancel_delete":"\u4e0d\uff0c\u53d6\u6d88","cancel_image":"\u53d6\u6d88\u56fe\u7247","cancel_profile":"\u53d6\u6d88\u4e2a\u4eba\u8d44\u6599","change_cover_image":"\u66f4\u6539\u5c01\u9762\u56fe\u7247","change_favicon":"Favicon \u00e4ndern","change_image":"\u66f4\u6539\u56fe\u50cf","change_logo":"Logo \u00e4ndern","change_profile":"\u66f4\u6539\u4e2a\u4eba\u8d44\u6599","city":"\u57ce\u5e02","closed":"\u95dc\u9589","contact":"\u63a5\u89e6","contact_us":"\u8054\u7cfb\u6211\u4eec","count":"\u6570\u6570","country":"\u56fd\u5bb6","create_an_account":"\u521b\u5efa\u4e00\u4e2a\u5e10\u6237","created_at":"\u521b\u5efa\u4e8e","created_by":"\u7531...\u5236\u4f5c","custom":"\u98ce\u4fd7","dec":"\u7532\u677f","december":"\u5341\u4e8c\u6708","declined":"\u8c22\u7edd","delete":"\u662f\u7684\uff0c\u5220\u9664","delete_message":" \u5df2\u88ab\u5220\u9664","delete_warning":"\u4f60\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u4e2a ","deleted":"\u5df2\u5220\u9664\uff01","details":"\u7ec6\u8282","discard":"\u4e22\u5f03","edit":"\u7f16\u8f91","feb":"\u4e8c\u6708","february":"\u4e8c\u6708","front_language":"\u9ed8\u8ba4\u524d\u7aef\u8bed\u8a00","get_the_best":"\u5c06\u6700\u597d\u7684\u535a\u5ba2\u6545\u4e8b\u653e\u5165\u60a8\u7684\u6536\u4ef6\u7bb1\uff01","image_error":"\u56fe\u7247\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6\uff1apng\u3001jpg\u3001jpeg\u3001webp\u3001svg\u3002","image_error_excel":"\u56fe\u7247\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6: png, jpg, jpeg, pdf,excel ","image_warning":" \u65e0\u6548\uff01\u5141\u8bb8\u7684\u6587\u4ef6\u7c7b\u578b\uff1apng\u3001jpg\u3001jpeg\u3002","jan":"\u7ea6\u7ff0","january":"\u4e00\u6708","jul":"\u4e03\u6708","july":"\u4e03\u6708","jun":"\u516d\u6708","june":"\u516d\u6708","language":"\u8bed\u8a00","leave_a_message":"\u7559\u8a00","login":"\u767b\u5f55","mar":"\u4e09\u6708","march":"\u884c\u8fdb","max":"\u7684 :attribute \u4e0d\u5f97\u5927\u4e8e :max.","may":"\u53ef\u80fd","name":"\u59d3\u540d","new_here":"\u65b0\u6765\u7684","no_data_available":"\u672a\u627e\u5230\u4efb\u4f55\u9879\u76ee\u3002\u5c1d\u8bd5\u6269\u5927\u60a8\u7684\u641c\u7d22\u8303\u56f4\u3002","note":"\u7b14\u8bb0","nov":"\u65b0","november":"\u5341\u4e00\u6708","oct":"\u5341\u6708","october":"\u5341\u6708","of":"\u7684","off":"\u79bb\u5f00","on":"\u5728","pending":"\u5f85\u529e\u7684","please_wait":"\u8bf7\u7a0d\u7b49...","read":"\u8bfb","register":"\u767b\u8bb0","rejected":"\u62d2\u7edd","remove_image":"\u79fb\u9664\u56fe\u7247","required":"\u7684 :attribute \u5fc5\u586b\u9879.","result":"\u7ed3\u679c","save":"\u8282\u7701","select_an_option":"\u9009\u62e9\u4e00\u4e2a\u9009\u9879","select_category":"\u9009\u62e9\u7c7b\u522b","select_language":"\u9009\u62e9\u8bed\u8a00","select_subcategory":"\u9009\u62e9\u5b50\u7c7b\u522b","send_email":"\u53d1\u7535\u5b50\u90ae\u4ef6","sep":"\u4e5d\u6708","september":"\u4e5d\u6708","service":"\u670d\u52a1","show_contact":"\u663e\u793a\u8054\u7cfb\u65b9\u5f0f","showing":"\u663e\u793a","sign_in_here":"\u5728\u8fd9\u91cc\u767b\u5f55","slug":"\u86de\u8753","state":"\u72b6\u6001","submit":"\u63d0\u4ea4","subscribe":"\u8ba2\u9605","success_msg":"\u6d88\u606f\u5df2\u6210\u529f\u53d1\u9001\u3002","time":"\u65f6\u95f4","title":"\u6807\u9898","to":"\u5230","update":"\u66f4\u65b0","view":"\u770b\u6cd5","your_email":"\u4f60\u7684\u90ae\u4ef6"},"contacts":"\u8054\u7cfb\u4eba","countries":"\u56fd\u5bb6","dashboard":"\u4eea\u8868\u76d8","dashboard_show":{"drafts":"\u8349\u7a3f","email":"\u7535\u5b50\u90ae\u4ef6","latest_user":"\u6700\u65b0\u7528\u6237","name":"\u59d3\u540d","post_views":"\u53d1\u5e03\u610f\u89c1","posts":"\u5e16\u5b50","profile":"\u8f6e\u5ed3","recent_user":"\u6700\u8fd1\u7684\u7528\u6237"},"days":{"last_month":"\u4e0a\u4e2a\u6708","last_week":"\u4e0a\u5468","this_month":"\u8fd9\u4e2a\u6708","this_week":"\u672c\u661f\u671f","today":"\u4eca\u5929"},"delete":"\u5220\u9664","details":{"admin_panel":"\u7ba1\u7406\u9762\u677f","article":"\u6587\u7ae0","breaking":"\u6253\u7834","category":"\u7c7b\u522b","contact_us":"\u8054\u7cfb\u6211\u4eec","featured_post":"\u7cbe\u9009\u5e16\u5b50","gallery":"\u753b\u5eca","home":"\u5bb6","hot_categories":"\u70ed\u95e8\u5206\u7c7b","language":"\u8bed\u8a00","latest_news":"\u6700\u65b0\u6d88\u606f","logout":"\u767b\u51fa","next_post":"\u4e0b\u4e00\u7bc7","popular_news":"\u70ed\u95e8\u65b0\u95fb","popular_tag":"\u70ed\u95e8\u6807\u7b7e","popular_tags":"\u70ed\u95e8\u6807\u7b7e","previous_post":"\u4e0a\u4e00\u7bc7\u6587\u7ae0","read_more":"\u9605\u8bfb\u66f4\u591a","recommended_post":"\u63a8\u8350\u5e16\u5b50","related_post":"\u76f8\u5173\u5e16\u5b50","sort":"\u79cd\u7c7b","top_stories":"\u5934\u6761\u65b0\u95fb","trending_post":"\u70ed\u95e8\u5e16\u5b50","view_more":"\u67e5\u770b\u66f4\u591a","view_options":"\u67e5\u770b\u9009\u9879","view_results":"\u67e5\u770b\u7ed3\u679c","views":"\u770b\u6cd5","vote":"\u6295\u7968","whats_new":"\u4ec0\u4e48\u662f\u65b0\u7684"},"edit_subscription":"\u7f16\u8f91\u8ba2\u9605","email_password_reset_link":"\u7535\u5b50\u90ae\u4ef6\u5bc6\u7801\u91cd\u7f6e\u94fe\u63a5","emails":{"Phone":"\u7535\u8bdd","email":"\u7535\u5b50\u90ae\u4ef6","enquiry_details":"\u8fd9\u662f\u67e5\u8be2\u8be6\u60c5","message":"\u4fe1\u606f","name":"\u59d3\u540d","required":"\u7535\u5b50\u90ae\u4ef6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684"},"emoji":{"emoji":"\u8868\u60c5\u7b26\u53f7","emojis":"\u8868\u60c5\u7b26\u53f7"},"enquiry":"\u8be2\u95ee","forgot_password":"\u5fd8\u8bb0\u5bc6\u7801","forgot_your_password":"\u5fd8\u8bb0\u5bc6\u7801\u4e86\u5417","forgot_your_password_no_problem_just_let_us_know_your_email_address":"\u5fd8\u8bb0\u5bc6\u7801\u4e86\u5417\uff1f \u6ca1\u95ee\u9898\u3002 \u53ea\u9700\u544a\u8bc9\u6211\u4eec\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u5730\u5740\uff0c\u6211\u4eec\u5c06\u901a\u8fc7\u7535\u5b50\u90ae\u4ef6\u5411\u60a8\u53d1\u9001\u4e00\u4e2a\u5bc6\u7801\u91cd\u7f6e\u94fe\u63a5\uff0c\u60a8\u53ef\u4ee5\u901a\u8fc7\u8be5\u94fe\u63a5\u9009\u62e9\u4e00\u4e2a\u65b0\u5bc6\u7801","gallery":{"add_images":"\u6dfb\u52a0\u56fe\u7247","album":"\u4e13\u8f91","category":"\u7c7b\u522b","date":"\u65e5\u671f","edit_images":"\u7f16\u8f91\u56fe\u50cf","id":"Id","image":"\u56fe\u7247","language":"\u8bed\u8a00","select_album":"\u9009\u62e9\u4e13\u8f91","title":"\u6807\u9898"},"home":"\u5bb6","images":"\u56fe\u7247","language":{"edit_language":"\u7f16\u8f91\u8bed\u8a00","edit_translation":"\u7f16\u8f91\u7ffb\u8bd1","front_language":"\u524d\u53f0\u8bed\u8a00\u72b6\u6001","is_active":"\u6d3b\u8dc3","is_default":"\u662f\u9ed8\u8ba4\u503c","is_rtl":"Is RTL","iso_code":"ISO \u4ee3\u7801","language":"\u8bed\u8a00","native":"\u672c\u673a","new_language":"\u65b0\u8bed\u8a00","no_language_available":"\u65e0\u53ef\u7528\u8bed\u8a00","no_language_found":"\u627e\u4e0d\u5230\u8bed\u8a00","translation":"\u7ffb\u8bd1"},"languages":"\u8bed\u8a00","mail":"\u90ae\u4ef6","mails":{"action_required":"\u5982\u679c\u60a8\u6ca1\u6709\u521b\u5efa\u5e10\u6237\uff0c\u5219\u65e0\u9700\u6267\u884c\u8fdb\u4e00\u6b65\u64cd\u4f5c\u3002","contact_messages":"\u8054\u7cfb\u4fe1\u606f","email_address":"\u7535\u5b50\u90ae\u4ef6\u5730\u5740","email_verification":"\u7535\u5b50\u90ae\u4ef6\u9a8c\u8bc1","encryption":"\u52a0\u5bc6","hello":"\u4f60\u597d","mail":"\u90ae\u4ef6","mail_host":"\u90ae\u4ef6\u4e3b\u673a","mail_library":"\u90ae\u4ef6\u5e93","mail_password":"\u90ae\u4ef6\u5bc6\u7801","mail_port":"\u90ae\u4ef6\u7aef\u53e3","mail_protocol":"\u90ae\u4ef6\u534f\u8bae","mail_title":"\u90ae\u4ef6\u6807\u9898","mail_user_name":"\u90ae\u4ef6\u7528\u6237\u540d","manual_payment_request":"\u624b\u52a8\u4ed8\u6b3e\u8bf7\u6c42","manual_payment_status":"\u4eba\u5de5\u4ed8\u6b3e\u72b6\u6001","please_click":"\u8bf7\u5355\u51fb\u4e0b\u9762\u7684\u6309\u94ae\u4ee5\u9a8c\u8bc1\u60a8\u7684\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u3002","regard":"\u770b\u5f85","reply_to":"\u56de\u590d","select_encryption":"\u9009\u62e9\u52a0\u5bc6","select_mail_library":"\u9009\u62e9\u90ae\u4ef6\u5e93","select_mail_protocol":"\u9009\u62e9\u90ae\u4ef6\u534f\u8bae","send_contact-messages_to_email_address":"\u5c06\u8054\u7cfb\u4fe1\u606f\u53d1\u9001\u5230\u7535\u5b50\u90ae\u4ef6\u5730\u5740","send_test_email":"\u53d1\u9001\u6d4b\u8bd5\u7535\u5b50\u90ae\u4ef6","test_mail":"\u6d4b\u8bd5\u90ae\u4ef6","verify_email":"\u786e\u8ba4\u7535\u5b50\u90ae\u4ef6\u5730\u5740"},"menu":{"add_menu":"\u6dfb\u52a0\u83dc\u5355","edit_menu":"\u7f16\u8f91\u83dc\u5355","link":"\u5173\u8054","menu":"\u83dc\u5355","menu_order":"\u83dc\u5355\u987a\u5e8f","parent_menu":"\u7236\u83dc\u5355","select_parent_menu":"\u9009\u62e9\u7236\u83dc\u5355","show_in_menu":"\u663e\u793a\u5728\u83dc\u5355\u4e2d","title":"\u6807\u9898"},"menus":"\u83dc\u5355","months":{"apr":"\u56db\u6708","aug":"\u4e5d\u6708","dec":"\u592a\u9633","feb":"\u4e8c\u6708","jan":"\u7b80","jul":"\u516b\u6708","jun":"\u541b","mar":"\u4e09\u6708","may":"\u53ef\u80fd","nov":"\u5341\u4e8c\u6708","oct":"\u5341\u4e00\u6708","sep":"\u5341\u6708"},"navigation":"\u5bfc\u822a","navigations":{"menu":"\u83dc\u5355"},"news_letters":"\u65b0\u95fb\u4fe1","no_album_found":"\u6ca1\u6709\u53ef\u7528\u7684\u4e13\u8f91","no_matching_records_found":"\u672a\u627e\u5230\u5339\u914d\u7684\u8bb0\u5f55\uff0c","no_results_found":"\u672a\u627e\u5230\u7ed3\u679c","notes":"\u7b14\u8bb0","ok":"\u597d\u7684","on_rss_feed":"RSS \u63d0\u8981\u5e16\u5b50\u603b\u6570","page":{"add_lang":"\u9009\u62e9\u8bed\u8a00","add_page":"\u6dfb\u52a0\u9875\u9762","add_parent_link":"\u9009\u62e9\u7236\u83dc\u5355\u94fe\u63a5","dont_add_menu":"\u4e0d\u6dfb\u52a0\u83dc\u5355","edit_page":"\u7f16\u8f91\u9875\u9762","footer":"\u9875\u811a","hide":"\u9690\u85cf","language":"\u8bed\u8a00","location":"\u5730\u70b9","main_menu":"\u4e3b\u83dc\u5355","meta_description":"\u5143\u63cf\u8ff0","meta_title":"\u5143\u6807\u9898","name":"\u5728\u9875\u9762\u4e0a\u663e\u793a\u83dc\u5355","no":"\u4e0d","page":"\u9875","parent_menu":"\u7236\u83dc\u5355\u94fe\u63a5","show":"\u663e\u793a","show_breadcrumb":"\u663e\u793a\u9762\u5305\u5c51","show_name":"\u59d3\u540d","show_right":"\u663e\u793a\u6b63\u786e","show_title":"\u663e\u793a\u6807\u9898","slug":"\u86de\u8753","title":"\u6807\u9898","top_menu":"\u9876\u90e8\u83dc\u5355","user_show":"\u4ec5\u5411\u6ce8\u518c\u7528\u6237\u663e\u793a","visibility":"\u80fd\u89c1\u5ea6","yes":"\u662f\u7684"},"pages":"\u9875\u9762","payment_method":"\u4ed8\u6b3e\u65b9\u5f0f","phone":"\u7535\u8bdd","placeholder":{"User_profile_updated_successfully":"\u7528\u6237\u8d44\u6599\u66f4\u65b0\u6210\u529f","You_active_more_than_emoji":"\u60a8\u4e0d\u80fd\u6fc0\u6d3b\u8d85\u8fc7 7 \u4e2a\u8868\u60c5\u7b26\u53f7","You_already_voted":"\u4f60\u5df2\u7ecf\u6295\u7968\u4e86!!","You_can_use_any_one_of_upload_video_or_video_URL_option":"\u60a8\u53ef\u4ee5\u4f7f\u7528\u4e0a\u4f20\u89c6\u9891\u6216\u89c6\u9891 URL \u9009\u9879\u4e2d\u7684\u4efb\u4f55\u4e00\u4e2a","You_disable_less_than_emoji":"\u60a8\u4e0d\u80fd\u7981\u7528\u5c11\u4e8e 4 \u4e2a\u8868\u60c5\u7b26\u53f7","adSpaces_updated_successfully":"AdSpaces \u66f4\u65b0\u6210\u529f","album_category_created_successfully":"\u4e13\u8f91\u7c7b\u522b\u521b\u5efa\u6210\u529f","album_category_deleted_successfully":"\u4e13\u8f91\u7c7b\u522b\u5220\u9664\u6210\u529f","album_category_retrieved_successfully":"\u4e13\u8f91\u7c7b\u522b\u68c0\u7d22\u6210\u529f","album_category_updated_successfully":"\u4e13\u8f91\u7c7b\u522b\u66f4\u65b0\u6210\u529f","album_created_successfully":"\u76f8\u518c\u521b\u5efa\u6210\u529f","album_deleted_successfully":"\u76f8\u518c\u5220\u9664\u6210\u529f","album_retrieve_successfully":"\u76f8\u518c\u68c0\u7d22\u6210\u529f","album_updated_successfully":"\u76f8\u518c\u66f4\u65b0\u6210\u529f","albums_retrieved_successfully":"\u76f8\u518c\u68c0\u7d22\u6210\u529f","already_image_exist":"\u56fe\u50cf\u5df2\u7ecf\u5b58\u5728","best_resolution_for_this_favicon_will_be_32X32":"\u6b64\u56fe\u6807\u7684\u6700\u4f73\u5206\u8fa8\u7387\u4e3a 32X32.","best_resolution_for_this_logo_will_be_90x60":"\u6b64\u5fbd\u6807\u7684\u6700\u4f73\u5206\u8fa8\u7387\u4e3a 90x60\u3002","bulk_post_created_successfully":"\u7fa4\u53d1\u90ae\u4ef6\u521b\u5efa\u6210\u529f\u3002","category_created_successfully":"\u7c7b\u522b\u521b\u5efa\u6210\u529f","category_deleted_successfully":"\u7c7b\u522b\u5220\u9664\u6210\u529f","category_retrieve_successfully":"\u7c7b\u522b\u68c0\u7d22\u6210\u529f","category_retrieved_successfully":"\u7c7b\u522b\u68c0\u7d22\u6210\u529f\u3002","category_updated_successfully":"\u7c7b\u522b\u66f4\u65b0\u6210\u529f","chart_updated_successfully":"\u56fe\u8868\u66f4\u65b0\u6210\u529f","clicking_on_submit_it_will_publish_your_post":"\u6ce8\u610f\uff1a\u70b9\u51fb\u63d0\u4ea4\u5c06\u53d1\u5e03\u60a8\u7684\u5e16\u5b50","comment_create_successfully":"\u8bc4\u8bba\u521b\u5efa\u6210\u529f","comment_deleted_successfully":"\u8bc4\u8bba\u5220\u9664\u6210\u529f","comment_setting_updated_successfully":"\u8bc4\u8bba\u8bbe\u7f6e\u66f4\u65b0\u6210\u529f","contact_deleted_successfully":"\u8054\u7cfb\u4eba\u5220\u9664\u6210\u529f","contact_number_field_is_required":"\u8054\u7cfb\u7535\u8bdd\u5b57\u6bb5\u662f\u5fc5\u9700\u7684","content_generated_successfully":"\u5185\u5bb9\u751f\u6210\u6210\u529f\u3002","controls_diversity_via_nucleus_sampling":"\u901a\u8fc7\u6838\u5fc3\u62bd\u6837\u63a7\u5236\u591a\u6837\u6027\uff1a0.5 \u8868\u793a\u8003\u8651\u6240\u6709\u4f3c\u7136\u52a0\u6743\u9009\u9879\u7684\u4e00\u534a","controls_randomness_lowering_results_in_less_random_completions":"\u63a7\u5236\u968f\u673a\u6027\uff1a\u964d\u4f4e\u968f\u673a\u5b8c\u6210\u7684\u7ed3\u679c\u3002 \u968f\u7740\u6e29\u5ea6\u63a5\u8fd1\u96f6\uff0c\u6a21\u578b\u5c06\u53d8\u5f97\u5177\u6709\u786e\u5b9a\u6027\u548c\u91cd\u590d\u6027","created_request_for_payment_of":"\u521b\u5efa\u4ed8\u6b3e\u8bf7\u6c42","current_password_in_invalid":"\u5f53\u524d\u5bc6\u7801\u65e0\u6548\u3002","data_retried":"\u6570\u636e\u91cd\u8bd5","default_language_deleted":"\u65e0\u6cd5\u5220\u9664\u9ed8\u8ba4\u8bed\u8a00","default_plan":"\u8fd9\u4e2a\u8ba1\u5212\u662f\u9ed8\u8ba4\u7684","default_plan_changed_successfully":"\u9ed8\u8ba4\u8ba1\u5212\u66f4\u6539\u6210\u529f","default_role_do_not_deleted":"\u9ed8\u8ba4\u89d2\u8272\u4e0d\u5220\u9664\u3002","desktop_view_image_dimensions_must_be_800X130":"\u684c\u9762\u67e5\u770b\u56fe\u50cf\u5c3a\u5bf8\u5fc5\u987b\u4e3a 800X130","email_send_successfully":"\u90ae\u4ef6\u53d1\u9001\u6210\u529f\u3002","email_setting_updated_successfully":"\u7535\u5b50\u90ae\u4ef6\u8bbe\u7f6e\u66f4\u65b0\u6210\u529f","emoji_created_successfully.":"\u8868\u60c5\u7b26\u53f7\u521b\u5efa\u6210\u529f","emoji_deleted_successfully.":"\u8868\u60c5\u7b26\u53f7\u5220\u9664\u6210\u529f","emoji_status_updated_successfully":"\u8868\u60c5\u7b26\u53f7\u72b6\u6001\u66f4\u65b0\u6210\u529f","feed_updated_successfully":"Feed \u66f4\u65b0\u6210\u529f\u3002","file_not_found":"\u6587\u4ef6\u672a\u627e\u5230","gallery_image_created_successfully":"\u56fe\u5e93\u56fe\u7247\u521b\u5efa\u6210\u529f","gallery_image_deleted_successfully.":"\u56fe\u5e93\u56fe\u50cf\u5df2\u6210\u529f\u5220\u9664","gallery_image_updated_successfully":"\u56fe\u5e93\u56fe\u7247\u66f4\u65b0\u6210\u529f","gallery_title_must_not_be_greater_than_190_characters":"\u56fe\u5e93\u6807\u9898\u4e0d\u5f97\u8d85\u8fc7 190 \u4e2a\u5b57\u7b26","generates_multiple_completions_server_side":"\u751f\u6210\u591a\u4e2a\u5b8c\u6210\u670d\u52a1\u5668\u7aef\uff0c\u5e76\u53ea\u663e\u793a\u6700\u597d\u7684\u3002 \u6d41\u5f0f\u5904\u7406\u4ec5\u5728\u8bbe\u7f6e\u4e3a 1 \u65f6\u6709\u6548\u3002\u7531\u4e8e\u5b83\u4f5c\u4e3a\u5b8c\u6210\u6b21\u6570\u7684\u4e58\u6570\uff0c\u56e0\u6b64\u6b64\u53c2\u6570\u4f1a\u5f88\u5feb\u5360\u7528\u60a8\u7684\u4ee4\u724c\u914d\u989d - \u8bf7\u8c28\u614e\u4f7f\u7528\uff01","given_post_is_not_yet_published":"\u7ed9\u5b9a\u7684\u5e16\u5b50\u5c1a\u672a\u53d1\u5e03","image_delete_successfully":"\u56fe\u7247\u5220\u9664\u6210\u529f","image_upload_successfully":"\u56fe\u7247\u4e0a\u4f20\u6210\u529f","img_retrieved":"\u68c0\u7d22\u5230\u7684 img","keyword_should_be_of_maximum_10_words_only":"\u5173\u952e\u5b57\u6700\u591a\u53ea\u80fd\u5305\u542b 10 \u4e2a\u8bcd","language_added_to_front_successfully":"\u8bed\u8a00\u6dfb\u52a0\u5230\u524d\u9762\u6210\u529f","language_be_deleted":"\u65e0\u6cd5\u5220\u9664\u8bed\u8a00","language_change_successfully":"\u8bed\u8a00\u66f4\u6539\u6210\u529f","language_changed_successfully":"\u8bed\u8a00\u66f4\u6539\u6210\u529f","language_deleted_successfully":"\u8bed\u8a00\u5220\u9664\u6210\u529f","language_not_found":"\u627e\u4e0d\u5230\u8bed\u8a00","language_removed_from_front_successfully":"\u8bed\u8a00\u4ece\u524d\u9762\u6210\u529f\u5220\u9664","language_retrieved_successfully":"\u8bed\u8a00\u68c0\u7d22\u6210\u529f","language_saved_successfully":"\u8bed\u8a00\u4fdd\u5b58\u6210\u529f","language_saved_successfully.":"\u8bed\u8a00\u4fdd\u5b58\u6210\u529f","language_updated_successfully":"\u8bed\u8a00\u66f4\u65b0\u6210\u529f","login_via_facebook":"\u901a\u8fc7\u8138\u4e66\u767b\u5165","login_via_google":"\u901a\u8fc7\u8c37\u6b4c\u767b\u5f55","mail_updated_successfully":"\u90ae\u4ef6\u6210\u529f","menu_created_successfully":"\u83dc\u5355\u521b\u5efa\u6210\u529f","menu_deleted_successfully":"\u83dc\u5355\u5220\u9664\u6210\u529f","menu_update_successfully":"\u83dc\u5355\u66f4\u65b0\u6210\u529f","mobile_view_image_dimensions_must_be_350X290":"\u624b\u673a\u67e5\u770b\u56fe\u7247\u5c3a\u5bf8\u5fc5\u987b\u4e3a350X290","name_field_is_required":"\u540d\u79f0\u5b57\u6bb5\u662f\u5fc5\u9700\u7684","navigation_updated_successfully":"\u5bfc\u822a\u66f4\u65b0\u6210\u529f","page_created_successfully":"\u9875\u9762\u6210\u529f\u521b\u5efa","page_deleted_successfully":"\u9875\u9762\u6210\u529f\u5220\u9664\u3002","page_updated_successfully":"\u9875\u9762\u6210\u529f\u66f4\u65b0","password_updated_successfully":"\u5bc6\u7801\u66f4\u65b0\u6210\u529f","payment_received":"\u4ed8\u6b3e\u6210\u529f","plan_already_used":"\u8ba1\u5212\u5df2\u4f7f\u7528","plan_created_successfully":"\u8ba1\u5212\u521b\u5efa\u6210\u529f","plan_deleted_successfully.":"\u8ba1\u5212\u5220\u9664\u6210\u529f","plan_updated_successfully":"\u8ba1\u5212\u66f4\u65b0\u6210\u529f","please_enter_CSV_files":"\u8bf7\u8f93\u5165 CSV \u6587\u4ef6","please_enter_video_URL":"\u8bf7\u8f93\u5165\u89c6\u9891\u7f51\u5740","please_enter_video_url_or_upload_a_video":"\u8bf7\u8f93\u5165\u89c6\u9891\u7f51\u5740\u6216\u4e0a\u4f20\u89c6\u9891","please_enter_video_url_or_upload_video":"\u8bf7\u8f93\u5165\u89c6\u9891\u7f51\u5740\u6216\u4e0a\u4f20\u89c6\u9891","please_select_any_one_permission":"\u8bf7\u9009\u62e9\u4efb\u610f\u4e00\u9879\u6743\u9650","please_select_audio_file":"\u8bf7\u9009\u62e9\u97f3\u9891\u6587\u4ef6","please_upgrade_plan":"\u8bf7\u5347\u7ea7\u8ba1\u5212","poll_created_successfully":"\u6295\u7968\u521b\u5efa\u6210\u529f\u3002","poll_deleted_successfully":"\u6295\u7968\u5220\u9664\u6210\u529f\u3002","poll_updated_successfully":"\u6295\u7968\u66f4\u65b0\u6210\u529f\u3002","poll_voted_successfully":"\u6295\u7968\u6210\u529f","post_added_on_headline_successfully":"\u5e16\u5b50\u6dfb\u52a0\u5230\u6807\u9898\u6210\u529f","post_added_to_breaking_successfully":"\u5e16\u5b50\u6dfb\u52a0\u5230\u7834\u89e3\u6210\u529f","post_added_to_featured_successfully":"\u5e16\u5b50\u6dfb\u52a0\u5230\u7cbe\u9009\u6210\u529f","post_added_to_recommended_successfully":"\u5e16\u5b50\u6dfb\u52a0\u5230\u63a8\u8350\u6210\u529f","post_added_to_slider_successfully":"\u5e16\u5b50\u5df2\u6210\u529f\u6dfb\u52a0\u5230\u6ed1\u5757","post_added_to_visibility_successfully":"\u5e16\u5b50\u5df2\u6210\u529f\u6dfb\u52a0\u5230\u53ef\u89c1\u6027","post_created_successfully":"\u5e16\u5b50\u521b\u5efa\u6210\u529f.","post_deleted_successfully":"\u5e16\u5b50\u5220\u9664\u6210\u529f\u3002","post_removed_from_breaking_successfully":"\u5df2\u6210\u529f\u5220\u9664\u5e16\u5b50","post_removed_from_featured_successfully":"\u5df2\u6210\u529f\u4ece\u7cbe\u9009\u4e2d\u5220\u9664\u5e16\u5b50","post_removed_from_headline_successfully":"\u5df2\u6210\u529f\u4ece\u6807\u9898\u4e2d\u5220\u9664\u5e16\u5b50","post_removed_from_recommended_successfully":"\u5df2\u6210\u529f\u4ece\u63a8\u8350\u4e2d\u5220\u9664\u5e16\u5b50","post_removed_from_slider_successfully":"\u5e16\u5b50\u5df2\u6210\u529f\u4ece\u6ed1\u5757\u4e2d\u5220\u9664","post_removed_from_visibility_successfully":"\u5e16\u5b50\u5df2\u6210\u529f\u4ece\u53ef\u89c1\u6027\u4e2d\u79fb\u9664","post_updated_successfully":"\u5e16\u5b50\u66f4\u65b0\u6210\u529f\u3002","reCAPTCHA_required":"\u9700\u8981\u9a8c\u8bc1\u7801\uff01","registered_success":"\u60a8\u5df2\u6ce8\u518c\u6210\u529f\uff0c\u901a\u8fc7\u90ae\u4ef6\u6fc0\u6d3b\u60a8\u7684\u5e10\u6237","role_already_exists":"\u89d2\u8272\u5df2\u7ecf\u5b58\u5728\u3002","role_created_successfully":"\u89d2\u8272\u521b\u5efa\u6210\u529f","role_deleted_successfully":"\u89d2\u8272\u5220\u9664\u6210\u529f\u3002","role_updated_successfully":"\u89d2\u8272\u66f4\u65b0\u6210\u529f\u3002","rss_feed_create_successfully":"RSS Feed \u521b\u5efa\u6210\u529f","rss_feed_deleted_successfully":"RSS Feed \u5220\u9664\u6210\u529f","rss_feed_update_successfully":"RSS Feed \u66f4\u65b0\u6210\u529f\u3002","seo_tools_updated_successfully":"SEO \u5de5\u5177\u66f4\u65b0\u6210\u529f\u3002","session_created_successfully":"\u4f1a\u8bdd\u521b\u5efa\u6210\u529f","settings_updated_successfully":"\u8bbe\u7f6e\u66f4\u65b0\u6210\u529f","show_in_home_updated_successfully":"\u4e3b\u9875\u663e\u793a\u66f4\u65b0\u6210\u529f","show_in_menu_updated_successfully":"\u5728\u83dc\u5355\u4e2d\u663e\u793a\u66f4\u65b0\u6210\u529f","something_wrong_occurred_please_try_again":"\u53d1\u751f\u9519\u8bef\u8bf7\u91cd\u8bd5","sort_list_title_must_not_be_greater_than_190_characters":"\u6392\u5e8f\u5217\u8868\u6807\u9898\u4e0d\u80fd\u5927\u4e8e190\u4e2a\u5b57\u7b26","staff_created_successfully":"\u4eba\u5458\u521b\u5efa\u6210\u529f\u3002","staff_deleted_successfully":"\u4eba\u5458\u5220\u9664\u6210\u529f\u3002","staff_updated_successfully":"\u4eba\u5458\u66f4\u65b0\u6210\u529f\u3002","status_updated_successfully":"\u72b6\u6001\u66f4\u65b0\u6210\u529f\u3002","sub_categories_saved_successfully":"\u5b50\u7c7b\u522b\u4fdd\u5b58\u6210\u529f\u3002","sub_category_delete_successfully":"\u5b50\u5206\u7c7b\u5220\u9664\u6210\u529f","sub_category_retrieved_successfully":"\u5b50\u7c7b\u522b\u68c0\u7d22\u6210\u529f\u3002","sub_category_updated_successfully":"\u5b50\u7c7b\u522b\u66f4\u65b0\u6210\u529f","subscribed_plan_wait":"\u60a8\u5df2\u6210\u529f\u8ba2\u9605\u6b64\u8ba1\u5212\uff0c\u4f46\u9700\u8981\u7b49\u5f85\u7ba1\u7406\u5458\u7684\u786e\u8ba4","subscribed_successfully":"\u8ba2\u9605\u6210\u529f","subscriber_delete_successfully":"\u8ba2\u9605\u8005\u5220\u9664\u6210\u529f","subscription_date_successfully_updated":"\u8ba2\u9605\u65e5\u671f\u5df2\u6210\u529f\u66f4\u65b0\u3002","subscription_successfully_retrieved":"\u8ba2\u9605\u6210\u529f\u83b7\u53d6","successfully_verified":"\u60a8\u5df2\u6210\u529f\u9a8c\u8bc1\u60a8\u7684\u90ae\u7bb1\uff0c\u8bf7\u767b\u5f55","test_mail_send_successfully":"\u6d4b\u8bd5\u90ae\u4ef6\u53d1\u9001 Sussssssful","the_audios_must_be_a_file_of_type":"\u97f3\u9891\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6\uff1amp3\u3001M4A\u3001wav\u3001aac\u3001wma\u3002","the_images_must_be_a_file_of_type":"\u56fe\u50cf\u5fc5\u987b\u662f\u4ee5\u4e0b\u7c7b\u578b\u7684\u6587\u4ef6\uff1ajpeg\u3001png\u3001jpg\u3001webp\u3001svg\u3002","the_iso_code_field_is_required":"ISO \u4ee3\u7801\u5b57\u6bb5\u662f\u5fc5\u9700\u7684","the_maximum_number_of_tokens_to_generate_requests_can_use_up":"\u8981\u751f\u6210\u7684\u6700\u5927\u4ee4\u724c\u6570\u3002 \u8bf7\u6c42\u6700\u591a\u53ef\u4ee5\u4f7f\u7528\u5728\u63d0\u793a\u548c\u5b8c\u6210\u4e4b\u95f4\u5171\u4eab\u7684 2,048 \u6216 4,000 \u4e2a\u4ee4\u724c\u3002 \u786e\u5207\u7684\u9650\u5236\u56e0\u578b\u53f7\u800c\u5f02\u3002 \uff08\u5bf9\u4e8e\u666e\u901a\u82f1\u6587\u6587\u672c\uff0c\u4e00\u4e2a\u6807\u8bb0\u5927\u7ea6\u662f 4 \u4e2a\u5b57\u7b26\uff09","the_upload_csv_file_field_is_required":"\u4e0a\u4f20 CSV \u6587\u4ef6\u5b57\u6bb5\u662f\u5fc5\u9700\u7684\u3002","the_upload_video_must_not_be_greater_than_150_MB":"\u4e0a\u4f20\u89c6\u9891\u4e0d\u5f97\u5927\u4e8e150MB\u3002","theme_changed_successfully":"\u4e3b\u9898\u66f4\u6539\u6210\u529f","this_album_category_is_in_use":"\u6b64\u4e13\u8f91\u7c7b\u522b\u6b63\u5728\u4f7f\u7528\u4e2d","this_album_is_in_use":"\u6b64\u76f8\u518c\u6b63\u5728\u4f7f\u7528\u4e2d","this_category_is_in_use":"\u8be5\u7c7b\u522b\u6b63\u5728\u4f7f\u7528\u4e2d","this_currency_is_not_supported":"\u4e0d\u652f\u6301\u6b64\u8d27\u5e01","this_email_is_already_subscribed":"\u6b64\u7535\u5b50\u90ae\u4ef6\u5df2\u88ab\u8ba2\u9605","this_sub_category_is_in_use":"\u6b64\u5b50\u7c7b\u522b\u6b63\u5728\u4f7f\u7528\u4e2d","thumbnail_image_is_required":"\u9700\u8981\u7f29\u7565\u56fe","unable_to_process_payment":"\u76ee\u524d\u65e0\u6cd5\u5904\u7406\u4ed8\u6b3e\u3002 \u7a0d\u540e\u518d\u8bd5","visibility_updated_successfully":"\u53ef\u89c1\u6027\u6210\u529f\u66f4\u65b0\u4e86","you_can_use_any_one_of_upload_video_or_video_URL_option":"\u60a8\u53ef\u4ee5\u4f7f\u7528\u4e0a\u4f20\u89c6\u9891\u6216\u89c6\u9891 URL \u9009\u9879\u4e2d\u7684\u4efb\u4f55\u4e00\u4e2a","you_delete_than_emoji":"\u4f60\u4e0d\u80fd\u5220\u9664\u8d85\u8fc7 4 \u4e2a\u8868\u60c5\u7b26\u53f7","your_account_is_currently_disabled_please_contact_to_administrator":"\u60a8\u7684\u5e10\u6237\u76ee\u524d\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002","your_mail_already_verified":"\u60a8\u7684\u90ae\u7bb1\u5df2\u7ecf\u901a\u8fc7\u9a8c\u8bc1\uff0c\u8bf7\u767b\u5f55","your_manual_payment_request_is":"\u60a8\u7684\u4eba\u5de5\u4ed8\u6b3e\u8bf7\u6c42\u662f","your_plan_is_expired_Please_choose_a_plan_to_continue_the_services":"\u4f60\u7684\u8ba1\u5212\u5df2\u7ecf\u8fc7\u671f\u4e86\u3002 \u8bf7\u9009\u62e9\u4e00\u4e2a\u8ba1\u5212\u4ee5\u7ee7\u7eed\u670d\u52a1"},"plans":{"add_plan":"\u6dfb\u52a0\u8ba1\u5212","allowed_post":"\u5141\u8bb8\u7684\u5e16\u5b50","currency":"\u8d27\u5e01","default_Plan":"\u9ed8\u8ba4\u8ba1\u5212","edit_plan":"\u7f16\u8f91\u8ba1\u5212","enter_trial":"\u8fdb\u5165\u8bd5\u7528","frequency":"\u9891\u7387","monthly":"\u6bcf\u6708","new_plan":"\u65b0\u8ba1\u5212","no_of_posts":"\u6ca1\u6709\u804c\u4f4d","plan":"\u8ba1\u5212","plan_name":"\u8ba1\u5212\u540d\u79f0","plans":"\u8ba1\u5212","price":"\u4ef7\u683c","select_currency":"\u9009\u62e9\u8d27\u5e01","trial_days":"\u8bd5\u7528\u65e5","unlimited":"\u65e0\u9650","yearly":"\u6bcf\u5e74"},"poll":{"add_poll":"\u6dfb\u52a0\u6295\u7968","add_polls":"\u6dfb\u52a0\u6295\u7968","all_user":"\u6240\u6709\u7528\u6237","edit_poll":"\u7f16\u8f91\u6295\u7968","no_result_found":"\u672a\u627e\u5230\u7ed3\u679c","option1":"\u9009\u9879 1","option10":"\u9009\u9879 10","option2":"\u9009\u9879 2","option3":"\u9009\u9879 3","option4":"\u9009\u9879 4","option5":"\u9009\u9879 5","option6":"\u9009\u9879 6","option7":"\u9009\u9879 7","option8":"\u9009\u9879 8","option9":"\u9009\u9879 9","poll":"\u8f6e\u8be2","poll_result":"\u6295\u7968\u7ed3\u679c","question":"\u95ee\u9898","register_user":"\u6ce8\u518c\u7528\u6237","show_result":"\u663e\u793a\u7ed3\u679c","total_vote":"\u603b\u7968\u6570","view_option":"\u67e5\u770b\u9009\u9879","voting_poll":"\u6295\u7968\u6295\u7968"},"polls":"\u6c11\u610f\u8c03\u67e5","post":{"add_ai":"\u4f7f\u7528Openai\u64b0\u5199\u5e16\u5b50","add_article":"\u6dfb\u52a0\u6587\u7ae0","add_audio":"\u6dfb\u52a0\u97f3\u9891","add_gallery":"\u6dfb\u52a0\u753b\u5eca","add_image":"\u6dfb\u52a0\u56fe\u7247","add_new_item":"\u6dfb\u52a0\u65b0\u9879\u76ee","add_on_headline":"\u6dfb\u52a0\u6807\u9898","add_personality_quiz":"\u6dfb\u52a0\u4e2a\u6027\u6d4b\u9a8c","add_post":"\u6dfb\u52a0\u5e16\u5b50","add_sort_list":"\u6dfb\u52a0\u6392\u5e8f\u5217\u8868","add_to_breaking":"\u6dfb\u52a0\u5230\u7834\u574f","add_to_featured":"\u6dfb\u52a0\u5230\u7cbe\u9009","add_to_recommended":"\u6dfb\u52a0\u5230\u63a8\u8350","add_to_slider":"\u6dfb\u52a0\u5230\u6ed1\u5757","add_trivia_quiz":"\u6dfb\u52a0\u7410\u4e8b\u6d4b\u9a8c","add_video":"\u6dfb\u52a0\u89c6\u9891","additional":"\u9644\u52a0\u56fe\u50cf","allowed_images_jpg_png_jpeg":"(JPG,PNG,JPEG,SVG,WEBP)","article":"\u6587\u7ae0","article_with_images":"\u5e26\u6709\u56fe\u50cf\u548c\u5d4c\u5165\u89c6\u9891\u7684\u6587\u7ae0","article_with_open_ai":"\u4f7f\u7528Openai\u5199\u60a8\u7684\u5185\u5bb9","audio":"\u58f0\u97f3\u7684","category":"\u7c7b\u522b","choose_post_format":"\u9009\u62e9\u5e16\u5b50\u683c\u5f0f","collection_of_images":"\u56fe\u50cf\u96c6\u5408","d&t":"\u9009\u62e9\u65e5\u671f\u548c\u65f6\u95f4","description":"\u63cf\u8ff0","draft":"\u4fdd\u5b58\u4e3a\u8349\u7a3f","edit_AI":"\u7f16\u8f91\u5e16\u5b50","edit_Article":"\u7f16\u8f91\u6587\u7ae0","edit_Audio":"\u7f16\u8f91\u97f3\u9891","edit_Gallery":"\u7f16\u8f91\u753b\u5eca","edit_Sorted":"\u7f16\u8f91\u6392\u5e8f\u5217\u8868","edit_Video":"\u7f16\u8f91\u89c6\u9891","edit_post":"\u7f16\u8f91\u5e16\u5b50","featured":"\u7cbe\u9009","file":"\u6587\u4ef6","gallery":"\u753b\u5eca","gallery_post_item":"\u56fe\u5e93\u5217\u8868\u9879","get_video":"\u4ece URL \u83b7\u53d6\u89c6\u9891","image":"\u56fe\u7247","image_description":"\u56fe\u7247\u63cf\u8ff0","keywords":"\u5173\u952e\u8bcd","list_based_article":"\u57fa\u4e8e\u5217\u8868\u7684\u6587\u7ae0","open_ai":"\u6253\u5f00AI","optional_url":"\u53ef\u9009\u7f51\u5740","or_add_url":"\u6216\u6dfb\u52a0\u56fe\u7247\u7f51\u5740","personality_quiz":"\u6027\u683c\u6d4b\u9a8c","post":"\u5e16\u5b50","post_type":"\u5e16\u5b50\u7c7b\u578b","posts":"\u5e16\u5b50","publish":"\u53d1\u5e03","publish_post":"\u53d1\u5e03\u5e16\u5b50","quizzes_with_custom_results":"\u5e26\u6709\u81ea\u5b9a\u4e49\u7ed3\u679c\u7684\u6d4b\u9a8c","quizzes_with_right_and_wrong_answers":"\u6b63\u786e\u548c\u9519\u8bef\u7b54\u6848\u7684\u6d4b\u9a8c","remove_on_headline":"\u5220\u9664\u6807\u9898","remove_to_breaking":"\u5220\u9664\u5230\u7834\u574f","remove_to_featured":"\u5220\u9664\u5230\u7cbe\u9009","remove_to_recommended":"\u5220\u9664\u4e3a\u63a8\u8350","remove_to_slider":"\u5220\u9664\u5230\u6ed1\u5757","scheduled_post":"\u9884\u5b9a\u7684\u5e16\u5b50","select_image":"\u9009\u62e9\u56fe\u7247","select_post_type":"\u9009\u62e9\u5e16\u5b50\u7c7b\u578b","selected_file":"\u9009\u5b9a\u7684\u6587\u4ef6","short_description":"\u7b80\u77ed\u7684\u4ecb\u7ecd","show_on_headline":"\u4e0a\u5934\u6761","show_registered_user":"\u4ec5\u5411\u6ce8\u518c\u7528\u6237\u663e\u793a","show_right":"\u663e\u793a\u53f3\u680f","sort_list":"\u6392\u5e8f\u5217\u8868","sort_list_item":"\u6392\u5e8f\u5217\u8868\u9879","spotted_video":"Youtube\u3001Vimeo\u3001Dailymotion","sub_category":"\u5b50\u7c7b\u522b","submit":"\u63d0\u4ea4","tag":"\u6807\u7b7e","thumbnail_image":"\u8bf7\u8f93\u5165\u6709\u6548\u7f51\u5740","trivia_quiz":"\u7410\u4e8b\u6d4b\u9a8c","upload_audios_and_create_playlist":"\u4e0a\u4f20\u97f3\u9891\u5e76\u521b\u5efa\u64ad\u653e\u5217\u8868","upload_or_embed_videos":"\u4e0a\u4f20\u6216\u5d4c\u5165\u89c6\u9891","upload_video":"\u4e0a\u4f20\u89c6\u9891","video":"\u89c6\u9891","video_embed_code":"\u89c6\u9891\u5d4c\u5165\u4ee3\u7801","video_thumbnail":"\u89c6\u9891\u7f29\u7565\u56fe","video_url":"\u89c6\u9891\u5730\u5740","visibility":"\u80fd\u89c1\u5ea6"},"post_reaction":"\u540e\u53cd\u5e94","reaction":{"angry":"\u751f\u6c14\u7684","dislike":"\u4e0d\u559c\u6b22","funny":"\u6709\u8da3\u7684","like":"\u559c\u6b22","love":"\u7231","pray":"\u7948\u7977","sad":"\u4f24\u5fc3","super":"\u6781\u597d\u7684","wow":"\u54c7"},"recent_posts":"\u6700\u8fd1\u7684\u5e16\u5b50","required":"\u5fc5\u9700\u7684","role":{"add_role":"\u6dfb\u52a0\u89d2\u8272","edit_role":"\u7f16\u8f91\u89d2\u8272","permissions":"\u6743\u9650","role":"\u89d2\u8272","role_permissions":"\u89d2\u8272\u6743\u9650","select_all_permissions":"\u9009\u62e9\u6240\u6709\u6743\u9650"},"roles":"\u89d2\u8272","roles_permissions":"\u89d2\u8272\u6743\u9650","rss-feed":"RSS\u8ba2\u9605","rss_feed":{"add_posts":"\u5c06\u5e16\u5b50\u6dfb\u52a0\u4e3a\u8349\u7a3f","add_rss_feed":"\u6dfb\u52a0 Rss \u63d0\u8981","auto_update":"\u81ea\u52a8\u66f4\u65b0","btn_text":"\u9605\u8bfb\u66f4\u591a\u6309\u94ae\u6587\u672c","feed_name":"\u9972\u6599\u540d\u79f0","feed_url":"\u63d0\u8981\u7f51\u5740","generate_keywords":"\u4ece\u6807\u9898\u751f\u6210\u5173\u952e\u5b57","images_source":"\u56fe\u7247\u6765\u6e90","keywords":"\u5173\u952e\u5b57","my_server":"\u4e0b\u8f7d\u56fe\u50cf\u5230\u6211\u7684\u670d\u52a1\u5668","no":"\u4e0d","no_posts":"\u6700\u5927\u8fdb\u53e3\u90ae\u5bc4","original_source":"\u663e\u793a\u539f\u59cb\u6765\u6e90\u7684\u56fe\u50cf","post_import":"\u5e16\u5b50\/\u5bfc\u5165","scheduled_post_delete":"\u9884\u5b9a\u5e16\u5b50\u5220\u9664","show_btn":"\u663e\u793a\u9605\u8bfb\u66f4\u591a\u6309\u94ae","show_btn_text":"\u663e\u793a\u6309\u94ae","yes":"\u662f\u7684"},"save":"\u8282\u7701","search":"\u641c\u7d22","seo-tool":{"google_analytics":"\u8c37\u6b4c\u5206\u6790","home_title":"\u4e3b\u9875\u6807\u9898","keyword":"\u5173\u952e\u8bcd","language":"\u8bed\u8a00","maxkeyword":"\u6700\u591a\u8f93\u5165 10 \u4e2a\u5173\u952e\u5b57","site_description":"\u7f51\u7ad9\u8bf4\u660e","site_title":"\u7f51\u7ad9\u6807\u9898"},"seo-tools":"\u641c\u7d22\u5f15\u64ce\u4f18\u5316\u5de5\u5177","service_categories":"\u670d\u52a1\u7c7b\u522b","services":"\u670d\u52a1","setting":{"Manually":"\u624b\u52a8","Paypal":"\u8d1d\u5b9d","Stripe":"\u6761\u7eb9","about_text":"\u5173\u4e8e\u6587\u672c","address":"\u5730\u5740","app_name":"\u5e94\u7528\u540d\u79f0","clinic_name":"\u8bca\u6240\u540d\u79f0","cms":"\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf","contact_address":"\u8054\u7cfb\u5730\u5740","contact_information":"\u8054\u7cfb\u4fe1\u606f","cookie_warning":"\u997c\u5e72\u8b66\u544a","copy_right_text":"\u7248\u6743\u6587\u672c","currency":"\u8d27\u5e01","currency_settings":"\u8d27\u5e01\u8bbe\u7f6e","facebook":"Facebook","facebook_url":"\u8138\u4e66\u7f51\u5740","favicon":"\u7f51\u7ad9\u56fe\u6807","front_language":"\u9ed8\u8ba4\u524d\u7aef\u8bed\u8a00","general":"\u4e00\u822c\u7684","general_details":"\u4e00\u822c\u7ec6\u8282","generate_sitemap":"\u751f\u6210\u7ad9\u70b9\u5730\u56fe","google_recaptcha":"\u8c37\u6b4c\u9a8c\u8bc1\u7801","instagram_url":"Instagram \u7f51\u5740","invalid_facebook_url":"\u8bf7\u8f93\u5165\u6709\u6548\u7684 Facebook \u7f51\u5740","invalid_instagram_url":"\u8bf7\u8f93\u5165\u6709\u6548\u7684 Instagram \u7f51\u5740","invalid_linkedin_url":"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u9886\u82f1\u7f51\u5740","invalid_pinterest_url":"\u8bf7\u8f93\u5165\u6709\u6548\u7684 Pinterest \u7f51\u5740","invalid_telegram_url":"\u8bf7\u8f93\u5165\u6709\u6548\u7684\u7535\u62a5 URL","invalid_twitter_url":"\u8bf7\u8f93\u5165\u6709\u6548\u7684 Twitter URL","invalid_vk_url":"\u8bf7\u8f93\u5165\u6709\u6548\u7684 Vk URL","invalid_youtube_url":"\u8bf7\u8f93\u5165\u6709\u6548\u7684 Youtube \u7f51\u5740","linkedIn":"\u9886\u82f1","linkedin_url":"\u9886\u82f1\u7f51\u5740","logo":"\u6807\u8bc6","manual_payment_guide":"\u4eba\u5de5\u4ed8\u6b3e\u6307\u5357","pinterest_url":"Pinterest \u7f51\u5740","postal_code":"\u90ae\u653f\u7f16\u7801","prefix":"\u5b57\u9996","privacy":"\u9690\u79c1","reddit":"Reddit","required_privacy":"\u9690\u79c1\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","required_support":"\u652f\u6301\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","required_t&c":"\u6761\u6b3e\u548c\u6761\u4ef6\u5b57\u6bb5\u4e3a\u5fc5\u586b\u9879","rss_feed_auto_update":"\u81ea\u52a8\u66f4\u65b0 RSS \u63d0\u8981","run_commend":"\u8fd0\u884c\u547d\u4ee4","secret_key":"\u5bc6\u94a5","select_time":"\u9009\u62e9\u65f6\u95f4","setting":"\u73af\u5883","show_captcha":"\u663e\u793a\u9a8c\u8bc1\u7801","show_cookie_warning":"\u663e\u793a Cookie \u8b66\u544a","site_key":"\u7ad9\u70b9\u5bc6\u94a5","social_media_setting":"\u793e\u4ea4\u5a92\u4f53\u8bbe\u7f6e","social_media_sharing":"\u793e\u4ea4\u5a92\u4f53\u5171\u4eab","support":"\u652f\u6301","telegram_url":"\u7535\u62a5\u7f51\u5740","terms-conditions":"\u6761\u6b3e\u548c\u6761\u4ef6","twitter":"\u63a8\u7279","twitter_url":"\u63a8\u7279\u7f51\u5740","vk_url":"\u89c6\u9891\u7f51\u5740","whatsapp":"Whatsapp","youtube_url":"\u4f18\u9177\u7f51\u5740"},"settings":"\u8bbe\u7f6e","share_this_post":"\u5206\u4eab\u8fd9\u4e2a\u5e16\u5b50","show":"\u663e\u793a","staff":{"about_us":"\u5173\u4e8e\u6211\u4eec","add_staff":"\u6dfb\u52a0\u5458\u5de5","confirm_password":"\u786e\u8ba4\u5bc6\u7801","contact_no":"\u8054\u7cfb\u65b9\u5f0f","cover_image":"\u5c01\u9762\u56fe\u7247","edit_staff":"\u7f16\u8f91\u4eba\u5458","email":"\u7535\u5b50\u90ae\u4ef6","email_verified":"\u7535\u5b50\u90ae\u4ef6\u5df2\u9a8c\u8bc1","female":"\u5973\u6027","first_name":"\u540d","gender":"\u6027\u522b","last_name":"\u59d3","male":"\u7537\u6027","password":"\u5bc6\u7801","profile":"\u8f6e\u5ed3","role":"\u89d2\u8272","staff":"\u804c\u5458"},"staffs":"\u5458\u5de5","states":"\u72b6\u6001","status":"\u5730\u4f4d","sub_categories":"\u5b50\u7c7b\u522b","sub_category":{"action":"\u884c\u52a8","add":"\u6dfb\u52a0\u5b50\u7c7b\u522b","add_lan":"\u8bed\u8a00","category":"\u7c7b\u522b","edit":"\u7f16\u8f91\u5b50\u7c7b\u522b","language":"\u8bed\u8a00","select_cat":"\u9009\u62e9\u7c7b\u522b","show_menu":"\u663e\u793a\u5728\u83dc\u5355\u4e2d","title":"\u6807\u9898"},"subscribed_user":"\u8ba2\u9605\u7684\u7528\u6237\u8ba1\u5212","subscriber":"\u8ba2\u6237","subscription":{"active_until":"\u6d3b\u8dc3\u81f3","active_until_unlimited":"\u6d3b\u8dc3\u5230\u65e0\u9650","amount":"\u6570\u91cf","cancel_subscription":"\u53d6\u6d88\u8ba2\u9605","change_payment_status":"\u66f4\u6539\u4ed8\u6b3e\u72b6\u6001","choose_plan":"\u9009\u62e9\u8ba1\u5212","current_expire":"\u5f53\u524d\u8fc7\u671f\u8ba1\u5212","current_plan":"\u5f53\u524d\u8ba1\u5212","currently_active":"\u76ee\u524d\u6d3b\u8dc3","days":"\u5929","duration":"Duraci\u00f3n","end_date":"\u7ed3\u675f\u65e5\u671f","expired":"\u8ba1\u5212\u5df2\u7ecf\u8fc7\u671f","expired_date":"\u8fc7\u671f\u65e5\u671f","free":"\u81ea\u7531","has_already_been_subscribed":"\u5df2\u7ecf\u8ba2\u9605","has_been_subscribed":"\u5df2\u8ba2\u9605","history":"\u8ba2\u9605\u5386\u53f2","manage_subscription":"\u7ba1\u7406\u8ba2\u9605","months":"Meses","no_plan_available":"\u6ca1\u6709\u53ef\u7528\u7684\u8ba1\u5212","number_of_post":"\u53d1\u5e16\u6570","pay_or_switch_plan":"\u4ed8\u8d39\/\u8f6c\u6362\u8ba1\u5212","payable_amount":"\u5e94\u4ed8\u91d1\u989d","payment":"\u652f\u4ed8","plan_name":"\u8ba1\u5212\u540d\u79f0","plan_price":"\u8ba1\u5212\u4ef7\u683c","proceed_to_payment":"\u7ee7\u7eed\u4ed8\u6b3e","purchase":"\u8d2d\u4e70","remaining":"\u5176\u4f59\u7684","remaining_balance":"\u4fdd\u6301\u5e73\u8861","remaining_days":"\u5269\u4f59\u5929\u6570","renew_free_plan":"\u514d\u8d39\u8ba1\u5212\u4e0d\u80fd\u518d\u6b21\u66f4\u65b0\/\u9009\u62e9","renew_plan":"\u66f4\u65b0\u8ba1\u5212","start_date":"\u5f00\u59cb\u65e5\u671f","subscribed_date":"\u8ba2\u9605\u65e5\u671f","switch_plan":"\u5207\u6362\u8ba1\u5212","total_days":"\u603b\u5929\u6570","trial_plan":"\u8bd5\u7528\u8ba1\u5212","upgrade_plan":"\u5347\u7ea7\u8ba1\u5212","used_balance":"\u5df2\u7528\u4f59\u989d","used_days":"\u4f7f\u7528\u5929\u6570","what_in_startup_plan":"Qu\u00e9 hay en el plan de inicio","year":"A\u00f1o"},"sync":"\u540c\u6b65","translation_manager":"\u7ffb\u8bd1\u7ecf\u7406","user":{"account":"\u5e10\u6237","account_setting":"\u5e10\u53f7\u8bbe\u5b9a","avatar":"\u963f\u51e1\u8fbe","change_password":"\u66f4\u6539\u5bc6\u7801","confirm_password":"\u786e\u8ba4\u5bc6\u7801","contact_number":"\u8054\u7cfb\u7535\u8bdd","current_password":"\u5f53\u524d\u5bc6\u7801","email":"\u7535\u5b50\u90ae\u4ef6","full_name":"\u5168\u540d","gender":"\u6027\u522b","new_password":"\u65b0\u5bc6\u7801","profile":"\u8f6e\u5ed3","profile_details":"\u4e2a\u4eba\u8d44\u6599\u8be6\u60c5","save_changes":"\u4fdd\u5b58\u66f4\u6539","setting":"\u73af\u5883","staff_details":"\u5458\u5de5\u8be6\u60c5","username":"\u7528\u6237\u540d"},"users":"\u7528\u6237","weekdays":{"fri":"\u5468\u4e94","mon":"\u661f\u671f\u4e00","sat":"\u661f\u671f\u516d","sun":"\u592a\u9633","thu":"\u5468\u56db","tue":"\u5468\u4e8c","wed":"\u661f\u671f\u4e09"}},"zh.pagination":{"next":"\u4e0b\u4e00\u4e2a &raquo;","previous":"&laquo; \u4ee5\u524d"},"zh.passwords":{"reset":"\u60a8\u7684\u5bc6\u7801\u5df2\u91cd\u7f6e\uff01","sent":"\u6211\u4eec\u5df2\u7ecf\u901a\u8fc7\u7535\u5b50\u90ae\u4ef6\u53d1\u9001\u4e86\u60a8\u7684\u5bc6\u7801\u91cd\u7f6e\u94fe\u63a5\uff01","throttled":"\u8bf7\u7b49\u5f85\uff0c\u7136\u540e\u91cd\u8bd5\u3002","token":"\u6b64\u5bc6\u7801\u91cd\u7f6e\u4ee4\u724c\u65e0\u6548\u3002","user":"\u6211\u4eec\u627e\u4e0d\u5230\u4f7f\u7528\u8be5\u7535\u5b50\u90ae\u4ef6\u5730\u5740\u7684\u7528\u6237\u3002"},"zh.validation":{"accepted":"\u7684 :attribute \u5fc5\u987b\u88ab\u63a5\u53d7.","active_url":"\u7684 :attribute \u4e0d\u662f\u6709\u6548\u7684\u7f51\u5740\u3002","after":"\u7684 :attribute \u5fc5\u987b\u662f\u4e4b\u540e\u7684\u65e5\u671f :date.","after_or_equal":"\u7684 :attribute \u5fc5\u987b\u662f\u7b49\u4e8e\u6216\u5c0f\u4e8e\u7b49\u4e8e\u7684\u65e5\u671f :date.","alpha":"\u7684 :attribute \u53ea\u80fd\u5305\u542b\u5b57\u6bcd.","alpha_dash":"\u7684 :attribute \u53ea\u80fd\u5305\u542b\u5b57\u6bcd\uff0c\u6570\u5b57\uff0c\u7834\u6298\u53f7\u548c\u4e0b\u5212\u7ebf\u3002","alpha_num":"\u7684 :attribute \u53ea\u80fd\u5305\u542b\u5b57\u6bcd\u548c\u6570\u5b57.","array":"\u7684 :attribute \u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u7ec4.","attributes":[],"before":"\u7684 :attribute \u5fc5\u987b\u662f\u4e00\u4e2a\u65e5\u671f\u4e4b\u524d :date.","before_or_equal":"\u7684 :attribute \u5fc5\u987b\u662f\u65e9\u4e8e\u6216\u7b49\u4e8e\u7684\u65e5\u671f :date.","between":{"array":"\u7684 :attribute \u5fc5\u987b\u4ecb\u4e8e :min \u548c :max \u9879\u76ee.","file":"\u7684 :attribute \u5fc5\u987b\u4ecb\u4e8e :min \u548c :max \u5343\u5b57\u8282.","numeric":"\u7684 :attribute \u5fc5\u987b\u4ecb\u4e8e :min \u548c :max.","string":"\u7684 :attribute \u5fc5\u987b\u4ecb\u4e8e :min \u548c :max \u4eba\u7269."},"boolean":"\u7684 :attribute \u5b57\u6bb5\u5fc5\u987b\u4e3atrue\u6216false\u3002.","confirmed":"\u7684 :attribute \u786e\u8ba4\u4e0d\u7b26.","custom":{"attribute-name":{"rule-name":"custom-message"}},"date":"\u7684 :attribute \u4e0d\u662f\u6709\u6548\u65e5\u671f.","date_equals":"\u7684 :attribute \u65e5\u671f\u5fc5\u987b\u7b49\u4e8e :date.","date_format":"\u7684 :attribute \u4e0e\u683c\u5f0f\u4e0d\u7b26 :format.","different":"\u7684 :attribute \u548c :other \u5fc5\u987b\u4e0d\u540c.","digits":"\u7684 :attribute \u4e00\u5b9a\u662f :digits \u6570\u5b57.","digits_between":"\u7684 :attribute \u5fc5\u987b\u4ecb\u4e8e :min \u548c :max \u6570\u5b57.","dimensions":"\u7684 :attribute \u56fe\u7247\u5c3a\u5bf8\u65e0\u6548.","distinct":"\u7684 :attribute \u5b57\u6bb5\u5177\u6709\u91cd\u590d\u503c.","email":"\u7684 :attribute \u5fc5\u987b\u662f\u4e00\u4e2a\u6709\u6548\u7684E-mail\u5730\u5740.","ends_with":"\u7684 :attribute \u5fc5\u987b\u4ee5\u4ee5\u4e0b\u4efb\u4e00\u7ed3\u5c3e: :values.","exists":"\u7684 \u5df2\u9009 :attribute \u662f\u65e0\u6548\u7684.","file":"\u7684 :attribute \u5fc5\u987b\u662f\u4e00\u4e2a\u6587\u4ef6.","filled":"\u7684 :attribute \u5b57\u6bb5\u5fc5\u987b\u6709\u4e00\u4e2a\u503c.","gt":{"array":"\u7684 :attribute \u5fc5\u987b\u8d85\u8fc7 :value \u9879\u76ee.","file":"\u7684 :attribute \u5fc5\u987b\u5927\u4e8e :value \u5343\u5b57\u8282.","numeric":"\u7684 :attribute \u5fc5\u987b\u5927\u4e8e :value.","string":"\u7684 :attribute \u5fc5\u987b\u5927\u4e8e :value \u4eba\u7269."},"gte":{"array":"\u7684 :attribute \u4e00\u5b9a\u6709 :value \u9879\u4ee5\u4e0a.","file":"\u7684 :attribute \u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e :value \u5343\u5b57\u8282.","numeric":"\u7684 :attribute \u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e :value.","string":"\u7684 :attribute \u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e :value \u4eba\u7269."},"image":"\u7684 :attribute \u5fc5\u987b\u662f\u56fe\u50cf.","in":"\u7684 \u5df2\u9009 :attribute \u662f\u65e0\u6548\u7684.","in_array":"\u7684 :attribute \u5b57\u6bb5\u4e0d\u5b58\u5728\u4e8e :other.","integer":"\u7684 :attribute \u5fc5\u987b\u662f\u6574\u6570.","ip":"\u7684 :attribute \u5fc5\u987b\u662f\u6709\u6548\u7684IP\u5730\u5740.","ipv4":"\u7684 :attribute \u5fc5\u987b\u662f\u6709\u6548\u7684IPv4\u5730\u5740.","ipv6":"\u7684 :attribute \u5fc5\u987b\u662f\u6709\u6548\u7684IPv6\u5730\u5740.","json":"v :attribute \u5fc5\u987b\u662f\u6709\u6548\u7684JSON\u5b57\u7b26\u4e32.","lt":{"array":"\u7684 :attribute \u5fc5\u987b\u5c11\u4e8e :value \u9879\u76ee.","file":"\u7684 :attribute \u5fc5\u987b\u5c0f\u4e8e :value \u5343\u5b57\u8282.","numeric":"\u7684 :attribute \u5fc5\u987b\u5c0f\u4e8e :value.","string":"\u7684 :attribute \u5fc5\u987b\u5c0f\u4e8e :value \u4eba\u7269."},"lte":{"array":"\u7684 :attribute \u4e0d\u5f97\u8d85\u8fc7 :value \u9879\u76ee.","file":"\u7684 :attribute \u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e :value \u5343\u5b57\u8282.","numeric":"\u7684 :attribute \u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e :value.","string":"\u7684 :attribute \u5fc5\u987b\u5c0f\u4e8e\u6216\u7b49\u4e8e :value \u4eba\u7269."},"max":{"array":"\u7684 :attribute \u53ef\u80fd\u4e0d\u8d85\u8fc7 :max \u9879\u76ee.","file":"\u7684 :attribute \u4e0d\u5f97\u5927\u4e8e :max \u5343\u5b57\u8282.","numeric":"\u7684 :attribute \u4e0d\u5f97\u5927\u4e8e :max.","string":"\u7684 :attribute \u4e0d\u5f97\u5927\u4e8e :max \u4eba\u7269."},"mimes":"\u7684 :attribute \u5fc5\u987b\u662f\u7c7b\u578b\u7684\u6587\u4ef6: :values.","mimetypes":"\u7684 :attribute \u5fc5\u987b\u662f\u7c7b\u578b\u7684\u6587\u4ef6: :values.","min":{"array":"\u7684 :attribute \u5fc5\u987b\u81f3\u5c11 :min \u9879\u76ee.","file":"\u7684 :attribute \u5fc5\u987b\u81f3\u5c11 :min \u5343\u5b57\u8282.","numeric":"\u7684 :attribute \u5fc5\u987b\u81f3\u5c11 :min.","string":"\u7684 :attribute \u5fc5\u987b\u81f3\u5c11 :min \u4eba\u7269."},"not_in":"\u7684 \u5df2\u9009 :attribute \u662f\u65e0\u6548\u7684.","not_regex":"\u7684 :attribute \u683c\u5f0f\u65e0\u6548.","numeric":"\u7684 :attribute \u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u5b57.","password":"\u7684 \u5bc6\u7801\u9519\u8bef.","present":"\u7684 :attribute \u5b57\u6bb5\u5fc5\u987b\u5b58\u5728.","regex":"\u7684 :attribute \u683c\u5f0f\u65e0\u6548.","required":"\u7684 :attribute \u5fc5\u586b\u9879.","required_if":"\u7684 :attribute \u4f55\u65f6\u9700\u8981\u8be5\u5b57\u6bb5 :other \u662f :value.","required_unless":"\u7684 :attribute \u5fc5\u586b\u5b57\u6bb5\uff0c\u9664\u975e :other \u5728 :values.","required_with":"\u7684 :attribute \u4f55\u65f6\u9700\u8981\u8be5\u5b57\u6bb5 :values \u5b58\u5728.","required_with_all":"\u7684 :attribute \u4f55\u65f6\u9700\u8981\u8be5\u5b57\u6bb5 :values \u5b58\u5728.","required_without":"\u7684 :attribute \u4f55\u65f6\u9700\u8981\u8be5\u5b57\u6bb5 :values \u4e0d\u5b58\u5728.","required_without_all":"\u7684 :attribute \u5982\u679c\u6ca1\u6709 :values \u5b58\u5728.","same":"\u7684 :attribute \u548c :other \u5fc5\u987b\u5339\u914d.","size":{"array":"\u7684 :attribute \u5fc5\u987b\u5305\u542b :size \u9879\u76ee.","file":"\u7684 :attribute \u4e00\u5b9a\u662f :size \u5343\u5b57\u8282.","numeric":"\u7684 :attribute \u4e00\u5b9a\u662f :size.","string":"\u7684 :attribute \u4e00\u5b9a\u662f :size \u4eba\u7269."},"starts_with":"\u7684 :attribute \u5fc5\u987b\u4ee5\u4e0b\u5217\u5176\u4e2d\u4e00\u9879\u5f00\u5934: :values.","string":"\u7684 :attribute \u5fc5\u987b\u662f\u4e00\u4e2a\u5b57\u7b26\u4e32.","timezone":"\u7684 :attribute \u5fc5\u987b\u662f\u6709\u6548\u533a\u57df.","unique":"\u7684 :attribute \u5df2\u6709\u4eba\u5e26\u8d70\u4e86.","uploaded":"\u7684 :attribute \u4e0a\u4f20\u5931\u8d25.","url":"\u7684 :attribute \u683c\u5f0f\u65e0\u6548.","uuid":"\u7684 :attribute \u5fc5\u987b\u662f\u6709\u6548\u7684UUID."}});
})();
